# coding: utf-8

import os
import sys
import pathlib
import xmltodict
import package.MojXmlDef as MojXmlDef
import package.MojXmlPolygon as MojXmlPolygon
import package.MojXMLtoGeoJSON as MojXMLtoGeoJSON


def SaveGeoJson(src_file, exclude_flag, untreated_flag, treated_flag, daihyo_flag, convert_flag, chiban_flag):
    moj_obj = MojXml(src_file)

    geojson_str, daihyo_geojson_str = MojGeojson(moj_obj, exclude_flag, untreated_flag, treated_flag, daihyo_flag, src_file, convert_flag, chiban_flag)

    # daihyoが付かないgeojsonの保存
    kukaku_dir = os.path.join(os.path.dirname(src_file), 'kukaku')
    os.makedirs(kukaku_dir, exist_ok=True)
    dst_name = pathlib.Path(kukaku_dir) / pathlib.Path(src_file).with_suffix(".geojson").name
    dst_name = dst_name.resolve()
    if chiban_flag is False:
        geojson_bytes = geojson_str.encode('utf-8')
        if len(geojson_bytes) >= 140:
            with open(dst_name, 'w', encoding='utf-8') as f:
                f.write(geojson_str.replace('null', '""'))


# convert xml to object
def MojXml(src_file):
    kukaku_dir = os.path.join(os.path.dirname(src_file), 'kukaku')
    os.makedirs(kukaku_dir, exist_ok=True)  # exist_ok=True を追加して括弧を閉じます
    chiban_dir = os.path.join(os.path.dirname(src_file), 'chiban')
    os.makedirs(chiban_dir, exist_ok=True)  # exist_ok=True を追加して括弧を閉じます
    with open(src_file, encoding='utf-8') as fp:
        xml_data = fp.read()
        # 半角の「\」を全角の「￥」に置換する
        xml_data = xml_data.replace('\\', '￥')
        moj_dict = xmltodict.parse(xml_data)

    version = moj_dict['地図']['version']
    city_name = moj_dict['地図']['市区町村名']
    crs = moj_dict['地図']['座標系']
    number_crs, named_crs = MojXmlDef.GetCrs(crs)
    datum_type = moj_dict.get('地図', {}).get('測地系判別')

    mojXmlPolygon = MojXmlPolygon.MojXmlPolygon(moj_dict)

    mojObj = {
        'version': version,
        'city_name': city_name,
        'crs': crs,
        'named_crs': named_crs,
        'number_crs': number_crs,
        'datum_type': datum_type,
        'mojXmlPolygon': mojXmlPolygon,
    }
    return mojObj


def MojGeojson(mojObj: dict, exclude_flag, untreated_flag, treated_flag, daihyo_flag, src_file, convert_flag, chiban_flag):
    return MojXMLtoGeoJSON.MojXMLtoGeoJSON(mojObj, exclude_flag, untreated_flag, treated_flag, daihyo_flag, src_file, convert_flag, chiban_flag)
