# coding: utf-8

import argparse
import traceback
import package.xml2geojson


def get_args():
    parser = argparse.ArgumentParser()

    parser.add_argument('FILE_PATH')
    parser.add_argument('-e', '--exclude', help='地番が地図外、別図、区域外、調査外の筆を除外して出力', action='store_true')
    parser.add_argument('-u', '--untreated', help='任意座標系を除外して出力', action='store_true')
    parser.add_argument('-t', '--treated', help='任意座標系のみ出力', action='store_true')
    parser.add_argument('-d', '--daihyo', help='代表点を別ファイルで出力', action='store_true')
    parser.add_argument('-x', '--xy', help='座標変換しない', action='store_true')
    parser.add_argument('-c', '--chiban', help='代表点のみ出力', action='store_true')
    args = parser.parse_args()

    return args


def main():
    args = get_args()
    srcFile = args.FILE_PATH
    exclude_flag = args.exclude
    untreated_flag = args.untreated
    treated_flag = args.treated
    daihyo_flag = args.daihyo
    convert_flag = args.xy
    chiban_flag = args.chiban

    try:
        package.xml2geojson.SaveGeoJson(srcFile, exclude_flag, untreated_flag, treated_flag, daihyo_flag, convert_flag, chiban_flag)
    except Exception:
        print('Error Source File:', srcFile)
        traceback.print_exc()


if __name__ == '__main__':
    main()
