# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Digitizer3#3.x#
                                 A QGIS plugin
        begin                : 2018-02-27
        copyright            : (C) 2018 by n-survey
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt5 import QtWidgets, uic
from PyQt5.QtCore import *
from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
import os
import sys
from qgis.core import *
from qgis.gui import *
import qgis.utils
import shutil
import subprocess
import math
try:
    from PIL import Image
    import PIL.ExifTags as ExifTags
except:
    pass
import zipfile
import codecs
try:
    import piexif
except:
    pass
try:
    import serial
except:
    pass
import datetime
import time
import threading
from time import sleep
import urllib.request, urllib.error, urllib.parse
import json
import re
import platform
import socket
from contextlib import closing
import random
from PyQt5.QtWidgets import QInputDialog
import csv
import json
import geopandas as gpd
import requests
import urllib
import pythoncom
try:
    from geojson import FeatureCollection
except:
    pass

import ctypes
from ctypes import wintypes

if sys.platform == "win32":
    FORM_CLASS, _ = uic.loadUiType(os.path.join(
        os.path.dirname(__file__), 'ui_dialog.ui'))
else:
    FORM_CLASS, _ = uic.loadUiType(os.path.join(
        os.path.dirname(__file__), 'ui_dialog_Mac.ui'))



class Setting:
    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Digitizer3_{}.qm'.format(locale))
        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
        self.actions = []
        self.menu = self.tr(u'&Digitizer3')
        self.toolbar = self.iface.addToolBar(u'Digitizer3')
        self.toolbar.setObjectName(u'Digitizer3')

    def tr(self, message):
        return QCoreApplication.translate('Digitizer3', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)
        if status_tip is not None:
            action.setStatusTip(status_tip)
        if whats_this is not None:
            action.setWhatsThis(whats_this)
        if add_to_toolbar:
            self.toolbar.addAction(action)
        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)
        self.actions.append(action)
        return action

    def initGui(self):
        icon_path = os.path.dirname(__file__) + '/digitizer.ico'
        self.add_action(
            icon_path,
            text=self.tr(u'Digitizer3'),
            callback=self.run,
            parent=self.iface.mainWindow())
        #----------------------------------------
        icon_path2 = ''
        self.add_action(
            icon_path2,
            text=self.tr(u'ウィンドウ位置初期化'),
            add_to_toolbar=False,
            callback=self.run2,
            parent=self.iface.mainWindow())
        #----------------------------------------
        icon_path3 = ''
        self.add_action(
            icon_path3,
            text=self.tr(u'環境設定'),
            add_to_toolbar=False,
            callback=self.run3,
            parent=self.iface.mainWindow())
        #----------------------------------------
        # マップキャンバスクリック時の動作
        self.mapTool = CaptureCoordinates(self.iface)

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Digitizer3'),
                action)
            self.iface.removeToolBarIcon(action)
        del self.toolbar

    def run(self):
        self.iface.mapCanvas().setMapTool(self.mapTool)
        # レジストリに登録された作業用フォルダを調べる
        ws = QSettings("M'z Room", "Digitizer3")
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        # 登録の作業フォルダがない場合は作成する。（初回起動時や登録したフォルダが削除されている場合）
        if not os.path.exists(workPath):
            try:
                os.mkdir(workPath)
            except: # 作成できない場合は、プラグインフォルダに「work」を作成し、作業フォルダとする。
                workPath = os.path.dirname(__file__) + u'/work'
                ws.setValue("setting/workPath", workPath)
                os.mkdir(workPath)
        # GNSSのログファイル保存フォルダ作成
        if not os.path.exists(os.path.dirname(__file__) + '/log'):
            try:
                os.mkdir(os.path.dirname(__file__) + '/log')
            except:
                pass
        # 前回削除できなかった一時ファイルを削除（使用中の場合は削除されない）
        try:
            for root, dirs, files in os.walk(workPath):
                for file in files:
                    os.remove(workPath + '/' + file)
        except:
            pass
        #--------------------------------------------------------
        # これで、プラグイン起動時にウィンドウを表示できるが、
        # 使用できないウィンドウが余分に開いてしまう。
        #self.dlg = Dialog()
        #self.dlg.close()
        #self.dlg.show()
        #self.dlg.raise_()
        #self.dlg.checkBox.setChecked(True)
        #self.dlg.tabWidget.setCurrentIndex(0)
        #--------------------------------------------------------

    # ウィンドウ位置初期化
    def run2(self):
        ws = QSettings("M'z Room", "Digitizer3")
        ws.setValue("setting/window_w", 570)
        ws.setValue("setting/window_x", 8)
        ws.setValue("setting/window_y", 31)

    # 環境設定
    def run3(self):
        if sys.platform == "win32":
            qv = Qgis.QGIS_VERSION.split('.')
            pv = platform.python_version().split('.')
            txt = ''
            qv2 = qv[2].split('-')
            txt = txt + '"C:\Program Files\QGIS 3.' + qv[1] + '.' + qv2[0]  + '\Apps\Python3' + pv[1] + '\python.exe" -m pip install --upgrade pip\n'
            txt = txt + 'pause\n'
            txt = txt + '"C:\Program Files\QGIS 3.' + qv[1] + '.' + qv2[0]  + '\Apps\Python3' + pv[1] + '\python.exe" -m pip install pillow\n'
            txt = txt + 'pause\n'
            txt = txt + '"C:\Program Files\QGIS 3.' + qv[1] + '.' + qv2[0]  + '\Apps\Python3' + pv[1] + '\python.exe" -m pip install piexif\n'
            txt = txt + 'pause\n'
            txt = txt + '"C:\Program Files\QGIS 3.' + qv[1] + '.' + qv2[0]  + '\Apps\Python3' + pv[1] + '\python.exe" -m pip install pyserial\n'
            txt = txt + 'pause\n'
#            if int(qv[1]) > 38:
            txt = txt + '"C:\Program Files\QGIS 3.' + qv[1] + '.' + qv2[0]  + '\Apps\Python3' + pv[1] + '\python.exe" -m pip install pymeshlab\n'
            txt = txt + 'pause\n'
            txt = txt + '"C:\Program Files\QGIS 3.' + qv[1] + '.' + qv2[0]  + '\Apps\Python3' + pv[1] + '\python.exe" -m pip install geojson\n'
            txt = txt + 'pause\n'
            fname = open(os.path.dirname(__file__) + u'/bat/install.bat', 'w')
            fname.write(txt)
            fname.close()
            cmd = os.path.dirname(__file__) + u'/bat/install.lnk'
            result = subprocess.run(cmd, shell=True)
            if result.returncode != 0:
                QMessageBox.information(None, u'環境設定', u'バッチファイルの実行に失敗しました。')
            else:
                QMessageBox.information(None, u'環境設定', u'環境設定が完了しました。<br> QGISを再起動してください。')
        else:
            result = subprocess.run('pip3 install pillow', shell=True)
            if result.returncode != 0:
                QMessageBox.information(None, u'環境設定', u'pillowのインストールに失敗しました。<br> ターミナルで「pip3 install pillow」を実行してください。')
            else:
                QMessageBox.information(None, u'環境設定', u'pillowのインストールが完了しました。<br> 続けてpiexifをインストールします。')
            result = subprocess.run('pip3 install piexif', shell=True)
            if result.returncode != 0:
                QMessageBox.information(None, u'環境設定', u'piexifのインストールに失敗しました。<br> ターミナルで「pip3 install piexif」を実行してください。')
            else:
                QMessageBox.information(None, u'環境設定', u'piexifのインストールが完了しました。<br> 続けてpyserialをインストールします。')
            result = subprocess.run('pip3 install pyserial', shell=True)
            if result.returncode != 0:
                QMessageBox.information(None, u'環境設定', u'pyserialのインストールに失敗しました。<br> ターミナルで「pip3 install pyserial」を実行してください。')
            else:
                QMessageBox.information(None, u'環境設定', u'pyserialのインストールが完了しました。<br> QGISを再起動すると有効になります。')



# マップキャンバスクリック時の動作
class CaptureCoordinates(QgsMapTool):
    def __init__(self, iface):
        QgsMapTool.__init__(self, iface.mapCanvas())
        self.iface = iface

    def canvasReleaseEvent(self, e):
        if not hasattr(self, 'dlg'):
            self.dlg = Dialog()
            # ウィンドウタイトル表示（バージョン取得）
            for line in codecs.open(os.path.dirname(__file__) + u'/metadata.txt', 'r', 'utf-8'):
                if line[0:8] == 'version=':
                    version = line.replace('version=', '')
            self.dlg.setWindowTitle('Digitizer3 Ver.' + version)
        # 右クリックでプラグインウィンドウを前面に表示
        button_type = e.button()
        if button_type == Qt.RightButton:
            self.dlg.show()
            self.dlg.raise_()
            if self.dlg.tabWidget.currentIndex() == 0 and self.dlg.textEdit_1.toPlainText() == '':
                self.dlg.textEdit_1.append('name,x(latitude),y(longitude),h,hsrc,note')
                self.dlg.textEdit_3.append('x(latitude),y(longitude),name')
                self.dlg.textEdit_point.append('Z00,/Digitizer3/,')
                self.dlg.textEdit_point.append('G00,01,')
                self.dlg.textEdit_point.append('Z00,/point data/,')
                self.dlg.textEdit_point.append('A00,')
                self.dlg.textEdit_kessen.append('Z00,/line data/,')
                self.dlg.textEdit_kukaku.append('Z00,/polygon data/,')
            return
        self.dlg.mPosX.setText('')
        self.dlg.mPosY.setText('')
        dPos = e.pos()
        mPos = self.toMapCoordinates(dPos)
        self.dlg.mPosX.setText(str(mPos.x()))
        self.dlg.mPosY.setText(str(mPos.y()))
        global xx
        global yy
        global x0
        global y0
        global x0u
        global y0u
        yy = str(mPos.x())
        xx = str(mPos.y())
        y0 = float(self.dlg.lineEdit_y.text())
        x0 = float(self.dlg.lineEdit_x.text())
        x0u = self.dlg.lineEdit_x.text()
        y0u = self.dlg.lineEdit_y.text()
        coordinate = str(xx) + ',' + str(yy)
        # プロジェクトのCRS設定を取得する
        global settings
        settings = QSettings()
        oldProjValue = settings.value('/Projections/defaultBehavior')
        self.dlg.lineEdit_crsSetting.setText(str(oldProjValue))
        settings.setValue('/Projections/defaultBehavior', 'useProject') # useProject=プロジェクトのCRSを使用するモード,prompt=CRSを確認するモード,useGlobal=デフォルトのCRSを使用するモード
        # プロジェクトのCRSを取得する
        epsgGet()
        if epsgcode != '':
            code = epsgcode
            messageBar_flag = 0
        else:
            code = usercode
            messageBar_flag = 1
        self.dlg.scrollArea.move(250, 25)
        self.dlg.scrollArea.hide()
        #[Digitizer]
        if self.dlg.tabWidget.currentIndex() == 0:
            # undo data
            global textEdit_1
            global textEdit_point
            global textEdit_kessen
            global textEdit_kukaku
            global lineEdit_1
            global lineEdit_2
            global kessenNo
            global kessenCount
            global kukakuNo
            global kukakuCount
            global lineEdit_d
            global lineEdit_td
            textEdit_1 = self.dlg.textEdit_1.toPlainText()
            textEdit_point = self.dlg.textEdit_point.toPlainText()
            textEdit_kessen = self.dlg.textEdit_kessen.toPlainText()
            textEdit_kukaku = self.dlg.textEdit_kukaku.toPlainText()
            lineEdit_1 = self.dlg.lineEdit_1.text()
            lineEdit_2 = self.dlg.lineEdit_2.text()
            kessenNo = self.dlg.kessenNo.text()
            kessenCount = self.dlg.kessenCount.text()
            kukakuNo = self.dlg.kukakuNo.text()
            kukakuCount = self.dlg.kukakuCount.text()
            lineEdit_d = self.dlg.lineEdit_d.text()
            lineEdit_td = self.dlg.lineEdit_td.text()
            if self.dlg.textEdit_1.toPlainText() == '':
                self.dlg.textEdit_1.append('name,x(latitude),y(longitude),h,hsrc,note')
                self.dlg.textEdit_3.append('x(latitude),y(longitude),name')
                self.dlg.textEdit_point.append('Z00,/Digitizer3/,')
                self.dlg.textEdit_point.append('G00,01,')
                self.dlg.textEdit_point.append('Z00,/point data/,')
                self.dlg.textEdit_point.append('A00,')
                self.dlg.textEdit_kessen.append('Z00,/line data/,')
                self.dlg.textEdit_kukaku.append('Z00,/polygon data/,')
            else:
                if self.dlg.checkBox.isChecked():
                    h = ''
                    hsrc = ''
                    if self.dlg.checkBox_H.isChecked():
                        try:
                            # 取得した座標をEPSG:4326に変換
                            crsSrs = self.iface.mapCanvas().mapSettings().destinationCrs()
                            trans = QgsCoordinateTransform(crsSrs, QgsCoordinateReferenceSystem(4326), QgsProject.instance())
                            mPos2 = trans.transform(mPos)
                            lon = str(mPos2.x())
                            lat = str(mPos2.y())
                            # 標高API
                            URL = "https://cyberjapandata2.gsi.go.jp/general/dem/scripts/getelevation.php?lon=" + lon + "&lat=" + lat + "&outtype=JSON"
                            data_all = urllib.request.urlopen(URL)
                            data = json.loads(data_all.read())
                            h = str(data['elevation'])
                            el = h + u' m'
                            hsrc = data[u'hsrc']
                            data_all.close()
                        except:
                            pass
                    if int(self.dlg.lineEdit_2.text()) > 0:
                        if self.dlg.checkBox3.isChecked():
                            d = math.sqrt((mPos.y() - x0)**2 + (mPos.x() - y0)**2)
                            self.dlg.lineEdit_d.setText(str("{:.3f}".format(d)))
                            td = float(self.dlg.lineEdit_td.text()) + d
                            self.dlg.lineEdit_td.setText(str("{:.3f}".format(td)))
                            xa = (mPos.y() + x0) / 2
                            ya = (mPos.x() + y0) / 2
                            p1 = self.dlg.lineEdit_1.text() + str(self.dlg.lineEdit_2.text())
                            p2 = self.dlg.lineEdit_1.text() + str(int(self.dlg.lineEdit_2.text()) + 1)
                            self.dlg.textEdit_3.append(str(xa) + ',' + str(ya) + ',' + str("{:.3f}".format(d)) + '(' + self.dlg.lineEdit_1.text() + str(self.dlg.lineEdit_2.text()) + '-' + self.dlg.lineEdit_1.text() + str(int(self.dlg.lineEdit_2.text()) + 1) + ')')
                        else:
                            d = math.sqrt((mPos.y() - x0)**2 + (mPos.x() - y0)**2)
                            self.dlg.lineEdit_d.setText(str("{:.3f}".format(d)))
                            td = float(self.dlg.lineEdit_td.text()) + d
                            self.dlg.lineEdit_td.setText(str("{:.3f}".format(td)))
                            xa = (mPos.y() + x0) / 2
                            ya = (mPos.x() + y0) / 2
                            p1 = self.dlg.lineEdit_1.text()
                            p2 = self.dlg.lineEdit_1.text()
                            self.dlg.textEdit_3.append(str(xa) + ',' + str(ya) + ',' + str("{:.3f}".format(d)) + '(' + self.dlg.lineEdit_1.text() + '-' + self.dlg.lineEdit_1.text() + ')')
                    #----------結線・区画線描画----------
                    if self.dlg.checkBox_draw.isChecked():
                        # 結線
                        if self.dlg.radioButton_kessen.isChecked() and int(self.dlg.kessenCount.text()) > 0:
                            points = [QgsPoint(y0, x0), QgsPoint(float(yy),float(xx))]
                            layer = QgsVectorLayer('Linestring?crs=epsg:' + code, self.dlg.kessenNo.text() + '.' + p1 + '-' + p2, 'memory')
                            provider = layer.dataProvider()
                            feature = QgsFeature()
                            feature.setGeometry(QgsGeometry.fromPolyline(points))
                            feature.setAttributes([p1 + '-' + p2, x0, y0, mPos.y(), mPos.x()])
                            provider.addFeatures([feature])
                            # グループ化
                            QgsProject.instance().addMapLayer(layer, False)
                            if QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr(u'結線')) == None:
                                QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.dlg.tr(u'結線')))
                            group = QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr(u'結線'))
                            group.insertLayer(0,layer)
                            self.iface.mapCanvas().refresh()
                            if self.dlg.comboBox_2.currentText() != '':
                                qmlfile = str(self.dlg.comboBox_2.currentText())
                                if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
                            else:
                                if os.path.exists(os.path.dirname(__file__) + u'/qml/kessen.qml'):
                                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/kessen.qml')
                            global Kessen_Layer_ID
                            Kessen_Layer_ID = layer.id()
                        # 区画
                        if self.dlg.radioButton_kukaku.isChecked():
                            if int(self.dlg.kukakuCount.text()) == 0:
                                global xs
                                global ys
                                xs = float(xx)
                                ys = float(yy)
                            else:
                                if int(self.dlg.kukakuCount.text()) == 1:
                                    global ps
                                    global pe
                                    global code2
                                    ps = p1
                                    code2 = code
                                points = [QgsPoint(y0, x0), QgsPoint(float(yy),float(xx))]
                                layer = QgsVectorLayer('Linestring?crs=epsg:' + code, self.dlg.kukakuNo.text() + '.' + p1 + '-' + p2, 'memory')
                                provider = layer.dataProvider()
                                feature = QgsFeature()
                                feature.setGeometry(QgsGeometry.fromPolyline(points))
                                feature.setAttributes([p1 + '-' + p2, x0, y0, mPos.y(), mPos.x()])
                                provider.addFeatures([feature])
                                # グループ化
                                QgsProject.instance().addMapLayer(layer, False)
                                if QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr(u'区画')) == None:
                                    QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.dlg.tr(u'区画')))
                                group = QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr(u'区画'))
                                group.insertLayer(0,layer)
                                self.iface.mapCanvas().refresh()
                                pe = p2
                                if self.dlg.comboBox_2.currentText() != '':
                                    qmlfile = str(self.dlg.comboBox_2.currentText())
                                    if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
                                else:
                                    if os.path.exists(os.path.dirname(__file__) + u'/qml/kukaku.qml'):
                                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/kukaku.qml')
                                global Kukaku_Layer_ID
                                Kukaku_Layer_ID = layer.id()
                    #------------------------------------
                    # ポイントレイヤの追加
                    no = int(self.dlg.lineEdit_2.text()) + 1
                    bikou = self.dlg.lineEdit_13.text()
                    if self.dlg.checkBox3.isChecked():
                        p2 = self.dlg.lineEdit_1.text() + str(no)
                    else:
                        p2 = self.dlg.lineEdit_1.text()
                    layer = QgsVectorLayer('Point?crs=epsg:' + code + '&field=' + self.dlg.tr('name') + '&field=' + self.dlg.tr('x') + '&field=' + self.dlg.tr('y') + '&field=' + self.dlg.tr('h') + '&field=' + self.dlg.tr('hsrc') + '&field=' + self.dlg.tr('note'), p2, 'memory')
                    provider = layer.dataProvider()
                    feature = QgsFeature()
                    geometry = QgsGeometry.fromPointXY(QgsPointXY(mPos.x(), mPos.y()))
                    feature.setGeometry(geometry)
                    feature.setAttributes([p2,mPos.y(),mPos.x(),h,hsrc,bikou])
                    provider.addFeatures([feature])
                    # グループ化
                    QgsProject.instance().addMapLayer(layer, False)
                    if QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('Digitizer')) == None:
                        QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.dlg.tr('Digitizer')))
                    group = QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('Digitizer'))
                    group.insertLayer(0,layer)
                    self.iface.mapCanvas().refresh()
                    global Point_Layer_ID
                    Point_Layer_ID = layer.id()
                    # スタイル設定
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/digitizer.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/digitizer.qml')
                    # SIMAテキストに追加
                    self.dlg.lineEdit_y.setText(yy)
                    self.dlg.lineEdit_x.setText(xx)
                    self.dlg.lineEdit_2.setText(str(no))
                    if self.dlg.checkBox3.isChecked():
                        self.dlg.textEdit_1.append(self.dlg.lineEdit_1.text() + str(no) + ',' + str(coordinate) + ',' + h + ',' + hsrc + ',' + self.dlg.lineEdit_13.text())
                        self.dlg.textEdit_point.setFocus()
                        self.dlg.textEdit_point.append('A01,' + str(no) + ',' + self.dlg.lineEdit_1.text() + str(no) + ',' + str(coordinate) + ',' + h + ',' + self.dlg.lineEdit_13.text())
                        if self.dlg.radioButton_kessen.isChecked():
                            no2 = int(self.dlg.kessenCount.text()) + 1
                            self.dlg.kessenCount.setText(str(no2))
                            self.dlg.textEdit_kessen.append('B01,' + str(no) + ',' + self.dlg.lineEdit_1.text() + str(no) + ',')
                        if self.dlg.radioButton_kukaku.isChecked():
                            no3 = int(self.dlg.kukakuCount.text()) + 1
                            self.dlg.kukakuCount.setText(str(no3))
                            self.dlg.textEdit_kukaku.append('B01,' + str(no) + ',' + self.dlg.lineEdit_1.text() + str(no) + ',')
                    else:
                        self.dlg.textEdit_1.append(self.dlg.lineEdit_1.text() + ',' + str(coordinate) + ',' + h + ',' + hsrc + ',' + self.dlg.lineEdit_13.text())
                        self.dlg.textEdit_point.setFocus()
                        self.dlg.textEdit_point.append('A01,' + str(no) + ',' + self.dlg.lineEdit_1.text() + ',' + str(coordinate) + ',' + h + ',' + self.dlg.lineEdit_13.text())
                        if self.dlg.radioButton_kessen.isChecked():
                            no2 = int(self.dlg.kessenCount.text()) + 1
                            self.dlg.kessenCount.setText(str(no2))
                            self.dlg.textEdit_kessen.append('B01,' + str(no) + ',' + self.dlg.lineEdit_1.text() + ',')
                        if self.dlg.radioButton_kukaku.isChecked():
                            no3 = int(self.dlg.kukakuCount.text()) + 1
                            self.dlg.kukakuCount.setText(str(no3))
                            self.dlg.textEdit_kukaku.append('B01,' + str(no) + ',' + self.dlg.lineEdit_1.text() + ',')
            self.dlg.pushButton_1.setFocus()
            # カスタムCRSの時にだけ出るメッセージバーを消す
            if messageBar_flag == 1:
                qgis.utils.iface.messageBar().clearWidgets()
                messageBar_flag = 0
        #[I/O]
        if self.dlg.tabWidget.currentIndex() == 1:
            self.iface.mapCanvas().setCenter(mPos)
            # 現在の縮尺を取得
            scale = round(map.scale(), 0)
            self.dlg.lineEdit_scale.setText(str(int(scale)))
            if self.dlg.check_scale.isChecked():
                # 変換先のEPSGを取得
                crs = self.dlg.comboBox_3.currentText().split(u',')
                epsg = int(crs[1])
                # プロジェクトのEPSGを取得
                epsgGet()
                if epsgcode != '':
                    crsSrc = QgsCoordinateReferenceSystem(int(epsgcode))
                else:
                    Src_crs = QgsCoordinateReferenceSystem()
                    Src_crs.createFromId(int(usercode), QgsCoordinateReferenceSystem.InternalCrsId)
                    crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                # マップキャンバスの中心座標を指定のEPSGに変更
                custom = str(QgsCoordinateReferenceSystem(epsg).authid())
                if custom == '':# 変換先がカスタムCRSの場合
                    Dest_crs = QgsCoordinateReferenceSystem()
                    Dest_crs.createFromId(epsg, QgsCoordinateReferenceSystem.InternalCrsId)
                    crsDest = QgsCoordinateReferenceSystem(Dest_crs)
                else:
                    crsDest = QgsCoordinateReferenceSystem(epsg)
                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                yc,xc = trans.transform(mPos.x(), mPos.y())
                self.dlg.xx.setText(str(xc))
                self.dlg.yy.setText(str(yc))
        #[GDAL/OGR]
        if self.dlg.tabWidget.currentIndex() == 2:
            self.dlg.scrollArea2.move(7, 120)
            self.dlg.scrollArea2.hide()
            self.dlg.scrollArea4.move(7, 120)
            self.dlg.scrollArea4.hide()
            self.dlg.scrollArea5.move(7, 120)
            self.dlg.scrollArea5.hide()
            if self.dlg.click1.isChecked():
                dPos = e.pos()
                mPos = self.toMapCoordinates(dPos)
                self.dlg.p1_x_src.setText(format(round(mPos.y(), 8)))
                self.dlg.p1_y_src.setText(format(round(mPos.x(), 8)))
                self.dlg.click1.setChecked(False)
                if self.dlg.click0.isChecked():
                    self.dlg.click2.setChecked(True)
                    self.dlg.label_info.setText('　マップキャンバスをクリックして、２点目の変換元座標を取得してください。')
                self.dlg.raise_()
                return
            if self.dlg.click2.isChecked():
                dPos = e.pos()
                mPos = self.toMapCoordinates(dPos)
                self.dlg.p2_x_src.setText(format(round(mPos.y(), 8)))
                self.dlg.p2_y_src.setText(format(round(mPos.x(), 8)))
                self.dlg.click2.setChecked(False)
                if self.dlg.click0.isChecked():
                    self.dlg.click3.setChecked(True)
                    self.dlg.label_info.setText('　マップキャンバスをクリックして、１点目の変換先座標を取得してください。')
                self.dlg.raise_()
                return
            if self.dlg.click3.isChecked():
                dPos = e.pos()
                mPos = self.toMapCoordinates(dPos)
                self.dlg.p1_x_dst.setText(format(round(mPos.y(), 8)))
                self.dlg.p1_y_dst.setText(format(round(mPos.x(), 8)))
                self.dlg.click3.setChecked(False)
                if self.dlg.click0.isChecked():
                    self.dlg.click4.setChecked(True)
                    self.dlg.label_info.setText('　マップキャンバスをクリックして、２点目の変換先座標を取得してください。')
                self.dlg.raise_()
                return
            if self.dlg.click4.isChecked():
                dPos = e.pos()
                mPos = self.toMapCoordinates(dPos)
                self.dlg.p2_x_dst.setText(format(round(mPos.y(), 8)))
                self.dlg.p2_y_dst.setText(format(round(mPos.x(), 8)))
                self.dlg.click4.setChecked(False)
                self.dlg.label_info.setText('　入力完了。「変換実行」ボタンを押してください。')
                if self.dlg.click0.isChecked():
                    if self.dlg.p1_x_src.text() == '':
                        self.dlg.click1.setChecked(True)
                        self.dlg.label_info.setText('　マップキャンバスをクリックして、１点目の変換元座標を取得してください。')
                    elif self.dlg.p1_y_src.text() == '':
                        self.dlg.click2.setChecked(True)
                        self.dlg.label_info.setText('　マップキャンバスをクリックして、１点目の変換元座標を取得してください。')
                    elif self.dlg.p2_y_src.text() == '':
                        self.dlg.click2.setChecked(True)
                        self.dlg.label_info.setText('　マップキャンバスをクリックして、２点目の変換元座標を取得してください。')
                    elif self.dlg.p2_y_src.text() == '':
                        self.dlg.click2.setChecked(True)
                        self.dlg.label_info.setText('　マップキャンバスをクリックして、２点目の変換元座標を取得してください。')
                    elif self.dlg.p1_x_dst.text() == '':
                        self.dlg.click3x.setChecked(True)
                        self.dlg.label_info.setText('　マップキャンバスをクリックして、３点目の変換先座標を取得してください。')
                    elif self.dlg.p1_y_dst.text() == '':
                        self.dlg.click3x.setChecked(True)
                        self.dlg.label_info.setText('　マップキャンバスをクリックして、３点目の変換先座標を取得してください。')
                self.dlg.raise_()
                return
            # ヘルマート座標取得モード中か確認
            if self.dlg.helmert_step in [1, 2]:
                point_clicked = self.toMapCoordinates(e.pos())
                # SIMAレイヤから一番近い点を取得 (前回作成したロジックを利用)
                try:
                    #layer_sim = QgsProject.instance().mapLayersByName('SIMA')[0]
                    layer_sim = QgsProject.instance().mapLayersByName(self.dlg.layerName1.text())[0]
                except:
                    #print("SIMAレイヤが見つかりません")
                    print(self.dlg.layerName1.text() +"レイヤが見つかりません")
                    return
                # 検索半径20m（環境に合わせて調整）
                hankei = float(self.dlg.hankei.text())
                request = QgsFeatureRequest().setDistanceWithin(QgsGeometry.fromPointXY(point_clicked), hankei)
                nearest_feat = None
                min_dist = 999999.0
                for feat in layer_sim.getFeatures(request):
                    dist = feat.geometry().distance(QgsGeometry.fromPointXY(point_clicked))
                    if dist < min_dist:
                        min_dist = dist
                        nearest_feat = feat
                if nearest_feat:
                    # SIMAレイヤの属性x, yを取得
                    attr_x = nearest_feat['x']
                    attr_y = nearest_feat['y']
                    if self.dlg.helmert_step == 1:
                        self.dlg.p1_x_src.setText(str(attr_x))
                        self.dlg.p1_y_src.setText(str(attr_y))
                        self.dlg.helmert_step = 2 # 次は2点目
                        print("1点目取得完了。続いて2点目をクリックしてください。")
                        self.dlg.label_info.setText("　1点目取得完了。続いて2点目をクリックしてください。")
                    elif self.dlg.helmert_step == 2:
                        self.dlg.p2_x_src.setText(str(attr_x))
                        self.dlg.p2_y_src.setText(str(attr_y))
                        self.dlg.helmert_step = 0 # 取得完了
                        print("　2点目取得完了。変換後の座標を入力して変換実行ボタンを押してください。")
                        self.dlg.label_info.setText("2点目取得完了。変換後の座標を入力して「変換実行」ボタンを押してください。")
                self.dlg.raise_()
                self.dlg.p1_x_dst.setFocus()
                return # 他のクリック処理へ行かないように終了
        #[WorldFile]
        if self.dlg.tabWidget.currentIndex() == 3:
            if self.dlg.checkBox_xt.isChecked() or self.dlg.checkBox_yt.isChecked() or self.dlg.checkBox_xb.isChecked() or self.dlg.checkBox_yb.isChecked():
                ws = QSettings("M'z Room", "Digitizer3")
                workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
                if self.dlg.lineEditXY.text() == '':
                    x1 = str(int(abs(mPos.x())))
                    y1 = str(int(abs(mPos.y())))
                    self.dlg.lineEditXY.setText(x1 + ',' + y1)
                else:
                    prgPath = ''
                    if sys.platform == "win32": # Windows
                        # Tesseract-OCR を prgPath1・prgPath2 以外にインストールした場合は、OSの種類に拘わらず prgPath2 を書き換えると良い。
                        prgPath1 = 'C:/PROGRA~1/Tesseract-OCR/tesseract.exe' # 32bit OS
                        prgPath2 = 'C:/PROGRA~2/Tesseract-OCR/tesseract.exe' # 64bit OS
                        if os.path.exists(prgPath1):
                            prgPath = prgPath1 + ' '
                            prgDir = prgPath1
                        else:
                            if os.path.exists(prgPath2):
                                prgPath = prgPath2 + ' '
                                prgDir = prgPath2
                    else: # Mac
                        if os.path.isdir('/usr/local/Cellar/tesseract/'):
                            for root, dirs, files in os.walk('/usr/local/Cellar/tesseract/'):
                                for fname in files:
                                    if os.path.join(root, fname)[-9:] == 'tesseract':
                                        prgPath = os.path.join(root, fname) + ' '
                                        prgDir = os.path.join(root, fname)
                    x2 = int(abs(mPos.x()))
                    y2 = int(abs(mPos.y()))
                    xy = self.dlg.lineEditXY.text().split(',')
                    x1 = int(xy[0])
                    y1 = int(xy[1])
                    if x1 == x2:
                        self.dlg.lineEditXY.setText('')
                        self.dlg.show()
                        self.dlg.raise_()
                        # プロジェクトのCRS設定を開始時に戻す
                        settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                    elif x1 > x2:
                        right = x1
                        left = x2
                    else:
                        right = x2
                        left = x1
                    if y1 == y2:
                        self.dlg.lineEditXY.setText('')
                        self.dlg.show()
                        self.dlg.raise_()
                        # プロジェクトのCRS設定を開始時に戻す
                        settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                    elif y1 > y2:
                        upper = y2
                        lower = y1
                    else:
                        upper = y1
                        lower = y2
                    self.dlg.lineEditXY.setText('')
                    img = Image.open(self.dlg.lineEdit_path.text())
                    fname = workPath + '/zahyo.png'
                    img.crop((left, upper, right, lower)).save(fname)
                    tate = abs(abs(upper) - abs(lower))
                    yoko = abs(abs(right) - abs(left))
                    if tate == yoko:
                        tateyoko = tate + 10
                    elif tate > yoko:
                        tateyoko = tate + 10
                    else:
                        tateyoko = yoko + 10
                    if self.dlg.checkBox_xt.isChecked():
                        # 回転が必要
                        img1 = Image.open(fname)
                        img2 = Image.new('RGB', (tateyoko, tateyoko), (255, 255, 255))
                        img2.paste(img1, (int(tateyoko / 2), 5))
                        img2 = img2.rotate(90).save(fname)
                    elif self.dlg.checkBox_xb.isChecked():
                        # 表示年月日切出(430×70)
                        fname2 = workPath + u'/date.png'
                        img.crop((545, 145, 975, 215)).save(fname2)
                        # OCR実行
                        cmd = prgPath + workPath + u'/date.png ' + workPath + u'/date -psm 7'
                        subprocess.call(cmd, shell=True)
                        # 表示年月日のOCR
                        tname = workPath + u'/date.txt'
                        line = ''
                        f = open(tname, 'r')
                        try:
                            line = f.readline()
                            line = line.replace('\r\n', '')
                            line = line.replace('\r', '')
                            line = line.replace('\n', '')
                            line = line.replace(' ', '')
                            line = line.replace(',', '.')
                            line = line.replace('=', '')
                            line = line.replace('+', '')
                            line = line.replace('＋', '')
                            line = line.replace('—', '-')
                            line = line.replace('E', '9')
                        except:
                            pass
                        # 回転が必要
                        img3 = Image.open(fname)
                        img4 = Image.new('RGB', (tateyoko, tateyoko), (255, 255, 255))
                        img4.paste(img3, (int(tateyoko / 2), 5))
                        if line != '':# 新見出有 2018/10/1以前
                            img4 = img4.rotate(270).save(fname)
                        else:# 新見出有 2018/10/1以降
                            img4 = img4.rotate(90).save(fname)
                    if prgPath != '':
                        # OCR実行
                        dirpath = os.path.dirname(prgDir)
                        os.chdir(dirpath)
                        cmd = prgPath + workPath + '/zahyo.png ' + workPath + '/zahyo -psm 7'
                        result = subprocess.run(cmd, shell=True)
                        if result.returncode != 0:
                            QMessageBox.information(None, u'Tesseract-OCR', u'OCRに失敗しました。（Tesseract-OCR）')
                            self.dlg.show()
                            self.dlg.raise_()
                            # プロジェクトのCRS設定を開始時に戻す
                            settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                            return
                        # OCR結果読込
                        #sleep(0.5)
                        fname = workPath + '/zahyo.txt'
                        try:
                            f = open(fname, 'r')
                            line = f.readline()
                            line = line.replace('\r\n', '')
                            line = line.replace('\r', '')
                            line = line.replace('\n', '')
                            line = line.replace(' ', '')
                            line = line.replace(',', '.')
                            line = line.replace('=', '')
                            line = line.replace('+', '')
                            line = line.replace('＋', '')
                            line = line.replace('—', '-')
                            line = line.replace('E', '9')
                            n = 0
                            while line:
                                if n == 0:
                                    if self.dlg.checkBox_xt.isChecked():
                                        self.dlg.xt2.setText(line)
                                    elif self.dlg.checkBox_yt.isChecked():
                                        self.dlg.yt2.setText(line)
                                    elif self.dlg.checkBox_xb.isChecked():
                                        self.dlg.xb2.setText(line)
                                    elif self.dlg.checkBox_yb.isChecked():
                                        self.dlg.yb2.setText(line)
                                line = f.readline()
                                n = n + 1
                        except:
                            pass
                        f.close()
                        # 作業ファイル削除
                        if os.path.exists(workPath + '/zahyo.png'):
                            os.remove(workPath + '/zahyo.png')
                        if os.path.exists(workPath + '/zahyo.txt'):
                            os.remove(workPath + '/zahyo.txt')
                        if os.path.exists(workPath + '/date.png'):
                            os.remove(workPath + '/date.png')
                        if os.path.exists(workPath + '/date.txt'):
                            os.remove(workPath + '/date.txt')
                self.dlg.show()
                self.dlg.raise_()
                # プロジェクトのCRS設定を開始時に戻す
                settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                return
            if self.dlg.checkBox_capture.isChecked():#画像の回転
                if self.dlg.radioButton_lb.isChecked():#1点目
                    self.dlg.xb2.setText(xx)
                    self.dlg.yb2.setText(yy)
                    if self.dlg.xt2.text() != '' and self.dlg.yt2.text() != '':
                        x1 = 0
                        y1 = float(self.dlg.yb2.text())
                        x2 = float(self.dlg.xt2.text()) - float(self.dlg.xb2.text())
                        y2 = float(self.dlg.yt2.text())
                        dx = x2 - x1
                        dy = y2 - y1
                        if dx == 0:
                            if dy == 0:
                                r_deg = 0
                            if dy > 0:
                                r_deg = 90
                            if dy < 0:
                                r_deg = 270
                            self.dlg.lineEdit_rotate.setText(str(r_deg))
                            # プロジェクトのCRS設定を開始時に戻す
                            settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                            return
                        if dy == 0:
                            if dx == 0:
                                r_deg = 0
                            if dx > 0:
                                r_deg = 90
                            if dx < 0:
                                r_deg = 270
                            self.dlg.lineEdit_rotate.setText(str(r_deg))
                            # プロジェクトのCRS設定を開始時に戻す
                            settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                            return
                        a = math.degrees(math.atan2(dy, dx))
                        if dx > 0 and dy > 0:#第1象限
                            self.dlg.lineEdit_rotate.setText(str(a))
                        if dx < 0 and dy > 0:#第2象限
                            self.dlg.lineEdit_rotate.setText(str(a))
                        if dx < 0 and dy < 0:#第3象限
                            self.dlg.lineEdit_rotate.setText(str(360 + a))
                        if dx > 0 and dy < 0:#第4象限
                            self.dlg.lineEdit_rotate.setText(str(360 + a))
                    self.dlg.radioButton_rt.setChecked(True)
                else:#2点目
                    self.dlg.xt2.setText(xx)
                    self.dlg.yt2.setText(yy)
                    if self.dlg.xb2.text() != '' and self.dlg.yb2.text() != '':
                        x1 = 0
                        y1 = float(self.dlg.yb2.text())
                        x2 = float(self.dlg.xt2.text()) - float(self.dlg.xb2.text())
                        y2 = float(self.dlg.yt2.text())
                        dx = x2 - x1
                        dy = y2 - y1
                        if dx == 0:
                            if dy == 0:
                                r_deg = 0
                            if dy > 0:
                                r_deg = 90
                            if dy < 0:
                                r_deg = 270
                            self.dlg.lineEdit_rotate.setText(str(r_deg))
                            # プロジェクトのCRS設定を開始時に戻す
                            settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                            return
                        if dy == 0:
                            if dx == 0:
                                r_deg = 0
                            if dx > 0:
                                r_deg = 90
                            if dx < 0:
                                r_deg = 270
                            self.dlg.lineEdit_rotate.setText(str(r_deg))
                            # プロジェクトのCRS設定を開始時に戻す
                            settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                            return
                        a = math.degrees(math.atan2(dy, dx))
                        if dx > 0 and dy > 0:#第1象限
                            self.dlg.lineEdit_rotate.setText(str(a))
                        if dx < 0 and dy > 0:#第2象限
                            self.dlg.lineEdit_rotate.setText(str(a))
                        if dx < 0 and dy < 0:#第3象限
                            self.dlg.lineEdit_rotate.setText(str(360 + a))
                        if dx > 0 and dy < 0:#第4象限
                            self.dlg.lineEdit_rotate.setText(str(360 + a))
                    self.dlg.radioButton_lb.setChecked(True)
                self.dlg.raise_()
                # ポイントレイヤの追加
                name = 'rotate'
                layer = QgsVectorLayer('Point?crs=epsg:' + code + '&field=' + self.dlg.tr('name') + '&field=' + self.dlg.tr('x') + '&field=' + self.dlg.tr('y'), name, 'memory')
                provider = layer.dataProvider()
                feature = QgsFeature()
                geometry = QgsGeometry.fromPointXY(QgsPointXY(mPos.x(), mPos.y()))
                feature.setGeometry(geometry)
                feature.setAttributes([name,mPos.y(),mPos.x()])
                provider.addFeatures([feature])
                # グループ化
                QgsProject.instance().addMapLayer(layer, False)
                if QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('WorldFile')) == None:
                    QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.dlg.tr('WorldFile')))
                group = QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('WorldFile'))
                group.insertLayer(0,layer)
                self.iface.mapCanvas().refresh()
                # スタイル設定
                if os.path.exists(os.path.dirname(__file__) + u'/qml/digitizer.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/digitizer.qml')
                # プロジェクトのCRS設定を開始時に戻す
                settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                # カスタムCRSの時にだけ出るメッセージバーを消す
                if messageBar_flag == 1:
                    qgis.utils.iface.messageBar().clearWidgets()
                    messageBar_flag = 0
                return
            if self.dlg.radioButton5.isChecked():#図郭座標を取得しない
                self.dlg.show()
                self.dlg.raise_()
                # プロジェクトのCRS設定を開始時に戻す
                settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                return
            if self.dlg.radioButton1.isChecked():#左下図郭座標
                self.dlg.xb.setText(xx)
                self.dlg.yb.setText(yy)
                name = 'LeftBottom'
            if self.dlg.radioButton2.isChecked():#右上図郭座標
                self.dlg.xt.setText(xx)
                self.dlg.yt.setText(yy)
                name = 'RightTop'
            if self.dlg.radioButton3.isChecked():#左上図郭座標
                self.dlg.xt.setText(xx)
                self.dlg.yb.setText(yy)
                name = 'LeftTop'
            if self.dlg.radioButton4.isChecked():#右下図郭座標
                self.dlg.xb.setText(xx)
                self.dlg.yt.setText(yy)
                name = 'RightBottom'
            # ポイントレイヤの追加
            layer = QgsVectorLayer('Point?crs=epsg:' + code + '&field=' + self.dlg.tr('name') + '&field=' + self.dlg.tr('x') + '&field=' + self.dlg.tr('y'), name, 'memory')
            provider = layer.dataProvider()
            feature = QgsFeature()
            geometry = QgsGeometry.fromPointXY(QgsPointXY(mPos.x(), mPos.y()))
            feature.setGeometry(geometry)
            feature.setAttributes([name,mPos.y(),mPos.x()])
            provider.addFeatures([feature])
            # グループ化
            QgsProject.instance().addMapLayer(layer, False)
            if QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('WorldFile')) == None:
                QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.dlg.tr('WorldFile')))
            group = QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('WorldFile'))
            group.insertLayer(0,layer)
            self.iface.mapCanvas().refresh()
            # スタイル設定
            if os.path.exists(os.path.dirname(__file__) + u'/qml/digitizer.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/digitizer.qml')
            # カスタムCRSの時にだけ出るメッセージバーを消す
            if messageBar_flag == 1:
                qgis.utils.iface.messageBar().clearWidgets()
                messageBar_flag = 0
        #[Georeference]
        if self.dlg.tabWidget.currentIndex() == 4:
            if self.dlg.textEdit_9.toPlainText() == '':
                if self.dlg.lineEdit_path.text() == '':
                    QMessageBox.information(None, 'GCP', u'先にラスタレイヤを追加してください。')
                    self.dlg.raise_()
                    # プロジェクトのCRS設定を開始時に戻す
                    settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                    return
                global Layer_GCP_ID
                if self.dlg.radioButton8.isChecked():
                    self.dlg.xp1.setText(xx)
                    self.dlg.yp1.setText(yy)
                    self.dlg.radioButton9.setChecked(True)
                    name = 'GCP'
                    # ポイントレイヤの追加
                    layer = QgsVectorLayer('Point?crs=epsg:' + code + '&field=' + self.dlg.tr('name') + '&field=' + self.dlg.tr('x') + '&field=' + self.dlg.tr('y'), name, 'memory')
                    provider = layer.dataProvider()
                    feature = QgsFeature()
                    geometry = QgsGeometry.fromPointXY(QgsPointXY(mPos.x(), mPos.y()))
                    feature.setGeometry(geometry)
                    feature.setAttributes([name,mPos.y(),mPos.x()])
                    provider.addFeatures([feature])
                    # グループ化
                    QgsProject.instance().addMapLayer(layer, False)
                    if QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('GroundControlPoint')) == None:
                        QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.dlg.tr('GroundControlPoint')))
                    group = QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('GroundControlPoint'))
                    group.insertLayer(0,layer)
                    self.iface.mapCanvas().refresh()
                    # スタイル設定
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/digitizer.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/digitizer.qml')
                    self.dlg.xp2.setFocus()
                    # ワールドファイル作成前のGCPを削除（やり直しの場合、前のGCPを削除する）
                    try:
                        QgsProject.instance().removeMapLayer(Layer_GCP_ID)
                    except:
                        pass
                    Layer_GCP_ID = layer.id()
                elif self.dlg.radioButton9.isChecked():
                    self.dlg.xp2.setText(xx)
                    self.dlg.yp2.setText(yy)
                    self.dlg.s.setFocus()
            else:
                if self.dlg.radioButton10.isChecked():
                    self.dlg.show()
                    self.dlg.raise_()
                    # プロジェクトのCRS設定を開始時に戻す
                    settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))
                    return
                if self.dlg.radioButton9.isChecked():
                    self.dlg.xp2.setText(xx)
                    self.dlg.yp2.setText(yy)
                    x0 = (float(self.dlg.xp3.text()) - float(self.dlg.xp1.text())) / float(self.dlg.xp4.text())
                    y0 = (float(self.dlg.yp1.text()) - float(self.dlg.yp3.text())) / float(self.dlg.yp4.text())
                    self.dlg.textEdit_8.append(self.dlg.yp2.text() + ',' + self.dlg.xp2.text() + ',' + str(y0) + ',' + str(x0) + ',1')
                    self.dlg.radioButton8.setChecked(True)
                    name = 'Dst'
                else:
                    self.dlg.xp1.setText(xx)
                    self.dlg.yp1.setText(yy)
                    self.dlg.radioButton9.setChecked(True)
                    name = 'Src'
                # ポイントレイヤの追加
                layer = QgsVectorLayer('Point?crs=epsg:' + code + '&field=' + self.dlg.tr('name') + '&field=' + self.dlg.tr('x') + '&field=' + self.dlg.tr('y'), name, 'memory')
                provider = layer.dataProvider()
                feature = QgsFeature()
                geometry = QgsGeometry.fromPointXY(QgsPointXY(mPos.x(), mPos.y()))
                feature.setGeometry(geometry)
                feature.setAttributes([name,mPos.y(),mPos.x()])
                provider.addFeatures([feature])
                # グループ化
                QgsProject.instance().addMapLayer(layer, False)
                if QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('GroundControlPoint')) == None:
                    QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.dlg.tr('GroundControlPoint')))
                group = QgsProject.instance().layerTreeRoot().findGroup(self.dlg.tr('GroundControlPoint'))
                group.insertLayer(0,layer)
                # スタイル設定
                if self.dlg.radioButton9.isChecked():
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/DestGCP.qml'):
                      layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/DestGCP.qml')
                      self.dlg.xp2.setFocus()
                else:
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/SrcGCP.qml'):
                      layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/SrcGCP.qml')
                      self.dlg.xp1.setFocus()
                self.iface.mapCanvas().refresh()
            # カスタムCRSの時にだけ出るメッセージバーを消す
            if messageBar_flag == 1:
                qgis.utils.iface.messageBar().clearWidgets()
                messageBar_flag = 0
        #[Exif]
        if self.dlg.tabWidget.currentIndex() == 5:
            global exif_layer
            try:
                QgsProject.instance().removeMapLayer(exif_layer)
            except:
                pass
            self.dlg.lineEdit_Lat.setText(xx)
            self.dlg.lineEdit_Lon.setText(yy)
            name = 'Exif'
            # ポイントレイヤの追加
            layer = QgsVectorLayer('Point?crs=epsg:' + code + '&field=' + self.dlg.tr('name') + '&field=' + self.dlg.tr('x') + '&field=' + self.dlg.tr('y'), name, 'memory')
            provider = layer.dataProvider()
            feature = QgsFeature()
            geometry = QgsGeometry.fromPointXY(QgsPointXY(mPos.x(), mPos.y()))
            feature.setGeometry(geometry)
            feature.setAttributes([name,mPos.y(),mPos.x()])
            provider.addFeatures([feature])
            tree = qgis.utils.iface.layerTreeView()
            tree.setCurrentLayer(None)
            QgsProject.instance().addMapLayer(layer)
            self.iface.mapCanvas().refresh()
            exif_layer = layer.id()
            # スタイル設定
            if os.path.exists(os.path.dirname(__file__) + u'/qml/digitizer.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/digitizer.qml')
            # カスタムCRSの時にだけ出るメッセージバーを消す
            if messageBar_flag == 1:
                qgis.utils.iface.messageBar().clearWidgets()
                messageBar_flag = 0
        #[座標変換]
        if self.dlg.tabWidget.currentIndex() == 6:
            if self.dlg.checkBox_2.isChecked():
                # 取得した座標を表示
                self.iface.mapCanvas().setCenter(mPos)
                self.dlg.lineEditX1.setText(str(mPos.y()))
                self.dlg.lineEditY1.setText(str(mPos.x()))
                self.dlg.radioButton_EPSG1.setChecked(True)
                self.dlg.lineEdit_EPSG1.setText(code)
                # プロジェクトのEPSGを取得
                # 変換先のEPSGが指定されていないか、変換元と変換先のEPSGが同じか、変換先がプロジェクトのEPSGコードと同じ場合はココで終了
                if self.dlg.lineEdit_EPSG2.text() == '' or self.dlg.lineEdit_EPSG1.text() == self.dlg.lineEdit_EPSG2.text() or self.dlg.lineEdit_EPSG2.text() == epsgcode or self.dlg.lineEdit_EPSG2.text() == usercode:
                    self.dlg.lineEdit_EPSG1.setText(code)
                    self.dlg.lineEditX2.setText('')
                    self.dlg.lineEditY2.setText('')
                    self.dlg.raise_()
                    return
                self.dlg.pButton_10()
        #[GNSS]
        if self.dlg.tabWidget.currentIndex() == 7:
            mPos = self.toMapCoordinates(e.pos())
            y1 = str(mPos.x())
            x1 = str(mPos.y())
            rect = QgsRectangle(float(y1),float(x1),float(y1),float(x1))
            map.setExtent(rect)
            map.refresh()
            if self.dlg.check_tansaku.isChecked():
                # プロジェクトのCRSを取得
                epsgGet()
                if epsgcode != '':
                    code = epsgcode
                else:
                    code = usercode
                self.dlg.x1.setText('')
                self.dlg.y1.setText('')
                EPSG1 = int(code)
                epsg2 = self.dlg.kei.currentText().split(':')
                EPSG2 = int(epsg2[1])
                if EPSG1 == EPSG2:
                    self.dlg.x1.setText('{:.3f}'.format(round(float(coordinate[3]), 3)))
                    self.dlg.y1.setText('{:.3f}'.format(round(float(coordinate[4]), 3)))
                else:
                    if epsgcode == '':#カスタムCRSの場合
                        Src_crs = QgsCoordinateReferenceSystem()
                        Src_crs.createFromId(EPSG1, QgsCoordinateReferenceSystem.InternalCrsId)
                        crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                    else:
                        Src_crs = QgsCoordinateReferenceSystem(EPSG1)
                        crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                    crsDest = QgsCoordinateReferenceSystem(EPSG2)
                    trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                    y2,x2 = trans.transform(float(y1), float(x1))
                    self.dlg.x1.setText('{:.3f}'.format(round(x2, 3)))
                    self.dlg.y1.setText('{:.3f}'.format(round(y2, 3)))
        self.dlg.show()
        self.dlg.raise_()
        self.dlg.checkBox.setChecked(True)
        self.iface.mapCanvas().refresh()
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.dlg.lineEdit_crsSetting.text()))



# ダイアログメニュー
class Dialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        super(Dialog, self).__init__(parent)
        self.setupUi(self)
        # マップキャンバスウィジェット
        global map
        map = qgis.utils.iface.mapCanvas()
        # プロジェクトのCRS設定を取得する
        global settings
        settings = QSettings()
        global ws
        ws = QSettings("M'z Room", "Digitizer3")
        # 開始時のCRS設定を記憶する
        oldProjValue = settings.value('/Projections/defaultBehavior')
        # 新しいレイヤの投影座標系の設定の取得
        if oldProjValue == 'prompt':
            self.radioButton_crsSetting1.setChecked(True)
            self.lineEdit_crsSetting.setText('prompt')
        if oldProjValue == 'useProject':
            self.radioButton_crsSetting2.setChecked(True)
            self.lineEdit_crsSetting.setText('useProject')
        if oldProjValue == 'useGlobal':
            self.radioButton_crsSetting3.setChecked(True)
            self.lineEdit_crsSetting.setText('useGlobal')
        # QGIS pythonのbinフォルダ
        pv = sys.version.split(".")
        p_path = str(sys.executable).split("\\")
        bin_dir = p_path[0] + "/" + p_path[1] + "/" + p_path[2] + "/bin/"
        self.lineEdit_bin.setText(bin_dir)
        # [I/O]
        self.comboBox_3.clear()
        self.comboBox_3.addItem('')
        self.comboBox_3.addItem(u'世界測地系(JGD2000),4612')
        self.comboBox_3.addItem(u'日本測地系(Tokyo),4301')
        self.comboBox_3.addItem(u'世界測地系1984(WGS84),4326')
        self.comboBox_3.addItem(u'世界測地系(1系),2443')
        self.comboBox_3.addItem(u'世界測地系(2系),2444')
        self.comboBox_3.addItem(u'世界測地系(3系),2445')
        self.comboBox_3.addItem(u'世界測地系(4系),2446')
        self.comboBox_3.addItem(u'世界測地系(5系),2447')
        self.comboBox_3.addItem(u'世界測地系(6系),2448')
        self.comboBox_3.addItem(u'世界測地系(7系),2449')
        self.comboBox_3.addItem(u'世界測地系(8系),2450')
        self.comboBox_3.addItem(u'世界測地系(9系),2451')
        self.comboBox_3.addItem(u'世界測地系(10系),2452')
        self.comboBox_3.addItem(u'世界測地系(11系),2453')
        self.comboBox_3.addItem(u'世界測地系(12系),2454')
        self.comboBox_3.addItem(u'世界測地系(13系),2455')
        self.comboBox_3.addItem(u'世界測地系(14系),2456')
        self.comboBox_3.addItem(u'世界測地系(15系),2457')
        self.comboBox_3.addItem(u'世界測地系(16系),2458')
        self.comboBox_3.addItem(u'世界測地系(17系),2459')
        self.comboBox_3.addItem(u'世界測地系(18系),2460')
        self.comboBox_3.addItem(u'世界測地系(19系),2461')
        self.comboBox_3.addItem(u'日本測地系(1系),30161')
        self.comboBox_3.addItem(u'日本測地系(2系),30162')
        self.comboBox_3.addItem(u'日本測地系(3系),30163')
        self.comboBox_3.addItem(u'日本測地系(4系),30164')
        self.comboBox_3.addItem(u'日本測地系(5系),30165')
        self.comboBox_3.addItem(u'日本測地系(6系),30166')
        self.comboBox_3.addItem(u'日本測地系(7系),30167')
        self.comboBox_3.addItem(u'日本測地系(8系),30168')
        self.comboBox_3.addItem(u'日本測地系(9系),30169')
        self.comboBox_3.addItem(u'日本測地系(10系),30170')
        self.comboBox_3.addItem(u'日本測地系(11系),30171')
        self.comboBox_3.addItem(u'日本測地系(12系),30172')
        self.comboBox_3.addItem(u'日本測地系(13系),30173')
        self.comboBox_3.addItem(u'日本測地系(14系),30174')
        self.comboBox_3.addItem(u'日本測地系(15系),30175')
        self.comboBox_3.addItem(u'日本測地系(16系),30176')
        self.comboBox_3.addItem(u'日本測地系(17系),30177')
        self.comboBox_3.addItem(u'日本測地系(18系),30178')
        self.comboBox_3.addItem(u'日本測地系(19系),30179')
        self.comboBox_3.addItem(u'世界測地系(UTM51N),3097')
        self.comboBox_3.addItem(u'世界測地系(UTM52N),3098')
        self.comboBox_3.addItem(u'世界測地系(UTM53N),3099')
        self.comboBox_3.addItem(u'世界測地系(UTM54N),3100')
        self.comboBox_3.addItem(u'世界測地系(UTM55N),3101')
        self.comboBox_3.addItem(u'日本測地系(UTM51N),3092')
        self.comboBox_3.addItem(u'日本測地系(UTM52N),3093')
        self.comboBox_3.addItem(u'日本測地系(UTM53N),3094')
        self.comboBox_3.addItem(u'日本測地系(UTM54N),3095')
        self.comboBox_3.addItem(u'日本測地系(UTM55N),3096')
        self.comboBox_3.addItem(u'WGS84(UTM51N),32651')
        self.comboBox_3.addItem(u'WGS84(UTM52N),32652')
        self.comboBox_3.addItem(u'WGS84(UTM53N),32653')
        self.comboBox_3.addItem(u'WGS84(UTM54N),32654')
        self.comboBox_3.addItem(u'WGS84(UTM55N),32655')
        self.comboBox_3.addItem(u'WGS84(Pseudo-Mercator),3857')
        # カスタムCRSをリストに追加
        if sys.platform == "win32":
            ucfname = os.path.dirname(__file__) + u'/user_crs.txt'
            if os.path.exists(ucfname):
                for line in codecs.open(ucfname,'r', 'utf-8'):
                    self.comboBox_3.addItem(line.rstrip('\r\n'))
        else:
            ucfname = os.path.dirname(__file__) + u'/user_crs_mac.txt'
            if os.path.exists(ucfname):
                for line in codecs.open(ucfname,'r', 'utf-8'):
                    self.comboBox_3.addItem(line.rstrip('\r\n'))
        # プロジェクトのCRSコンボボックスをセットする
        self.set_Combo()
        # スタイルファイルリストの取得
        qmldir = os.path.dirname(__file__) + u'/qml'
        self.comboBox_2.clear()
        self.comboBox_2.addItem('')
        for root, dirs, files in os.walk(qmldir):
            for file in files:
                if file.lower()[-4:] == '.qml':
                    self.comboBox_2.addItem(str(file))
        # タイルリストを追加
        tfname = os.path.dirname(__file__) + u'/tile.txt'
        if os.path.exists(tfname):
            for line in codecs.open(tfname,'r', 'utf-8'):
                if line[:1] != '#' and line != '\n' and line != '\r\n':
                    dat = line.rstrip('\r\n').split(',')
                    self.haikei.addItem(dat[0])
                    self.haikei2.addItem(line.rstrip('\r\n'))
        # 都道府県リストを追加
        tfname = os.path.dirname(__file__) + u'/pref.txt'
        if os.path.exists(tfname):
            for line in codecs.open(tfname,'r', 'utf-8'):
                if line[:1] != '#' and line != '\n' and line != '\r\n':
                    dat = line.rstrip('\r\n').split(',')
                    self.pref.addItem(dat[0])
                    self.pref2.addItem(line.rstrip('\r\n'))
        # プロジェクトファイルリストを追加
        projdir = os.path.dirname(__file__) + u'/project'
        self.combo_project.clear()
        self.combo_project.addItem('')
        for root, dirs, files in os.walk(projdir):
            for file in files:
                if file.lower()[-4:] == '.qgs':
                    self.combo_project.addItem(str(file))
        # スケールを取得
        scale = round(map.scale(), 0)
        self.lineEdit_scale.setText(str(int(scale)))
        # [GDAL/OGR]
        # gdalwarp/ogr2ogr によるデータコンバート
        self.comboBox_format2.clear()
        self.comboBox_format2.addItem(u'tif')
        self.comboBox_format2.addItem(u'png')
        self.comboBox_format2.addItem(u'bmp')
        self.comboBox_format2.addItem(u'jpg')
        self.comboBox_format2.addItem(u'pdf')
        self.comboBox_format2.setCurrentIndex(0)
        # ヘルマート用：現在何点目を待機しているか (0:待機なし, 1:一点目, 2:二点目)
        self.helmert_step = 0

        # ZIPリストを追加
        zfname = os.path.dirname(__file__) + u'/url.txt'
        if os.path.exists(zfname):
            for line in codecs.open(zfname,'r', 'utf-8'):
                dat = line.rstrip('\r\n').split('/download/')
                self.listWidget_ziplist.addItem(dat[1])
                self.listWidget_ziplist2.addItem(line.rstrip('\r\n'))

        # 検索用リストを追加
        kfname = os.path.dirname(__file__) + u'/city.txt'
        if os.path.exists(kfname):
            for line in codecs.open(kfname,'r', 'utf-8'):
                dat = line.rstrip('\r\n')
                self.listWidget_kensaku.addItem(dat)

        # [WorldFile]
        # パターンファイルリストの設定
        self.comboBox_format.clear()
        self.comboBox_format.addItem('dxf')
        self.comboBox_format.addItem('geojson')
        self.comboBox_format.addItem('fgb')
        self.comboBox_format.addItem('shp')
        self.comboBox_format.addItem('txt')
        self.comboBox_format.addItem('laz')
        self.comboBox_format.setCurrentIndex(0)
        fpath = self.lineEdit_path_wf.text()
        self.lineEdit_path.setText(fpath)
        self.comboBox.clear()
        self.textEdit_pattern.clear()
        self.comboBox.addItem(u'新見出有,-596,4306,-4563,371')
        self.comboBox.addItem(u'旧見出有,-596,4312,-4564,371')
        self.comboBox.addItem(u'旧見出無,-636,4312,-4604,371')
        ptfname = os.path.dirname(__file__) + u'\pattern.txt'
        if os.path.exists(ptfname):
            for line in codecs.open(ptfname,'r', 'shift-jis'):
                self.comboBox.addItem(line.replace((u'\n' or u'\r\n'),''))
                self.textEdit_pattern.append(line.replace((u'\n' or u'\r\n'),''))
        # [Georeference]
        # 変換タイプ・リサンプリング法・圧縮
        self.comboBox_4.clear()
        self.comboBox_5.clear()
        self.comboBox_6.clear()
        self.comboBox_4.addItem(u'多項式１')
        self.comboBox_4.addItem(u'多項式２')
        self.comboBox_4.addItem(u'多項式３')
        self.comboBox_4.addItem(u'シンプレートスプライン')
        self.comboBox_5.addItem(u'最近傍')
        self.comboBox_5.addItem(u'線形')
        self.comboBox_5.addItem(u'キュービック')
        self.comboBox_5.addItem(u'キュービックスプライン')
        self.comboBox_5.addItem(u'ランチョシュ')
        self.comboBox_6.addItem(u'NONE')
        self.comboBox_6.addItem(u'LZW')
        self.comboBox_6.addItem(u'PACKBITS')
        self.comboBox_6.addItem(u'DEFLATE')
        # [Exif]
        # 平面直角座標系リストの設定
        self.comboKei.clear()
        self.comboKei.addItem('')
        self.comboKei.addItem('1')
        self.comboKei.addItem('2')
        self.comboKei.addItem('3')
        self.comboKei.addItem('4')
        self.comboKei.addItem('5')
        self.comboKei.addItem('6')
        self.comboKei.addItem('7')
        self.comboKei.addItem('8')
        self.comboKei.addItem('9')
        self.comboKei.addItem('10')
        self.comboKei.addItem('11')
        self.comboKei.addItem('12')
        self.comboKei.addItem('13')
        self.comboKei.addItem('14')
        self.comboKei.addItem('15')
        self.comboKei.addItem('16')
        self.comboKei.addItem('17')
        self.comboKei.addItem('18')
        self.comboKei.addItem('19')
        # [GNSS]
        self.kei.addItem(u'世界測地系 (JGD2011)  1 系　： EPSG:6669')
        self.kei.addItem(u'世界測地系 (JGD2011)  2 系　： EPSG:6670')
        self.kei.addItem(u'世界測地系 (JGD2011)  3 系　： EPSG:6671')
        self.kei.addItem(u'世界測地系 (JGD2011)  4 系　： EPSG:6672')
        self.kei.addItem(u'世界測地系 (JGD2011)  5 系　： EPSG:6673')
        self.kei.addItem(u'世界測地系 (JGD2011)  6 系　： EPSG:6674')
        self.kei.addItem(u'世界測地系 (JGD2011)  7 系　： EPSG:6675')
        self.kei.addItem(u'世界測地系 (JGD2011)  8 系　： EPSG:6676')
        self.kei.addItem(u'世界測地系 (JGD2011)  9 系　： EPSG:6677')
        self.kei.addItem(u'世界測地系 (JGD2011) 10 系　： EPSG:6678')
        self.kei.addItem(u'世界測地系 (JGD2011) 11 系　： EPSG:6679')
        self.kei.addItem(u'世界測地系 (JGD2011) 12 系　： EPSG:6680')
        self.kei.addItem(u'世界測地系 (JGD2011) 13 系　： EPSG:6681')
        self.kei.addItem(u'世界測地系 (JGD2011) 14 系　： EPSG:6682')
        self.kei.addItem(u'世界測地系 (JGD2011) 15 系　： EPSG:6683')
        self.kei.addItem(u'世界測地系 (JGD2011) 16 系　： EPSG:6684')
        self.kei.addItem(u'世界測地系 (JGD2011) 17 系　： EPSG:6685')
        self.kei.addItem(u'世界測地系 (JGD2011) 18 系　： EPSG:6686')
        self.kei.addItem(u'世界測地系 (JGD2011) 19 系　： EPSG:6687')
        self.comboBox_port.addItem(u'COM1')
        self.comboBox_port.addItem(u'COM2')
        self.comboBox_port.addItem(u'COM3')
        self.comboBox_port.addItem(u'COM4')
        self.comboBox_port.addItem(u'COM5')
        self.comboBox_port.addItem(u'COM6')
        self.comboBox_port.addItem(u'COM7')
        self.comboBox_port.addItem(u'COM8')
        self.comboBox_port.addItem(u'COM9')
        self.comboBox_port.addItem(u'COM10')
        self.comboBox_port.addItem(u'COM11')
        self.comboBox_port.addItem(u'COM12')
        self.comboBox_port.addItem(u'ttyUSB0')
        self.comboBox_port.addItem(u'ttyUSB1')
        self.comboBox_port.addItem(u'ttyACM0')
        self.comboBox_port.addItem(u'ttyACM1')
        self.comboBox_port.addItem(u'tty.usbmodem14101')
        self.comboBox_port.addItem(u'tty.usbmodem14201')
        self.comboBox_baudrate.addItem(u'1200')
        self.comboBox_baudrate.addItem(u'2400')
        self.comboBox_baudrate.addItem(u'4800')
        self.comboBox_baudrate.addItem(u'9600')
        self.comboBox_baudrate.addItem(u'14400')
        self.comboBox_baudrate.addItem(u'19200')
        self.comboBox_baudrate.addItem(u'38400')
        self.comboBox_baudrate.addItem(u'57600')
        self.comboBox_baudrate.addItem(u'115200')
        self.comboBox_baudrate.addItem(u'230400')
        self.comboBox_baudrate.addItem(u'460800')
        self.comboBox_sentence.addItem(u'GNRMC/GPRMC')
        self.comboBox_sentence.addItem(u'GNGGA/GPGGA')
        self.comboBox_sentence.addItem(u'GNGLL/GPGLL')
        self.comboBox_sentence.addItem(u'NMEA')
        self.comboBox_sentence.addItem(u'RTKNAVI_FIX')
        self.comboBox_sentence.addItem(u'RTKNAVI_ALL')
        self.comboBox_sentence.addItem(u'RTKNAVI_RATIO')
        self.comboBox_sentence.addItem(u'TCP_FIX')
        self.comboBox_sentence.addItem(u'TCP_ALL')
        self.comboBox_sentence.addItem(u'TCP_RATIO')
        gnss_kei = ws.value("setting/GNSS_Kei", 12)                # 平面直角座標系
        gnss_port = ws.value("setting/GNSS_Port", 3)               # Port
        gnss_baudrate = ws.value("setting/GNSS_Baudrate", 8)       # Baudrate
        gnss_sentence = ws.value("setting/GNSS_Sentence", 1)       # Sentence
        gnss_time = ws.value("setting/GNSS_Time", '0')             # Time
        gnss_plot = ws.value("setting/GNSS_Plot", '0')             # プロット
        gnss_centering = ws.value("setting/GNSS_Centering", '0')   # センタリング
        gnss_log = ws.value("setting/GNSS_Log", '0')               # ログ表示
        gnss_view = ws.value("setting/GNSS_View", '0')             # 詳細表示
        self.kei.setCurrentIndex(gnss_kei)
        self.comboBox_port.setCurrentIndex(gnss_port)
        self.comboBox_baudrate.setCurrentIndex(gnss_baudrate)
        self.comboBox_sentence.setCurrentIndex(gnss_sentence)
        if gnss_sentence == 6:
            self.lineEdit_Ratio.setEnabled(True)
        else:
            self.lineEdit_Ratio.setEnabled(False)
        if gnss_time == '1':
            self.radioButton_time1.setChecked(True)
        else:
            self.radioButton_time2.setChecked(True)
        if gnss_plot == '1':
            self.check_plot.setChecked(True)
        else:
            self.check_plot.setChecked(False)
        if gnss_centering == '1':
            self.check_centering.setChecked(True)
        else:
            self.check_centering.setChecked(False)
        if gnss_log == '1':
            self.check_log.setChecked(True)
        else:
            self.check_log.setChecked(False)
        if gnss_view == '1':
            self.check_shousai.setChecked(True)
        else:
            self.check_shousai.setChecked(False)
        if self.check_plot.isChecked():
            self.check_centering.setEnabled(True)
        else:
            self.check_centering.setChecked(False)
            self.check_centering.setEnabled(False)
        self.SetEnable5()
        self.switch_on.setFocus()

        # ウィンドウの設定を復元する
        # [全般]
        #ウィンドウの位置とサイズ
        window_x = ws.value("setting/window_x", 8)
        window_y = ws.value("setting/window_y", 32)
        window_w = ws.value("setting/window_w", 570)
        self.setGeometry(window_x, window_y, window_w, 368)
        if window_w == 250:
            self.pushButton_18.setText(u'最大化')
        else:
            self.pushButton_18.setText(u'最小化')
        # [Digitizer]
        # 点名の頭文字
        pn_header1 = ws.value("setting/pn_header1", "D")
        try:
            self.lineEdit_1.setText(pn_header1)
        except:
            pass

        # [I/O]
        # 読込オプション
        op_x = ws.value("setting/op_x", 1)
        op_y = ws.value("setting/op_y", 2)
        op_sep = ws.value("setting/op_sep", ',')
        self.lineEdit_5.setText(str(op_x))
        self.lineEdit_6.setText(str(op_y))
        self.lineEdit_7.setText(str(op_sep))
        # 都道府県リスト設定
        pref = ws.value("setting/pref", 0)
        self.pref.setCurrentIndex(pref)
        txt2las_path = ws.value("setting/txt2las_path", '')
        self.label_txt2las.setText(txt2las_path)

        # [GDAL/OGR]
        # 読込オプション
        python_path = ws.value("setting/python_Path", "")
        self.python_path.setText(python_path)
        mojxml2geojson_folder = ws.value("setting/mojxml2geojson_Path", "")
        self.mojxml2geojson_folder.setText(mojxml2geojson_folder)
        check_xml_1 = ws.value("setting/check_xml_1", "1")
        if check_xml_1 == "1":
            self.check_xml_1.setChecked(True)
        else:
            self.check_xml_1.setChecked(False)
        check_xml_2 = ws.value("setting/check_xml_2", "1")
        if check_xml_2 == "1":
            self.check_xml_2.setChecked(True)
        else:
            self.check_xml_2.setChecked(False)
        check_xml_3 = ws.value("setting/check_xml_3", "0")
        if check_xml_3 == "1":
            self.check_xml_3.setChecked(True)
        else:
            self.check_xml_3.setChecked(False)
        check_xml_4 = ws.value("setting/check_xml_4", "0")
        if check_xml_4 == "1":
            self.check_xml_4.setChecked(True)
        else:
            self.check_xml_4.setChecked(False)
        check_xml_5 = ws.value("setting/check_xml_5", "1")
        if check_xml_5 == "1":
            self.check_xml_5.setChecked(True)
        else:
            self.check_xml_5.setChecked(False)
        check_xml_6 = ws.value("setting/check_xml_6", "0")
        if check_xml_6 == "1":
            self.check_xml_6.setChecked(True)
        else:
            self.check_xml_6.setChecked(False)
        check_xml_7 = ws.value("setting/check_xml_7", "0")
        if check_xml_7 == "1":
            self.check_xml_7.setChecked(True)
        else:
            self.check_xml_7.setChecked(False)
        check_xml_8 = ws.value("setting/check_xml_8", "0")
        if check_xml_8 == "1":
            self.check_xml_8.setChecked(True)
        else:
            self.check_xml_8.setChecked(False)
        check_xml_9 = ws.value("setting/check_xml_9", "0")
        if check_xml_9 == "1":
            self.check_xml_9.setChecked(True)
        else:
            self.check_xml_9.setChecked(False)
        pm_op_1 = ws.value("setting/pm_op_1", "moj_map")
        self.pm_op_1.setText(pm_op_1)
        pm_op_2 = ws.value("setting/pm_op_2", "16")
        self.pm_op_2.setText(pm_op_2)
        pm_op_3 = ws.value("setting/pm_op_3", "8")
        self.pm_op_3.setText(pm_op_3)
        pm_op_4 = ws.value("setting/pm_op_4", "moj_map")
        self.pm_op_4.setText(pm_op_4)
        pm_op_5 = ws.value("setting/pm_op_5", "chiban")
        self.pm_op_1.setText(pm_op_1)
        pm_op_6 = ws.value("setting/pm_op_6", "18")
        self.pm_op_6.setText(pm_op_6)
        pm_op_7 = ws.value("setting/pm_op_7", "16")
        self.pm_op_1.setText(pm_op_1)
        pm_op_8 = ws.value("setting/pm_op_8", "")
        self.pm_op_8.setText(pm_op_8)
        pm_op_9 = ws.value("setting/pm_op_9", "")
        self.lineEdit_tippecanoe.setText(pm_op_9)
        pm_ubuntu = ws.value("setting/pm_ubuntu", "Ubuntu-22.04")
        self.pm_ubuntu.setText(pm_ubuntu)
        pm_src = ws.value("setting/pm_src", "1")
        if pm_src == "1":
            self.radioButton_pm_1.setChecked(True)
        elif pm_src == "2":
            self.radioButton_pm_2.setChecked(True)
        elif pm_src == "3":
            self.radioButton_pm_3.setChecked(True)
        elif pm_src == "4":
            self.radioButton_pm_4.setChecked(True)
        elif pm_src == "5":
            self.radioButton_pm_5.setChecked(True)
        pm_layer = ws.value("setting/pm_layer", "1")
        if pm_layer == "1":
            self.radioButton_layer_1.setChecked(True)
        else:
            self.radioButton_layer_2.setChecked(True)
        apikey = ws.value("setting/apikey", "")
        self.lineEdit_apikey.setText(apikey)
        year = ws.value("setting/year", "")
        self.lineEdit_year.setText(year)
        savefolder = ws.value("setting/savefolder", "")
        self.lineEdit_savefolder.setText(savefolder)
        self.listWidget_pref.addItem('01_北海道')
        self.listWidget_pref.addItem('02_青森県')
        self.listWidget_pref.addItem('03_岩手県')
        self.listWidget_pref.addItem('04_宮城県')
        self.listWidget_pref.addItem('05_秋田県')
        self.listWidget_pref.addItem('06_山形県')
        self.listWidget_pref.addItem('07_福島県')
        self.listWidget_pref.addItem('08_茨城県')
        self.listWidget_pref.addItem('09_栃木県')
        self.listWidget_pref.addItem('10_群馬県')
        self.listWidget_pref.addItem('11_埼玉県')
        self.listWidget_pref.addItem('12_千葉県')
        self.listWidget_pref.addItem('13_東京都')
        self.listWidget_pref.addItem('14_神奈川県')
        self.listWidget_pref.addItem('15_新潟県')
        self.listWidget_pref.addItem('16_富山県')
        self.listWidget_pref.addItem('17_石川県')
        self.listWidget_pref.addItem('18_福井県')
        self.listWidget_pref.addItem('19_山梨県')
        self.listWidget_pref.addItem('20_長野県')
        self.listWidget_pref.addItem('21_岐阜県')
        self.listWidget_pref.addItem('22_静岡県')
        self.listWidget_pref.addItem('23_愛知県')
        self.listWidget_pref.addItem('24_三重県')
        self.listWidget_pref.addItem('25_滋賀県')
        self.listWidget_pref.addItem('26_京都府')
        self.listWidget_pref.addItem('27_大阪府')
        self.listWidget_pref.addItem('28_兵庫県')
        self.listWidget_pref.addItem('29_奈良県')
        self.listWidget_pref.addItem('30_和歌山県')
        self.listWidget_pref.addItem('31_鳥取県')
        self.listWidget_pref.addItem('32_島根県')
        self.listWidget_pref.addItem('33_岡山県')
        self.listWidget_pref.addItem('34_広島県')
        self.listWidget_pref.addItem('35_山口県')
        self.listWidget_pref.addItem('36_徳島県')
        self.listWidget_pref.addItem('37_香川県')
        self.listWidget_pref.addItem('38_島根県')
        self.listWidget_pref.addItem('39_高知県')
        self.listWidget_pref.addItem('40_福岡県')
        self.listWidget_pref.addItem('41_佐賀県')
        self.listWidget_pref.addItem('42_長崎県')
        self.listWidget_pref.addItem('43_熊本県')
        self.listWidget_pref.addItem('44_大分県')
        self.listWidget_pref.addItem('45_宮崎県')
        self.listWidget_pref.addItem('46_鹿児島県')
        self.listWidget_pref.addItem('47_沖縄県')

        #[WorldFile]
        # ベクタ変換する
        addLayer1 = ws.value("setting/addLayer1", 1)
        if addLayer1 == 1:
            self.checkBox_3.setChecked(True)
        else:
            self.checkBox_3.setChecked(False)
        # 図郭で切り取る
        crop = ws.value("setting/crop", 1)
        if crop == 1:
            self.checkBox_crop.setChecked(True)
        else:
            self.checkBox_crop.setChecked(False)
        # 線色（R・G・B）
        line_R = ws.value("setting/line_R", 0)
        line_G = ws.value("setting/line_G", 0)
        line_B = ws.value("setting/line_B", 0)
        self.R2.setText(str(line_R))
        self.G2.setText(str(line_G))
        self.B2.setText(str(line_B))

        # [Georeference]
        # 縮尺
        scale = ws.value("setting/scale", 0)
        self.s.setText(str(scale))
        # 解像度
        dpi = ws.value("setting/dpi", 0)
        self.r.setText(str(dpi))

        # [Exif]
        # 座標系
        kei = ws.value("setting/kei", 0)
        self.comboKei.setCurrentIndex(kei)
        # ファイル名を表示する
        show_fname = ws.value("setting/show_fname", 1)
        if show_fname == 1:
            self.checkBox_filename.setChecked(True)
        else:
            self.checkBox_filename.setChecked(False)
        # Shape出力
        save_shape = ws.value("setting/save_shape", 1)
        if save_shape == 1:
            self.checkBox_shape.setChecked(True)
        else:
            self.checkBox_shape.setChecked(False)

        # [座標変換]
        # マップキャンバスから座標を取得する
        capture = ws.value("setting/capture", 1)
        if capture == 1:
            self.checkBox_2.setChecked(True)
        else:
            self.checkBox_2.setChecked(False)
        # 変換後、ポイントレイヤに追加する
        addLayer2 = ws.value("setting/addLayer2", 1)
        if addLayer2 == 1:
            self.checkBox_4.setChecked(True)
        else:
            self.checkBox_4.setChecked(False)
        # 点名の頭文字
        pn_header2 = ws.value("setting/pn_header2", "H")
        op_p2 = ws.value("setting/op_p2", 3)
        op_x2 = ws.value("setting/op_x2", 4)
        op_y2 = ws.value("setting/op_y2", 5)
        op_sep2 = ws.value("setting/op_sep2", ',')
        try:
            self.lineEdit_3.setText(pn_header2)
            self.lineEdit_9.setText(str(op_p2))
            self.lineEdit_10.setText(str(op_x2))
            self.lineEdit_11.setText(str(op_y2))
            self.lineEdit_12.setText(op_sep2)
        except:
            pass
        curl_path = ws.value("setting/curl_Path", "")
        self.lineEdit_curl.setText(curl_path)

        # [設定]
        # ダイアログのデフォルトのフォントサイズ
        if sys.platform == "win32":
            self.font_size.setText("9")
        else:
            self.font_size.setText("12")
        # 作業フォルダ
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        self.lineEdit_workPath.setText(workPath)
        # プロジェクトファイル
        startProj = ws.value("setting/startProj", 0)
        start = ws.value("setting/start", 0)
        kakunin = ws.value("setting/kakunin", 0)
        self.combo_project.setCurrentIndex(startProj)
        if kakunin == 0:
            self.check_kakunin.setChecked(False)
        else:
            self.check_kakunin.setChecked(True)
        if start == 0:
            self.check_start.setChecked(False)
        else:
            self.check_start.setChecked(True)
            if startProj != 0:
                pn = self.combo_project.currentText()
                if kakunin == 0:
                    result = QMessageBox.question(self,u'読込確認', u'表示中のレイヤは全て削除されます。\n' + pn + u' を読み込んでもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
                    if result == QMessageBox.Yes:
                        QgsProject.instance().removeAllMapLayers()
                        projfile = os.path.dirname(__file__) + u'/project/' + self.combo_project.currentText()
                        QgsProject.instance().read(projfile)
                else:
                    QgsProject.instance().removeAllMapLayers()
                    projfile = os.path.dirname(__file__) + u'/project/' + self.combo_project.currentText()
                    QgsProject.instance().read(projfile)
        # プロジェクトのCRSコンボボックスをセットする
        self.set_Combo()

        # SIGNAL
        # Digitizer--------------------------------------------------------------------------------------------------------------------
        self.pushButton_1.clicked.connect(self.plot1)                    # プロット(Digitizer)
        self.pushButton_6.clicked.connect(self.plot2)                    # 結線(Digitizer)
        self.pushButton_2.clicked.connect(self.plot3)                    # 結線・プロット(Digitizer)
        self.pushButton_4.clicked.connect(self.pButton_4)                # CSV保存(Digitizer)
        self.pushButton_5.clicked.connect(self.pButton_5)                # SIMA保存(Digitizer)
        self.pushButton_43.clicked.connect(self.pButton_43)              # KML保存(Digitizer)
        self.radioButton_kessen.clicked.connect(self.KukakuKessen)       # 結線・区画　追加(Digitizer)
        self.radioButton_kukaku.clicked.connect(self.KukakuKessen)       # 結線・区画　追加(Digitizer)
        self.pushButton_20.clicked.connect(self.pButton_20)              # 結線・区画　確定(Digitizer)
        self.pushButton_undo.clicked.connect(self.undo)                  # 取消(Digitizer)
        self.pushButton_3.clicked.connect(self.pButton_3)                # 消去(Digitizer)
        # I/O--------------------------------------------------------------------------------------------------------------------------
        self.pushButton_29.clicked.connect(self.KMLCZML)                 # KML/CZML保存(I/O)
        self.radioButton_crsSetting1.clicked.connect(self.crsSetting)    # 新しいレイヤの投影座標系(I/O)
        self.radioButton_crsSetting2.clicked.connect(self.crsSetting)    # 新しいレイヤの投影座標系(I/O)
        self.radioButton_crsSetting3.clicked.connect(self.crsSetting)    # 新しいレイヤの投影座標系(I/O)
        self.radioButton_Layer_1.clicked.connect(self.setQml)            # スタイルファイル設定(I/O)
        self.radioButton_Layer_2.clicked.connect(self.setQml)            # スタイルファイル設定(I/O)
        self.radioButton_Layer_3.clicked.connect(self.setQml)            # スタイルファイル設定(I/O)
        self.radioButton_Layer_4.clicked.connect(self.setQml)            # スタイルファイル設定(I/O)
        self.radioButton_Layer_5.clicked.connect(self.setQml)            # スタイルファイル設定(I/O)
        self.radioButton_Layer_6.clicked.connect(self.setQml)            # スタイルファイル設定(I/O)
        self.radioButton_Layer_7.clicked.connect(self.setQml)            # スタイルファイル設定(I/O)
        self.radioButton_Layer_8.clicked.connect(self.setQml)            # スタイルファイル設定(I/O)
        self.radioButton_Layer_9.clicked.connect(self.setQml)            # スタイルファイル設定(I/O)
        self.pushButton_37.clicked.connect(self.pButton_37)              # スケール変更(I/O)
        self.pushButton_38.clicked.connect(self.pButton_38)              # ズームイン(I/O)
        self.pushButton_39.clicked.connect(self.pButton_39)              # ズームアウト(I/O)
        self.pushButton_40.clicked.connect(self.pButton_40)              # 表示中のレイヤの全域にズーム(I/O)
        self.pushButton_48.clicked.connect(self.pButton_48)              # 選択したレイヤの領域にズーム(I/O)
        self.pushButton_49.clicked.connect(self.pButton_49)              # スケール取得(I/O)
        self.pushButton_44.clicked.connect(self.pButton_44)              # ファイルについて(I/O)
        self.pushButton_30.clicked.connect(self.pButton_30)              # レイヤの追加(I/O)
        self.pushButton_63.clicked.connect(self.pButton_63)              # Vector→Vector(I/O)
        self.pushButton_71.clicked.connect(self.pButton_71)              # 頂点(I/O)
        self.pushButton_52.clicked.connect(self.pButton_52)              # 画像として保存(I/O)
        self.pushButton_42.clicked.connect(self.pButton_41)              # EPSGコード(I/O、GDAL/OGR、Georeference、座標変換)
        self.haikei.currentIndexChanged.connect(self.SetTile)            # タイル地図リスト連動(I/O)
        self.addLayer.clicked.connect(self.addTileLayer)                 # タイル地図追加(I/O)
        self.pushButton_jump.clicked.connect(self.jump)                  # 移動((I/O)
        self.check_scale.clicked.connect(self.SetCenter)                 # マップキャンバスの中心座票を取得(I/O)
        self.comboBox_3.currentIndexChanged.connect(self.SetCenter)      # マップキャンバスの中心座票を取得(I/O)
        self.gazo.clicked.connect(self.gazo_open)                        # Point2Cloud_画像を開く(I/O)
        self.close_scrollArea.clicked.connect(self.gazo_close)           # 画像として保存ウィンドウを閉じる(I/O)
        self.conv.clicked.connect(self.gazou0)                           # 画像として保存実行(I/O)
        self.las_dir.clicked.connect(self.LasDir)                        # txt2las.exe選択(I/O)
        self.pushButton_haikei.clicked.connect(self.pButton_haikei)      # 画像として保存 背景色(I/O)
        self.pushButton_line1.clicked.connect(self.pButton_line1)        # 画像として保存 変更前線色(I/O)
        self.pushButton_line2.clicked.connect(self.pButton_line2)        # 画像として保存 変更後線色(I/O)
        # GDAL/OGR---------------------------------------------------------------------------------------------------------------------
        self.pushButton_45.clicked.connect(self.pButton_41)              # EPSGコード(I/O、GDAL/OGR、Georeference、座標変換)
        self.radioButton_raster.clicked.connect(self.setFormat)          # Formatのリスト設定(GDAL/OGR)
        self.radioButton_vector.clicked.connect(self.setFormat)          # Formatのリスト設定(GDAL/OGR)
        self.radioButton_rasvec.clicked.connect(self.setFormat)          # Formatのリスト設定(GDAL/OGR)
        self.comboBox_format2.currentIndexChanged.connect(self.set4326B) # KML・PDFのをEPSGを4326にセット(GDAL/OGR)
        self.pushButton_54.clicked.connect(self.pButton_54)              # gdalinfoによる画像情報取得(GDAL/OGR)
        self.pushButton_55.clicked.connect(self.pButton_55)              # フォーマット変換＆投影変換(GDAL/OGR)
        self.pushButton_58.clicked.connect(self.pButton_58)              # ラスタ→ベクタ変換(GDAL/OGR)
        self.pushButton_python.clicked.connect(self.pButton_python)      # python.exec選択(GDAL/OGR)
        self.pushButton_folder.clicked.connect(self.pButton_folder)      # mojxml2geojsonフォルダ選択(GDAL/OGR)
        self.check_xml_2.clicked.connect(self.SetCheckXml2)              # チェックボックス(GDAL/OGR)
        self.check_xml_3.clicked.connect(self.SetCheckXml3)              # チェックボックス(GDAL/OGR)
        self.check_xml_4.clicked.connect(self.SetCheckXml4)              # チェックボックス(GDAL/OGR)
        self.check_xml_6.clicked.connect(self.SetCheckXml6)              # チェックボックス(GDAL/OGR)
        self.check_xml_7.clicked.connect(self.SetCheckXml7)              # チェックボックス(GDAL/OGR)
        self.check_xml_9.clicked.connect(self.SetCheckXml9)              # チェックボックス(GDAL/OGR)
        self.click0.clicked.connect(self.SetClick0)                      # チェックボックス(GDAL/OGR)
        self.click1.clicked.connect(self.SetClick1)                      # チェックボックス(GDAL/OGR)
        self.click2.clicked.connect(self.SetClick2)                      # チェックボックス(GDAL/OGR)
        self.click3.clicked.connect(self.SetClick3)                      # チェックボックス(GDAL/OGR)
        self.click4.clicked.connect(self.SetClick4)                      # チェックボックス(GDAL/OGR)
        self.pushButton_xml.clicked.connect(self.pButton_xml2geojson)    # コンバート実行(GDAL/OGR)
        self.pushButton_build.clicked.connect(self.pButton_build)        # mojxml2geojson.exeビルド(GDAL/OGR)
        self.pushButton_fgb.clicked.connect(self.pButton_fgb)            # FlatGeobuf変換(GDAL/OGR)
        self.pushButton_sima.clicked.connect(self.pButton_sima)          # SIMA変換ファイルから(GDAL/OGR)
        self.pushButton_sima0.clicked.connect(self.pButton_sima0)        # SIMA変換実行(GDAL/OGR)
        self.pushButton_sima4.clicked.connect(self.pButton_sima4)        # SIMA変換閉じる(GDAL/OGR)
        self.pushButton_sima1.clicked.connect(self.pButton_sima5)        # GeoJSON読込(GDAL/OGR)
        self.pushButton_sima2.clicked.connect(self.pButton_sima6)        # SIMA変換実行(GDAL/OGR)
        self.pushButton_pmtiles_1.clicked.connect(self.pButton_pmtiles1) # PMTiles変換(GDAL/OGR)
        self.pushButton_options.clicked.connect(self.pButton_options)    # 追加オプション(GDAL/OGR)
        self.radioButton_layer_1.clicked.connect(self.select_layers)     # レイヤ選択(GDAL/OGR)
        self.radioButton_layer_2.clicked.connect(self.select_layers)     # レイヤ選択(GDAL/OGR)
        self.checkBox_pointonsurface.clicked.connect(self.pButton_options) # 追加オプション(GDAL/OGR)
        self.pushButton_pmtiles_2.clicked.connect(self.pButton_pmtiles2) # PMTile閉じる(GDAL/OGR)
        self.pushButton_pmtiles_3.clicked.connect(self.go_pmtiles)       # PMTiles_実行(GDAL/OGR)
        self.pushButton_pmtiles_4.clicked.connect(self.pButton_pmtiles4) # 補足(GDAL/OGR)
        self.pushButton_daihyo.clicked.connect(self.pButton_daihyo)      # 代表点ファイル作成ファイルから(GDAL/OGR)
        self.pushButton_daihyo2.clicked.connect(self.pButton_daihyo2)    # 代表点ファイル作成レイヤから(GDAL/OGR)
        self.pushButton_56.clicked.connect(self.pButton_56)              # 補足(GDAL/OGR)
        self.pushButton_64.clicked.connect(self.pButton_64)              # 補足(GDAL/OGR)
        self.pushButton_70.clicked.connect(self.pButton_70)              # 補足(GDAL/OGR)
        self.pushButton_download.clicked.connect(self.pButton_download)  # ダウンロード(GDAL/OGR)
        self.pushButton_ziplist.clicked.connect(self.pButton_ziplist)    # リスト取得(GDAL/OGR)
        self.pushButton_savefolder.clicked.connect(self.pButton_savefolder)# 保存先フォルダ設定(GDAL/OGR)
        self.pushButton_curl.clicked.connect(self.pButton_curl)          # curl.exeのパス設定(GDAL/OGR)
        self.pushButton_select1.clicked.connect(self.pButton_select1)    # ziplist全選択(GDAL/OGR)
        self.pushButton_select2.clicked.connect(self.pButton_select2)    # ziplist全解除(GDAL/OGR)
        self.pushButton_download2.clicked.connect(self.pButton_download2)# ダウンロード(GDAL/OGR)
        self.pushButton_idou.clicked.connect(self.pButton_idou)          # 移動(GDAL/OGR)
        self.pushButton_unzip.clicked.connect(self.pButton_unzip)        # 解凍(GDAL/OGR)
        self.pushButton_kensaku.clicked.connect(self.pButton_kensaku)    # 検索(GDAL/OGR)
        self.listWidget_ziplist.currentItemChanged.connect(self.kensaku) # 検索2(GDAL/OGR)
        self.listWidget_pref.clicked.connect(self.kensaku2)              # 検索3(GDAL/OGR)
        self.pushButton_close.clicked.connect(self.pButton_close)        # 閉じる(GDAL/OGR)
        self.pushButton_Helmert.clicked.connect(self.pButton_Helmert)    # ヘルマート変換(GDAL/OGR)
        self.pushButton_Helmert2.clicked.connect(self.pButton_Helmert2)  # ヘルマート変換開始(GDAL/OGR)
        self.pushButton_Helmert3.clicked.connect(self.pButton_Helmert3)  # ヘルマート変換を閉じる(GDAL/OGR)
        self.pushButton_reset.clicked.connect(self.pButton_reset)        # リセット(GDAL/OGR)
        self.pushButton_layername1.clicked.connect(self.pButton_layername1)  # ポイントレイヤ名を取得する(GDAL/OGR)
        self.pushButton_layername2.clicked.connect(self.pButton_layername2)  # ポリゴンレイヤ名を取得する(GDAL/OGR)
        # WorldFile--------------------------------------------------------------------------------------------------------------------
        self.pushButton_11.clicked.connect(self.pButton_11)              # ラスタレイヤの追加(I/O、WorldFile、Georeference)
        self.pushButton_12.clicked.connect(self.pButton_12)              # ワールドファイル作成(WorldFile)
        self.pushButton_32.clicked.connect(self.pButton_32)              # WorldFile⇔KMLコンバート(WorldFile)
        self.pushButton_33.clicked.connect(self.pButton_33)              # 回転(WorldFile)
        self.pushButton_34.clicked.connect(self.pButton_34)              # 透過 PNG／TIF 作成(WorldFile)
        self.pushButton_35.clicked.connect(self.pButton_35)              # 透過色の選択(WorldFile)
        self.pushButton_36.clicked.connect(self.pButton_36)              # 線色の選択(WorldFile)
        self.pushButton_13.clicked.connect(self.pButton_13)              # パターン呼出(WorldFile)
        self.checkBox_xt.clicked.connect(self.SetCheckBox1)              # チェックボックス(WorldFile)
        self.checkBox_yt.clicked.connect(self.SetCheckBox2)              # チェックボックス(WorldFile)
        self.checkBox_xb.clicked.connect(self.SetCheckBox3)              # チェックボックス(WorldFile)
        self.checkBox_yb.clicked.connect(self.SetCheckBox4)              # チェックボックス(WorldFile)
        self.radioButton1.clicked.connect(self.SetCheckBox5)             # チェックボックス(WorldFile)
        self.radioButton2.clicked.connect(self.SetCheckBox5)             # チェックボックス(WorldFile)
        self.radioButton3.clicked.connect(self.SetCheckBox5)             # チェックボックス(WorldFile)
        self.radioButton4.clicked.connect(self.SetCheckBox5)             # チェックボックス(WorldFile)
        self.pushButton_22.clicked.connect(self.pButton_22)              # カスタムパターン登録(WorldFile)
        self.pushButton_26.clicked.connect(self.pButton_26)              # 地図の中心にする－右上(WorldFile)
        self.pushButton_27.clicked.connect(self.pButton_27)              # 地図の中心にする－左下(WorldFile)
        # ジオリファレンス-------------------------------------------------------------------------------------------------------------
        self.pushButton_16.clicked.connect(self.pButton_11)              # ラスタレイヤの追加(I/O、WorldFile、Georeference)
        self.pushButton_14.clicked.connect(self.pButton_14)              # ワールドファイル作成(Georeference)
        self.pushButton_15.clicked.connect(self.pButton_15)              # GCP保存(Georeference)
        self.pushButton_53.clicked.connect(self.pButton_53)              # GCP登録(Georeference)
        self.pushButton_59.clicked.connect(self.pButton_59)              # ジオリファレンシング(Georeference)
        self.pushButton_46.clicked.connect(self.pButton_41)              # EPSGコード(I/O、GDAL/OGR、Georeference、座標変換)
        self.pushButton_17.clicked.connect(self.pButton_17)              # 消去(Georeference)
        # Exif-------------------------------------------------------------------------------------------------------------------------
        self.pushButton_23.clicked.connect(self.OpenBrowse)              # フォルダ選択(Exif)
        self.pushButton_24.clicked.connect(self.getExifInfo)             # Exif2CSV(Exif)
        self.pushButton_25.clicked.connect(self.saveExif)                # CSV保存(Exif)
        self.pushButton_28.clicked.connect(self.saveKMZ)                 # KMZ保存(Exif)
        self.pushButton_Exif.clicked.connect(self.editExif)              # Exif編集(Exif)
        self.radioButton_Exif1.clicked.connect(self.epsgMsg)             # 位置情報書換で平面直角座標を選択した場合(Exif)
        self.radioButton_Exif2.clicked.connect(self.epsg4326)            # 位置情報書換で緯度・経度を選択した場合、EPSG4326に変更(Exif)
        self.pushButton_60.clicked.connect(self.pButton_60)              # 消去(Exif)
        # 座標変換---------------------------------------------------------------------------------------------------------------------
        self.pushButton_41.clicked.connect(self.pButton_41)              # EPSGコード(I/O、GDAL/OGR、Georeference、座標変換)
        self.pushButton_8.clicked.connect(self.pButton_8)                # CSV保存(座標変換)
        self.pushButton_10.clicked.connect(self.pButton_10)              # 変換実行(座標変換)
        self.pushButton_21.clicked.connect(self.pButton_21)              # 地図の中心にする(座標変換)
        self.pushButton_65.clicked.connect(self.pButton_65)              # 一括変換(座標変換)
        self.radioButton_EPSG1.clicked.connect(self.epsgSet)             # EPSG1またはEPSG2に現在のEPSGをセット(座標変換)
        self.radioButton_EPSG2.clicked.connect(self.epsgSet)             # EPSG1またはEPSG2に現在のEPSGをセット(座標変換)
        self.pushButton_9.clicked.connect(self.pButton_9)                # 消去(座標変換)
        self.pushButton_geocoder.clicked.connect(self.pButton_geocoder)  # ジオコーダー(座標変換)
        self.pushButton_geocoder2.clicked.connect(self.pButton_geocoder2)# 補足(座標変換)
        # GNSS-------------------------------------------------------------------------------------------------------------------------
        self.switch_on.toggled.connect(self.on_off)
        self.check_plot.clicked.connect(self.SetEnable2)
        self.check_tansaku.clicked.connect(self.SetEnable3)
        self.check_shousai.clicked.connect(self.SetEnable4)
        self.comboBox_sentence.currentIndexChanged.connect(self.SetEnable5)
        self.GPX.clicked.connect(self.gpx_save)
        self.SIMA.clicked.connect(self.sima_save)
        self.KML.clicked.connect(self.kml_save)
        self.clear_log.clicked.connect(self.clearlog)
        self.epoch.clicked.connect(self.changeText)
        # 設定-------------------------------------------------------------------------------------------------------------------------
        self.pushButton_61.clicked.connect(self.pButton_61)              # 作業フォルダ選択(設定)
        self.pushButton_62.clicked.connect(self.pButton_62)              # デフォルトに設定(設定)
        self.pushButton_66.clicked.connect(self.pButton_66)              # フォントサイズの設定(設定)
        self.pushButton_67.clicked.connect(self.pButton_67)              # フォントサイズを9ポイントに設定(設定)
        self.pushButton_68.clicked.connect(self.pButton_68)              # Window最大幅の設定(設定)
        self.pushButton_69.clicked.connect(self.pButton_69)              # Window最大幅を700に設定(設定)
        self.pushButton_default2.clicked.connect(self.defaultCRS2)       #「デフォルトのCRS」を現在のプロジェクトのCRSに設定(設定)
        self.pushButton_50.clicked.connect(self.openProject)             # プロジェクトファイルを開く(設定)
        self.pushButton_51.clicked.connect(self.saveProject)             # プロジェクトファイルを保存する(設定)
        self.pushButton_57.clicked.connect(self.deleteProject)           # プロジェクトファイルを削除する(設定)
        # 共通-------------------------------------------------------------------------------------------------------------------------
        self.tabWidget.currentChanged.connect(self.setTab)               # タブが変更された時（共通）
        self.pushButton_47.clicked.connect(self.pButton_47)              # プロジェクトのEPSG変更(共通)
        self.pushButton_31.clicked.connect(self.pButton_31)              # タイル変更(共通)
        self.pushButton_18.clicked.connect(self.pButton_18)              # ウィンドウリサイズ(共通)


# ----------Digitizer----------------------------------------------------------------------------------------------------------------
    # 一時保存（Digitizer）
    def hozon(self):
        if self.lineEdit_2.text() == '0':
            return
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        savename = workPath + u'/coordinates.csv'
        fname = codecs.open(savename, 'w', 'utf-8')
        fname.write(self.textEdit_1.toPlainText())
        fname.close()
        savename2 = workPath + u'/distance.csv'
        fname = codecs.open(savename2, 'w', 'utf-8')
        fname.write(self.textEdit_3.toPlainText())
        fname.close()


    # プロット（Digitizer）
    def plot1(self):
        if int(self.lineEdit_2.text()) == 0:
            return
        keizoku = QMessageBox.question(self,u'プロット', u'レイヤグループ「Digitizer」は、消去されます。\n実行してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if keizoku == QMessageBox.Yes:
            self.hozon()
            global digitize_Layer
            try:
                digitize_Layer0 = digitize_Layer
            except:
                pass
            # プロジェクトのCRSを取得
            epsgGet()
            if epsgcode != '':
                code = epsgcode
            else:
                code = usercode
            workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
            fname = workPath + u'/coordinates.csv'
            # プロット表示（coordinates.csv）
            uri = 'file:///' + fname + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_3', 'field_2&crs=epsg:' + code)
            layer = QgsVectorLayer(uri, 'digitize', 'delimitedtext')
            # 先頭にレイヤを追加
            tree = qgis.utils.iface.layerTreeView()
            tree.setCurrentLayer(None)
            QgsProject.instance().addMapLayer(layer)
            digitize_Layer = layer.id()
            # スタイルファイルの読み込み
            if os.path.exists(os.path.dirname(__file__) + u'/qml/digitizer.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/digitizer.qml')
            # Digitizerレイヤグループ削除
            root = QgsProject.instance().layerTreeRoot()
            group = root.findGroup('Digitizer')
            if not group is None:
                for child in group.children():
                    dump = child.dump()
                    id = dump.split("=")[-1].strip()
                    QgsProject.instance().removeMapLayer(id)
                root.removeChildNode(group)
            map.refresh()
            # digitizeレイヤ削除
            try:
                QgsProject.instance().removeMapLayer(digitize_Layer0)
            except:
                pass
            # レイヤの領域にズームする
            try:
                self.zoom()
            except:
                pass
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # 結線（Digitizer）
    def plot2(self):
        if int(self.lineEdit_2.text()) < 2:
            return
        self.hozon()
        global distance_Layer
        global kessen_Layer
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        # 点間距離表示（distance.csv）
        try:
            QgsProject.instance().removeMapLayer(distance_Layer)
        except:
            pass
        fname = workPath + u'/distance.csv'
        if os.path.exists(fname):
            uri = 'file:///' + fname + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_2', 'field_1&crs=epsg:' + code)
            layer = QgsVectorLayer(uri, 'distance', 'delimitedtext')
            tree = qgis.utils.iface.layerTreeView()
            tree.setCurrentLayer(None)
            QgsProject.instance().addMapLayer(layer)
            # スタイルファイルの読み込み
            if os.path.exists(os.path.dirname(__file__) + u'/qml/distance.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/distance.qml')
            distance_Layer = layer.id()
        # 結線表示（coordinates.csv）
        try:
            QgsProject.instance().removeMapLayer(kessen_Layer)
        except:
            pass
        n = 0
        points =[]
        fname = workPath + u'/coordinates.csv'
        for line in codecs.open(fname, 'r','utf-8'):
            if n > 0:
                dat = line.split(',')
                if n % 2 == 1:
                    p1 = dat[0]
                    x1 = dat[1]
                    y1 = dat[2]
                else:
                    p2 = dat[0]
                    x2 = dat[1]
                    y2 = dat[2]
                    points.append(QgsPoint(float(y1), float(x1)))
                    points.append(QgsPoint(float(y2), float(x2)))
            n = n + 1
        if n % 2 == 0:
            p2 = dat[0]
            x2 = dat[1]
            y2 = dat[2]
            points.append(QgsPoint(float(y1), float(x1)))
            points.append(QgsPoint(float(y2), float(x2)))
        layer = QgsVectorLayer('Linestring?crs=epsg:' + code, 'kessen', 'memory')
        provider = layer.dataProvider()
        feature = QgsFeature()
        feature.setGeometry(QgsGeometry.fromPolyline(points))
        provider.addFeatures([feature])
        tree = qgis.utils.iface.layerTreeView()
        tree.setCurrentLayer(None)
        QgsProject.instance().addMapLayer(layer)
        if self.comboBox_2.currentText() != '':
            qmlfile = str(self.comboBox_2.currentText())
            if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
        else:
            if os.path.exists(os.path.dirname(__file__) + u'/qml/kessen(yellow).qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/kessen(yellow).qml')
        kessen_Layer = layer.id()
        # レイヤの領域にズームする
        try:
            self.zoom()
        except:
            pass
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # 結線・プロット（Digitizer）
    def plot3(self):
        if int(self.lineEdit_2.text()) < 2:
            return
        keizoku = QMessageBox.question(self,u'結線・プロット', u'レイヤグループ「Digitizer」は、消去されます。\n実行してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if keizoku == QMessageBox.Yes:
            self.hozon()
            global distance_Layer
            global digitize_Layer
            global kessen_Layer
            # プロジェクトのCRSを取得
            epsgGet()
            if epsgcode != '':
                code = epsgcode
            else:
                code = usercode
            workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
            # 点間距離表示（distance.csv）
            try:
                QgsProject.instance().removeMapLayer(distance_Layer)
            except:
                pass
            fname = workPath + u'/distance.csv'
            if os.path.exists(fname):
                uri = 'file:///' + fname + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_2', 'field_1&crs=epsg:' + code)
                layer = QgsVectorLayer(uri, 'distance', 'delimitedtext')
                tree = qgis.utils.iface.layerTreeView()
                tree.setCurrentLayer(None)
                QgsProject.instance().addMapLayer(layer)
                # スタイルファイルの読み込み
                if os.path.exists(os.path.dirname(__file__) + u'/qml/distance.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/distance.qml')
                distance_Layer = layer.id()
            # プロット表示（coordinates.csv）
            try:
                QgsProject.instance().removeMapLayer(digitize_Layer)
            except:
                pass
            fname = workPath + u'/coordinates.csv'
            if os.path.exists(fname):
                uri = 'file:///' + fname + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_3', 'field_2&crs=epsg:' + code)
                layer = QgsVectorLayer(uri, 'digitize', 'delimitedtext')
                tree = qgis.utils.iface.layerTreeView()
                tree.setCurrentLayer(None)
                QgsProject.instance().addMapLayer(layer)
                # スタイルファイルの読み込み
                if os.path.exists(os.path.dirname(__file__) + u'/qml/digitizer.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/digitizer.qml')
                digitize_Layer = layer.id()
            # 結線表示（coordinates.csv）
            try:
                QgsProject.instance().removeMapLayer(kessen_Layer)
            except:
                pass
            n = 0
            points =[]
            for line in codecs.open(fname, 'r','utf-8'):
                if n > 0:
                    dat = line.split(',')
                    if n % 2 == 1:
                        p1 = dat[0]
                        x1 = dat[1]
                        y1 = dat[2]
                    else:
                        p2 = dat[0]
                        x2 = dat[1]
                        y2 = dat[2]
                        points.append(QgsPoint(float(y1), float(x1)))
                        points.append(QgsPoint(float(y2), float(x2)))
                n = n + 1
            if n % 2 == 0:
                p2 = dat[0]
                x2 = dat[1]
                y2 = dat[2]
                points.append(QgsPoint(float(y1), float(x1)))
                points.append(QgsPoint(float(y2), float(x2)))
            layer = QgsVectorLayer('Linestring?crs=epsg:' + code, 'kessen', 'memory')
            provider = layer.dataProvider()
            feature = QgsFeature()
            feature.setGeometry(QgsGeometry.fromPolyline(points))
            provider.addFeatures([feature])
            tree = qgis.utils.iface.layerTreeView()
            tree.setCurrentLayer(None)
            QgsProject.instance().addMapLayer(layer)
            if self.comboBox_2.currentText() != '':
                qmlfile = str(self.comboBox_2.currentText())
                if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
            else:
                if os.path.exists(os.path.dirname(__file__) + u'/qml/kessen(yellow).qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/kessen(yellow).qml')
            kessen_Layer = layer.id()
            # レイヤグループ削除
            root = QgsProject.instance().layerTreeRoot()
            group = root.findGroup('Digitizer')
            if not group is None:
                for child in group.children():
                    dump = child.dump()
                    id = dump.split("=")[-1].strip()
                    QgsProject.instance().removeMapLayer(id)
                root.removeChildNode(group)
            # レイヤの領域にズームする
            try:
                self.zoom()
            except:
                pass
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # CSV保存（Digitizer）
    def pButton_4(self):
        # 一時作業用（CSV保存には全く関係ない）
        #------------------------------------------------------
        #layer = qgis.utils.iface.activeLayer()
        #features = layer.selectedFeatures()
        #crs = QgsCoordinateReferenceSystem("EPSG:4326")
        #QgsVectorFileWriter.writeAsVectorFormat(layer, 'D:/WORK/' + self.lineEdit_1.text() + self.lineEdit_2.text() + '.geojson', "utf-8", crs, "geojson", onlySelected=True)
        #self.lineEdit_2.setText(str(int(self.lineEdit_2.text()) + 1))
        #return
        #------------------------------------------------------
        if self.lineEdit_2.text() == '0':
            QMessageBox.information(self, u'エラー', u'データがありません。')
            return
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        savename = dialog.getSaveFileName(self, u'ファイルを保存', '', '*.csv')
        if not savename or str(savename) == "('', '')":
            return
        reg_path = os.path.dirname(str(savename)).replace('(' + "'", '')
        ws.setValue("setting/reg_path", reg_path)
        fpath = str(savename).split("'")
        fname = open(fpath[1], 'w')
        fname.write(self.textEdit_1.toPlainText() + '\n')
        fname.close()
        QMessageBox.information(self, u'CSV保存', u'「' + fpath[1] + u'」を作成しました。')


    # SIMA保存（Digitizer）
    def pButton_5(self):
        if self.lineEdit_2.text() == '0':
            QMessageBox.information(self, u'エラー', u'データがありません。')
            return
        if int(self.kukakuNo.text()) > 0 and self.kukakuFlag.text() == u'編集中' and int(self.kukakuCount.text()) < 3:
            QMessageBox.information(self, u'エラー', u'区画データが不足しています。')
            self.radioButton_kukaku.setChecked(True)
            return
        if int(self.kessenNo.text()) > 0 and self.kessenFlag.text() == u'編集中' and int(self.kessenCount.text()) < 2:
            QMessageBox.information(self, u'エラー', u'結線データが不足しています。')
            self.radioButton_kessen.setChecked(True)
            return
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        savename = dialog.getSaveFileName(self, u'ファイルを保存', '', '*.sim')
        if not savename or str(savename) == "('', '')":
            return
        reg_path = os.path.dirname(str(savename)).replace('(' + "'", '')
        ws.setValue("setting/reg_path", reg_path)
        fpath = str(savename).split("'")
        #fname = open(fpath[1], 'w')
        fname = codecs.open(fpath[1], 'w', 'shift-jis')

        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        simtext = workPath + u'/sim0.txt'
        #fname0 = open(simtext, 'w')
        fname0 = codecs.open(simtext, 'w', 'shift-jis')

        fname0.write(self.textEdit_point.toPlainText() + '\n' + 'A99,')
        if int(self.kukakuNo.text()) > 0:
            if self.kukakuCount.text() != '0':
                self.textEdit_kukaku.append('D99,')
                self.kukakuCount.setText('0')
                self.kukakuFlag.setText('')
            fname0.write('\n')
            fname0.write(self.textEdit_kukaku.toPlainText())
        if int(self.kessenNo.text()) > 0:
            if self.kessenCount.text() != '0':
                self.textEdit_kessen.append('F99,')
                self.kessenCount.setText('0')
                self.kessenFlag.setText('')
            fname0.write('\n')
            fname0.write(self.textEdit_kessen.toPlainText())
        fname0.close()

        for line in codecs.open(simtext, 'r','shift-jis'):
            dat = line.replace((u'\n'), '')
            dat = dat.replace((u'\r'), '')
            if dat[:4] == 'A01,':
                p = dat.split(',')
                fname.write(p[0] + ',' + p[1] + ',' + p[2] + ',' + p[3] + ',' + p[4] + ',' + p[5] + ',\n')
            else:
                fname.write(dat + ',\n')
        fname.close()
        if os.path.exists(simtext):
            os.remove(simtext)

        QMessageBox.information(self, u'SIMA保存', u'「' + fpath[1] + u'」を作成しました。')


    # KML保存（Digitizer）
    def pButton_43(self):
        if self.lineEdit_2.text() == '0':
            QMessageBox.information(self, u'エラー', u'データがありません。')
            return
        if int(self.kukakuNo.text()) > 0 and self.kukakuFlag.text() == u'編集中' and int(self.kukakuCount.text()) < 3:
            QMessageBox.information(self, u'エラー', u'区画データが不足しています。')
            self.radioButton_kukaku.setChecked(True)
            return
        if int(self.kessenNo.text()) > 0 and self.kessenFlag.text() == u'編集中' and int(self.kessenCount.text()) < 2:
            QMessageBox.information(self, u'エラー', u'結線データが不足しています。')
            self.radioButton_kessen.setChecked(True)
            return
        self.lineEdit_path_sim.setText('')
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        simtext = workPath + u'/sim.txt'
        self.lineEdit_path_sim.setText(str(simtext))
        fname = codecs.open(simtext, 'w', 'shift-jis')
        fname.write(self.textEdit_point.toPlainText() + '\n' + 'A99,')
        if int(self.kukakuNo.text()) > 0:
            if self.kukakuCount.text() != '0':
                self.textEdit_kukaku.append('D99,')
                self.kukakuCount.setText('0')
                self.kukakuFlag.setText('')
            fname.write('\n')
            fname.write(self.textEdit_kukaku.toPlainText())
        if int(self.kessenNo.text()) > 0:
            if self.kessenCount.text() != '0':
                self.textEdit_kessen.append('F99,')
                self.kessenCount.setText('0')
                self.kessenFlag.setText('')
            fname.write('\n')
            fname.write(self.textEdit_kessen.toPlainText())
        fname.close()
        self.saveKML()
        if os.path.exists(workPath + u'/sim.txt'):
            os.remove(workPath + u'/sim.txt')
        if os.path.exists(workPath + u'/sima.txt'):
            os.remove(workPath + u'/sima.txt')


    # SIMA→KML/CZML（I/O）
    def KMLCZML(self):
        x = QInputDialog().getInt(None, u"変換先選択", u"1 = KML<br>2 = CZML(Polygon+Plot)<br>3 = CZML(Polyline+Plot)<br>4 = CZML(Polygon)<br>5 = CZML(Polyline)", 1, 1, 5, 1)
        if str(x) == '(1, True)': # kml
            self.lineEdit_CZML.setText('1')
            self.saveKML()
        elif str(x) == '(2, True)': # czml(polygon&plot)
            self.lineEdit_CZML.setText('2')
            self.saveCZML()
        elif str(x) == '(3, True)': # czml(polyline&plot)
            self.lineEdit_CZML.setText('3')
            self.saveCZML()
        elif str(x) == '(4, True)': # czml(polygon)
            self.lineEdit_CZML.setText('4')
            self.saveCZML()
        elif str(x) == '(5, True)': # czml(polyline)
            self.lineEdit_CZML.setText('5')
            self.saveCZML()
        else:
            return


    # KML保存（Digitizer），SIMA→KML（I/O）
    def saveKML(self):
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))

        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
            code0 = epsgcode
        else:
            code = epsgcode
            code0 = epsgcode

        # 指定のEPSGの判別（custom=''ならカスタムCRS）
        epsg = self.lineEdit_8.text()
        if epsg != '':
            custom = str(QgsCoordinateReferenceSystem(int(epsg)).authid())
        # [Digitizer-KML保存]か[I/O-SIMA→KML変換]
        if self.tabWidget.currentIndex() == 0:#[Digitizer-KML保存]
            # プロジェクトのCRSを使用するモード
            settings.setValue('/Projections/defaultBehavior', 'useProject')
        else:#[I/O-SIMA→KML変換]
            # 使用していない作業ファイルを削除
            if os.path.exists(workPath + u'/sima.txt'):
                try:
                    os.remove(workPath + u'/sima.txt')
                except:
                    pass
            # EPSG:4326へ座標変換するため、最初にSIMAのEPSGの指定が必須
            if epsg == '':#EPSGの指定がない場合
                QMessageBox.information(self, u'エラー', u'EPSGコードの指定は必須です。')
                self.lineEdit_8.setFocus()
                # プロジェクトのCRS設定を開始時に戻す
                settings.setValue('/Projections/defaultBehavior', str( self.lineEdit_crsSetting.text()))
                return

        # SIMAファイル（「.,KML保存」はテンポラリファイル）を読み込む
        if self.tabWidget.currentIndex() == 0: #[Digitizer-KML保存]の場合は、テンポラリファイルから読み込む
            simaname = workPath + u'/sim.txt'
        else:                                  #[I/O-SIMA→KML変換]の場合は、「SIMAインポート」ダイアログを表示する
            simaname = dialog.getOpenFileName(self, u'SIMAインポート（KMLへ変換）', '', '*.sim')
            fpath = str(simaname).split("'")
            simaname = fpath[1]
        if not simaname or str(simaname) == "('', '')":
            return
        reg_path = os.path.dirname(simaname)
        ws.setValue("setting/reg_path", reg_path)
        # カンマの数でSIMAか成果数値データかを判別（6=SIMA／10=成果数値データ）
        sokuchikei = ""#0=世界測地系
        zahyoukei = "" #平面直角座標系
        for line in codecs.open(simaname, 'r','shift-jis'):
           if line[:4] == 'A01,':
               n = line.count(',')
           if line[:4] == 'Z02,':#[成果数値データ]の場合は、測地系と平面直角座標系を取得
               z02 = line.split(',')
               sokuchikei = z02[1].replace(' ', '')#0=世界測地系
               zahyoukei = z02[2].replace(' ', '') #平面直角座標系
        if n == 10:#[成果数値データ]
            if sokuchikei == '0':#[世界測地系]
                code = str(2442 + int(zahyoukei))
            else:#[日本測地系]
                code = str(30160 + int(zahyoukei))
            crsSrc = QgsCoordinateReferenceSystem(int(code))

        # フィールド行を作成
        savename = workPath + u'/sima.txt'
        fout = open(savename, 'w')
        fout.write('A01,no,name,x,y,h,latitude,longitude,note\n')

        self.textEdit_point2.clear()
        self.textEdit_kessen2.clear()
        self.textEdit_kukaku2.clear()
        self.textEdit_sim2kml.clear()

        k1 = 0
        k2 = 0
        for line in codecs.open(simaname, 'r','shift-jis'):
            dat = line.replace((u'\n'), '')
            dat = dat.replace((u'\r'), '')
            if line[:4] == 'A01,':#[SIMA／成果数値データ 共通]
                A01 = line.split(',')
                a1 = A01[0]
                pn1 = A01[1]
                pn2 = A01[2]
                if n == 6:#[SIMA]
                    xx = A01[3].replace(' ','')
                    yy = A01[4].replace(' ','')
                    hh = A01[5].replace(' ','')
                    bikou = A01[6]
                else:#[成果数値データ]
                    xx = A01[5].replace(' ','')
                    yy = A01[6].replace(' ','')
                    hh = A01[8].replace(' ','')
                    bikou = ''
                if xx != '' and yy != '':
                    x1 = float(xx)
                    y1 = float(yy)
                    if hh != '':
                        h1 = float(hh)
                    else:
                        h1 = ''
                if self.tabWidget.currentIndex() == 0:#[Digitizer]
                    if epsgcode == '':#プロジェクトのCRSがカスタムCRSの場合
                        Src_crs = QgsCoordinateReferenceSystem()
                        Src_crs.createFromId(int(code), QgsCoordinateReferenceSystem.InternalCrsId)
                        crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                    else:
                        crsSrc = QgsCoordinateReferenceSystem(int(code))
                else:#[I/O]
                    if custom == '':#変換元がカスタムCRSの場合
                        Src_crs = QgsCoordinateReferenceSystem()
                        Src_crs.createFromId(int(epsg), QgsCoordinateReferenceSystem.InternalCrsId)
                        crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                    else:
                        crsSrc = QgsCoordinateReferenceSystem(int(epsg))
                crsDest = QgsCoordinateReferenceSystem(4326)
                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                y2,x2 = trans.transform(y1, x1)
                self.textEdit_point2.append(str(a1) + ',' + str(pn1) + ',' + pn2 + ',' + str(x1) + ',' + str(y1) + ',' + str(h1) + ',' + str(x2) + ',' + str(y2) + ',' + str(bikou))

            if n == 6:#[SIMA]の場合は、区画・結線データも取得
                if line[:4] == 'D00,':
                    polygon = dat + '\n'
                    k1 = 1
                    k2 = 0
                if line[:4] == 'F00,':
                    polyline = dat + '\n'
                    k2 = 1
                    k1 = 0
                if line[:4] == 'B01,':
                    if k1 > 0 and k2 == 0:
                        polygon = polygon + dat + '\n'
                        k1 = k1 + 1
                    if k1 == 0 and k2 > 0:
                        polyline = polyline + dat + '\n'
                        k2 = k2 + 1
                if line[:4] == 'D99,':
                    if k1 > 3:
                        polygon = polygon + dat + '\n'
                        self.textEdit_kukaku2.append(polygon)
                        k1 = 0
                if line[:4] == 'F99,':
                    if k2 > 2:
                        polyline = polyline + dat + '\n'
                        self.textEdit_kessen2.append(polyline)
                        k2 = 0
        fout.write(self.textEdit_point2.toPlainText())
        fout.close()

        # SIMA／成果数値データ 共通
        self.textEdit_sim2kml.append('<?xml version=' + '"' + '1.0' + '"' + ' encoding=' + '"' + 'UTF-8' + '"' + '?>')
        self.textEdit_sim2kml.append('<kml xmlns=' + '"' + 'http://www.opengis.net/kml/2.2' + '"' + ' xmlns:gx=' + '"' + 'http://www.google.com/kml/ext/2.2' + '"' +' xmlns:kml=' + '"' + 'http://www.opengis.net/kml/2.2' + '"' + ' xmlns:atom=' + '"' + 'http://www.w3.org/2005/Atom' + '"' + '>')
        self.textEdit_sim2kml.append('    <Document>')
        self.textEdit_sim2kml.append('        <name></name>')
        self.textEdit_sim2kml.append('        <StyleMap id=' + '"' + 'my_line' + '"' + '>')
        self.textEdit_sim2kml.append('            <Pair>')
        self.textEdit_sim2kml.append('                <key>normal</key>')
        self.textEdit_sim2kml.append('                <styleUrl>#s_my_line</styleUrl>')
        self.textEdit_sim2kml.append('            </Pair>')
        self.textEdit_sim2kml.append('        </StyleMap>')
        self.textEdit_sim2kml.append('        <Style1 id=' + '"' + 's_my_line' + '"' + '>')
        self.textEdit_sim2kml.append('            <LineStyle>')
        if self.radioButton_R.isChecked():
            self.textEdit_sim2kml.append('                <color>880000FF</color>')
        elif self.radioButton_G.isChecked():
            self.textEdit_sim2kml.append('                <color>8800FF00</color>')
        elif self.radioButton_B.isChecked():
            self.textEdit_sim2kml.append('                <color>88FF0000</color>')
        else:
            self.textEdit_sim2kml.append('                <color>8800FFFF</color>')
        self.textEdit_sim2kml.append('                <width>2</width>')
        self.textEdit_sim2kml.append('            </LineStyle>')
        self.textEdit_sim2kml.append('            <PolyStyle>')
        self.textEdit_sim2kml.append('                <fill>0</fill>')
        self.textEdit_sim2kml.append('            </PolyStyle>')
        self.textEdit_sim2kml.append('        </Style>')
        # 11行目の'        <Style id="s_my_line">'が入力できないことの代替策（原因不明）
        dat_style = self.textEdit_sim2kml.toPlainText().replace('Style1', 'Style')
        self.textEdit_sim2kml.clear()
        self.textEdit_sim2kml.append(dat_style)

        if n == 6:#[SIMA]
            # 区画データがある場合は、区画データのテンポラリファイルを作成
            if self.textEdit_kukaku2.toPlainText() != '':
                savename2 = workPath + u'/sima2.txt'
                if sys.platform == "win32":
                    fname = open(savename2, 'w')
                else:
                    fname =codecs. open(savename2, 'w', 'shift-jis')
                fname.write(self.textEdit_kukaku2.toPlainText() + '\n')
                fname.close()
                #for line in codecs.open(savename2, 'r','shift-jis'):
                for line in open(savename2, 'r'):
                    if line[:4] == 'D00,':
                        dat = line.split(',')
                        chiban = dat[2]
                        self.textEdit_sim2kml.append('        <Placemark>')
                        #self.textEdit_sim2kml.append('            <name>track</name>')
                        #self.textEdit_sim2kml.append('            <description>track</description>')
                        self.textEdit_sim2kml.append('            <name>' + chiban + '</name>')
                        self.textEdit_sim2kml.append('            <description>' + chiban + '</description>')
                        self.textEdit_sim2kml.append('            <styleUrl>#my_line</styleUrl>')
                        self.textEdit_sim2kml.append('            <Polygon>')
                        self.textEdit_sim2kml.append('                <tessellate>1</tessellate>')
                        self.textEdit_sim2kml.append('                <outerBoundaryIs>')
                        self.textEdit_sim2kml.append('                    <LinearRing>')
                        self.textEdit_sim2kml.append('                        <coordinates>')
                        k = 0
                    if line[:4] == 'B01,':
                        dat = line.split(',')
                        pn = dat[1].replace(' ','')
                        infilename = workPath + u'/sima.txt'
                        for line2 in open(infilename, 'r'):
                            if line2[:4] == 'A01,':
                                dat2 = line2.split(',')
                                if pn == dat2[1].replace(' ',''):
                                    hh = dat2[5]
                                    if hh.replace(' ', '') == '':
                                        hh = 0
                                    bb = dat2[6]
                                    ll = dat2[7]
                                    # 区画データがある場合は、区画データのテンポラリファイルを作成
                                    point = str(ll) + ',' + str(bb) + ',' + str(hh) + ' '
                                    if k == 0:
                                        coordinates = '                            ' + point
                                        point0 = str(ll) + ',' + str(bb) + ',' + str(hh) + ' '
                                    else:
                                        coordinates = coordinates + point
                                    k = k + 1
                    if line[:4] == 'D99,':
                        self.textEdit_sim2kml.append(coordinates + point0)
                        self.textEdit_sim2kml.append('                        </coordinates>')
                        self.textEdit_sim2kml.append('                    </LinearRing>')
                        self.textEdit_sim2kml.append('                </outerBoundaryIs>')
                        self.textEdit_sim2kml.append('            </Polygon>')
                        self.textEdit_sim2kml.append('        </Placemark>')
                        k = 0

            # 結線データがある場合は、結線データのテンポラリファイルを作成
            if self.textEdit_kessen2.toPlainText() != '':
                savename3 = workPath + u'/sima3.txt'
                if sys.platform == "win32":
                    fname = open(savename3, 'w')
                else:
                    fname =codecs. open(savename3, 'w', 'shift-jis')
                fname.write(self.textEdit_kessen2.toPlainText() + '\n')
                fname.close()
                for line in codecs.open(savename3, 'r','shift-jis'):
                    if line[:4] == 'F00,':
                        dat = line.split(',')
                        chiban = dat[3]
                        self.textEdit_sim2kml.append('        <Placemark>')
                        self.textEdit_sim2kml.append('            <name>' + chiban + '</name>')
                        self.textEdit_sim2kml.append('            <description>' + chiban + '</description>')
                        self.textEdit_sim2kml.append('            <styleUrl>#my_line</styleUrl>')
                        self.textEdit_sim2kml.append('            <LineString>')
                        self.textEdit_sim2kml.append('                <tessellate>1</tessellate>')
                        self.textEdit_sim2kml.append('                <altitudeMode>relativeToGround</altitudeMode>')
                        self.textEdit_sim2kml.append('                    <coordinates>')
                        k = 0
                    if line[:4] == 'B01,':
                        dat = line.split(',')
                        pn = dat[1].replace(' ','')
                        infilename = workPath + u'/sima.txt'
                        for line2 in open(infilename, 'r'):
                            #line2 = unicode(line2, encoding = 'shift-jis')
                            if line2[:4] == 'A01,':
                                dat2 = line2.split(',')
                                if pn == dat2[1].replace(' ',''):
                                    bb = dat2[6]
                                    ll = dat2[7]
                                    hh = dat2[5]
                                    if hh.replace(' ', '') == '':
                                        hh = '0'
                                    # 区画データがある場合は、区画データのテンポラリファイルを作成
                                    point = str(ll) + ',' + str(bb) + ',' + str(hh) + ' '
                                    if k == 0:
                                        coordinates = '                        ' + point
                                    else:
                                        coordinates = coordinates + point
                                    k = k + 1
                    if line[:4] == 'F99,':
                        self.textEdit_sim2kml.append(coordinates)
                        self.textEdit_sim2kml.append('                    </coordinates>')
                        self.textEdit_sim2kml.append('            </LineString>')
                        self.textEdit_sim2kml.append('        </Placemark>')
                        k = 0

        # プロットデータ
        k = 0
        infilename = workPath + u'/sima.txt'
        for line2 in open(infilename, 'r'):
            if k > 0 and line2[:4] == 'A01,':
                dat2 = line2.split(',')
                pn = dat2[1]
                pn2 = dat2[2]
                xx = dat2[3]
                yy = dat2[4]
                hh = dat2[5]
                #if hh.replace(' ', '') == '':
                #    hh = '0'
                hh = hh.replace(' ', '')
                bb = dat2[6]
                ll = dat2[7]
                bikou = dat2[8]
                self.textEdit_sim2kml.append('        <Placemark>')
                self.textEdit_sim2kml.append('          <name>' + pn2 + '</name>')
                self.textEdit_sim2kml.append('          <description><![CDATA[<div>X= ' + str(xx) + '</div><div>Y= ' + str(yy) + '</div><div>H= ' + str(hh) + '</div><div>【備考】 ' + bikou + '</div>]]></description>')
                self.textEdit_sim2kml.append('          <Point>')
                self.textEdit_sim2kml.append('              <coordinates>' + str(ll) + ',' + str(bb) + ',' + str(hh) + '</coordinates>')
                self.textEdit_sim2kml.append('          </Point>')
                self.textEdit_sim2kml.append('        </Placemark>')
            k = k + 1
        self.textEdit_sim2kml.append('    </Document>')
        self.textEdit_sim2kml.append('</kml>')
        # <div>が入力できないことの代替策
        dat_style = self.textEdit_sim2kml.toPlainText().replace('div2', 'div')
        self.textEdit_sim2kml.clear()
        self.textEdit_sim2kml.append(dat_style)

        # kml保存
        savename = dialog.getSaveFileName(self, u'ファイルを保存', '', '*.kml')
        if not savename or str(savename) == "('', '')":
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str( self.lineEdit_crsSetting.text()))
            return
        reg_path = os.path.dirname(str(savename)).replace('(' + "'", '')
        ws.setValue("setting/reg_path", reg_path)
        fpath = str(savename).split("'")
        fname = codecs.open(fpath[1], 'w','utf-8')
        fname.write(self.textEdit_sim2kml.toPlainText() + '\n')
        fname.close()

        sleep(0.5)
        layer = QgsVectorLayer(fpath[1], u'kml', 'ogr')
        tree = qgis.utils.iface.layerTreeView()
        tree.setCurrentLayer(None)
        QgsProject.instance().addMapLayer(layer)

        if self.comboBox_2.currentText() != '':
            qmlfile = str(self.comboBox_2.currentText())
            if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
        else:
            if self.radioButton_R.isChecked():
                if os.path.exists(os.path.dirname(__file__) + u'/qml/sim2kml.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/sim2kml.qml')
            elif self.radioButton_G.isChecked():
                if os.path.exists(os.path.dirname(__file__) + u'/qml/sim2kmlG.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/sim2kmlG.qml')
            elif self.radioButton_B.isChecked():
                if os.path.exists(os.path.dirname(__file__) + u'/qml/sim2kmlB.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/sim2kmlB.qml')
            elif self.radioButton_Y.isChecked():
                if os.path.exists(os.path.dirname(__file__) + u'/qml/sim2kmlY.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/sim2kmlY.qml')
        global kml_Layer
        kml_Layer = layer.id()

        # ポイント、結線、区画、kmlの作業用テキストを初期化
        self.textEdit_sim2kml.clear()
        self.textEdit_point2.clear()
        self.textEdit_kessen2.clear()
        self.textEdit_kukaku2.clear()
        self.lineEdit_path_sim.setText('')
        # 区画情報のテンポラリファイルを削除
        fname = workPath + u'/sima2.txt'
        if os.path.exists(fname):
            os.remove(fname)
        # 結線情報のテンポラリファイルを削除
        fname = workPath + u'/sima3.txt'
        if os.path.exists(fname):
            os.remove(fname)

        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str( self.lineEdit_crsSetting.text()))

        # レイヤの領域にズームする
        self.zoom()

        QgsApplication.processEvents()

        # 完了メッセージ
        QMessageBox.information(self, u'SIMA→KMLコンバート', u'「' + fpath[1] + u'」を作成しました。')

        # Google Earthを起動
        if sys.platform == "win32":
            os.startfile(fpath[1])
        else:
            opener ="open" if sys.platform == "darwin" else "xdg-open"
            subprocess.run([opener, fpath[1]])


    # SIMA→CZML（I/O）
    def saveCZML(self):
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))

        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
            code0 = epsgcode
        else:
            code = epsgcode
            code0 = epsgcode

        # 指定のEPSGの判別（custom=''ならカスタムCRS）
        epsg = self.lineEdit_8.text()
        if epsg != '':
            custom = str(QgsCoordinateReferenceSystem(int(epsg)).authid())
        # 使用していない作業ファイルを削除
        if os.path.exists(workPath + u'/sima.txt'):
            try:
                os.remove(workPath + u'/sima.txt')
            except:
                pass
        if os.path.exists(workPath + u'/tmp.kml'):
            try:
                os.remove(workPath + u'/tmp.kml')
            except:
                pass
        # EPSG:4326へ座標変換するため、最初にSIMAのEPSGの指定が必須
        if epsg == '':#EPSGの指定がない場合
            QMessageBox.information(self, u'エラー', u'EPSGコードの指定は必須です。')
            self.lineEdit_8.setFocus()
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str( self.lineEdit_crsSetting.text()))
            return

        simaname = dialog.getOpenFileName(self, u'SIMAインポート（CZMLに変換）', '', '*.sim')
        fpath = str(simaname).split("'")
        simaname = fpath[1]
        if not simaname or str(simaname) == "('', '')":
            return
        reg_path = os.path.dirname(simaname)
        ws.setValue("setting/reg_path", reg_path)

        # フィールド行を作成
        savename = workPath + u'/sima.txt'
        fout = open(savename, 'w')
        fout.write('A01,no,name,x,y,h,latitude,longitude,\n')

        self.textEdit_point2.clear()
        self.textEdit_kessen2.clear()
        self.textEdit_kukaku2.clear()
        self.textEdit_sim2kml.clear()

        k1 = 0
        k2 = 0
        for line in codecs.open(simaname, 'r','shift-jis'):
            dat = line.replace((u'\n'), '')
            dat = dat.replace((u'\r'), '')
            if line[:4] == 'A01,':
                A01 = line.split(',')
                a1 = A01[0]
                pn1 = A01[1]
                pn2 = A01[2]
                xx = A01[3].replace(' ','')
                yy = A01[4].replace(' ','')
                hh = A01[5].replace(' ','')
                if xx != '' and yy != '':
                    x1 = float(xx)
                    y1 = float(yy)
                    if hh != '':
                        h1 = float(hh)
                    else:
                        h1 = ''
                if custom == '':#変換元がカスタムCRSの場合
                    Src_crs = QgsCoordinateReferenceSystem()
                    Src_crs.createFromId(int(epsg), QgsCoordinateReferenceSystem.InternalCrsId)
                    crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                else:
                    crsSrc = QgsCoordinateReferenceSystem(int(epsg))
                crsDest = QgsCoordinateReferenceSystem(4326)
                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                y2,x2 = trans.transform(y1, x1)
                self.textEdit_point2.append(str(a1) + ',' + str(pn1) + ',' + pn2 + ',' + str(x1) + ',' + str(y1) + ',' + str(h1) + ',' + str(x2) + ',' + str(y2) + ',')
            if line[:4] == 'D00,':
                polygon = dat + '\n'
                k1 = 1
                k2 = 0
            if line[:4] == 'F00,':
                polyline = dat + '\n'
                k2 = 1
                k1 = 0
            if line[:4] == 'B01,':
                if k1 > 0 and k2 == 0:
                    polygon = polygon + dat + '\n'
                    k1 = k1 + 1
                if k1 == 0 and k2 > 0:
                    polyline = polyline + dat + '\n'
                    k2 = k2 + 1
            if line[:4] == 'D99,':
                if k1 > 3:
                    polygon = polygon + dat + '\n'
                    self.textEdit_kukaku2.append(polygon)
                    k1 = 0
            if line[:4] == 'F99,':
                if k2 > 2:
                    polyline = polyline + dat + '\n'
                    self.textEdit_kessen2.append(polyline)
                    k2 = 0
        fout.write(self.textEdit_point2.toPlainText())
        fout.close()

        # QGIS表示用KML作成
        #--------------------------------------------------------------------------------------------------------------------------------------------------
        data = ''
        data = data + '<?xml version=' + '"' + '1.0' + '"' + ' encoding=' + '"' + 'UTF-8' + '"' + '?>' + '\n'
        data = data + '<kml xmlns=' + '"' + 'http://www.opengis.net/kml/2.2' + '"' + ' xmlns:gx=' + '"' + 'http://www.google.com/kml/ext/2.2' + '"' +' xmlns:kml=' + '"' + 'http://www.opengis.net/kml/2.2' + '"' + ' xmlns:atom=' + '"' + 'http://www.w3.org/2005/Atom' + '"' + '>' + '\n'
        data = data + '    <Document>' + '\n'
        data = data + '        <name></name>' + '\n'
        data = data + '        <StyleMap id=' + '"' + 'my_line' + '"' + '>' + '\n'
        data = data + '            <Pair>' + '\n'
        data = data + '                <key>normal</key>' + '\n'
        data = data + '                <styleUrl>#s_my_line</styleUrl>' + '\n'
        data = data + '            </Pair>' + '\n'
        data = data + '        </StyleMap>' + '\n'
        data = data + '        <Style1 id=' + '"' + 's_my_line' + '"' + '>' + '\n'
        data = data + '            <LineStyle>' + '\n'
        if self.radioButton_R.isChecked():
            self.textEdit_sim2kml.append('                <color>880000FF</color>')
        elif self.radioButton_G.isChecked():
            self.textEdit_sim2kml.append('                <color>8800FF00</color>')
        elif self.radioButton_B.isChecked():
            self.textEdit_sim2kml.append('                <color>88FF0000</color>')
        else:
            self.textEdit_sim2kml.append('                <color>8800FFFF</color>')
        data = data + '                <width>2</width>' + '\n'
        data = data + '            </LineStyle>' + '\n'
        data = data + '            <PolyStyle>' + '\n'
        data = data + '                <fill>0</fill>' + '\n'
        data = data + '            </PolyStyle>' + '\n'
        data = data + '        </Style>' + '\n'
        # 11行目の'        <Style id="s_my_line">'が入力できないことの代替策（原因不明）
        data = data.replace('Style1', 'Style')

        if self.textEdit_kukaku2.toPlainText() != '':
            savename2 = workPath + u'/sima2.txt'
            if sys.platform == "win32":
                fname = open(savename2, 'w')
            else:
                fname =codecs. open(savename2, 'w', 'shift-jis')
            fname.write(self.textEdit_kukaku2.toPlainText() + '\n')
            fname.close()
            #for line in codecs.open(savename2, 'r','shift-jis'):
            for line in open(savename2, 'r'):
                if line[:4] == 'D00,':
                    dat = line.split(',')
                    chiban = dat[2]
                    data = data + '        <Placemark>' + '\n'
                    data = data + '            <name>' + chiban + '</name>' + '\n'
                    data = data + '            <description>' + chiban + '</description>' + '\n'
                    data = data + '            <styleUrl>#my_line</styleUrl>' + '\n'
                    data = data + '            <Polygon>' + '\n'
                    data = data + '                <tessellate>1</tessellate>' + '\n'
                    data = data + '                <outerBoundaryIs>' + '\n'
                    data = data + '                    <LinearRing>' + '\n'
                    data = data + '                        <coordinates>' + '\n'
                    k = 0
                if line[:4] == 'B01,':
                    dat = line.split(',')
                    pn = dat[1].replace(' ','')
                    infilename = workPath + u'/sima.txt'
                    for line2 in open(infilename, 'r'):
                        if line2[:4] == 'A01,':
                            dat2 = line2.split(',')
                            if pn == dat2[1].replace(' ',''):
                                hh = dat2[5]
                                if hh.replace(' ', '') == '':
                                    hh = 0
                                bb = dat2[6]
                                ll = dat2[7]
                                point = str(ll) + ',' + str(bb) + ',' + str(hh) + ' '
                                if k == 0:
                                    coordinates = '                            ' + point
                                    point0 = str(ll) + ',' + str(bb) + ',' + str(hh) + ' '
                                else:
                                    coordinates = coordinates + point
                                k = k + 1
                if line[:4] == 'D99,':
                    data = data + coordinates + point0 + '\n'
                    data = data + '                        </coordinates>' + '\n'
                    data = data + '                    </LinearRing>' + '\n'
                    data = data + '                </outerBoundaryIs>' + '\n'
                    data = data + '            </Polygon>' + '\n'
                    data = data + '        </Placemark>' + '\n'
                    k = 0

            if self.textEdit_kessen2.toPlainText() != '':
                savename3 = workPath + u'/sima3.txt'
                if sys.platform == "win32":
                    fname = open(savename3, 'w')
                else:
                    fname =codecs. open(savename3, 'w', 'shift-jis')
                fname.write(self.textEdit_kessen2.toPlainText() + '\n')
                fname.close()
                for line in codecs.open(savename3, 'r','shift-jis'):
                    if line[:4] == 'F00,':
                        dat = line.split(',')
                        chiban = dat[3]
                        data = data + '        <Placemark>' + '\n'
                        data = data + '            <name>' + chiban + '</name>' + '\n'
                        data = data + '            <description>' + chiban + '</description>' + '\n'
                        data = data + '            <styleUrl>#my_line</styleUrl>' + '\n'
                        data = data + '            <LineString>' + '\n'
                        data = data + '                <tessellate>1</tessellate>' + '\n'
                        data = data + '                <altitudeMode>relativeToGround</altitudeMode>' + '\n'
                        data = data + '                    <coordinates>' + '\n'
                        k = 0
                    if line[:4] == 'B01,':
                        dat = line.split(',')
                        pn = dat[1].replace(' ','')
                        infilename = workPath + u'/sima.txt'
                        for line2 in open(infilename, 'r'):
                            #line2 = unicode(line2, encoding = 'shift-jis')
                            if line2[:4] == 'A01,':
                                dat2 = line2.split(',')
                                if pn == dat2[1].replace(' ',''):
                                    bb = dat2[6]
                                    ll = dat2[7]
                                    hh = dat2[5]
                                    if hh.replace(' ', '') == '':
                                        hh = '0'
                                    point = str(ll) + ',' + str(bb) + ',' + str(hh) + ' '
                                    if k == 0:
                                        coordinates = '                        ' + point
                                    else:
                                        coordinates = coordinates + point
                                    k = k + 1
                    if line[:4] == 'F99,':
                        data = data + coordinates + '\n'
                        data = data + '                    </coordinates>' + '\n'
                        data = data + '            </LineString>' + '\n'
                        data = data + '        </Placemark>' + '\n'
                        k = 0

        # プロットデータ
        k = 0
        infilename = workPath + u'/sima.txt'
        for line2 in open(infilename, 'r'):
            if k > 0 and line2[:4] == 'A01,':
                dat2 = line2.split(',')
                pn = dat2[1]
                pn2 = dat2[2]
                xx = dat2[3]
                yy = dat2[4]
                hh = dat2[5]
                if hh.replace(' ', '') == '':
                    hh = '0'
                bb = dat2[6]
                ll = dat2[7]
                data = data + '        <Placemark>' + '\n'
                data = data + '          <name>' + pn2 + '</name>' + '\n'
                data = data + '          <description><![CDATA[<div>X= ' + str(xx) + '</div><div>Y= ' + str(yy) + '</div><div>H= ' + str(hh) + '</div>]]></description>' + '\n'
                data = data + '          <Point>' + '\n'
                data = data + '              <coordinates>' + str(ll) + ',' + str(bb) + ',' + str(hh) + '</coordinates>' + '\n'
                data = data + '          </Point>' + '\n'
                data = data + '        </Placemark>' + '\n'
            k = k + 1
        data = data + '    </Document>' + '\n'
        data = data + '</kml>' + '\n'
        # <div>が入力できないことの代替策
        dat = data.replace('div2', 'div')

        # kml保存
        savename = workPath + u'/tmp.kml'
        fpath = str(savename).split("'")
        fname = codecs.open(savename, 'w','utf-8')
        fname.write(data)
        fname.close()

        sleep(0.5)
        layer = QgsVectorLayer(savename, u'kml', 'ogr')
        QgsProject.instance().addMapLayer(layer)

        if self.comboBox_2.currentText() != '':
            qmlfile = str(self.comboBox_2.currentText())
            if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
        else:
            if self.radioButton_R.isChecked():
                if os.path.exists(os.path.dirname(__file__) + u'/qml/sim2kml.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/sim2kml.qml')
            elif self.radioButton_G.isChecked():
                if os.path.exists(os.path.dirname(__file__) + u'/qml/sim2kmlG.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/sim2kmlG.qml')
            elif self.radioButton_B.isChecked():
                if os.path.exists(os.path.dirname(__file__) + u'/qml/sim2kmlB.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/sim2kmlB.qml')
            elif self.radioButton_Y.isChecked():
                if os.path.exists(os.path.dirname(__file__) + u'/qml/sim2kmlY.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/sim2kmlY.qml')
        global kml_Layer
        kml_Layer = layer.id()
        #--------------------------------------------------------------------------------------------------------------------------------------------------

        data = ''
        data = data + '[{' + '\n'
        data = data + '    ' + '"' + 'id' + '"' + ' : ' + '"' + 'document' + '"' + ',' + '\n'
        data = data + '    ' + '"' + 'name' + '"' + ' : ' + '"' + 'sima2czml' + '"' + ',' + '\n'
        data = data + '    ' + '"' + 'version' + '"' + ' : ' + '"' + '1.0' + '"' + '\n'

        # 区画データ(Polygon)
        if self.textEdit_kukaku2.toPlainText() != '':
            #savename2 = workPath + u'/sima2.txt'
            #if sys.platform == "win32":
            #    fname = open(savename2, 'w')
            #else:
            #    fname =codecs. open(savename2, 'w', 'shift-jis')
            #fname.write(self.textEdit_kukaku2.toPlainText() + '\n')
            #fname.close()
            m = 1
            if self.lineEdit_CZML.text() == '2' or self.lineEdit_CZML.text() == '4':
                for line in open(savename2, 'r'):
                    if line[:4] == 'D00,':
                        dat = line.split(',')
                        chiban = dat[2]
                        data = data + ' },{' + '\n'
                        data = data + '    ' + '"' + 'id' + '"' + ' : ' + '"' + str(m) + '"' + ',' + '\n'
                        data = data + '    ' + '"' + 'name' + '"' + ' : ' + '"' + str(chiban) + '"' + ',' + '\n'
                        data = data + '    ' + '"' + 'description' + '"' + ' : ' + '"' + '"' + ',' + '\n'
                        data = data + '    ' + '"' + 'polygon' + '"' + ': {' + '\n'
                        data = data + '        ' + '"' + 'positions' + '"' + ' : {' + '\n'
                        data = data + '            ' + '"' + 'cartographicDegrees' + '"' + ': [' + '\n'
                        m = m + 1
                        k = 0
                    if line[:4] == 'B01,':
                        dat = line.split(',')
                        pn = dat[1].replace(' ','')
                        infilename = workPath + u'/sima.txt'
                        for line2 in open(infilename, 'r'):
                            if line2[:4] == 'A01,':
                                dat2 = line2.split(',')
                                if pn == dat2[1].replace(' ',''):
                                    bb = dat2[6]
                                    ll = dat2[7]
                                    if k == 0:
                                        b0 = bb
                                        l0 = ll
                                    data = data + '                ' + str(ll) + ',' + str(bb) + ',0,' + '\n'
                                    k = 1
                    if line[:4] == 'D99,':
                        rcol = random.randint(0, 255)
                        gcol = random.randint(0, 255)
                        bcol = random.randint(0, 255)
                        rgbcol = '[' + str(rcol) + ',' + str(gcol) + ',' + str(bcol) + ',' + '150]'
                        data = data + '                ' + str(l0) + ',' + str(b0) + ',0' + '\n'
                        data = data + '            ]' + '\n'
                        data = data + '        },' + '\n'
                        data = data + '        ' + '"' + 'material' + '"' + ': {' + '\n'
                        data = data + '            ' + '"' + 'solidColor' + '"' + ': {' + '\n'
                        data = data + '                ' + '"' + 'color' + '"' + ': {' + '\n'
                        data = data + '                    ' + '"' + 'rgba' + '"' + ': ' + rgbcol + '\n'
                        data = data + '                }' + '\n'
                        data = data + '            }' + '\n'
                        data = data + '        }' + '\n'
                        data = data + '    }' + '\n'
                        k = 0

            # 区画データ(Polyline)
            if self.lineEdit_CZML.text() == '3' or self.lineEdit_CZML.text() == '5':
                for line in open(savename2, 'r'):
                    if line[:4] == 'D00,':
                        dat = line.split(',')
                        chiban = dat[2]
                        data = data + ' },{' + '\n'
                        data = data + '    ' + '"' + 'id' + '"' + ' : ' + '"' + str(m) + '"' + ',' + '\n'
                        data = data + '    ' + '"' + 'name' + '"' + ' : ' + '"' + str(chiban) + '"' + ',' + '\n'
                        data = data + '    ' + '"' + 'description' + '"' + ' : ' + '"' + '"' + ',' + '\n'
                        data = data + '    ' + '"' + 'polyline' + '"' + ': {' + '\n'
                        data = data + '        ' + '"' + 'positions' + '"' + ' : {' + '\n'
                        data = data + '            ' + '"' + 'cartographicDegrees' + '"' + ': [' + '\n'
                        m = m + 1
                        k = 0
                    if line[:4] == 'B01,':
                        dat = line.split(',')
                        pn = dat[1].replace(' ','')
                        infilename = workPath + u'/sima.txt'
                        for line2 in open(infilename, 'r'):
                            if line2[:4] == 'A01,':
                                dat2 = line2.split(',')
                                if pn == dat2[1].replace(' ',''):
                                    bb = dat2[6]
                                    ll = dat2[7]
                                    if k == 0:
                                        b0 = bb
                                        l0 = ll
                                    data = data + '                ' + str(ll) + ',' + str(bb) + ',0,' + '\n'
                                    k = 1
                    if line[:4] == 'D99,':
                        data = data + '                ' + str(l0) + ',' + str(b0) + ',0' + '\n'
                        data = data + '            ]' + '\n'
                        data = data + '        },' + '\n'
                        data = data + '        ' + '"' + 'material' + '"' + ': {' + '\n'
                        data = data + '            ' + '"' + 'solidColor' + '"' + ': {' + '\n'
                        data = data + '                ' + '"' + 'color' + '"' + ': {' + '\n'
                        if self.radioButton_R.isChecked():
                            data = data + '                    ' + '"' + 'rgba' + '"' + ': [255, 0, 0, 150]' + '\n'
                        elif self.radioButton_G.isChecked():
                            data = data + '                    ' + '"' + 'rgba' + '"' + ': [0, 255, 0, 150]' + '\n'
                        elif self.radioButton_B.isChecked():
                            data = data + '                    ' + '"' + 'rgba' + '"' + ': [0, 0, 255, 150]' + '\n'
                        else:
                            data = data + '                    ' + '"' + 'rgba' + '"' + ': [255, 255, 0, 150]' + '\n'
                        data = data + '                }' + '\n'
                        data = data + '            }' + '\n'
                        data = data + '        },' + '\n'
                        data = data + '        ' + '"' + 'width' + '"' + ': 1.0,' + '\n'
                        data = data + '        ' + '"' + 'clampToGround' + '"' + ': true' + '\n'
                        data = data + '    }' + '\n'
                        k = 0

        # 地番データ
        fname.close()
        if self.textEdit_kukaku2.toPlainText() != '':
            for line in open(savename2, 'r'):
                if line[:4] == 'D00,':
                    dat = line.split(',')
                    chiban = dat[2]
                    data = data + ' }, {' + '\n'
                    data = data + '    ' + '"' + 'id' + '"' + ' : ' + '"' + str(m) + '"' + ',' + '\n'
                    data = data + '    ' + '"' + 'name' + '"' + ' : ' + '"' + str(chiban) + '"' + ',' + '\n'
                    data = data + '    ' + '"' + 'description' + '"' + ' : ' + '"' + '"' + ',' + '\n'
                    data = data + '    ' + '"' + 'position' + '"' + ' : {' + '\n'
                    m = m + 1
                    k = 0
                    bbb = 0
                    lll = 0
                if line[:4] == 'B01,':
                    dat = line.split(',')
                    pn = dat[1].replace(' ','')
                    infilename = workPath + u'/sima.txt'
                    for line2 in open(infilename, 'r'):
                        if line2[:4] == 'A01,':
                            dat2 = line2.split(',')
                            if pn == dat2[1].replace(' ',''):
                                bb = float(dat2[6])
                                ll = float(dat2[7])
                                if k == 0:
                                    b0 = bb
                                    l0 = ll
                                    bbb = bbb + bb
                                    lll = lll + ll
                                    k = k + 1
                                else:
                                    if bb != b0 and ll != l0:
                                        bbb = bbb + bb
                                        lll = lll + ll
                                        k = k + 1
                if line[:4] == 'D99,':
                    bbb = bbb / k
                    lll = lll / k
                    data = data + '    ' + '        ' + '"' + 'cartographicDegrees' + '"' + ': [' + str(lll) + ',' + str(bbb) + ',0]' + '\n'
                    data = data + '    ' + '    },' + '\n'
                    data = data + '    ' + '    ' + '"' + 'point' + '"' + ': {' + '\n'
                    data = data + '    ' + '        ' + '"' + 'color' + '"' + ': {' + '\n'
                    data = data + '    ' + '            ' + '"' + 'rgba' + '"' + ': [255, 255, 255, 0]' + '\n'
                    data = data + '    ' + '        },' + '\n'
                    data = data + '    ' + '        ' + '"' + 'pixelSize' + '"' + ': 0' + '\n'
                    data = data + '    ' + '    },' + '\n'
                    data = data + '    ' + '    ' + '"' + 'label' + '"' + ': {' + '\n'
                    data = data + '    ' + '        ' + '"' + 'fillColor' + '"' + ': {' + '\n'
                    data = data + '    ' + '            ' + '"' + 'rgba' + '"' + ' : [255, 255, 255, 255]' + '\n'
                    data = data + '    ' + '        },' + '\n'
                    data = data + '    ' + '        ' + '"' + 'font' + '"' + ' : ' + '"' + '10pt Lucida Console' + '"' + ',' + '\n'
                    data = data + '    ' + '        ' + '"' + 'horizontalOrigin' + '"' + ' : ' + '"' + 'CENTER' + '"' + ',' + '\n'
                    data = data + '    ' + '        ' + '"' + 'outlineColor' + '"' + ' : {' + '\n'
                    data = data + '    ' + '            ' + '"' + 'rgba' + '"' + ':[255, 255, 255, 255]' + '\n'
                    data = data + '    ' + '        },' + '\n'
                    data = data + '    ' + '        ' + '"' + 'outlineWidth' + '"' + ' : 0.5,' + '\n'
                    data = data + '    ' + '        ' + '"' + 'pixelOffset' + '"' + ' : {' + '\n'
                    data = data + '    ' + '            ' + '"' + 'cartesian2' + '"' + ' : [0, 0]' + '\n'
                    data = data + '    ' + '        },' + '\n'
                    data = data + '    ' + '        ' + '"' + 'style' + '"' + ' : ' + '"' + 'FILL_AND_OUTLINE' + '"' + ',' + '\n'
                    data = data + '    ' + '        ' + '"' + 'text' + '"' + ' : ' + '"' + str(chiban) + '"' + ',' + '\n'
                    data = data + '    ' + '        ' + '"' + 'heightReference' + '"' + ' : ' + '"' + 'CLAMP_TO_GROUND' + '"' + '\n'
                    data = data + '    ' + '    }' + '\n'
                    k = 0

        # 結線データ
        fname.close()
        if self.textEdit_kessen2.toPlainText() != '':
            #savename3 = workPath + u'/sima3.txt'
            #if sys.platform == "win32":
            #    fname = open(savename3, 'w')
            #else:
            #    fname =codecs. open(savename3, 'w', 'shift-jis')
            #fname.write(self.textEdit_kessen2.toPlainText() + '\n')
            #fname.close()
            for line in open(savename3, 'r'):
                if line[:4] == 'F00,':
                    dat = line.split(',')
                    chiban = dat[2]
                    data = data + ' },{'
                    data = data + '    ' + '"' + 'id' + '"' + ' : ' + '"' + str(m) + '"' + ',' + '\n'
                    data = data + '    ' + '"' + 'name' + '"' + ' : ' + '"' + str(chiban) + '"' + ',' + '\n'
                    data = data + '    ' + '"' + 'description' + '"' + ' : ' + '"' + '"' + ',' + '\n'
                    data = data + '    ' + '"' + 'polyline' + '"' + ': {' + '\n'
                    data = data + '        ' + '"' + 'positions' + '"' + ' : {' + '\n'
                    data = data + '            ' + '"' + 'cartographicDegrees' + '"' + ': [' + '\n'
                    m = m + 1
                if line[:4] == 'B01,':
                    dat = line.split(',')
                    pn = dat[1].replace(' ','')
                    infilename = workPath + u'/sima.txt'
                    for line2 in open(infilename, 'r'):
                        if line2[:4] == 'A01,':
                            dat2 = line2.split(',')
                            if pn == dat2[1].replace(' ',''):
                                bb = dat2[6]
                                ll = dat2[7]
                                data = data + '                ' + str(ll) + ',' + str(bb) + ',0,' + '\n'
                if line[:4] == 'F99,':
                    data = data[:-2] + '\n'
                    data = data + '            ]' + '\n'
                    data = data + '        },' + '\n'
                    data = data + '        ' + '"' + 'material' + '"' + ': {' + '\n'
                    data = data + '            ' + '"' + 'solidColor' + '"' + ': {' + '\n'
                    data = data + '                ' + '"' + 'color' + '"' + ': {' + '\n'
                    if self.radioButton_R.isChecked():
                        data = data + '                    ' + '"' + 'rgba' + '"' + ': [255, 0, 0, 150]' + '\n'
                    elif self.radioButton_G.isChecked():
                        data = data + '                    ' + '"' + 'rgba' + '"' + ': [0, 255, 0, 150]' + '\n'
                    elif self.radioButton_B.isChecked():
                        data = data + '                    ' + '"' + 'rgba' + '"' + ': [0, 0, 255, 150]' + '\n'
                    else:
                        data = data + '                    ' + '"' + 'rgba' + '"' + ': [255, 255, 0, 150]' + '\n'
                    data = data + '                }' + '\n'
                    data = data + '            }' + '\n'
                    data = data + '        },' + '\n'
                    data = data + '        ' + '"' + 'width' + '"' + ': 1.0,' + '\n'
                    data = data + '        ' + '"' + 'clampToGround' + '"' + ': true' + '\n'
                    data = data + '    }' + '\n'

        # プロットデータ
        if self.lineEdit_CZML.text() == '2' or self.lineEdit_CZML.text() == '3':
            k = 0
            br = '<' + 'b' + 'r' + '>'
            infilename = workPath + u'/sima.txt'
            for line2 in open(infilename, 'r'):
                if k > 0 and line2[:4] == 'A01,':
                    dat2 = line2.split(',')
                    pn = dat2[2]
                    xx = dat2[3]
                    yy = dat2[4]
                    bb = dat2[6]
                    ll = dat2[7]
                    data = data + ' }, {' + '\n'
                    data = data + '    ' + '"' + 'id' + '"' + ' : ' + '"' + str(m) + '"' + ',' + '\n'
                    data = data + '    ' + '"name" : "' + str(pn) + '",' + '\n'
                    data = data + '    ' + '"' + 'description' + '"' + ' : ' + '"' + 'X=' + str(xx) + ' Y=' + str(yy) + '"' + ',' + '\n'
                    data = data + '    ' + '"' + 'position' + '"' + ' : {' + '\n'
                    data = data + '        ' + '"' + 'cartographicDegrees' + '"' + ': [' + str(ll) + ',' + str(bb) + ',0]' + '\n'
                    data = data + '    },' + '\n'
                    data = data + '    ' + '"' + 'point' + '"' + ': {' + '\n'
                    data = data + '        ' + '"' + 'color' + '"' + ': {' + '\n'
                    if self.radioButton_R.isChecked():
                        data = data + '            ' + '"' + 'rgba' + '"' + ': [255, 0, 0, 150]' + '\n'
                    elif self.radioButton_G.isChecked():
                        data = data + '            ' + '"' + 'rgba' + '"' + ': [0, 255, 0, 150]' + '\n'
                    elif self.radioButton_B.isChecked():
                        data = data + '            ' + '"' + 'rgba' + '"' + ': [0, 0, 255, 150]' + '\n'
                    else:
                        data = data + '            ' + '"' + 'rgba' + '"' + ': [255, 255, 0, 150]' + '\n'
                    data = data + '        },' + '\n'
                    data = data + '        ' + '"' + 'pixelSize' + '"' + ': 4,' + '\n'
                    data = data + '        ' + '"' + 'heightReference' + '"' + ' : ' + '"' + 'CLAMP_TO_GROUND' + '"' + '\n'
                    data = data + '    }' + '\n'
                    m = m + 1
                k = 1

        data = data + '}]' + '\n'

        # czml保存
        savename = dialog.getSaveFileName(self, u'ファイルを保存', '', '*.czml')
        if not savename or str(savename) == "('', '')":
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str( self.lineEdit_crsSetting.text()))
            return
        reg_path = os.path.dirname(str(savename)).replace('(' + "'", '')
        ws.setValue("setting/reg_path", reg_path)
        fpath = str(savename).split("'")
        fname = codecs.open(fpath[1], 'w','utf-8')
        #fname.write(self.textEdit_sim2kml.toPlainText() + '\n')
        fname.write(data)
        fname.close()

        # ポイント、結線、区画、kmlの作業用テキストを初期化
        self.textEdit_sim2kml.clear()
        self.textEdit_point2.clear()
        self.textEdit_kessen2.clear()
        self.textEdit_kukaku2.clear()
        self.lineEdit_path_sim.setText('')
        # 区画情報のテンポラリファイルを削除
        fname = workPath + u'/sima2.txt'
        if os.path.exists(fname):
            os.remove(fname)
        # 結線情報のテンポラリファイルを削除
        fname = workPath + u'/sima3.txt'
        if os.path.exists(fname):
            os.remove(fname)
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str( self.lineEdit_crsSetting.text()))
        QgsApplication.processEvents()
        # 完了メッセージ
        QMessageBox.information(self, u'SIMA→CZMLコンバート', u'「' + fpath[1] + u'」を作成しました。')


    # 結線・区画　追加（Digitizer）
    def KukakuKessen(self):
        if self.radioButton_kessen.isChecked():
            self.kessenFlag.setText(u'編集中')
            self.kessenNo.setText(str(int(self.kessenNo.text()) + 1))
            self.textEdit_kessen.append('F00,' + self.kessenNo.text() + ',0,' + self.kessenNo.text() + ',1,')
        if self.radioButton_kukaku.isChecked():
            self.kukakuFlag.setText(u'編集中')
            self.kukakuNo.setText(str(int(self.kukakuNo.text()) + 1))
            self.textEdit_kukaku.append('D00,' + self.kukakuNo.text() + ',' + self.kukakuNo.text() + ',1,')
            self.pushButton_5.setEnabled(False)
            self.pushButton_43.setEnabled(False)
        self.pushButton_5.setEnabled(False)
        self.pushButton_43.setEnabled(False)
        self.radioButton_point.setEnabled(False)
        self.radioButton_kessen.setEnabled(False)
        self.radioButton_kukaku.setEnabled(False)
        self.checkBox_draw.setEnabled(False)


    # 結線・区画　確定（Digitizer）
    def pButton_20(self):
        if self.radioButton_kessen.isChecked():
            if self.kessenFlag.text() == '':
                return
            if int(self.kessenCount.text()) < 2:
                QMessageBox.information(self, u'エラー：点数不足', u'結線データには、２点以上必要です。')
                return
            self.kessenFlag.setText('')
            self.textEdit_kessen.append('F99,')
            self.kessenCount.setText('0')
            keizoku = QMessageBox.question(self,u'継続確認', u'続けて結線データを作成しますか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
            if keizoku == QMessageBox.Yes:
                self.kessenNo.setText(str(int(self.kessenNo.text()) + 1))
                self.kessenFlag.setText(u'編集中')
                self.textEdit_kessen.append('F00,' + self.kessenNo.text() + ',0,' + self.kessenNo.text() + ',1,')
            else:
                self.pushButton_5.setEnabled(True)
                self.pushButton_43.setEnabled(True)
                self.radioButton_point.setEnabled(True)
                self.radioButton_kessen.setEnabled(True)
                self.radioButton_kukaku.setEnabled(True)
                self.checkBox_draw.setEnabled(True)
                self.radioButton_point.setChecked(True)
        if self.radioButton_kukaku.isChecked():
            if self.kukakuFlag.text() == '':
                return
            if int(self.kukakuCount.text()) < 3:
                QMessageBox.information(self, u'エラー：点数不足', u'区画データには、３点以上必要です。')
                return
            self.kukakuFlag.setText('')
            self.textEdit_kukaku.append('D99,')
            self.kukakuCount.setText('0')
            #----------区画線描画----------
            # 区画を閉じる
            if self.checkBox_draw.isChecked():
                points = [QgsPoint(float(yy), float(xx)), QgsPoint(ys, xs)]
                layer = QgsVectorLayer('Linestring?crs=epsg:' + code2, self.kukakuNo.text() + '.' + pe + '-' + ps, 'memory')
                provider = layer.dataProvider()
                feature = QgsFeature()
                feature.setGeometry(QgsGeometry.fromPolyline(points))
                feature.setAttributes([pe + '-' + ps, float(yy), float(xx), ys, xs])
                provider.addFeatures([feature])
                # グループ化
                QgsProject.instance().addMapLayer(layer, False)
                if QgsProject.instance().layerTreeRoot().findGroup(self.tr(u'区画')) == None:
                    QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.tr(u'区画')))
                group = QgsProject.instance().layerTreeRoot().findGroup(self.tr(u'区画'))
                group.insertLayer(0,layer)
                map.refresh()
                if self.comboBox_2.currentText() != '':
                    qmlfile = str(self.comboBox_2.currentText())
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
                else:
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/kukaku.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/kukaku.qml')
            #------------------------------
            # 継続確認
            keizoku = QMessageBox.question(self,u'継続確認', u'続けて区画データを作成しますか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
            if keizoku == QMessageBox.Yes:
                self.kukakuNo.setText(str(int(self.kukakuNo.text()) + 1))
                self.kukakuFlag.setText(u'編集中')
                self.textEdit_kukaku.append('D00,' + self.kukakuNo.text() + ',' + self.kukakuNo.text() + ',1,')
            else:
                self.pushButton_5.setEnabled(True)
                self.pushButton_43.setEnabled(True)
                self.radioButton_point.setEnabled(True)
                self.radioButton_kessen.setEnabled(True)
                self.radioButton_kukaku.setEnabled(True)
                self.checkBox_draw.setEnabled(True)
                self.radioButton_point.setChecked(True)


    # 取消（Digitizer）
    def undo(self):
        if self.lineEdit_2.text() == '0':
            return
        if self.radioButton_kessen.isChecked() and self.kessenCount.text() == '0':
            return
        if self.radioButton_kukaku.isChecked() and self.kukakuCount.text() == '0':
            return
        self.textEdit_1.setText(textEdit_1)
        self.textEdit_point.setText(textEdit_point)
        self.textEdit_kessen.setText(textEdit_kessen)
        self.textEdit_kukaku.setText(textEdit_kukaku)
        self.lineEdit_1.setText(lineEdit_1)
        self.lineEdit_2.setText(lineEdit_2)
        self.lineEdit_d.setText(lineEdit_d)
        self.lineEdit_td.setText(lineEdit_td)
        QgsProject.instance().removeMapLayer(Point_Layer_ID)
        if self.radioButton_kessen.isChecked():
            QgsProject.instance().removeMapLayer(Kessen_Layer_ID)
            self.lineEdit_x.setText(x0u)
            self.lineEdit_y.setText(y0u)
            self.kessenNo.setText(kessenNo)
            self.kessenCount.setText(kessenCount)
        if self.radioButton_kukaku.isChecked():
            QgsProject.instance().removeMapLayer(Kukaku_Layer_ID)
            self.lineEdit_x.setText(x0u)
            self.lineEdit_y.setText(y0u)
            self.kukakuNo.setText(kukakuNo)
            self.kukakuCount.setText(kukakuCount)
            global xx
            global yy
            xx = x0
            yy = y0
        map.refresh()


    # 消去（Digitizer）
    def pButton_3(self):
        keizoku = QMessageBox.question(self,u'消去', u'実行してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if keizoku == QMessageBox.Yes:
            self.textEdit_1.clear()
            self.textEdit_point.clear()
            self.textEdit_kessen.clear()
            self.textEdit_kukaku.clear()
            self.textEdit_3.clear()
            self.lineEdit_2.setText('0')
            self.lineEdit_d.setText('0')
            self.lineEdit_td.setText('0')
            self.lineEdit_x.setText('0')
            self.lineEdit_y.setText('0')
            self.kessenNo.setText('0')
            self.kukakuNo.setText('0')
            self.kessenCount.setText('0')
            self.kukakuCount.setText('0')
            self.kessenFlag.setText('')
            self.kukakuFlag.setText('')
            self.textEdit_1.append('name,x(latitude),y(longitude),h,hsrc,note')
            self.textEdit_3.append('x(latitude),y(longitude),name')
            self.textEdit_point.append('Z00,/Digitizer3/,')
            self.textEdit_point.append('G00,01,')
            self.textEdit_point.append('Z00,/point data/,')
            self.textEdit_point.append('A00,')
            self.textEdit_kessen.append('Z00,/line data/,')
            self.textEdit_kukaku.append('Z00,/polygon data/,')
            self.radioButton_point.setEnabled(True)
            self.radioButton_kessen.setEnabled(True)
            self.radioButton_kukaku.setEnabled(True)
            self.checkBox_draw.setEnabled(True)
            self.pushButton_5.setEnabled(True)
            self.pushButton_43.setEnabled(True)
            self.radioButton_point.setChecked(True)
            self.textEdit_sim2kml.clear()
            self.textEdit_point2.clear()
            self.textEdit_kessen2.clear()
            self.textEdit_kukaku2.clear()
            self.lineEdit_path_sim.setText('')
            # レイヤグループ削除
            root = QgsProject.instance().layerTreeRoot()
            group = root.findGroup('Digitizer')
            if not group is None:
                for child in group.children():
                    dump = child.dump()
                    id = dump.split("=")[-1].strip()
                    QgsProject.instance().removeMapLayer(id)
                root.removeChildNode(group)
            group = root.findGroup(u'区画')
            if not group is None:
                for child in group.children():
                    dump = child.dump()
                    id = dump.split("=")[-1].strip()
                    QgsProject.instance().removeMapLayer(id)
                root.removeChildNode(group)
            group = root.findGroup(u'結線')
            if not group is None:
                for child in group.children():
                    dump = child.dump()
                    id = dump.split("=")[-1].strip()
                    QgsProject.instance().removeMapLayer(id)
                root.removeChildNode(group)
            try:
                QgsProject.instance().removeMapLayer(distance_Layer)
            except:
                pass
            try:
                QgsProject.instance().removeMapLayer(digitize_Layer)
            except:
                pass
            try:
                QgsProject.instance().removeMapLayer(kessen_Layer)
            except:
                pass
            try:
                QgsProject.instance().removeMapLayer(kml_Layer)
            except:
                pass
            map.refresh()
            # 一時保存ファイル削除
            workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
            try:
                for root, dirs, files in os.walk(workPath):
                    for file in files:
                        os.remove(workPath + '/' + file)
            except:
                pass


# ----------I/O----------------------------------------------------------------------------------------------------------------
    # スタイルファイルセット（I/O）
    def setQml(self):
        if self.radioButton_Layer_1.isChecked():
            qml = 'dxf.qml'
        elif self.radioButton_Layer_2.isChecked():
            qml = 'kml.qml'
        elif self.radioButton_Layer_3.isChecked():
            qml = 'photo.qml'
        elif self.radioButton_Layer_4.isChecked():
            qml = 'shp.qml'
        elif self.radioButton_Layer_5.isChecked():
            qml = 'geojson.qml'
        elif self.radioButton_Layer_6.isChecked():
            qml = 'sima.qml'
        elif self.radioButton_Layer_7.isChecked():
            qml = 'csv.qml'
        elif self.radioButton_Layer_8.isChecked():
            qml = ''
        elif self.radioButton_Layer_9.isChecked():
            qml = 'gpx_track.qml'
        no = 0
        for count in range(self.comboBox_2.count()):
            if count > 0:
                dat = self.comboBox_2.itemText(count)
                if dat == qml:
                    no = count
        self.comboBox_2.setCurrentIndex(no)


    # スケールの変更（I/O）
    def pButton_37(self):
        if self.lineEdit_scale.text() == '':
            return
        scale = round(float(self.lineEdit_scale.text()), 0)
        self.lineEdit_scale.setText(str(int(scale)))
        map.zoomScale(scale)


    # ズームイン（I/O）
    def pButton_38(self):
        map.zoomIn()
        scale = round(map.scale(), 0)
        self.lineEdit_scale.setText(str(int(scale)))


    # ズームアウト（I/O）
    def pButton_39(self):
        map.zoomOut()
        scale = round(map.scale(), 0)
        self.lineEdit_scale.setText(str(int(scale)))


    # 表示中のレイヤの全域にズーム（I/O）
    def pButton_40(self):
        map.zoomToFullExtent()
        scale = round(map.scale(), 0)
        self.lineEdit_scale.setText(str(int(scale)))


    # 選択したレイヤの領域にズーム（I/O）
    def pButton_48(self):
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        layer = qgis.utils.iface.activeLayer()
        try:# レイヤグループは対応不可
            layer_crs = layer.crs().authid()
        except:
            return
        if layer_crs[:5] == 'EPSG:':#元のCRSがカスタムCRSでない場合
            active_layer_crs = layer_crs.replace('EPSG:', '')
            new_crs = QgsCoordinateReferenceSystem(int(active_layer_crs), QgsCoordinateReferenceSystem.EpsgCrsId)
        else:
            active_layer_crs = layer_crs.replace('USER:', '')
            new_crs = QgsCoordinateReferenceSystem(int(active_layer_crs), QgsCoordinateReferenceSystem.InternalCrsId)
        # プロジェクトとアクティブレイヤのCRSが違う時は、一旦プロジェクトCRSをアクティブレイヤのCRSに変更する
        if active_layer_crs != code:
            QgsProject.instance().setCrs(new_crs)
        try:
            self.zoom()
        except:
            pass
        # 変更したCRSを元のCRSに戻す
        if active_layer_crs != code:
            if epsgcode != '':#元のCRSがカスタムCRSでない場合
                new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.EpsgCrsId)
            else:
                new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
        map.refresh()


    # スケール取得（I/O）
    def pButton_49(self):
        QgsApplication.processEvents()
        scale = round(map.scale(), 0)
        self.lineEdit_scale.setText(str(int(scale)))
        QgsApplication.processEvents()


    # ファイルについて（I/O）
    def pButton_44(self):
        dat = u'DXF：結線・区画・点名・距離・区画名が表示できます。※1 ※2\n'
        dat = dat + u'SIMA：点データ（プロットマークと点名）・区画・結線を別レイヤで\n'
        dat = dat + u'　　　 表示します。※2\n'
        dat = dat + u'CSV：点データ（プロットマークと点名）のみ表示できます。※2 ※3 ※4\n'
        dat = dat + u'KML：イメージオーバーレイデータには対応しません。\n'
        dat = dat + u'KMZ：Exifに位置情報がある写真データを含むものが対象です。\n'
        dat = dat + u'SHAPE：ポリライン又はポリゴンのみ表示できます。※1 ※2\n'
        dat = dat + u'GeoJSON：ポリライン又はポリゴンのみ表示できます。※1 ※2\n'
        dat = dat + u'FlatGeobuf：ポリライン又はポリゴンのみ表示できます。※1 ※2\n'
        dat = dat + u'ラスタファイル：QGISで対応しているフォーマットが対象です。※2 ※5\n'
        dat = dat + u'GPX：track、route、waypointに対応しています。\n'
        dat = dat + u'\n'
        dat = dat + u'※1 結線・区画のpolylineレイヤと点名・距離・区画名等のpointレイヤ\n'
        dat = dat + u'　　に分かれて表示されます。DXFの場合、「ポリゴン化」して読み込むと、\n'
        dat = dat + u'　　「地番」という属性をもつポリゴンデータを作成します。\n'
        dat = dat + u'※2 CRSは、読込オプションの設定に従います。\n'
        dat = dat + u'※3 CSV：位置情報の列、区切文字は、読込オプションの設定に従います。\n'
        dat = dat + u'※4 1行目を見出行として、点名の見出を「name」とした場合、点名が表示　\n'
        dat = dat + u'　　されます。見出行がない場合、1行目はプロットされません。\n'
        dat = dat + u'※5 ワールドファイルがない場合は、プロジェクトのCRSで読み込みます。\n'
        QMessageBox.information(self, u'ファイルについて', dat)


    # レイヤの追加（I/O）
    def pButton_30(self):

        # 現在のマップキャンバスの中心座標を取得
        center_point = map.center()
        #print(f"現在のマップキャンバスの中心座標: X={center_point.x()}, Y={center_point.y()}")
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        # 使用されていない一時ファイルを削除
        try:
            os.remove(workPath + u'/csv.txt')
        except:
            pass
        try:
            os.remove(workPath + u'/sima.txt')
        except:
            pass
        try:
            os.remove(workPath + '/tmp.geojson')
        except:
            pass
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        # EPSGの指定がない場合は、プロジェクトのCRSを適用する
        if self.lineEdit_8.text() == '':
            self.lineEdit_8.setText(code)
        # プロジェクトのEPSGと異なる場合
        code2 = self.lineEdit_8.text()
        if code2 != code:
            flag = 1
        else:
            flag = 0
        # 読み込むデータのEPSGの判別（custom=''ならカスタムCRS）
        custom = str(QgsCoordinateReferenceSystem(int(code2)).authid())
        # 読込ダイアログ表示
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        # DXF
        if self.radioButton_Layer_1.isChecked():
            fname = dialog.getOpenFileName(self, u'DXFインポート', '', '*.dxf')
        # KML
        elif self.radioButton_Layer_2.isChecked():
            fname = dialog.getOpenFileName(self, u'KMLインポート', '', '*.kml')
        # KMZ
        elif self.radioButton_Layer_3.isChecked():
            fname = dialog.getOpenFileName(self, u'KMZインポート', '', '*.kmz')
        # KMZ
        elif self.radioButton_Layer_3.isChecked():
            fname = dialog.getOpenFileName(self, u'KMZインポート', '', '*.kmz')
        # SHP
        elif self.radioButton_Layer_4.isChecked():
            fname = dialog.getOpenFileName(self, u'Shapeインポート', '', '*.shp')
        # GeoJSON/FlatGeobuf
        elif self.radioButton_Layer_5.isChecked():
            if self.checkCenter.isChecked():
                filter = 'GeoJSON (*.geojson)'
            else:
                filter = 'GeoJSON (*.geojson);;FlatGeobuf (*.fgb)'
            fname = dialog.getOpenFileName(self, u'ベクタファイルを開く', '', filter)
            if not fname or str(fname) == "('', '')":
                return
            if self.checkCenter.isChecked():
                if isinstance(fname, tuple):
                    fname = fname[0]
                else:
                    fname = fname
                old_epsg = ""
                new_epsg = code2
                new_geojson_content = ""
                output_path = workPath + '/tmp.geojson'
                fin = codecs.open(fname, "r", "utf-8")
                for row in fin:
                    if "EPSG::" in row:
                        line = row.split("EPSG::")
                        line2 = line[1].split('"')
                        row = line[0] + "EPSG::" + new_epsg + '"' + line2[1]
                    new_geojson_content = new_geojson_content + row
                if line2[1].strip() == "},":
                    new_geojson_content = new_geojson_content + '"type": "name"}}'
                fin.close()
                # 3. 書き換え後の内容を新しいファイルとして保存する
                try:
                    # output_path は関数の引数として受け取っているため、スコープエラーは発生しない
                    with open(output_path, 'w', encoding='utf-8') as f:
                        f.write(new_geojson_content)
                    print(f"書き換え後のファイルを保存しました: {output_path}")
                    fname = output_path
                except Exception as e:
                    # このエラーメッセージは、ファイルパスが無効な場合などに発生する可能性があります
                    print(f"エラー: ファイル保存中に問題が発生しました - {e}")
                    return
        # SIMA
        elif self.radioButton_Layer_6.isChecked():
            fname = dialog.getOpenFileName(self, u'SIMAインポート', '', '*.sim')
        # CSV
        elif self.radioButton_Layer_7.isChecked():
            fname = dialog.getOpenFileName(self, u'CSVインポート', '', '*.csv')
        # ラスタファイル
        elif self.radioButton_Layer_8.isChecked():
            fname = dialog.getOpenFileName(self, u'ラスタファイルインポート', '', '*.*')
        # GPX
        elif self.radioButton_Layer_9.isChecked():
            fname = dialog.getOpenFileName(self, u'GPXインポート', '', '*.gpx')

        file_name = os.path.basename(str(fname))
        # キャンセルの場合
        if not fname or str(fname) == "('', '')":
            return
        if self.checkCenter.isChecked() and self.radioButton_Layer_5.isChecked():
            pass
        else:
            fn = str(fname).split("'")
            fname = fn[1]

        if (self.radioButton_Layer_2.isChecked() or self.radioButton_Layer_3.isChecked() or self.radioButton_Layer_9.isChecked()) and code == '4326':
            flag = 0
        # KML、KMZ、GPXは指定のEPSGに関係なく4326
        if (self.radioButton_Layer_2.isChecked() or self.radioButton_Layer_3.isChecked() or self.radioButton_Layer_9.isChecked()) and code != '4326':
            new_crs = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
            QgsProject.instance().setCrs(new_crs)
            map.refresh()
            code2 = '4326'
            flag = 1
        # KML、KMZ、GPX以外で、プロジェクトのEPSGと異なる場合、プロジェクトのCRSを指定のEPSGに変更する
        if flag == 1 and (not self.radioButton_Layer_2.isChecked()) and (not self.radioButton_Layer_3.isChecked()) and (not self.radioButton_Layer_9.isChecked()):
            #　データのCRSがカスタムCRSでない場合
            if custom != '':
                new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.EpsgCrsId)
            #　データのCRSがカスタムCRSの場合
            else:
                new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
            map.refresh()

        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')

        # DXF
        if self.radioButton_Layer_1.isChecked():
            result = QMessageBox.question(self,u'DXFインポート', u'ポリゴン化して読み込みますか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
            if result == QMessageBox.Yes:
                workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
                dxf_path1 = workPath + '/dxf1.geojson'
                bin_dir = self.lineEdit_bin.text()
                cmd = '"' + bin_dir + 'ogr2ogr.exe" -f geojson -s_srs EPSG:' + code2 + ' -t_srs EPSG:' + code2 + ' ' + dxf_path1 + ' ' + fname
                result = subprocess.run(cmd, shell=True)
                dxf_path2 = workPath + '/dxf2.geojson'
                #command = "qgis_process run native:polygonize --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + dxf_path1 + " --KEEP_FIELDS=false --OUTPUT=" + dxf_path2
                #os.system(command)
                result = qgis.processing.run("native:polygonize", {'INPUT':dxf_path1,'KEEP_FIELDS':False,'OUTPUT':dxf_path2})
                uri = dxf_path1 + '|layername=entities|geometrytype=Point'
                layer = QgsVectorLayer(uri, 'dxf2geojson(point)', 'ogr')
                dxf_path3 = workPath + '/dxf3.geojson'
                QgsVectorFileWriter.writeAsVectorFormat(layer, dxf_path3, "utf-8", layer.crs(), 'geojson')
                dxf_path4 = workPath + '/dxf4.geojson'
                #command = "qgis_process run native:joinattributesbylocation --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + dxf_path2 + " --PREDICATE=1 --JOIN=" +  dxf_path3 + " --JOIN_FIELDS=Text --METHOD=1 --DISCARD_NONMATCHING=false --PREFIX= --OUTPUT=" + dxf_path4
                #os.system(command)
                qgis.processing.run("native:joinattributesbylocation", {'INPUT':dxf_path2,'PREDICATE':[1],'JOIN':dxf_path3,'JOIN_FIELDS':['Text'],'METHOD':0,'DISCARD_NONMATCHING':False,'PREFIX':'','OUTPUT':dxf_path4})
                dxf_path5 = workPath + '/dxf2geojson.geojson'
                #command = "qgis_process run native:renametablefield --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + dxf_path4 + " --FIELD=Text --NEW_NAME=地番 --OUTPUT=" + dxf_path5
                #os.system(command)
                qgis.processing.run("native:renametablefield", {'INPUT':dxf_path4,'FIELD':'Text','NEW_NAME':'地番','OUTPUT':dxf_path5})
                layer = QgsVectorLayer(dxf_path5, 'dxf2geojson', 'ogr')
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/dxf2geojson.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/dxf2geojson.qml')
            else:
                uri = fname + '|layername=entities|geometrytype=Point'
                layer = QgsVectorLayer(uri, 'dxf(point)', 'ogr')
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/dxf(point).qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/dxf(point).qml')
                #uri = fname + '|layername=entities|geometrytype=Polyline'
                uri = fname + '|layername=entities|geometrytype=Polygone'
                layer = QgsVectorLayer(uri, 'dxf(polyline)', 'ogr')
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/dxf.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/dxf.qml')
        # KML
        elif self.radioButton_Layer_2.isChecked():
            layer = QgsVectorLayer(fname, 'kml', 'ogr')
            QgsProject.instance().addMapLayer(layer)
        # KMZ
        elif self.radioButton_Layer_3.isChecked():
            # KMZのPathを記録する
            foldername = dialog.getExistingDirectory(self, u'解凍先のフォルダを選択してください。')
            if foldername == "" or foldername == None:
                # プロジェクトのCRS設定を開始時に戻す
                settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
                return
            if os.path.exists(foldername + '/kmz_temp'):
                try:
                    shutil.rmtree(foldername + '/kmz_temp')
                except:
                    QMessageBox.information(self, u'フォルダを削除できません。', u'「kmz_temp」には、使用中か書込禁止属性のついた\nフォルダ又はファイルがあります。\n解凍先には別のフォルダを指定してください。')
                    # プロジェクトのCRS設定を開始時に戻す
                    settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
                    return
            os.mkdir(foldername + '/kmz_temp')
            with zipfile.ZipFile(fname, 'r') as zip_file:
                zip_file.extractall(path = foldername + '/kmz_temp')
            #「Exif」でレイヤに追加する
            self.textPath.setText(foldername + '/kmz_temp')
            self.getExifInfo()
            self.textPath.clear()
            self.textExif.clear()
        # SHP
        elif self.radioButton_Layer_4.isChecked():
            layer = QgsVectorLayer(fname, 'shp', 'ogr')
            QgsProject.instance().addMapLayer(layer)
        # GeoJSON
        elif self.radioButton_Layer_5.isChecked():
            if self.checkCenter.isChecked():
                layer = QgsVectorLayer(fname, 'moved_geojson', 'ogr')
            else:
                layer = QgsVectorLayer(fname, 'geojson', 'ogr')
            QgsProject.instance().addMapLayer(layer)
        # SIMA
        elif self.radioButton_Layer_6.isChecked():
            # 日本語の文字化け対策のため、utf-8に変換
            savename0 = workPath + u'/utf-8.sim'
            fin = codecs.open(fname, "r", "shift_jis")
            fout = codecs.open(savename0, "w", "utf-8")
            for row in fin:
                fout.write(row)
            fin.close()
            fout.close()
            fname = savename0
            savename = workPath + u'/sim2point.txt'
            savename2 = workPath + u'/sim2geojson1.txt'
            savename3 = workPath + u'/sim2geojson2.txt'
            savename4 = workPath + u'/sim2geojson3.txt'
            savename5 = workPath + u'/sim2geojson4.txt'
            savename6 = workPath + u'/sima.geojson'
            savename7 = workPath + u'/sima2.geojson'
            fin = codecs.open(fname, 'r', 'utf-8')
            fout = codecs.open(savename, 'w', 'utf-8')
            fout2 = codecs.open(savename2, 'w', 'utf-8')
            fout3 = codecs.open(savename4, 'w', 'utf-8')

            # sim2point.txt/sim2geojson1.txt/sim2geojson3.txt
            fout.writelines('A01,no,name,x,y,h,\n')
            d_flag = 0
            f_flag = 0
            for line in fin:
                if line[:4] == 'A01,':
                    fout.writelines(line)
                if line[:4] == 'D00,':
                    fout2.writelines(line)
                    d_flag = 1
                if line[:4] == 'F00,':
                    fout3.writelines(line)
                    f_flag = 1
                if (line[:4] == 'B01,') and (d_flag == 1) and (f_flag == 0):
                    fout2.writelines(line)
                if (line[:4] == 'B01,') and (f_flag == 1) and (d_flag == 0):
                    fout3.writelines(line)
                if line[:4] == 'D99,':
                    fout2.writelines(line)
                    d_flag = 0
                if line[:4] == 'F99,':
                    fout3.writelines(line)
                    f_flag = 0
            fin.close()
            fout.close()
            fout2.close()
            fout3.close()

            # polyline ------------------------------------------------------------------------------------------------------------
            # polygonの前にpolylineを作成しないとpolylineが表示できない場合がある（原因不明）
            # sim2geojson4.txt
            fin2 = codecs.open(savename4, 'r', 'utf-8')
            fout = codecs.open(savename5, 'w', 'utf-8')
            txt = ''
            for line2 in fin2:
                if line2[:4] == 'F00,':
                    d2 = line2.split(',')
                    chiban = d2[3].replace('\\', '(')
                    fout.writelines('F00,' + chiban + ',\n')
                if line2[:4] == 'F99,':
                    fout.writelines('F99,\n')
                if line2[:4] == 'B01,':
                    fin1 = codecs.open(savename, 'r', 'utf-8')
                    d2 = line2.split(',')
                    p_no2 = d2[1]
                    for line1 in fin1:
                        d1 = line1.split(',')
                        p_no1 = d1[1]
                        x = d1[3]
                        y = d1[4]
                        if p_no2 == p_no1:
                            break
                    fout.writelines(y + ',' + x + ',\n')
                    fin1.close()
            fin2.close()
            fout.close()

            # sima2.geojson
            count = 0
            with open(savename5) as f:
                for line in f:
                    count += 1
            fin = codecs.open(savename5, 'r', 'utf-8')
            txt = '{\r\n'
            txt = txt + "  " + '"' + "type" + '"' + ":" + '"' + "FeatureCollection" + '"' + ",\r\n"
            txt = txt + "  " + '"' + "name" + '"' + ":" + '"' + "entities" + '"' + ",\r\n"
            txt = txt + "  " + '"' + "crs" + '"' + ": {" + '"' + "type" + '"' + ": " + '"' + "name" + '"' + "," + '"' + "properties" + '"' + ": {" + '"' + "name" + '"' + ": " + '"' + "urn:ogc:def:crs:EPSG::" + code + '"' + "}},\r\n"
            txt = txt + "  " + '"' + "features" + '"' + ": [\r\n"
            fout = codecs.open(savename7, 'w', 'utf-8')
            l = 0
            for line in fin:
                l = l + 1
                d = line.split(',')
                if line[:4] == 'F00,':
                    chiban = d[1].replace('\\', '(')
                    txt = txt + '    {\r\n'
                    txt = txt + '      ' + '"' + 'type' + '"' + ":" + '"' + "Feature" + '"' + ',\r\n'
                    txt = txt + '      ' + '"' + 'properties' + '"' + ': {\r\n'
                    txt = txt + '        ' + '"' + 'line' + '"' + ": " + '"' + chiban + '"' + '\n'
                    txt = txt + '      },\r\n'
                    txt = txt + '        ' + '"' + 'geometry' + '"' + ": {\r\n"
                    txt = txt + '        ' + '"' + 'type' + '"' + ": " + '"' + "LineString" + '"' + ',\r\n'
                    txt = txt + '        ' + '"' + 'coordinates' + '"' + ': [\r\n'
                elif line[:4] == 'F99,':
                    txt = txt + '        ]\r\n'
                    txt = txt + '      }\r\n'
                    if l == count:
                        txt = txt + '    }\r\n'
                    else:
                        txt = txt + '    },\r\n'
                else:
                    dat = d[0] + ',' + d[1]
                    txt = txt + '          [' + dat + '],\r\n'
            txt = txt + '  ]\r\n'
            txt = txt + '}\r\n'
            txt = txt.replace('],\r\n        ]', ']\r\n        ]')
            fin.close()
            fout.write(txt)
            try:
                if os.path.exists(savename4):
                    fs = os.path.getsize(savename4)
                    if fs == 0:
                        os.remove(savename4)
            except:
                pass
            try:
                if os.path.exists(savename5):
                    fs = os.path.getsize(savename5)
                    if fs == 0:
                        os.remove(savename5)
            except:
                pass

            # polygon -------------------------------------------------------------------------------------------------------------
            # sim2geojson2.txt
            fin2 = codecs.open(savename2, 'r', 'utf-8')
            fout = codecs.open(savename3, 'w', 'utf-8')
            txt = ''
            for line2 in fin2:
                if line2[:4] == 'D00,':
                    d2 = line2.split(',')
                    chiban = d2[2]
                    fout.writelines('D00,' + chiban + ',\n')
                if line2[:4] == 'D99,':
                    fout.writelines('D99,\n')
                if line2[:4] == 'B01,':
                    fin1 = codecs.open(savename, 'r', 'utf-8')
                    d2 = line2.split(',')
                    p_no2 = d2[1]
                    for line1 in fin1:
                        d1 = line1.split(',')
                        p_no1 = d1[1]
                        x = d1[3]
                        y = d1[4]
                        if p_no2 == p_no1:
                            break
                    fout.writelines(y + ',' + x + ',\n')
                    fin1.close()
            fin2.close()
            fout.close()

            # sima.geojson
            count = 0
            with open(savename3) as f:
                for line in f:
                    count += 1
            fin = codecs.open(savename3, 'r', 'utf-8')
            txt = '{\r\n'
            txt = txt + "  " + '"' + "type" + '"' + ":" + '"' + "FeatureCollection" + '"' + ",\r\n"
            txt = txt + "  " + '"' + "name" + '"' + ":" + '"' + "entities" + '"' + ",\r\n"
            txt = txt + "  " + '"' + "crs" + '"' + ": {" + '"' + "type" + '"' + ": " + '"' + "name" + '"' + "," + '"' + "properties" + '"' + ": {" + '"' + "name" + '"' + ": " + '"' + "urn:ogc:def:crs:EPSG::" + code + '"' + "}},\r\n"
            txt = txt + "  " + '"' + "features" + '"' + ": [\r\n"
            fout = codecs.open(savename6, 'w', 'utf-8')
            l = 0
            for line in fin:
                l = l + 1
                d = line.split(',')
                if line[:4] == 'D00,':
                    n = 1
                    chiban = d[1].replace('\\', '(')
                    txt = txt + '    {\r\n'
                    txt = txt + '      ' + '"' + 'type' + '"' + ":" + '"' + "Feature" + '"' + ',\r\n'
                    txt = txt + '      ' + '"' + 'properties' + '"' + ': {\r\n'
                    txt = txt + '        ' + '"' + '地番' + '"' + ": " + '"' + chiban + '"' + '\n'
                    txt = txt + '      },\r\n'
                    txt = txt + '        ' + '"' + 'geometry' + '"' + ": {\r\n"
                    txt = txt + '        ' + '"' + 'type' + '"' + ": " + '"' + "MultiPolygon" + '"' + ',\r\n'
                    txt = txt + '        ' + '"' + 'coordinates' + '"' + ': [\r\n'
                    txt = txt + '          [[\r\n'
                elif line[:4] == 'D99,':
                    txt = txt + '            [' + dat1 + ']\r\n'
                    txt = txt + '          ]]\r\n'
                    txt = txt + '        ]\r\n'
                    txt = txt + '      }\r\n'
                    if l == count:
                        txt = txt + '    }\r\n'
                    else:
                        txt = txt + '    },\r\n'
                else:
                    dat = d[0] + ',' + d[1]
                    txt = txt + '            [' + dat + '],\r\n'
                    if n == 1:
                        dat1 = dat
                    n = 2
            txt = txt + '  ]\r\n'
            txt = txt + '}\r\n'
            fin.close()
            fout.write(txt)
            fout.close()
            try:
                if os.path.exists(savename2):
                    fs = os.path.getsize(savename2)
                    if fs == 0:
                        os.remove(savename2)
            except:
                pass
            try:
                if os.path.exists(savename3):
                    fs = os.path.getsize(savename3)
                    if fs == 0:
                        os.remove(savename3)
            except:
                pass
            # ポリゴンレイヤの追加
            if os.path.exists(savename3):
                layer = QgsVectorLayer(savename6, '区画', 'ogr')
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml')
            # ポリラインレイヤの追加
            if os.path.exists(savename5):
                layer = QgsVectorLayer(savename7, '結線', 'ogr')
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/kessen(green).qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/kessen(green).qml')
            # ポイントレイヤの追加
            uri = 'file:///' + savename + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_5', 'field_4' + '&crs=epsg:' + self.lineEdit_8.text())
            layer = QgsVectorLayer(uri, '頂点', 'delimitedtext')
            QgsProject.instance().addMapLayer(layer)
            if os.path.exists(os.path.dirname(__file__) + u'/qml/csv2.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/csv2.qml')

        # CSV
        elif self.radioButton_Layer_7.isChecked():
            # 日本語対応にするために、Utf-8テキストを作成
            savename = workPath + u'/csv.txt'
            fin = open(fname, "r")
            fout = codecs.open(savename, 'w', 'utf-8')
            try:
                for line in fin:
                   fout.writelines(line)
            except:
                QMessageBox.information(self, u'エラー', u'CSVの文字コードを「shift-jis」に変更してください。')
                return
            fin.close()
            fout.close()
            kugiri = self.lineEdit_7.text()#区切文字
            # ポイントレイヤの追加
            uri = 'file:///' + savename + '?delimiter=%s&xField=%s&yField=%s' % (kugiri, 'field_' + str(self.lineEdit_6.text()), 'field_' + str(self.lineEdit_5.text()) + '&crs=epsg:' + self.lineEdit_8.text())
            layer = QgsVectorLayer(uri, 'CSV', 'delimitedtext')
            QgsProject.instance().addMapLayer(layer)
        # ラスタ
        elif self.radioButton_Layer_8.isChecked():
            fileInfo = QFileInfo(fname)
            layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
            QgsProject.instance().addMapLayer(layer)
        # GPX
        elif self.radioButton_Layer_9.isChecked():
            uri = fname + '?type=waypoint'
            layer = QgsVectorLayer(uri, 'gpx_waypoint', 'gpx')
            if layer:
                QgsProject.instance().addMapLayer(layer)
            uri = fname + '?type=route'
            layer = QgsVectorLayer(uri, 'gpx_route', 'gpx')
            if layer:
                QgsProject.instance().addMapLayer(layer)
            if os.path.exists(os.path.dirname(__file__) + u'/qml/gpx_route.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/gpx_route.qml')
            uri = fname + '?type=track'
            layer = QgsVectorLayer(uri, 'gpx_track', 'gpx')
            if layer:
                QgsProject.instance().addMapLayer(layer)

        # カレントPathを記録する
        reg_path = os.path.dirname(fname)
        ws.setValue("setting/reg_path", reg_path)

        if not self.radioButton_Layer_3.isChecked():
            # スタイルの設定
            if self.comboBox_2.currentText() != '':
                qmlfile = str(self.comboBox_2.currentText())
                if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
            # レイヤの領域に移動する
            self.zoom()
        if flag == 1:
            QMessageBox.information(self, u'空間参照系変更', u'プロジェクトのCRSを、EPSG:' + code2 + u' に変更しました。')
        # プロジェクトのCRSのコンボボックスを更新
        self.set_Combo()
        # スケール取得
        QgsApplication.processEvents()
        self.pButton_49()
        QgsApplication.processEvents()
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))

        # snap設定（これを実行後、プロジェクトの新規作成を実行するとQGIS3.4はクラッシュする）
        #snap_config = QgsSnappingConfig()
        #snap_config.setEnabled(True)
        #snap_config.setType(QgsSnappingConfig.VertexAndSegment) # Vertex=頂点,Segment=線
        #snap_config.setUnits(QgsTolerance.Pixels)
        #snap_config.setTolerance(30) # 許容値
        #snap_config.setIntersectionSnapping(True)
        #QgsProject.instance().setSnappingConfig(snap_config)

        # 読み込んだレイヤをマップキャンバスの中心に移動させる（GeoJSON）
        if self.checkCenter.isChecked() and self.radioButton_Layer_5.isChecked():
            # レイヤが正常に読み込まれたか確認
            if layer.isValid():
                # レイヤをQGISのマップに追加
                QgsProject.instance().addMapLayer(layer)
                #print(f"'{layer_name}' を正常に読み込みました。")
                # 3. 地物全体の中心座標を取得する
                # ----------------------------------------------------
                # 地物全体の境界ボックス (extent) を取得
                extent = layer.extent()
                # 境界ボックスの中心座標を計算
                features_center_x = (extent.xMinimum() + extent.xMaximum()) / 2
                features_center_y = (extent.yMinimum() + extent.yMaximum()) / 2
                features_center_point = QgsPointXY(features_center_x, features_center_y)
                #print(f"地物全体の中心座標: X={features_center_point.x()}, Y={features_center_point.y()}")
                # 4. 地物全体をマップキャンバスの中心に移動する
                # ----------------------------------------------------
                # 移動の差分を計算
                delta_x = center_point.x() - features_center_point.x()
                delta_y = center_point.y() - features_center_point.y()
                # レイヤの編集モードを開始
                layer.startEditing()
                # 各地物をループして移動
                for feature in layer.getFeatures():
                    geometry = feature.geometry()
                    # ジオメトリを移動
                    geometry.translate(delta_x, delta_y)
                    # 地物のジオメトリを更新
                    layer.changeGeometry(feature.id(), geometry)
                # 編集を保存して終了
                #layer.commitChanges()
                # マップビューを更新
                map.refresh()
                #print("地物全体をマップキャンバスの中心に移動しました。")
                # スタイルの設定
                if os.path.exists(os.path.dirname(__file__) + u'/qml/center.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/center.qml')
                # レイヤの領域に移動する
                self.zoom()


    # Vector→Vector（I/O）
    def pButton_63(self):
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        # 使用されていない一時ファイルを削除
        try:
            os.remove(workPath + u'/csv.txt')
        except:
            pass
        try:
            os.remove(workPath + u'/sima.txt')
        except:
            pass
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        # EPSGの指定がない場合は、プロジェクトのCRSを適用する
        if self.lineEdit_8.text() == '':
            self.lineEdit_8.setText(code)
        # プロジェクトのEPSGと異なる場合
        code2 = self.lineEdit_8.text()
        if code2 != code:
            flag = 1
        else:
            flag = 0
        # 指定のEPSGの判別（custom=''ならカスタムCRS）
        custom = str(QgsCoordinateReferenceSystem(int(self.lineEdit_8.text())).authid())
        # 読込ダイアログ表示
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        filter = 'DXF (*.dxf);;KML (*.kml);;GeoJSON (*.geojson);;FlatGeobuf (*.fgb);;ESRI Shapefile (*.shp);;PDF (*.pdf);;*.* (*.*)'
        fname = dialog.getOpenFileName(self, u'ベクタファイルを開く', '', filter)
        file_name = os.path.basename(str(fname))
        if not fname or str(fname) == "('', '')":
            return
        fn = str(fname).split("'")
        fname = fn[1]
        dirpath0 = os.path.dirname(fname)
        filename0 = os.path.basename(fname)
        fn0, ext0 = os.path.splitext(filename0)
        ext0 = ext0.lower().replace('.', '')
        if ext0 == 'kmz':
            QMessageBox.information(self, u'未対応', u'KMZには対応していません。')
            return
        # 保存ダイアログ表示
        filter = 'KML (*.kml);;DXF (*.dxf);;ESRI Shapefile (*.shp);;GeoJSON (*.geojson);;FlatGeobuf (*.fgb);;PDF (*.pdf);;*.* (*.*)'
        fname2 = dialog.getSaveFileName(self, u'ベクタファイル保存', '', filter)
        if not fname2 or str(fname2) == "('', '')":
            return
        fn = str(fname2).split("'")
        fname2 = fn[1]
        dirpath = os.path.dirname(fname2)
        filename = os.path.basename(fname2)
        fn, ext = os.path.splitext(filename)
        ext = ext.lower().replace('.', '')
        if ext == 'sim':
            QMessageBox.information(self, u'未対応', u'SIMAの出力には対応していません。')
            return
        if ext == 'gpx':
            QMessageBox.information(self, u'未対応', u'GPXの出力には対応していません。')
            return
        if ext == 'shp':
            ext = 'ESRI Shapefile'
        if ext == 'fgb':
            ext = 'FlatGeobuf'
        if (ext0 == 'kml' or ext0 == 'gpx') and code == '4326':
            flag = 0
        # KMLは指定のEPSGに関係なく4326
        if (ext0 == 'kml' or ext0 == 'gpx') and code != '4326':
            new_crs = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
            QgsProject.instance().setCrs(new_crs)
            map.refresh()
            code2 = '4326'
            flag = 1
        # KML以外で、プロジェクトのEPSGと異なる場合、プロジェクトのCRSを指定のEPSGに変更する
        if flag == 1 and ext0 != 'kml' and ext0 != 'gpx':
            #　データのCRSがカスタムCRSでない場合
            if custom != '':
                new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.EpsgCrsId)
            #　データのCRSがカスタムCRSの場合
            else:
                new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
            map.refresh()

        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')

        # DXF
        if ext0 == 'dxf':
            uri = fname + '|layername=entities|geometrytype=PolyLine'
            layer = QgsVectorLayer(uri, 'dxf', 'ogr')
            QgsProject.instance().addMapLayer(layer)
            if os.path.exists(os.path.dirname(__file__) + u'/qml/dxf.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/dxf.qml')
            QgsVectorFileWriter.writeAsVectorFormat(layer, fname2, "utf-8", layer.crs(), ext)
            uri = fname + '|layername=entities|geometrytype=Point'
            layer2 = QgsVectorLayer(uri, 'dxf_Point', 'ogr')
            QgsProject.instance().addMapLayer(layer2)
            if os.path.exists(os.path.dirname(__file__) + u'/qml/dxf(point).qml'):
                layer2.loadNamedStyle(os.path.dirname(__file__) + u'/qml/dxf(point).qml')
            if ext == 'ESRI Shapefile' or ext == 'FlatGeobuf':
                QgsVectorFileWriter.writeAsVectorFormat(layer2, dirpath + '/' + fn + '_point', 'utf-8', layer2.crs(), ext)
            else:
                QgsVectorFileWriter.writeAsVectorFormat(layer2, dirpath + '/' + fn + '_point.' + ext, 'utf-8', layer2.crs(), ext)
            if os.path.exists(fname2):
                QMessageBox.information(self, u'完了', u'「' + fname2 + u'」を作成しました。')
            else:
                QMessageBox.information(self, u'エラー', u'「' + fname2 + u'」を作成できませんでした。')
            return
        # KML
        elif ext0 == 'kml':
            layer = QgsVectorLayer(fname, 'kml', 'ogr')
            layer.setCrs(QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId))
            QgsProject.instance().addMapLayer(layer)
        # SHP
        elif ext0 == 'shp':
            layer = QgsVectorLayer(fname, 'shp', 'ogr')
            QgsProject.instance().addMapLayer(layer)
        # GeoJSON
        elif ext0 == 'geojson':
            layer = QgsVectorLayer(fname, 'geojson', 'ogr')
            QgsProject.instance().addMapLayer(layer)
        # FlatGeobuf
        elif ext0 == 'fgb':
            layer = QgsVectorLayer(fname, 'fgb', 'ogr')
            QgsProject.instance().addMapLayer(layer)
        # SIMA
        elif ext0 == 'sim':
            #カンマの数でSIMAか成果数値データかを判別（6=SIMA：10=成果数値データ）
            fin = open(fname, 'r')
            try:
                for line in fin:
                    if line[:4] == 'A01,':
                        n = line.count(',')
            except:
                QMessageBox.information(self, u'エラー', u'SIMAの文字コードを「shift-jis」に変更してください。')
                return
            fin.close()
            # 日本語対応にするため＆フィールド行を作成するため、Utf-8のテキストを作成
            savename = workPath + u'/sima.txt'
            fin = open(fname, "r")
            fout = codecs.open(savename, 'w', 'utf-8')
            if n == 6:#[SIMAファイル]
                fout.writelines('A01,no,name,x,y,h,\n')
            if n == 10:#[成果数値データファイル]
                fout.writelines('A01,no,name,latitude,longitude,x,y,kei,h,geoid,\n')
            for line in fin:
                if line[:4] == 'Z02,':
                    z02 = line.split(',')
                    sokuchikei = z02[-3]#0=世界測地系
                    zahyoukei = z02[-2] #1～19=平面直角座標系
                if line[:4] == 'A01,':
                    fout.writelines(line)
            fin.close()
            fout.close()
            # ポイントレイヤの追加
            uri = 'file:///' + savename + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_5', 'field_4' + '&crs=epsg:' + self.lineEdit_8.text())
            if n == 10:#[成果数値データファイル]の場合
                if sokuchikei != '' and zahyoukei != '':#測地系または座標系の記載がある場合は、測地系または座標系からEPSG算出
                    if sokuchikei == '0':#[世界測地系]
                        epsgcode2 = str(2442 + int(zahyoukei))
                        uri = 'file:///' + savename + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_7', 'field_6&crs=epsg:' + epsgcode2)
                    else:#[日本測地系]
                        epsgcode2 = str(30160 + int(zahyoukei))
                        uri = 'file:///' + savename + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_7', 'field_6&crs=epsg:' + epsgcode2)
            layer = QgsVectorLayer(uri, 'SIMA', 'delimitedtext')
            QgsProject.instance().addMapLayer(layer)
        # CSV
        elif ext0 == 'csv':
            # 日本語対応にするために、Utf-8テキストを作成
            savename = workPath + u'/csv.txt'
            fin = open(fname, "r")
            fout = codecs.open(savename, 'w', 'utf-8')
            try:
                for line in fin:
                   fout.writelines(line)
            except:
                QMessageBox.information(self, u'エラー', u'CSVの文字コードを「shift-jis」に変更してください。')
                return
            fin.close()
            fout.close()
            kugiri = self.lineEdit_7.text()#区切文字
            # ポイントレイヤの追加
            uri = 'file:///' + savename + '?delimiter=%s&xField=%s&yField=%s' % (kugiri, 'field_' + str(self.lineEdit_6.text()), 'field_' + str(self.lineEdit_5.text()) + '&crs=epsg:' + self.lineEdit_8.text())
            layer = QgsVectorLayer(uri, 'CSV', 'delimitedtext')
            QgsProject.instance().addMapLayer(layer)
        # GPX
        elif ext0 == 'gpx':
            uri = fname + '?type=waypoint'
            layer = QgsVectorLayer(uri, 'gpx_waypoint', 'gpx')
            if layer:
                QgsProject.instance().addMapLayer(layer)
            uri = fname + '?type=route'
            layer = QgsVectorLayer(uri, 'gpx_route', 'gpx')
            if layer:
                QgsProject.instance().addMapLayer(layer)
            if os.path.exists(os.path.dirname(__file__) + u'/qml/gpx_route.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/gpx_route.qml')
            uri = fname + '?type=track'
            layer = QgsVectorLayer(uri, 'gpx_track', 'gpx')
            if layer:
                QgsProject.instance().addMapLayer(layer)
        # その他
        else:
            layer = QgsVectorLayer(fname, 'vector', 'ogr')
            QgsProject.instance().addMapLayer(layer)

        # Vectorファイルを保存する
        if ext0 != 'dxf':
            if ext == 'kml' or ext == 'ESRI Shapefile' or ext == 'geojson' or ext == 'FlatGeobuf':
                QgsVectorFileWriter.writeAsVectorFormat(layer, fname2, "utf-8", layer.crs(), ext)
            else:
                QgsVectorFileWriter.writeAsVectorFormat(layer, fname2, "shift-jis", layer.crs(), ext)
            if os.path.exists(fname2):
                QMessageBox.information(self, u'完了', u'「' + fname2 + u'」を作成しました。')
            else:
                QMessageBox.information(self, u'エラー', u'「' + fname2 + u'」を作成できませんでした。')

        # カレントPathを記録する
        reg_path = os.path.dirname(fname)
        ws.setValue("setting/reg_path", reg_path)

        # スタイルの設定
        if self.comboBox_2.currentText() != '':
            qmlfile = str(self.comboBox_2.currentText())
            if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
        # レイヤの領域にズームする
        self.zoom()
        if flag == 1:
            QMessageBox.information(self, u'空間参照系変更', u'プロジェクトのCRSを、EPSG:' + code2 + u' に変更しました。')
        # プロジェクトのCRSコンボボックスを更新
        self.set_Combo()
        # スケール取得
        QgsApplication.processEvents()
        self.pButton_49()
        QgsApplication.processEvents()
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
        # 保存形式がKMLならGoogle Earthを起動
        if ext == 'kml':
            if sys.platform == "win32":
                os.startfile(fname2)
            else:
                opener ="open" if sys.platform == "darwin" else "xdg-open"
                subprocess.run([opener, fname2])


    # 頂点（I/O）
    def pButton_71(self):
        filter = "CSV (*.csv)"
        savename, ext = QFileDialog.getSaveFileName(None, "CSVで保存", "chouten.csv", filter)
        if not savename:
            return
        layer = qgis.utils.iface.activeLayer()
        crs = layer.crs()                      # ソースファイルの座標参照系を取得
        EPSG = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得
        src_path = layer.dataProvider().dataSourceUri().split('|')[0]
        src_dir = os.path.dirname(src_path)
        filename = os.path.basename(src_path).split('.')[0]
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        outfile = workPath + '/chouten.geojson'
        bin_dir = self.lineEdit_bin.text()
        cmd = '"' + bin_dir + 'ogr2ogr.exe" -f geojson -s_srs EPSG:' + EPSG + ' -t_srs EPSG:' + EPSG + ' ' + outfile + ' ' + src_path
        result = subprocess.run(cmd, shell=True)
        if result.returncode != 0:
            QMessageBox.information(self, u'エラー',  u'テンポラリファイルの作成に失敗しました。（ogr2ogr）')
            return
        sleep(0.5)
        outfile2 = workPath + '/chouten2.geojson'
        command = "qgis_process run native:extractvertices --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --geometryCheck=QgsFeatureRequest.GeometryNoCheck --INPUT=" + outfile + " --OUTPUT=" + outfile2
        os.system(command)

        outfile3 = workPath + '/chouten3.geojson'
        with open(outfile2, "r") as f:
            data = json.load(f)
        for feature in data["features"]:
            feature["properties"] = {}
        with open(outfile3, "w") as f:
            json.dump(data, f, indent=2)

        fout = open(savename, 'w')
        fout.writelines(u'点番号,x,y,\n')
        fin = open(outfile3, 'r')
        flag = 0
        n = 0
        for line in fin:
            if 'coordinates' in line:
                flag = 1
            elif flag == 1:
                x = line.replace(' ', '').replace('\n', '')
                flag = 2
            elif flag == 2:
                n = n + 1
                y = line.replace(' ', '').replace(',', '').replace('\n', '')
                fout.writelines(str(n) + ',' + y + ',' + x + ',\n')
                flag = 0
        fin.close()
        fout.close()

        # ポイントレイヤの追加
        global Point_Layer_ID2
        try:
            QgsProject.instance().removeMapLayer(Point_Layer_ID2)
        except:
            pass
        uri = 'file:///' + (savename + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_3', 'field_2' + '&crs=epsg:' + EPSG))
        layer = QgsVectorLayer(uri, u'頂点', 'delimitedtext')
        Point_Layer_ID2 = layer.id()
        QgsProject.instance().addMapLayer(layer)
        if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_point3.qml'):
            layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_point3.qml')
        self.pButton_48()

        if len(savename) == 0:
            QMessageBox.information(self, 'エラー', u'頂点の作成に失敗しました。')

        if os.path.exists(outfile):
            os.remove(outfile)
        if os.path.exists(outfile2):
            os.remove(outfile2)
        if os.path.exists(outfile3):
            os.remove(outfile3)


    # 画像として保存（I/O）
    def pButton_52(self):
        self.scrollArea.move(250, 25)
        self.scrollArea.show()


    # 画像として保存を閉じる（I/O）
    def gazo_close(self):
        self.scrollArea.hide()


    # 透過色の選択（I/O）
    def pButton_haikei(self):
        color = QColorDialog.getColor(QColor(255, 255, 255), self)
        if color.isValid():
            cn = color.name()
            self.lineEdit_rh.setText(str(int(cn[1:3], 16)))
            self.lineEdit_gh.setText(str(int(cn[3:5], 16)))
            self.lineEdit_bh.setText(str(int(cn[-2:], 16)))


    # 線色の選択（I/O）変更前
    def pButton_line1(self):
        color = QColorDialog.getColor(QColor(0, 0, 0), self)
        if color.isValid():
            cn = color.name()
            self.lineEdit_rb.setText(str(int(cn[1:3], 16)))
            self.lineEdit_gb.setText(str(int(cn[3:5], 16)))
            self.lineEdit_bb.setText(str(int(cn[-2:], 16)))


    # 線色の選択（I/O）変更後
    def pButton_line2(self):
        color = QColorDialog.getColor(QColor(255, 0, 0), self)
        if color.isValid():
            cn = color.name()
            self.lineEdit_ra.setText(str(int(cn[1:3], 16)))
            self.lineEdit_ga.setText(str(int(cn[3:5], 16)))
            self.lineEdit_ba.setText(str(int(cn[-2:], 16)))


    # 画像として保存（I/O）
    def gazou0(self):
        if self.radioButton_g1.isChecked():
            x = QInputDialog().getInt(None, u"画像として保存", u"1 = 表示されているマップキャンバスの全域を保存する。<br>2 = PointCloud（.txt）も作成する。<br>3 = PointCloud（.txt）とLas（.laz）も作成する。", 1, 1, 3, 1)
            if str(x) == '(1, True)':
                self.gazou1()
            elif str(x) == '(2, True)':
                self.gazou1()
                self.convert()
            elif str(x) == '(3, True)':
                self.gazou1()
                self.convert2()
            else:
                return
        elif self.radioButton_g2.isChecked():
            x = QInputDialog().getInt(None, u"画像として保存", u"1 = 選択中のラスタレイヤをGeoTIFFで保存（表示されていない部分を含む。）<br>2 = PointCloud（.txt）も作成する。<br>3 = PointCloud（.txt）とLas（.laz）も作成する。", 1, 1, 3, 1)
            if str(x) == '(1, True)':
                self.gazou2()
            elif str(x) == '(2, True)':
                self.gazou2()
                self.convert()
            elif str(x) == '(3, True)':
                self.gazou2()
                self.convert2()
            else:
                return
        elif self.radioButton_g3.isChecked():
            self.convert()
        elif self.radioButton_g4.isChecked():
            self.convert2()


    # 画像として保存Ⅰ（I/O）
    def gazou1(self):
        # プロジェクトのCRSを取得する
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        # EPSGの指定があり、プロジェクトのEPSGと異なる場合、指定のCRSに変更する（ここで先に変更しないと保存したラスタがズレる）
        if self.lineEdit_8.text() != '' and self.lineEdit_8.text() != code:
            epsg = str(QgsCoordinateReferenceSystem(int(self.lineEdit_8.text())).authid())#指定のEPSGの判別（epsg=''ならカスタムCRS）
            if epsg != '':#指定のCRSがカスタムCRSでない場合
                new_crs = QgsCoordinateReferenceSystem(int(self.lineEdit_8.text()), QgsCoordinateReferenceSystem.EpsgCrsId)
            else:
                new_crs = QgsCoordinateReferenceSystem(int(self.lineEdit_8.text()), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
            map.refresh()
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        filter = 'PNG (*.png);;TIF (*.tif);;BMP (*.bmp);;JPG (*.jpg);;GIF (*.gif);;PDF (*.pdf);;*.* (*.*)'
        savename = dialog.getSaveFileName(self, u'画像として保存Ⅰ', '', filter)
        if not savename or str(savename) == "('', '')":
            # 元のCRSに戻す
            if epsgcode != '':#元のCRSがカスタムCRSでない場合
                new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.EpsgCrsId)
            else:
                new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
            return
        # カレントPathを記録する
        reg_path = os.path.dirname(str(savename)).replace('(' + "'", '')
        ws.setValue("setting/reg_path", reg_path)
        fpath = str(savename).split("'")
        savename = fpath[1]
        dirpath = os.path.dirname(savename)
        filename = os.path.basename(savename)
        fn, ext = os.path.splitext(filename)
        ext = ext.lower()
        self.label_file.setText(savename)
        # 画像として保存
        map.saveAsImage(savename);
        # レイヤ追加
        self.lineEdit_path.setText(str(savename))
        self.lineEdit_path_wf.setText(str(savename))
        fileInfo = QFileInfo(str(savename))
        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')
        layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
        QgsProject.instance().addMapLayer(layer)
        # 画像情報を取得
        self.size_h.setText('')
        self.size_w.setText('')
        
        self.gazo_open2()
        # ワールドファイルを読み込む
        ext_wf = ext[0:2] + ext[-1:] + 'w' #pgw,tfw,jgw...
        global wf_path
        wf_path = str(dirpath) + u'/' + fn + ext_wf
        self.readWorldFile()
        print(str(self.wk1.text()))
        print(str(self.wk2.text()))
        print(str(self.wk3.text()))
        print(str(self.wk4.text()))
        # 指定のEPSGが4326なら、KMLを作成してGoogleEarthで開く
        if self.lineEdit_8.text() == '4326':
            savename2 = dirpath + '/' +  fn + '.kml'
            try:
                bb = float(self.wk4.text()) + float(self.size_h.text()) * float(self.wk2.text())
                ll = float(self.wk3.text()) + float(self.size_w.text()) * float(self.wk1.text())
                self.wk1.setText(str(ll))
                self.wk2.setText(str(bb))
                dat = '<?xml version=' + '"' + '1.0' + '"' +' encoding=' + '"' + 'UTF-8' + '"' + '?>' + '\n'
                dat = dat + '<kml xmlns=' + '"' + 'http://www.opengis.net/kml/2.2' + '"' + '>' + '\n'
                dat = dat + '    <Document>' + '\n'
                dat = dat + '        <GroundOverlay>' + '\n'
                dat = dat + '            <name></name>' + '\n'
                dat = dat + '            <description></description>' + '\n'
                dat = dat + '            <Icon><href>' + filename + '</href></Icon>' + '\n'
                dat = dat + '            <LatLonBox>' + '\n'
                dat = dat + '                <south>' + str(self.wk2.text()) + '</south>' + '\n'
                dat = dat + '                <west>' + str(float(self.wk3.text())) + '</west>' + '\n'
                dat = dat + '                <north>' + str(float(self.wk4.text())) + '</north>' + '\n'
                dat = dat + '                <east>' + str(self.wk1.text()) + '</east>' + '\n'
                dat = dat + '            </LatLonBox>' + '\n'
                dat = dat + '        </GroundOverlay>' + '\n'
                dat = dat + '    </Document>' + '\n'
                dat = dat + '</kml>' + '\n'
                fout = codecs.open(savename2, 'w', 'utf-8')
                fout.write(dat)
                fout.close()
                f = codecs.open(savename2, 'r', 'utf-8')
                txt = f.read()
                txt = txt.replace('\n', '\r\n')
                f = codecs.open(savename2, 'w', 'utf-8')
                f.write(txt)
                f.close()
                QMessageBox.information(self, u'画像として保存', u'「' + unicode(savename) + u'」\nワールドファイル（' + wf_path + u'）を作成しました。')
                # Google Earth を起動する
                if sys.platform == "win32":
                    os.startfile(savename2)
                else:
                    opener ="open" if sys.platform == "darwin" else "xdg-open"
                    subprocess.run([opener, savename2])
            except:
                QMessageBox.information(self, u'エラー', u'不正なデータです。処理を中止します。')
        else:
            if ext == '.pdf':
                os.remove(dirpath + '/' + fn + '.pfw')
                QMessageBox.information(self, u'画像として保存Ⅰ', u'「' + unicode(savename) + u'」を作成しました。')
            else:
                QMessageBox.information(self, u'画像として保存Ⅰ', u'「' + unicode(savename) + u'」と\nワールドファイル（' + wf_path + u'）を作成しました。')
        # 元のCRSに戻す
        if epsgcode != '':#元のCRSがカスタムCRSでない場合
            new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.EpsgCrsId)
        else:
            new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.InternalCrsId)
        QgsProject.instance().setCrs(new_crs)
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # 画像読込
    def gazo_open(self):
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        # 読込ダイアログ表示
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        filter = '*.* (*.*)'
        gazo_file = dialog.getOpenFileName(self, u'画像ファイル', '', filter)
        if not gazo_file or str(gazo_file) == "('', '')":
            return
        reg_path = os.path.dirname(str(gazo_file)).replace('(' + "'", '')
        ws.setValue("setting/reg_path", reg_path)
        fn = str(gazo_file).split("'")
        fname = fn[1]
        dirpath = os.path.dirname(fname)
        filename = os.path.basename(fname)
        fn, ext = os.path.splitext(filename)
        ext = ext.lower().replace('.', '')
        self.label_file.setText(fname)
        self.gazo_open2()


    # 画像読込2
    def gazo_open2(self):
        fname = self.label_file.text()
        img = Image.open(fname)
        size = img.size
        self.label_x_2.setText(str(size[0]))
        self.label_y_2.setText(str(size[1]))
        self.lineEdit_x_2.setText(str(size[0]))
        self.lineEdit_y_2.setText(str(size[1]))
        # ワールドファイルがある場合は、実寸と左下座標を計算する
        # 元データにワールドファイルがある場合は、縦横の実寸・左下座標を計算する
        dirpath = os.path.dirname(fname)
        filename = os.path.basename(fname)
        fn, ext = os.path.splitext(filename)
        wf1 = dirpath + '/' + fn + '.wld'                    #wld
        wf2 = dirpath + '/' + fn + ext + 'w'                 #pngw,tifw,jpgw...
        wf3 = dirpath + '/' + fn + ext[0:2] + ext[-1:] + 'w' #pgw,tfw,jgw...
        w = 0
        if os.path.exists(wf1):
            w = 1
        if os.path.exists(wf2):
            w = 2
        if os.path.exists(wf3):
            w = 3
        # ワールドファイルが複数あった場合、QGISの優先順位に会わせる
        # wf1(pgw,tfw,jgw...)→wf2(pngw,tifw,jpgw...)→wf3(wld)
        if w != 0:
            if w == 1:
                world_file = wf1
            if w == 2 :
                world_file = wf2
            if w == 3:
                world_file = wf3
            n = 1
            with open(world_file) as f:
                for line in f:
                    if n == 1:
                        xd = float(line)
                    if n == 4:
                        yd = float(line)
                    if n == 5:
                        yt = float(line)
                    if n == 6:
                        xt = float(line)
                    n = n + 1
            xx = xd * size[0]
            yy = yd * size[1]
            xb = xt + yy
            yc = yt + (xx / 2)
            xc = xt + (yy / 2)
            scale = xx / 150
            self.lineEdit_x_2.setText(str(xx))
            self.lineEdit_y_2.setText(str(abs(yy)))
            self.lineEdit_dx.setText(str(xb))
            self.lineEdit_dy.setText(str(yt))
            clipboard = QgsApplication.clipboard()
            clipboard.setText(u'横のピクセル数=' + str(size[0]) + '\n' + u'縦のピクセル数=' + str(size[1]) + '\n' + u'横の実寸=' + str(xx) + '\n' + u'縦の実寸=' + str(abs(yy)) + '\n' + u'横の左下座標＝' + str(yt) +  '\n'+ u'縦の左下座標＝' + str(xb) + '\n' + u'横の中心座標＝' + str(yc) +  '\n'+ u'縦の中心座標＝' + str(xc) +  '\n'+ u'地理院VRMLを実寸にするためのスケール＝' + str(scale))
        else:
            # gdalinfoによる画像情報取得...GeoTIFFの場合
            if ext.lower().replace('.', '') == 'tif' or ext.lower().replace('.', '') == 'tiff':
                workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
                cmd = 'gdalinfo '+ fname + ' >' + workPath + u'/result.txt'
                result = subprocess.run(cmd, shell=True)
                if result.returncode != 0:
                    QMessageBox.information(self, u'gdalinfo', u'画像情報取得に失敗しました。（gdalinfo）')
                sleep(0.5)
                fname = workPath + u'/result.txt'
                for line in codecs.open(fname, 'r','shift-jis'):
                    if line[:7] == 'Driver:':
                        dv = line.replace('Driver:', '').replace(' ', '')
                        if dv == 'GTiff/GeoTIFF':
                            if os.path.exists(fname):     # result.txt
                                os.remove(fname)
                            return
                    if line[:13] == 'Lower Left  (':
                        xy = line.replace('Lower Left  (', '')
                        xy = xy.replace(' ', '')
                        xy = xy.split(')')
                        xy = xy[0].split(',')
                        x1 = xy[1]
                        y1= xy[0]
                    if line[:13] == 'Upper Right (':
                        xy = line.replace('Upper Right (', '')
                        xy = xy.replace(' ', '')
                        xy = xy.split(')')
                        xy = xy[0].split(',')
                        x2 = xy[1]
                        y2 = xy[0]
                yy = abs(float(x1) - float(x2))
                xx = abs(float(y1) - float(y2))
                self.lineEdit_x_2.setText(str(xx))
                self.lineEdit_y_2.setText(str(abs(yy)))
                self.lineEdit_dx.setText(str(x1))
                self.lineEdit_dy.setText(str(y1))
                if os.path.exists(fname):     # result.txt
                    os.remove(fname)
        QMessageBox.information(self, u'画像情報', u'画像情報をクリップボードに転送しました。')

    # PointCloud 変換
    def convert(self):
        gazo_file = self.label_file.text()
        if gazo_file == '':
            return
        if self.label_x_2.text() == '':
            return
        if self.label_y_2.text() == '':
            return
        if self.lineEdit_x_2.text() == '':
            self.lineEdit_x_2.setText('0')
        if self.lineEdit_y_2.text() == '':
            self.lineEdit_y_2.setText('0')
        if self.lineEdit_z.text() == '':
            self.lineEdit_z.setText('0')
        dirpath = os.path.dirname(gazo_file)
        filename = os.path.basename(gazo_file)
        fn, ext = os.path.splitext(filename)
        PointCloud_name = dirpath + '/' + fn + '.txt'
        img = Image.open(gazo_file)
        rgb_img = img.convert('RGB')
        size = rgb_img.size
        txt = ''
        xm = float(self.lineEdit_x_2.text())
        ym = float(self.lineEdit_y_2.text())
        dx = float(self.lineEdit_dx.text())
        dy = float(self.lineEdit_dy.text())
        rh = self.lineEdit_rh.text()
        gh = self.lineEdit_gh.text()
        bh = self.lineEdit_bh.text()
        rb = self.lineEdit_rb.text()
        gb = self.lineEdit_gb.text()
        bb = self.lineEdit_bb.text()
        ra = self.lineEdit_ra.text()
        ga = self.lineEdit_ga.text()
        ba = self.lineEdit_ba.text()

        z = self.lineEdit_z.text()
        if os.path.exists(PointCloud_name):
            os.remove(PointCloud_name)
        f = open(PointCloud_name, 'a')
        for x in range(size[0]):
            for y in range(size[1]):
                r,g,b = rgb_img.getpixel((x,y))
                y = int(size[1]) - y
                xn = x / (float(self.label_x_2.text()) /xm) + dy
                yn = y / (float(self.label_y_2.text()) /ym) + dx
                if self.checkBox1.isChecked():
                    if rh != str(r) and gh != str(g) and bh != str(b):
                        if self.checkBox2.isChecked():
                            if rb == str(r) and gb == str(g) and bb == str(b):
                                txt = str(xn) + ',' + str(yn) + ',' + z + ',' + ra + ',' + ga + ',' + ba
                            else:
                                txt = str(xn) + ',' + str(yn) + ',' + z + ',' + str(r) + ',' + str(g) + ',' + str(b)
                        else:
                            txt = str(xn) + ',' + str(yn) + ',' + z + ',' + str(r) + ',' + str(g) + ',' + str(b)
                else:
                    if self.checkBox2.isChecked():
                        if rb == str(r) and gb == str(g) and bb == str(b):
                            txt = str(xn) + ',' + str(yn) + ',' + z + ',' + str(r) + ',' + str(g) + ',' + str(b)
                        else:
                            txt = str(xn) + ',' + str(yn) + ',' + z + ',' + ra + ',' + ga + ',' + ba
                    else:
                        txt = str(xn) + ',' + str(yn) + ',' + z + ',' + str(r) + ',' + str(g) + ',' + str(b)
                print(txt, file = f)
        f.close()
        QMessageBox.information(self, u'完了', PointCloud_name + u'を作成しました。')


    # Las 変換
    def convert2(self):
        self.convert()
        gazo_file = self.label_file.text()
        dirpath = os.path.dirname(gazo_file)
        filename = os.path.basename(gazo_file)
        fn, ext = os.path.splitext(filename)
        PointCloud_name = dirpath + '/' + fn + '.txt'
        if not os.path.exists(PointCloud_name):
            return
        Las_name = dirpath + '/' + fn + '.laz'
        bat_name = dirpath + '/las.bat'
        cmd = self.label_txt2las.text() + "/txt2las.exe -parse xyzRGB -i " + PointCloud_name + " -o " + Las_name
        f = open(bat_name, 'w')
        f.write(cmd)
        f.close()
        result = subprocess.run(bat_name, shell=True)
        if os.path.exists(bat_name):
            os.remove(bat_name)
        QMessageBox.information(self, u'完了', Las_name + u'を作成しました。')

    # txt2las.exe フォルダ選択
    def LasDir(self):
        # 読込ダイアログ表示
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        filter = 'txt2las.exe (txt2las.exe)'
        txt2las_dir = dialog.getOpenFileName(self, u'txt2las.exeを選択してください。', '', filter)
        if not txt2las_dir or str(txt2las_dir) == "('', '')":
            return
        fn = str(txt2las_dir).split("'")
        fname = fn[1]
        dirpath = os.path.dirname(fname)
        self.label_txt2las.setText(dirpath)
        ws.setValue("setting/txt2las_path", dirpath)


    # 画像として保存Ⅱ（I/O）
    def gazou2(self):
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        # 保存ダイアログ表示
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        fname = dialog.getSaveFileName(self, u'画像として保存Ⅱ', '', 'GeoTIFF(*.tif)')
        file_name = os.path.basename(str(fname))
        if not fname or str(fname) == "('', '')":
            return
        fn = str(fname).split("'")
        fname = fn[1]
        self.label_file.setText(fname)
        # カレントPathを記録する
        reg_path = os.path.dirname(fname)
        ws.setValue("setting/reg_path", reg_path)
        # アクティブレイヤの領域を保存する
        try:
            layer = qgis.utils.iface.activeLayer()
            provider = layer.dataProvider()
            crs = provider.crs()
            pipe = QgsRasterPipe()
            pipe.set(provider.clone())
            rasterWriter = QgsRasterFileWriter(fname)
            xSize = provider.xSize()
            ySize = provider.ySize()
            ext = provider.extent()
            rasterWriter.writeRaster(pipe, xSize, ySize, ext, crs)
            sleep(0.5)
            # レイヤ追加
            self.lineEdit_path.setText(fname)
            self.lineEdit_path_wf.setText(fname)
            fileInfo = QFileInfo(fname)
            # プロジェクトのCRSを使用するモード
            settings.setValue('/Projections/defaultBehavior', 'useProject')
            layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
            QgsProject.instance().addMapLayer(layer)
            QgsApplication.processEvents()
            if os.path.exists(fname):
                QMessageBox.information(self, u'画像として保存Ⅱ', u'GeoTIFF 「' + fname + u'」 を作成しました。')
            else:
                QMessageBox.information(self, u'エラー', u'対応していないレイヤです。処理を中止します。')
        except:
            QMessageBox.information(self, u'エラー', u'対応していないレイヤです。処理を中止します。')
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
        self.gazo_open2()


    # EPSGコード(I/O、GDAL/OGR、Georeference、座標変換)
    def pButton_41(self):
        dat = u'【投影座標系 (平面直角座標系)】     【地理座標系 (緯度・経度)】\n'
        dat = dat + u' 座標系 世界測地系 日本測地系      世界測地系 (JGD2000)         4612\n'
        dat = dat + u'   1系       2443        30161                   日本測地系 (Tokyo)              4301\n'
        dat = dat + u'   2系       2444        30162                   世界測地系1984 (WGS84)    4326\n'
        dat = dat + u'   3系       2445        30163\n'
        dat = dat + u'   4系       2446        30164       【投影座標系 (UTM座標系)】\n'
        dat = dat + u'   5系       2447        30165         ZONE 世界測地系 日本測地系 WGS84  \n'
        dat = dat + u'   6系       2448        30166         51N       3097        3092       32651\n'
        dat = dat + u'   7系       2449        30167         52N       3098        3093       32652\n'
        dat = dat + u'   8系       2450        30168         53N       3099        3094       32653\n'
        dat = dat + u'   9系       2451        30169         54N       3100        3095       32654\n'
        dat = dat + u'  10系      2452        30170         55N       3101        3096       32655\n'
        dat = dat + u'  11系      2453        30171\n'
        dat = dat + u'  12系      2454        30172\n'
        dat = dat + u'  13系      2455        30173\n'
        dat = dat + u'  14系      2456        30174\n'
        dat = dat + u'  15系      2457        30175\n'
        dat = dat + u'  16系      2458        30176\n'
        dat = dat + u'  17系      2459        30177\n'
        dat = dat + u'  18系      2460        30178\n'
        dat = dat + u'  19系      2461        30179'
        QMessageBox.information(self, u'EPSGコード', dat)


    # ラスターレイヤ追加時にWorldFileを読み込む（I/O、WorldFile）＊
    def readWorldFile(self):
        self.wk1.setText('')
        self.wk2.setText('')
        self.wk3.setText('')
        self.wk4.setText('')
        k = 1
        try:
            for line in codecs.open(wf_path, 'r','shift-jis'):
                if k == 1:
                  self.wk1.setText(line)
                if k == 4:
                  self.wk2.setText(line)
                if k == 5:
                  self.wk3.setText(line)
                if k == 6:
                  self.wk4.setText(line)
                k = k + 1
        except:
            pass


    # タイル地図リスト（I/O）
    def SetTile(self):
        self.haikei2.setCurrentIndex(self.haikei.currentIndex())
        dat = self.haikei2.currentText().split(',')
        self.title.clear()
        self.title.setText(dat[9])


    # タイル地図をレイヤに追加（I/O）
    def addTileLayer(self):
        # 現在の縮尺を取得
        scale = int(self.lineEdit_scale.text())
        # 変換先のEPSGを取得
        crs = self.comboBox_3.currentText().split(u',')
        epsg = int(crs[1])
        # タイル地図情報取得
        dat = self.haikei2.currentText().split(u',')
        title = dat[0]
        #fmt = dat[1]
        #src = dat[2]
        zl = dat[3]
        z = zl.split('to')
        zmin = z[0].replace('z', '')
        zmax = z[1]
        url = dat[4].replace('"', '')
        minx = dat[5]
        miny = dat[6]
        maxx = dat[7]
        maxy = dat[8]
        x = self.xx.text()
        y = self.yy.text()
        # タイル地図を読み込む
        uri = 'url=' + url + '&zmax=' + zmax + '&zmin=' + zmin + '&type=xyz'
        layer = QgsRasterLayer(uri, title, 'wms')
        if not layer.isValid():
            QMessageBox.information(self, u'エラー', u'読み込みに失敗しました。')
            return
        else:
            QgsProject.instance().addMapLayer(layer)
            QgsApplication.processEvents()
            rect = QgsRectangle(float(miny), float(minx), float(maxy), float(maxx))
            map.setExtent(rect)
            # 指定のEPSGに変更
            self.pButton_47()
            # 領域の座標をEPSG:3857から指定のEPSGに変更
            crsSrc = QgsCoordinateReferenceSystem(3857)
            custom = str(QgsCoordinateReferenceSystem(epsg).authid())
            if custom == '':# 変換先がカスタムCRSの場合
                Dest_crs = QgsCoordinateReferenceSystem()
                Dest_crs.createFromId(epsg, QgsCoordinateReferenceSystem.InternalCrsId)
                crsDest = QgsCoordinateReferenceSystem(Dest_crs)
            else:
                crsDest = QgsCoordinateReferenceSystem(epsg)
            trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
            miny,minx = trans.transform(float(miny), float(minx))
            maxy,maxx = trans.transform(float(maxy), float(maxx))
            rect = QgsRectangle(float(miny), float(minx), float(maxy), float(maxx))
            map.setExtent(rect)
        # 中心座標の指定がある場合
        if self.xx.text() != '' and self.yy.text() != '':
            rect = QgsRectangle(float(y), float(x), float(y), float(x))
            map.setExtent(rect)
            map.zoomScale(scale)
        if self.check_rendo.isChecked():
            self.jump()
        # 現在の縮尺を取得する
        QgsApplication.processEvents()
        self.pButton_49()
        QgsApplication.processEvents()


    def SetCenter(self):#マップキャンバスの中心座標を取得（I/O）
        if self.tabWidget.currentIndex() == 1:
            # 現在の縮尺を取得
            QgsApplication.processEvents()
            self.pButton_49()
            QgsApplication.processEvents()
            if self.check_scale.isChecked():
                # 変換先のEPSGを取得
                crs = self.comboBox_3.currentText().split(u',')
                epsg = int(crs[1])
                # マップキャンバスの中心座標を取得
                mPos = map.center()
                # プロジェクトのEPSGを取得
                epsgGet()
                if epsgcode != '':
                    crsSrc = QgsCoordinateReferenceSystem(int(epsgcode))
                else:
                    Src_crs = QgsCoordinateReferenceSystem()
                    Src_crs.createFromId(int(usercode), QgsCoordinateReferenceSystem.InternalCrsId)
                    crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                # マップキャンバスの中心座標を指定のEPSGに変更
                custom = str(QgsCoordinateReferenceSystem(epsg).authid())
                if custom == '':# 変換先がカスタムCRSの場合
                    Dest_crs = QgsCoordinateReferenceSystem()
                    Dest_crs.createFromId(epsg, QgsCoordinateReferenceSystem.InternalCrsId)
                    crsDest = QgsCoordinateReferenceSystem(Dest_crs)
                else:
                    crsDest = QgsCoordinateReferenceSystem(epsg)
                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                yc,xc = trans.transform(mPos.x(), mPos.y())
                self.xx.setText(str(xc))
                self.yy.setText(str(yc))
            else:
                self.xx.clear()
                self.yy.clear()
            QgsApplication.processEvents()


    # 移動（I/O）
    def jump(self):
        # 現在の縮尺を取得
        scale = int(round(map.scale(), 0))
        # タイル地図情報取得
        self.pref2.setCurrentIndex(self.pref.currentIndex())
        dat = self.pref2.currentText().split(u',')
        pref = dat[0]
        x = dat[1]
        y = dat[2]
        kei = int(dat[3])
        scale = int(dat[4])
        # 変換先のEPSGを取得
        if self.changeCRS.isChecked():
            epsg = 2442 + kei
            i = 0
            for count in range(self.comboBox_3.count()):
                if count > 0:
                  dat = self.comboBox_3.itemText(count).split(',')
                  if dat[1] == str(epsg):
                      i = count
            self.comboBox_3.setCurrentIndex(i)
            if i == 0:
                self.comboBox_3.setCurrentText(epsg)
        else:
            crs = self.comboBox_3.currentText().split(u',')
            epsg = int(crs[1])
        # 指定のEPSGに変更
        self.pButton_47()
        # 中心の座標をEPSG:4326から指定のEPSGに変更
        crsSrc = QgsCoordinateReferenceSystem(4326)
        custom = str(QgsCoordinateReferenceSystem(epsg).authid())
        if custom == '':# 変換先がカスタムCRSの場合
            Dest_crs = QgsCoordinateReferenceSystem()
            Dest_crs.createFromId(epsg, QgsCoordinateReferenceSystem.InternalCrsId)
            crsDest = QgsCoordinateReferenceSystem(Dest_crs)
        else:
            crsDest = QgsCoordinateReferenceSystem(epsg)
        trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
        yc,xc = trans.transform(float(y), float(x))
        rect = QgsRectangle(float(yc), float(xc), float(yc), float(xc))
        map.setExtent(rect)
        if self.changeScale.isChecked():
            map.zoomScale(scale)
        QgsApplication.processEvents()


# ----------GDAL/OGR----------------------------------------------------------------------------------------------------------------
    # Formatのリスト設定(GDAL/OGR)
    def setFormat(self):
        # プロジェクトのEPSGを取得する
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        self.comboBox_format2.clear()
        if self.radioButton_raster.isChecked():
            self.comboBox_format2.addItem(u'tif')
            self.comboBox_format2.addItem(u'png')
            self.comboBox_format2.addItem(u'bmp')
            self.comboBox_format2.addItem(u'jpg')
            self.comboBox_format2.addItem(u'pdf')
            self.comboBox_format2.setCurrentText('tif')
            self.pushButton_55.setEnabled(True)
            self.pushButton_58.setEnabled(False)
            self.lineEdit_srsEPSG.setText(code)
            self.lineEdit_dstEPSG.setText(code)
            self.lineEdit_srsEPSG.setEnabled(True)
            self.lineEdit_dstEPSG.setEnabled(True)
            self.lineEdit_srsEPSG.setFocus()
        if self.radioButton_vector.isChecked():
            self.comboBox_format2.addItem(u'kml')
            self.comboBox_format2.addItem(u'dxf')
            self.comboBox_format2.addItem(u'geojson')
            self.comboBox_format2.addItem(u'fgb')
            self.comboBox_format2.addItem(u'shp')
            self.comboBox_format2.addItem(u'pdf')
            self.comboBox_format2.setCurrentText('kml')
            self.pushButton_55.setEnabled(True)
            self.pushButton_58.setEnabled(False)
            self.lineEdit_srsEPSG.setText(code)
            self.lineEdit_dstEPSG.setText('4326')
            self.lineEdit_srsEPSG.setEnabled(True)
            self.lineEdit_dstEPSG.setEnabled(True)
            self.lineEdit_srsEPSG.setFocus()
        if self.radioButton_rasvec.isChecked():
            self.comboBox_format2.addItem(u'dxf')
            self.comboBox_format2.addItem(u'kml')
            self.comboBox_format2.addItem(u'geojson')
            self.comboBox_format2.addItem(u'fgb')
            self.comboBox_format2.addItem(u'shp')
            self.comboBox_format2.addItem(u'pdf')
            self.comboBox_format2.setCurrentText('dxf')
            self.pushButton_55.setEnabled(False)
            self.pushButton_58.setEnabled(True)
            self.lineEdit_srsEPSG.setText(code)
            self.lineEdit_dstEPSG.setText('')
            self.lineEdit_srsEPSG.setEnabled(True)
            self.lineEdit_dstEPSG.setEnabled(False)
            self.comboBox_format2.setFocus()
        self.comboBox_format2.setCurrentIndex(0)


    # KML・PDFのをEPSGを4326にセット(GDAL/OGR)
    def set4326B(self):
        if self.comboBox_format2.currentText().lower() == 'kml':
            if self.radioButton_vector.isChecked():
                self.lineEdit_dstEPSG.setText('4326')


    # gdalinfoによる画像情報取得（GDAL/OGR）
    def pButton_54(self):
        savename = ''
        savename2 = ''
        fname = ''
        fname2 = ''
        wf4 = ''
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        infile0 = dialog.getOpenFileName(self, u'画像情報取得', '', u'*.*(*.*)')
        if not infile0 or str(infile0) == "('', '')":
            return
        fp = str(infile0).split("'")
        infile0 = fp[1]
        dirpath = os.path.dirname(infile0)
        filename = os.path.basename(infile0)
        fn, ext = os.path.splitext(filename)
        ws.setValue("setting/reg_path", dirpath)
        imagefile = workPath + u'/temp' + ext
        shutil.copy(infile0, imagefile)
        sleep(0.5)
        os.chmod(imagefile, 0o777)

        #元データにワールドファイルがある場合は、変換後のファイル用に作成する
        wf1 = dirpath + '/' + fn + ext[0:2] + ext[-1:] + 'w' #pgw,tfw,jgw...
        wf2 = dirpath + '/' + fn + ext + 'w'                 #pngw,tifw,jpgw...
        wf3 = dirpath + '/' + fn + '.wld'                    #wld
        wf4 = ''
        n = 0
        if os.path.exists(wf1):
            n = 1
        if os.path.exists(wf2):
            n = n + 2
        if os.path.exists(wf3):
            n = n + 4
        #0=なし、1=wf1、2=wf2、3=wf1 & wf2、4=wf3、5=wf1 & wf3、6=wf2 & wf3、7=wf1 & wf2 & wf3
        #ワールドファイルが複数あった場合の処理
        #QGISの優先順位：wf1(pgw,tfw,jgw...)－wf2(pngw,tifw,jpgw...)－wf3(wld)
        if n != 0:
            wf4 = workPath + u'/temp' + ext + 'w'
            if n == 1 or n == 3 or n == 5 or n == 7:
                shutil.copy(wf1, wf4)
            if n == 2 or n == 6:
                shutil.copy(wf2, wf4)
            if n == 4:
                shutil.copy(wf3, wf4)
            sleep(0.5)
            os.chmod(wf4, 0o777)
        # コマンド作成
        cmd = 'gdalinfo '+ imagefile + ' >' + workPath + u'/result.txt'
        result = subprocess.run(cmd, shell=True)
        if result.returncode != 0:
            QMessageBox.information(self, u'gdalinfo', u'画像情報取得に失敗しました。（gdalinfo）')
            # 作業ファイル削除
            if os.path.exists(fname):     # result.txt
                os.remove(fname)
            if os.path.exists(savename2): # WorldFile
                os.remove(savename2)
            if os.path.exists(fname2):    # kml
                os.remove(fname2)
            if os.path.exists(imagefile): # imagefile
                os.remove(imagefile)
            if os.path.exists(wf4):       # WorldFile
               os.remove(wf4)
            return
        sleep(0.5)
        fname = workPath + u'/result.txt'
        # 情報ファイルを開く
        if os.path.exists(fname):
            dat2 = ''
            for line in codecs.open(fname,'r','shift-jis'):
                dat = line.replace(u'\r\n', '')
                dat = dat.replace(imagefile, infile0)
                if n == 1 or n == 3 or n == 5 or n == 7:
                    dat = dat.replace(wf4, wf1)
                if n == 2 or n == 6:
                    dat = dat.replace(wf4, wf2)
                if n == 4:
                    dat = dat.replace(wf4, wf3)
                dat2 = dat2 + '\n' + dat
            clipboard = QgsApplication.clipboard()
            clipboard.setText(dat2)
        epsg = ''
        for line in codecs.open(fname, 'r','shift-jis'):
            if line[:8] == 'Size is ':
                size = line.replace('Size is ', '').split(',')
                yoko = size[0]
                tate = size[1].replace(' ', '')
            if line[:14] == '    AUTHORITY[':
                crs = line.split('"')
                epsg = crs[3]
            if line[:13] == 'Upper Left  (':
                xy = line.replace('Upper Left  (', '')
                xy = xy.replace(' ', '')
                xy = xy.split(')')
                xy = xy[0].split(',')
                xt = xy[1]
                yl = xy[0]
            if line[:13] == 'Lower Right (':
                xy = line.replace('Lower Right (', '')
                xy = xy.replace(' ', '')
                xy = xy.split(')')
                xy = xy[0].split(',')
                xb = xy[1]
                yr = xy[0]
            if line[:10] == 'Origin = (':
                xy = line.replace('Origin = (', '')
                xy = xy.replace(')', '')
                xy = xy.split(',')
                xx = xy[1]
                yy = xy[0]
            if line[:14] == 'Pixel Size = (':
                px = line.replace('Pixel Size = (', '')
                px = px.replace(')', '')
                px = px.split(',')
                px1 = px[0]
                px2 = px[1]
        if epsg != '':#GeoTIFFの場合
            # WorldFile作成
            savename2 = workPath + u'/' + filename + u'w'
            fout = open(savename2, 'w')
            fout.write(px1 + '\n')
            fout.write('0' + '\n')
            fout.write('0' + '\n')
            fout.write(px2)
            fout.write(yy + '\n')
            fout.write(xx)
            fout.close()
            if epsg == '4326' or epsg == '4612':#CRSが緯度・経度系の場合は、KMLも作成する
                fname2 = workPath + u'/' + fn + u'.kml'
                dat = '<?xml version=' + '"' + '1.0' + '"' +' encoding=' + '"' + 'UTF-8' + '"' + '?>' + '\n'
                dat = dat + '<kml xmlns=' + '"' + 'http://www.opengis.net/kml/2.2' + '"' + '>' + '\n'
                dat = dat + '    <Document>' + '\n'
                dat = dat + '        <GroundOverlay>' + '\n'
                dat = dat + '            <name></name>' + '\n'
                dat = dat + '            <description></description>' + '\n'
                dat = dat + '            <Icon><href>' + filename + '</href></Icon>' + '\n'
                dat = dat + '            <LatLonBox>' + '\n'
                dat = dat + '                <south>' + xb + '</south>' + '\n'
                dat = dat + '                <west>' + yl + '</west>' + '\n'
                dat = dat + '                <north>' + xt + '</north>' + '\n'
                dat = dat + '                <east>' + yr + '</east>' + '\n'
                dat = dat + '            </LatLonBox>' + '\n'
                dat = dat + '        </GroundOverlay>' + '\n'
                dat = dat + '    </Document>' + '\n'
                dat = dat + '</kml>' + '\n'
                fout = codecs.open(fname2, 'w', 'utf-8')
                fout.write(dat)
                fout.close()
                f = codecs.open(fname2, 'r', 'utf-8')
                txt = f.read()
                txt = txt.replace('\n', '\r\n')
                f = codecs.open(fname2, 'w', 'utf-8')
                f.write(txt)
                f.close()
                mf = QMessageBox.question(self,u'gdalinfo', u'クリップボードに画像情報を転送しました。\n\nワールドファイルとKMLファイルを作成できます。\n実行しますか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
                if mf == QMessageBox.Yes:
                    shutil.copy(savename2, dirpath + u'/' + filename + u'w')
                    shutil.copy(fname2, dirpath + u'/' + fn + u'.kml')
                    QMessageBox.information(self, u'完了', u'「' + dirpath + u'/' + filename + u'w」と\n「' + dirpath + u'/' + fn + u'.kml' + u'」\nを作成しました。')
            else:
                mf = QMessageBox.question(self,u'gdalinfo', u'クリップボードに画像情報を転送しました。\n\nワールドファイルを作成できます。\n実行しますか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
                if mf == QMessageBox.Yes:
                    shutil.copy(savename2, dirpath + u'/' + filename + u'w')
                    QMessageBox.information(self, u'完了', u'「' + dirpath + u'/' + filename + u'w」\nを作成しました。')
        else:
            QMessageBox.information(self, u'gdalinfo', 'クリップボードに画像情報を転送しました。')
        # 作業ファイル削除
        if os.path.exists(fname):     # result.txt
            os.remove(fname)
        if os.path.exists(savename2): # WorldFile
            os.remove(savename2)
        if os.path.exists(fname2):    # kml
            os.remove(fname2)
        if os.path.exists(imagefile): # imagefile
            os.remove(imagefile)
        if os.path.exists(wf4):       # WorldFile
           os.remove(wf4)


    # [gdalwarp/gdal_translateによるラスタの投影＆フォーマット変換] ＆ [gdalwarp/ogr2ogrによるベクタの投影＆フォーマット変換] (GDAL/OGR)
    def pButton_55(self):
        if self.lineEdit_srsEPSG.text() == '':
            return
        if self.comboBox_format2.currentText() == '':
            return
        if self.lineEdit_dstEPSG.text() == '':
            return
        epsg1 = self.lineEdit_srsEPSG.text()
        epsg2 = self.lineEdit_dstEPSG.text()
        infile = ''
        outfile = ''
        wf4 = ''
        ext2 = self.comboBox_format2.currentText()
        # プロジェクトのCRSを取得する
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        code2 = code

        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))

        # gdalwarpによる投影変換＆gdal_translateによるフォーマット変換（ラスタ）
        if self.radioButton_raster.isChecked():
            filter = '*.* (*.*);;PNG (*.png);;TIF (*.tif);;BMP (*.bmp);;JPG (*.jpg);;GIF (*.gif);;PDF (*.pdf)'
            infile0 = dialog.getOpenFileName(self, u'ラスタファイルの読込', '', filter)
            infile = ''
            outfile = ''
            outfile3 = ''
            if not infile0 or str(infile0) == "('', '')":
                return
            fp = str(infile0).split("'")
            infile0 = fp[1]
            dirpath = os.path.dirname(infile0)
            filename = os.path.basename(infile0)
            fn, ext = os.path.splitext(filename)
            ws.setValue("setting/reg_path", dirpath)
            # ファイル名の日本語対策（一旦、作業ディレクトリに名前を変えてコピー）
            infile = workPath + u'/temp' + ext
            shutil.copy(infile0, infile)
            sleep(0.5)
            os.chmod(infile, 0o777)
            os.chdir(dirpath)
            outfile = workPath + u'/temp.' + ext2
            outfile2 = dialog.getSaveFileName(self, u'ラスタファイルの保存', fn, '*.' + ext2)
            if not outfile2 or str(outfile2) == "('', '')":
                return
            fp = str(outfile2).split("'")
            outfile2 = fp[1]
            dirpath2 = os.path.dirname(outfile2)
            # コマンド作成
            ext3 = ext2
            if ext2 == 'jpg' or ext2 == 'jpeg':
                ext3 = 'JPEG'
            if ext2 == 'tif' or ext2 == 'tiff':
                ext3 = 'GTiff'
            # 一旦、GeoTIFFを作成して、投影変換する
            # ワールドファイルを作業フォルダにコピーする
            wf1 = dirpath + '/' + fn + ext[0:2] + ext[-1:] + 'w'
            wf2 = dirpath + '/' + fn + ext + 'w'
            wf3 = dirpath + '/' + fn + '.wld'
            wf4 = ''
            n = 0
            if os.path.exists(wf1):
                n = 1
            if os.path.exists(wf2):
                n = n + 2
            if os.path.exists(wf3):
                n = n + 4
            if n != 0:
                wf4 = workPath + u'/temp' + ext + 'w'
                if n == 1 or n == 3 or n == 5 or n == 7:
                    shutil.copy(wf1, wf4)
                if n == 2 or n == 6:
                    shutil.copy(wf2, wf4)
                if n == 4:
                    shutil.copy(wf3, wf4)
                sleep(0.5)
                os.chmod(wf4, 0o777)
            if ext.lower() == '.kml':
                epsg1 = '4326'
            # コマンド作成
            outfile3 = workPath + '/geo.tif'
            # gdalwarpによる投影変換
            try:
                bin_dir = self.lineEdit_bin.text()
                cmd = '"' + bin_dir + 'gdalwarp.exe" -s_srs EPSG:' + epsg1 + ' -t_srs EPSG:' + epsg2 + ' ' + infile + ' ' + outfile3
                result = subprocess.run(cmd, shell=True)
                if result.returncode != 0:
                    QMessageBox.information(self, u'フォーマット変換', u'作業ファイルの作成に失敗しました。（gdalwarp）')
                    if os.path.exists(infile):
                        os.remove(infile)
                    if os.path.exists(wf4):
                        os.remove(wf4)
                    return
                sleep(0.5)
                if os.path.exists(infile):
                    os.remove(infile)
                infile = outfile3
            except:
                QMessageBox.information(self, u'エラー', u'対応できないファイルです。\n処理を中止します。')
                if os.path.exists(infile):
                    os.remove(infile)
                if os.path.exists(wf4):
                    os.remove(wf4)
                return
            # gdal_translateによるフォーマット変換
            try:
                bin_dir = self.lineEdit_bin.text()
                cmd = '"' + bin_dir + 'gdal_translate.exe" -of ' + ext3 + ' ' + infile + ' ' +  outfile
                result = subprocess.run(cmd, shell=True)
                if result.returncode != 0:
                    QMessageBox.information(self, u'フォーマット変換', u'変換に失敗しました。（gdal_translate）')
                    return
                sleep(0.5)
                shutil.copy(outfile, outfile2)
                fileInfo = QFileInfo(outfile2)
                # プロジェクトのCRSを使用するモード
                settings.setValue('/Projections/defaultBehavior', 'useProject')
                if epsg2 != code:
                    custom = str(QgsCoordinateReferenceSystem(int(epsg2)).authid())
                    if custom != '':#指定のCRSがカスタムCRSでない場合
                        new_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.EpsgCrsId)
                    else:
                        new_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.InternalCrsId)
                    QgsProject.instance().setCrs(new_crs)
                    self.lineEdit_8.setText(epsg2)
                layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
                QgsProject.instance().addMapLayer(layer)
                QgsApplication.processEvents()
                # 最終Path保存
                ws.setValue("setting/reg_path", dirpath2)
                # プロジェクトのCRSを取得する
                epsgGet()
                if epsgcode != '':
                    code = epsgcode
                else:
                    code = usercode
                # プロジェクトのCRSコンボボックスを更新
                self.set_Combo()
                # レイヤの領域にズーム
                self.zoom()
                # スケール取得
                QgsApplication.processEvents()
                self.pButton_49()
                QgsApplication.processEvents()
                if code2 != code:
                    QMessageBox.information(self, u'完了', '「' + outfile2 + u'」を作成しました。\nプロジェクトのCRSをEPSG:' + epsg2 + u' に変更しました。')
                else:
                    QMessageBox.information(self, u'完了', '「' + outfile2 + u'」を作成しました。')
            except:
                if os.path.exists(outfile2):
                    QMessageBox.information(self, u'表示不可', outfile2 + u' を作成しましたが、レイヤに追加することができません。')
                else:
                    QMessageBox.information(self, u'エラー', u'対応できないファイルです。\n処理を中止します。')
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
            # 作業ファイル削除
            if os.path.exists(infile):
                os.remove(infile)
            if os.path.exists(outfile):
                os.remove(outfile)
            if os.path.exists(outfile3):
                os.remove(outfile3)
            if os.path.exists(wf4):
                os.remove(wf4)

        # gdalwarp/ogr2ogrによる投影＆フォーマット変換（ベクタ）
        else:
            filter = '*.* (*.*);;DXF (*.dxf);;KML (*.kml);;ESRI Shapefile (*.shp);;GeoJSON (*.geojson);;GPX (*.gpx);;PDF (*.pdf)'
            infile0 = dialog.getOpenFileName(self, u'ベクタファイルの読込', '', filter)
            if not infile0 or str(infile0) == "('', '')":
                return
            fp = str(infile0).split("'")
            infile0 = fp[1]
            dirpath = os.path.dirname(infile0)
            filename = os.path.basename(infile0)
            fn, ext = os.path.splitext(filename)
            ws.setValue("setting/reg_path", dirpath)
            # ファイル名の日本語対策（一旦、作業ディレクトリに名前を変えてコピー）
            infile = workPath + u'/temp' + ext
            shutil.copy(infile0, infile)
            sleep(0.5)
            os.chmod(infile, 0o777)
            os.chdir(dirpath)
            outfile = workPath + u'/temp.' + ext2
            outfile2 = dialog.getSaveFileName(self, u'ベクタファイルの保存', fn, '*.' + ext2)
            if not outfile2 or str(outfile2) == "('', '')":
                return
            fp = str(outfile2).split("'")
            outfile2 = fp[1]
            dirpath2 = os.path.dirname(outfile2)
            filename = os.path.basename(outfile2)
            # コマンド作成
            if ext2 == 'shp':
                ext3 = '"ESRI Shapefile"'
            elif ext2 == 'fgb':
                ext3 = 'FlatGeobuf'
            else:
                ext3 = ext2
            if ext.lower() == '.kml':
                epsg1 = '4326'
            bin_dir = self.lineEdit_bin.text()
            try:
                if ext2 == 'dxf':
                    epsg1 = self.lineEdit_srsEPSG.text()
                    epsg2 = self.lineEdit_dstEPSG.text()
                    if epsg1 != epsg2:
                        outfile3 = workPath + u'/temp.' + ext
                        cmd = '"' + bin_dir + 'ogr2ogr.exe" -f ' + ext.replace(".","") + ' -s_srs EPSG:' + epsg1 + ' -t_srs EPSG:' + epsg2 + ' ' + outfile3 + ' ' + infile
                        result = subprocess.run(cmd, shell=True)
                        if result.returncode != 0:
                            QMessageBox.information(self, u'エラー', u'投影変換に失敗しました。（ogr2ogr）')
                            if os.path.exists(infile):
                                os.remove(infile)
                            if os.path.exists(wf4):
                                os.remove(wf4)
                            return
                        infile = outfile3
                    epsg = "'EPSG:" + self.lineEdit_dstEPSG.text() + "'"
                    cmd = '"' + bin_dir + 'ogr2ogr.exe" ' + outfile + ' ' + infile
                    result = subprocess.run(cmd, shell=True)
                else:
                    cmd = '"' + bin_dir + 'ogr2ogr.exe" -f ' + ext3 + ' -s_srs EPSG:' + epsg1 + ' -t_srs EPSG:' + epsg2 + ' ' + outfile + ' ' + infile
                    result = subprocess.run(cmd, shell=True)
                    if result.returncode != 0:
                        QMessageBox.information(self, u'投影変換（ベクタ）',  u'「' + outfile2 + u'」の作成に失敗しました。（ogr2ogr）')
                        if os.path.exists(infile):
                            os.remove(infile)
                        return
                sleep(0.5)
                shutil.copy(outfile, outfile2)
                dirpath2 = os.path.dirname(outfile2)
                filename2 = os.path.basename(outfile2)
                fn4, ext4 = os.path.splitext(filename2)
                if ext2 == 'shp':
                    shutil.copy(workPath + u'/temp.dbf', dirpath2 + '/' + fn4 +'.dbf')
                    shutil.copy(workPath + u'/temp.prj', dirpath2 + '/' + fn4 +'.prj')
                    shutil.copy(workPath + u'/temp.shx', dirpath2 + '/' + fn4 +'.shx')
                # プロジェクトのCRSを使用するモード
                settings.setValue('/Projections/defaultBehavior', 'useProject')
                # プロジェクトのEPSGと変換先のラスタのEPSGが違う場合は、プロジェクトのEPSGをラスタのEPSGに変更する
                if epsg2 != code:
                    custom = str(QgsCoordinateReferenceSystem(int(epsg2)).authid())
                    if custom != '':#ラスタのCRSがカスタムCRSでない場合
                        new_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.EpsgCrsId)
                    else:
                        new_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.InternalCrsId)
                    QgsProject.instance().setCrs(new_crs)
                    self.lineEdit_8.setText(epsg2)
                layer = QgsVectorLayer(outfile2, ext2, 'ogr')
                QgsProject.instance().addMapLayer(layer)
                QgsApplication.processEvents()
                # 最終Path保存
                ws.setValue("setting/reg_path", dirpath2)
                # プロジェクトのCRSを取得する
                epsgGet()
                if epsgcode != '':
                    code = epsgcode
                else:
                    code = usercode
                # プロジェクトのCRSコンボボックスを更新
                self.set_Combo()
                # レイヤの領域にズーム
                self.zoom()
                # スケール取得
                QgsApplication.processEvents()
                self.pButton_49()
                QgsApplication.processEvents()
                if code2 != code:
                    QMessageBox.information(self, u'完了', '「' + outfile2 + u'」を作成しました。\nプロジェクトのCRSをEPSG:' + epsg2 + u' に変更しました。')
                else:
                    QMessageBox.information(self, u'完了', '「' + outfile2 + u'」を作成しました。')
                if ext2 == 'kml':
                    if sys.platform == "win32":
                        os.startfile(outfile2)
                    else:
                        opener ="open" if sys.platform == "darwin" else "xdg-open"
                        subprocess.run([opener, outfile2])
            except:
                if os.path.exists(outfile2):
                    QMessageBox.information(self, u'表示不可', outfile2 + u' を作成しましたが、レイヤに追加することができません。')
                else:
                    QMessageBox.information(self, u'エラー', u'対応できないファイルです。\n処理を中止します。')
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
            # 作業ファイル削除
            try:
                if os.path.exists(infile):
                    os.remove(infile)
            except:
                pass
            try:
                if os.path.exists(outfile):
                    os.remove(outfile)
            except:
                pass
            if os.path.exists(wf4):
                os.remove(wf4)
            if os.path.exists(workPath + u'/temp.dbf'):
                os.remove(workPath + u'/temp.dbf')
            if os.path.exists(workPath + u'/temp.prj'):
                os.remove(workPath + u'/temp.prj')
            if os.path.exists(workPath + u'/temp.shx'):
                os.remove(workPath + u'/temp.shx')


    # ラスタ→ベクタ変換(GDAL/OGR)
    def pButton_58(self):
        if self.lineEdit_srsEPSG.text() == '':
            return
        if self.comboBox_format2.currentText() == '':
            return
        epsg1 = self.lineEdit_srsEPSG.text()
        infile = ''
        outfile = ''
        wf4 = ''
        # プロジェクトのCRSを取得する
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        ext2 = self.comboBox_format2.currentText().lower()
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        filter = '*.* (*.*);;PNG (*.png);;TIF (*.tif);;BMP (*.bmp);;JPG (*.jpg);;GIF (*.gif);;PDF (*.pdf)'
        infile0 = dialog.getOpenFileName(self, u'ラスタファイルの読込', '', filter)
        if not infile0 or str(infile0) == "('', '')":
            return
        fp = str(infile0).split("'")
        infile0 = fp[1]
        dirpath = os.path.dirname(infile0)
        filename = os.path.basename(infile0)
        fn, ext = os.path.splitext(filename)
        ws.setValue("setting/reg_path", os.path.dirname(infile0))
        # ファイル名の日本語対策（一旦、作業ディレクトリに名前を変えてコピー）
        infile = workPath + u'/temp' + ext
        infile1 = workPath + u'/temp' + ext
        shutil.copy(infile0, infile)
        sleep(0.5)
        # ReadOnly属性解除
        os.chmod(infile, 0o777)
        # ワールドファイルを作業フォルダにコピーする
        wf1 = dirpath + '/' + fn + ext[0:2] + ext[-1:] + 'w'
        wf2 = dirpath + '/' + fn + ext + 'w'
        wf3 = dirpath + '/' + fn + '.wld'
        n = 0
        if os.path.exists(wf1):
            n = 1
        if os.path.exists(wf2):
            n = n + 2
        if os.path.exists(wf3):
            n = n + 4
        if n != 0:
            if ext2 != 'kml' and ext2 != 'geojson':
                wf4 = workPath + u'/temp.pngw'
            else:
                wf4 = infile1 + 'w'
            if n == 1 or n == 3 or n == 5 or n == 7:
                shutil.copy(wf1, wf4)
            if n == 2 or n == 6:
                shutil.copy(wf2, wf4)
            if n == 4:
                shutil.copy(wf3, wf4)
            sleep(0.5)
            os.chmod(wf4, 0o777)

        # 変換先がkmlかpdfの場合は、GeoTIFFを作成する
        if ext2 == 'kml' or ext2 == 'pdf' :
            # コマンド作成
            outfile3 = workPath + '/geo.tif'
            if ext2 == 'kml':
                epsg2 = '4326'
            else:
                epsg2 = epsg1
            # gdalwarpによる投影変換
            try:
                bin_dir = self.lineEdit_bin.text()
                cmd = '"' + bin_dir + 'gdalwarp.exe" -s_srs EPSG:' + epsg1 + ' -t_srs EPSG:' + epsg2 + ' ' + infile + ' ' + outfile3
                result = subprocess.run(cmd, shell=True)
                if result.returncode != 0:
                    QMessageBox.information(self, u'ラスタ→ベクタ変換', u'作業ファイルの作成に失敗しました。（gdalwarp）')
                    if os.path.exists(infile):
                        os.remove(infile)
                    if os.path.exists(wf4):
                        os.remove(wf4)
                    return
                sleep(0.5)
                if os.path.exists(infile):
                    os.remove(infile)
                infile1 = outfile3
            except:
                QMessageBox.information(self, u'エラー', u'対応できないファイルです。\n処理を中止します。')
                if os.path.exists(infile):
                    os.remove(infile)
                if os.path.exists(wf4):
                    os.remove(wf4)
                return

        # 変換先がdxfの場合は、RGBAに変換したpngを作成する
        if ext2 == 'dxf':
            if ext.lower() == '.tif' or ext.lower() == '.tiff':
                bin_dir = self.lineEdit_bin.text()
                try:
                    cmd = '"' + bin_dir + 'gdal_translate.exe" -co TFW=YES ' + infile0 + ' ' + workPath + u'/temp2.tif'
                    result = subprocess.run(cmd, shell=True)
                    if result.returncode != 0:
                        QMessageBox.information(self, u'ラスタ→ベクタ変換', u'変換に失敗しました。（gdal_translate）1')
                        if os.path.exists(infile):
                            os.remove(infile)
                        if os.path.exists(outfile):
                            os.remove(outfile)
                        if os.path.exists(wf4):
                            os.remove(wf4)
                        if os.path.exists(workPath + u'/temp' + ext):
                            os.remove(workPath + u'/temp' + ext)
                        if os.path.exists(workPath + u'/temp2.tif'):
                            os.remove(workPath + u'/temp2.tif')
                        return
                    wf4 = workPath + u'/temp.pngw'
                    cmd = '"' + bin_dir + 'gdal_translate.exe" ' + infile + ' ' + workPath + u'/temp.png'
                    result = subprocess.run(cmd, shell=True)
                    if result.returncode != 0:
                        QMessageBox.information(self, u'ラスタ→ベクタ変換', u'変換に失敗しました。（gdal_translate）2')
                        if os.path.exists(infile):
                            os.remove(infile)
                        if os.path.exists(outfile):
                            os.remove(outfile)
                        if os.path.exists(wf4):
                            os.remove(wf4)
                        if os.path.exists(workPath + u'/temp' + ext):
                            os.remove(workPath + u'/temp' + ext)
                        if os.path.exists(workPath + u'/temp2.tif'):
                            os.remove(workPath + u'/temp2.tif')
                        return
                    os.rename(workPath + u'/temp2.tfw', wf4)
                except:
                    pass
            try:
                # PNG(RGBA)に変換
                infile = workPath + u'/temp.png'
                Image.open(infile).convert('RGBA').save(infile, "PNG")
            except:
                QMessageBox.information(self, u'エラー', u'対応できないファイルです。\n処理を中止します。')
                if os.path.exists(infile):
                    os.remove(infile)
                if os.path.exists(outfile):
                    os.remove(outfile)
                if os.path.exists(wf4):
                    os.remove(wf4)
                if os.path.exists(workPath + u'/temp' + ext):
                    os.remove(workPath + u'/temp' + ext)
                if os.path.exists(workPath + u'/temp2.tif'):
                    os.remove(workPath + u'/temp2.tif')
                return

        os.chdir(dirpath)
        outfile = workPath + u'/temp.' + ext2
        outfile2 = dialog.getSaveFileName(self, u'ベクタファイルの保存', fn, '*.' + ext2)
        if not outfile2 or str(outfile2) == "('', '')":
            return
        fp = str(outfile2).split("'")
        outfile2 = fp[1]
        dirpath2 = os.path.dirname(outfile2)
        # 透過処理
        if ext2 == 'dxf':
            img = Image.open(infile)
            datas = img.getdata()
            newData = []
            for item in datas:
                if item[0] == 255 and item[1] == 255 and item[2] == 255:
                    newData.append((255, 255, 255, 0))
                else:
                    newData.append(item)
            img.putdata(newData)
            img.save(workPath + u'/temp.png', "PNG")
        # コマンド作成
        if ext2 == 'shp':
            ext3 = '"ESRI Shapefile"'
        elif ext2 == 'fgb':
            ext3 = '"FlatGeobuf"'
        else:
            ext3 = ext2

        bin_dir = self.lineEdit_bin.text()
        try:
            if ext3 == 'dxf':
                # 一旦、temp_fileを作成して（GeoJSON）、作成されたファイルの4行目にCRS情報を加えたtemp_file2（GeoJSON）を作成する。
                temp_file = workPath + '/tmp.geojson'
                temp_file2 = workPath + '/tmp2.geojson'
                cmd = 'gdal_polygonize.bat ' + infile + ' -f geojson ' + temp_file
                os.system(cmd)
                with open(temp_file, 'r', encoding='utf-8') as f:
                    lines = f.readlines()
                crs_line = '"crs": { "type": "name", "properties": { "name": "urn:ogc:def:crs:EPSG::' + code + '" } },\n'
                lines.insert(3, crs_line)
                with open(temp_file2, 'w', encoding='utf-8') as f:
                    f.writelines(lines)
                # geojson→dxf変換
                cmd = '"' + bin_dir + 'ogr2ogr.exe" ' + outfile + ' ' + temp_file2
            else:
                cmd = 'gdal_polygonize.bat ' + infile + ' -f ' + ext3 + ' ' + outfile
            result = subprocess.run(cmd, shell=True)
            if result.returncode != 0:
                QMessageBox.information(self, u'ラスタ→ベクタ変換', u'変換に失敗しました。（gdal_polygonize）3')
                return
                if os.path.exists(infile):
                    os.remove(infile)
                if os.path.exists(outfile):
                    os.remove(outfile)
                try:
                    os.remove(outfile3)
                except:
                    pass
                if os.path.exists(wf4):
                    os.remove(wf4)
                if os.path.exists(workPath + u'/temp' + ext):
                    os.remove(workPath + u'/temp' + ext)
                if os.path.exists(workPath + u'/temp2.tif'):
                    os.remove(workPath + u'/temp2.tif')
                if os.path.exists(workPath + u'/temp.dbf'):
                    os.remove(workPath + u'/temp.dbf')
                if os.path.exists(workPath + u'/temp.shx'):
                    os.remove(workPath + u'/temp.shx')
                if os.path.exists(workPath + u'/temp.geojson'):
                    os.remove(workPath + u'/tmp.geojson')
                if os.path.exists(workPath + u'/temp2.geojson'):
                    os.remove(workPath + u'/tmp2.geojson')
                return
            sleep(0.5)
            shutil.copy(outfile, outfile2)
            fn_dst, ext_dst = os.path.splitext(outfile2)
            fname_dst = os.path.basename(outfile2)
            if ext2 == 'shp':
                shutil.copy(workPath + u'/temp.dbf', fn_dst + '.dbf')
                shutil.copy(workPath + u'/temp.shx', fn_dst + '.shx')
            elif ext2 == 'geojson':
                # GeoJSONの場合は、作成されたファイルに１行（CRS情報）加える。
                outfile3 = outfile + '2'
                fout = codecs.open(outfile3, 'w', 'utf-8')
                for line in open(outfile, 'r'):
                    if line[:11] == '"' + 'features' + '":':
                        line2 = '"' + 'crs' + '"' + ': { ' + '"' + 'type' + '"' + ': ' + '"' + 'name' + '"' + ', ' + '"' + 'properties' + '"' + ': { ' + '"' + 'name' + '"' + ': ' + '"' + 'urn:ogc:def:crs:EPSG::' + self.lineEdit_srsEPSG.text() + '"' + ' } },\n'
                        fout.writelines(line2)
                    fout.writelines(line)
                fout.close()
                shutil.copy(outfile3, outfile2)
            # プロジェクトのCRSを使用するモード
            settings.setValue('/Projections/defaultBehavior', 'useProject')
            if ext2 == 'kml':
                code2 = '4326'
                new_crs = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
            else:
                code2 = self.lineEdit_srsEPSG.text()
                custom = str(QgsCoordinateReferenceSystem(int(code2)).authid())
                if custom != '':#ラスタのCRSがカスタムCRSでない場合
                    new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.EpsgCrsId)
                else:
                    new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
            self.lineEdit_8.setText(code2)
            layer = QgsVectorLayer(outfile2, fname_dst, 'ogr')
            QgsProject.instance().addMapLayer(layer)
            if self.comboBox_2.currentText() != '':
                qmlfile = str(self.comboBox_2.currentText())
                if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
            else:
                if ext2 == 'dxf':
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/polygonize.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/polygonize.qml')
                else:
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/geojson.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/geojson.qml')
            # 最終Path保存
            ws.setValue("setting/reg_path", dirpath2)
            # プロジェクトのCRSコンボボックスを更新
            self.set_Combo()
            # レイヤの領域にズーム
            self.zoom()
            # スケール取得
            QgsApplication.processEvents()
            self.pButton_49()
            QgsApplication.processEvents()
            if code2 != code:
                QMessageBox.information(self, u'完了', '「' + outfile2 + u'」を作成しました。\nプロジェクトのCRSをEPSG:' + code2 + u' に変更しました。')
            else:
                QMessageBox.information(self, u'完了', '「' + outfile2 + u'」を作成しました。')
            if ext2 == 'kml':
                if sys.platform == "win32":
                    os.startfile(outfile2)
                else:
                    opener ="open" if sys.platform == "darwin" else "xdg-open"
                    subprocess.run([opener, outfile2])
        except:
            if sys.platform == "win32":
                QMessageBox.information(self, u'エラー', ext2 + u' の作成に失敗しました。')
            else:
                if os.path.exists(outfile2):
                    QMessageBox.information(self, u'表示不可', outfile2 + u' を作成しましたが、レイヤに追加することができません。')
                else:
                    QMessageBox.information(self, u'エラー', ext2 + u' の作成に失敗しました。')

        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))

        # 作業ファイル削除
        if os.path.exists(infile):
            os.remove(infile)
        if os.path.exists(outfile):
            os.remove(outfile)
        try:
            os.remove(outfile3)
        except:
            pass
        if os.path.exists(wf4):
            os.remove(wf4)
        if os.path.exists(workPath + u'/temp' + ext):
            os.remove(workPath + u'/temp' + ext)
        if os.path.exists(workPath + u'/temp2.tif'):
            os.remove(workPath + u'/temp2.tif')
        if os.path.exists(workPath + u'/temp.dbf'):
            os.remove(workPath + u'/temp.dbf')
        if os.path.exists(workPath + u'/temp.shx'):
            os.remove(workPath + u'/temp.shx')
        if os.path.exists(workPath + u'/temp.geojson'):
            os.remove(workPath + u'/tmp.geojson')
        if os.path.exists(workPath + u'/temp2.geojson'):
            os.remove(workPath + u'/tmp2.geojson')

    # 補足（GDAL/OGR）
    def pButton_56(self):
        dat =       u'<フォーマット ＆ 投影変換>\n'
        dat = dat + u'[ラスタ→ラスタ] gdalwarp.exe と gdal_translate.exe を使用して、投影変換と\n'
        dat = dat + u'フォーマット変換をします。  変換元・変換先ラスタの EPSG コードと変換先のラスタ\n'
        dat = dat + u'フォーマットを指定してください。  変換先が pdf の場合は、GeoPDF が作成されます。\n'
        dat = dat + u'変換先が kml の場合は、変換先の EPSG の指定に拘わらず、4326 が適用されます。\n'
        dat = dat + u'\n'
        dat = dat + u'[ベクタ→ベクタ] ogr2ogr.exe を使用して、投影変換とフォーマット変換をします。\n'
        dat = dat + u'変換元・変換先のEPSGコードと変換先のベクタフォーマットを指定してください。\n'
        dat = dat + u'変換先が pdf の場合は、GeoPDF が作成されます。  変換先が kml の場合は、\n'
        dat = dat + u'変換先の EPSG の指定に拘わらず、4326 が適用されます。\n'
        dat = dat + u'\n'
        dat = dat + u'<ラスタ→ベクタ変換>\n'
        dat = dat + u'ラスタファイルからベクタファイルへ変換します。\n'
        dat = dat + u'変換元の EPSG と変換先のベクタフォーマットを指定してください。変換先 EPSG の\n'
        dat = dat + u'指定は不要です。  変換元ファイルは、GeoTIFF やワールドファイルなど位置情報を\n'
        dat = dat + u'もつラスタファイルである必要があります。（ない場合は、画像が反転します。）\n'
        dat = dat + u'\n'
        dat = dat + u'<画像情報取得>\n'
        dat = dat + u'gdalinfo.exe を使用して、ラスタデータの情報を取得し、クリップボードに転送します。\n'
        dat = dat + u'メモ帳等のテキストエディタに貼り付けてご覧ください。\n'
        dat = dat + u'変換元・変換先のラスタフォーマット・EPSG の指定は不要です。読み込むラスタデータ\n'
        dat = dat + u'が GeoTIFF の場合、ワールドファイルの作成が可能で、空間参照系が緯度・経度系\n'
        dat = dat + u'EPSG が 4326 か 4612）の場合は、KMLファイルの作成も可能です。'
        QMessageBox.information(self, u'補足', dat)

    # 補足2（GDAL/OGR）
    def pButton_64(self):
        dat = u'<QGISのpython.exeのパス><mojxml2geojsonのフォルダ>について\n'
        dat = dat + u'QGISからmojxml2geojsonを起動するには、QGISのpython.exeのパスと\n'
        dat = dat + u'mojxml2geojsonのフォルダのパスの設定が必要です。\n'
        dat = dat + u'QGISのpython.exeのパスは、デフォルトでインストールすると、\n'
        dat = dat + u'「C:\Program Files\QGIS 3.xx.xx\apps\Python39\python.exe」になります。\n'
        dat = dat + u'（xxは、バージョンにより異なります。）\n'
        dat = dat + u'mojxml2geojsonは、デジタル庁のコンバータの改造版（K’z lab版）が必要です。\n'
        dat = dat + u'mojxml2geojsonのフォルダは、Digitizerに同梱の「x2g-kzlab.zip」を解凍してできた\n'
        dat = dat + u'フォルダを指定してください。解凍したフォルダ名は変更せずにお使いください。\n'
        dat = dat + u'\n'
        dat = dat + u'<バッチファイルの作成>について\n'
        dat = dat + u'mojxml2geojsonを初めて使用する場合、または改造後に使用する場合は、「ビルド」\n'
        dat = dat + u'する必要があります。実行すると、mojxml2geojsonのフォルダ内に「build.bat」を\n'
        dat = dat + u'作成します。また、QGISをインストールした状態では、「pyproj」というライブラリで\n'
        dat = dat + u'エラーを起こすことがあり、その際は「pyproj」のアップグレードが必要になります。\n'
        dat = dat + u'「pyproj_upgrade.bat」というファイルも同時に作成しますので、エクスプローラで\n'
        dat = dat + u'これらを実行してください。\n'
        dat = dat + u'\n'
        dat = dat + u'<変換>について\n'
        dat = dat + u'上記の設定後、地図XML（ダウンロードしたZIP又は解凍したXMLを読み込んで\n'
        dat = dat + u'GeoJSONに変換します。保存先には空のフォルダを指定してください。\n'
        dat = dat + u'「FlatGeobuf」にチェックをすると、続けてFlatGeobufも作成します。\n'
        dat = dat + u'\n'
        dat = dat + u'<SIMA>について\n'
        dat = dat + u'アクティブレイヤの表示領域又は選択地物、又はGeoJSONファイルを読み込んで\n'
        dat = dat + u'SIMA に変換します。変換元の GeoJSON は、ConvertTool統合版、デジタル庁の\n'
        dat = dat + u'mojxml2geojson（K’zlab改造版）で作成した平面直角座標系のポリゴンデータ\n'
        dat = dat + u'のみ対応です。。\n'
        dat = dat + u'作成したGeoJSONの一部をQGAISで切り出して、SIMAに変換することを想定して、\n'
        dat = dat + u'います。処理には時間がかかります。\n'
        dat = dat + u'\n'
        dat = dat + u'<変換オプション>について\n'
        dat = dat + u'[地区外・別図・区域外・調査外を除外]\n'
        dat = dat + u'地図XMLデータの「地番」に上記の文字が含まれる場合、変換から除外します。\n'
        dat = dat + u'[座標変換しない]\n'
        dat = dat + u'地図XMLは、平面直角座標系又は任意座標系のデータです。これを緯度・経度\n'
        dat = dat + u'に座標変換せずにGeoJSONに変換する場合にチェックします。\n'
        dat = dat + u'[公共座標系のみ出力／任意座標系のみ出力]\n'
        dat = dat + u'「mojxml2geojson」（K’z lab改造版）は、同時に両方を変換することはでき\n'
        dat = dat + u'ない仕様のため、必要な方にチェックします。\n'
        dat = dat + u'[代表点を別ファイルで出力]\n'
        dat = dat + u'代表点ファイルは、PMTilesを作成してWEB地図として使用する場合の地番\n'
        dat = dat + u'表示用のファイルとなります。これを区画データと同時に作成します。\n'
        dat = dat + u'[代表点ファイルのみ作成]\n'
        dat = dat + u'区画データを作成せず、代表点ファイルだけ作成します。\n'
        dat = dat + u'[SIMA出力]\n'
        dat = dat + u'GeoJSONに変換後、SIMAファイルも作成します。\n'
        dat = dat + u'[FlatGeobuf作成]\n'
        dat = dat + u'GeoJSON作成後、FlatGeobufも作成します。\n'
        dat = dat + u'[CRS変換（EPSG:4326）]\n'
        dat = dat + u'FlatGeobufに変換する際、CRS（空間参照系）を緯度・経度にして作成します。\n'
        dat = dat + u'[レイヤに追加]\n'
        dat = dat + u'変換後、マップキャンバスに表示します。\n'
        dat = dat + u'\n'
        dat = dat + u'<FlatGeobuf>について\n'
        dat = dat + u'既に変換済みのGeoJSONファイルからFlatGeobufに変換します。\n'
        dat = dat + u'\n'
        dat = dat + u'<PMTiles>について\n'
        dat = dat + u'既に変換済みのGeoJSON又はFlatGeobufファイルからPMTilesに変換します。\n'
        dat = dat + u'「XML/ZIP→GeoJSON→FlatGeobuf→PMTiles」は、地図XML（XML又はZIP）\n'
        dat = dat + u'を読み込み、保存先を指定するだけで、PMTilesまで作成します。設定が必要な\n'
        dat = dat + u'オプションは、「Ubuntu Version」、「地区外」「別図」...を除外」、区画と\n'
        dat = dat + u'地番の「レイヤ名・最大ズーム・最小ズーム」で、他の設定は無視されます。\n'
        dat = dat + u'また、チェックの有無に拘わらず、代表点ファイルも作成します。\n'
        dat = dat + u'地図XMLからGeoJSONへの変換では、座標変換しません。FlatGeobufへの変換の\n'
        dat = dat + u'段階でEPSG:4326に変換され、PMTilesが作成されます。\n'
        dat = dat + u'保存先には空のフォルダを指定してください。\n'
        dat = dat + u'\n'
        dat = dat + u'<代表点 File>について\n'
        dat = dat + u'既に変換済みのGeoJSON又はFlatGeobufファイルのポリゴンの代表点ファイルを\n'
        dat = dat + u'作成します。\n'
        dat = dat + u'\n'
        dat = dat + u'<代表点 Layer>について\n'
        dat = dat + u'アクティブレイヤのポリゴンの代表点ファイルを作成します。\n'
        QMessageBox.information(self, u'補足', dat)

    # 補足3（GDAL/OGR）
    def pButton_pmtiles4(self):
        dat = u'PMTiles変換には、Windows に Ubuntu のインストールと、Ubuntu に tippecanoe の\n'
        dat = dat + u'インストールが必要です。以下を参考に環境設定してください。\n'
        dat = dat + u'\n'
        dat = dat + u'● Ubuntu 22.04 のインストール\n'
        dat = dat + u' (1) Linuxインストール前の準備\n'
        dat = dat + u'     コントロールパネル→プログラムと機能→Windowsの機能の有効化または無効化で、\n'
        dat = dat + u'　   Linux用Windowsサブシステム と 仮想マシンプラットフォーム にチェックを入れ OK\n'
        dat = dat + u' (2) WSL2用Linuxカーネルをインストール\n'
        dat = dat + u'     https://aka.ms/wsl2kernel の x64マシン用WSL2 Linuxカーネル更新プログラム\n'
        dat = dat + u'     パッケージ でインストーラをダウンロード＆インストール\n'
        dat = dat + u' (3) WSL2を既定のバージョンに設定\n'
        dat = dat + u'     1.コマンドプロンプトを起動して wsl --set-default-version 2 とタイプし、Enter\n'
        dat = dat + u' (4) Linuxディストリビューションのインストール\n'
        dat = dat + u'     1. Microsoft Store から Ubuntu 22.04.3 LTSをインストール\n'
        dat = dat + u'     2.インストールしたUbuntuを開き、初期設定\n'
        dat = dat + u'        1. Enter new UNIX username で新規作成するユーザー名を入力\n'
        dat = dat + u'        2. New password でパスワードを入力\n'
        dat = dat + u'        3. Retype new password で同じパスワードを入力\n'
        dat = dat + u'\n'
        dat = dat + u'● tippecanoe のインストール\n'
        dat = dat + u' Ubuntuを開き、以下のコマンドを入力し、各行毎にEnter\n'
        dat = dat + u' sudo apt update\n'
        dat = dat + u' sudo apt upgrade\n'
        dat = dat + u' sudo apt install language-pack-ja\n'
        dat = dat + u" echo 'export LANG=ja_JP.UTF-8' >> ~/.bashrc\n"
        dat = dat + u' sudo apt install gcc\n'
        dat = dat + u' git clone https://github.com/felt/tippecanoe.git\n'
        dat = dat + u' cd tippecanoe\n'
        dat = dat + u' sudo apt install make\n'
        dat = dat + u' sudo apt install g++\n'
        dat = dat + u' sudo apt install build-essential libsqlite3-dev zlib1g-dev\n'
        dat = dat + u' make -j\n'
        dat = dat + u' sudo make install\n'
        QMessageBox.information(self, u'補足', dat)

    # 補足2（GDAL/OGR）
    def pButton_70(self):
        dat = u'「選択地物」「表示領域」「ファイル」のいずれの場合も、最初に必ず、「情報取得」を\n'
        dat = dat + u'実行してください。実行すると、データソースの地番区域と属性がリストアップされます。\n'
        dat = dat + u'「抽出」と「変換」の違いは、地番区域による抽出をするかどうかです。\n'
        dat = dat + u'「抽出」を実行した場合は、地番区域による抽出が優先し、「選択地物」「表示領域」\n'
        dat = dat + u'は無視されます。\n'
        dat = dat + u'「属性追加」と「属性削除」は「抽出」「変換」いずれの場合も有効です。\n'
        dat = dat + u'\n'
        dat = dat + u'※ 「属性追加」と「属性削除」は、GeoJSON/FlatGeobuf変換のオプションです。\n'
        QMessageBox.information(self, u'補足', dat)

    # 地図XML→GeoJSON→FlatGeobuf変換
    # python.exe Path設定（GDAL/OGR）
    def pButton_python(self):
        pv = sys.version.split(".")
        python_path = str(sys.executable).split("\\")
        default_dir = python_path[0] + "/" + python_path[1] + "/" + python_path[2] + "/apps/Python" + pv[0] + pv[1] + "/python.exe"
        #default_dir = "C:\Program Files"
        filter = "EXEファイル (*.exe)"
        filename, _ = QFileDialog.getOpenFileName(None, "QGIS附属のpython.exeを選択してください。", default_dir, filter)
        if filename == '' or filename == None:
            return
        self.python_path.setText(filename)
        ws.setValue("setting/python_Path", filename)

    # mojxml2geojson Path設定（GDAL/OGR）
    def pButton_folder(self):
        mojxml2geojson_Path = ws.value("setting/mojxml2geojson_Path", 'C:\mojxml2geojson-kzlab')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        dialog.setOption(QFileDialog.ShowDirsOnly)
        try:
            dialog.setDirectory(mojxml2geojson_Path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        if self.mojxml2geojson_folder.text() == '' and os.path.exists('C:\mojxml2geojson-kzlab'):
            foldername = dialog.getExistingDirectory(self, u'フォルダを選択してください。', 'C:\mojxml2geojson-kzlab')
        else:
            foldername = dialog.getExistingDirectory(self, u'フォルダを選択してください。')
        if foldername == '' or foldername == None:
            foldername = mojxml2geojson_Path
        if foldername[-20:] != "mojxml2geojson-kzlab":
            QMessageBox.information(self, u'エラー', u"フォルダ名は「mojxml2geojson-kzlab」でなければなりません。\n（K'z lab改造版が必要です。）")
            self.mojxml2geojson_folder.setText('')
            return
        self.mojxml2geojson_folder.setText(foldername)
        ws.setValue("setting/mojxml2geojson_Path", foldername)

    # mojxml2geojson.exeのビルド用バッチファイル＆pyprojupgrade用バッチファイル（GDAL/OGR）
    def pButton_build(self):
        bat_name = self.mojxml2geojson_folder.text() + "/build.bat"
        python_path = self.python_path.text()
        cmd = self.mojxml2geojson_folder.text()[:2] + "\n"
        cmd = cmd + "cd " + self.mojxml2geojson_folder.text() + "\n"
        cmd = cmd + '"' + python_path + '"' + " -m pip install ." + "\n"
        cmd = cmd + "pause"
        fname = codecs.open(bat_name, 'w', 'shift-jis')
        fname.write(cmd)
        fname.close()
        cmd = ""
        bat_name2 = self.mojxml2geojson_folder.text() + "/pyproj_upgrade.bat"
        python_path = self.python_path.text()
        cmd = cmd + '"' + python_path + '"' + " -m pip install --upgrade pyproj" + "\n"
        cmd = cmd + "pause"
        fname = codecs.open(bat_name2, 'w', 'shift-jis')
        fname.write(cmd)
        fname.close()

        if os.path.exists(bat_name):
            QMessageBox.information(self, u'バッチファイル作成',  'mojxml2geojson.exe のビルド用バッチファイル\n' + str(bat_name) + u' を作成しました。\n実行してください。\n\npyproj の upgrade用バッチファイル\n' + str(bat_name) + u' を作成しました。\n必要に応じて実行してください。')
        # QGISからバッチファイルを実行すると、違う場所にビルドされてしまう。
        #result = subprocess.run(bat_name, shell=False)
        #if result.returncode != 0:
        #    QMessageBox.information(self, u'mojxml2geojson.exeのビルド', u'ビルドに失敗しました。（mojxml2geojson）')
        #    return

    # チェックボックスセット（GDAL/OGR）
    def SetCheckXml2(self):
        if self.check_xml_2.isChecked():
            self.check_xml_3.setChecked(False)
        else:
            self.check_xml_3.setChecked(True)

    # チェックボックスセット（GDAL/OGR）
    def SetCheckXml3(self):
        if self.check_xml_3.isChecked():
            self.check_xml_2.setChecked(False)
        else:
            self.check_xml_2.setChecked(True)

    # チェックボックスセット（GDAL/OGR）
    def SetCheckXml4(self):
        if not self.check_xml_4.isChecked():
            self.check_xml_6.setChecked(False)

    # チェックボックスセット（GDAL/OGR）
    def SetCheckXml6(self):
        if self.check_xml_6.isChecked():
            self.check_xml_4.setChecked(True)

    # チェックボックスセット（GDAL/OGR）
    def SetCheckXml7(self):
        if not self.check_xml_7.isChecked():
            self.check_xml_9.setChecked(False)

    # チェックボックスセット（GDAL/OGR）
    def SetCheckXml9(self):
        if self.check_xml_9.isChecked():
            self.check_xml_7.setChecked(True)

    # チェックボックスセット（GDAL/OGR）
    def SetClick0(self):
        if self.click0.isChecked():
            self.click1.setChecked(True)
            self.click2.setChecked(False)
            self.click3.setChecked(False)
            self.click4.setChecked(False)
            self.label_info.setText('　マップキャンバスをクリックして、１点目の変換元座標を取得してください。')

    # チェックボックスセット（GDAL/OGR）
    def SetClick1(self):
        if self.click1.isChecked():
            self.click2.setChecked(False)
            self.click3.setChecked(False)
            self.click4.setChecked(False)
            self.label_info.setText('　マップキャンバスをクリックして、１点目の変換元座標を取得してください。')

    # チェックボックスセット（GDAL/OGR）
    def SetClick2(self):
        if self.click2.isChecked():
            self.click1.setChecked(False)
            self.click3.setChecked(False)
            self.click4.setChecked(False)
            self.label_info.setText('　マップキャンバスをクリックして、２点目の変換元座標を取得してください。')

    # チェックボックスセット（GDAL/OGR）
    def SetClick3(self):
        if self.click3.isChecked():
            self.click1.setChecked(False)
            self.click2.setChecked(False)
            self.click4.setChecked(False)
            self.label_info.setText('　マップキャンバスをクリックして、１点目の変換先座標を取得してください。')

    # チェックボックスセット（GDAL/OGR）
    def SetClick4(self):
        if self.click4.isChecked():
            self.click1.setChecked(False)
            self.click2.setChecked(False)
            self.click3.setChecked(False)
            self.label_info.setText('　マップキャンバスをクリックして、２点目の変換先座標を取得してください。')

    # コンバート
    def pButton_xml2geojson(self):

        if self.python_path.text() == "":
            QMessageBox.information(self, u'設定', u'QGIS附属のpython.exeのパスが設定されていません。\n次のウィンドウでpython.exeを選択してください。')
            self.pButton_python()
            return
        if not os.path.exists(self.python_path.text()):
            QMessageBox.information(self, u'設定', u'python.exeのパスが無効です。\n次のウィンドウでQGIS附属のpython.exeを選択してください。')
            self.pButton_python()
            return
        if self.python_path.text() == "":
            QMessageBox.information(self, u'設定', u'QGIS附属のpython.exeのパスが設定されていません。\n次のウィンドウでpython.exeを選択してください。')
            self.pButton_python()
            return
        if self.mojxml2geojson_folder.text() == "":
            QMessageBox.information(self, u'設定', u'mojxml2geojson-kzlabのパスが設定されていません。\n次のウィンドウでmojxml2geojson-kzlabのフォルダを選択してください。')
            self.pButton_folder()
            return
        if not os.path.exists(self.mojxml2geojson_folder.text()):
            QMessageBox.information(self, u'設定', u'mojxml2geojsonのパスが無効です。\n次のウィンドウでmojxml2geojson-kzlabのフォルダを選択してください。')
            self.pButton_folder()
            return

        filter = "XMLファイル (*.xml);;ZIPファイル (*.zip)"
        default_dir = ""
        filename, _ = QFileDialog.getOpenFileName(None, "XML/ZIPファイルを選択してください。", default_dir, filter)
        if filename == '' or filename == None:
            return
        filepath, ext = os.path.splitext(filename)
        fgb_name = os.path.basename(filepath)
        kukaku_path = os.path.dirname(filename) + '/kukaku/'
        chiban_path = os.path.dirname(filename) + '/chiban/'
        f_name = os.path.splitext(os.path.basename(filename))[0]

        if filename[-4:] == ".zip": # ZIPの場合は、空の保存先フォルダを指定する
            dirname = QFileDialog.getExistingDirectory(None, "空の保存先フォルダを選択してください。", filepath)
            if dirname == '' or dirname == None:
                return
            files = os.listdir(dirname)
            if len(files) != 0:
                QMessageBox.information(self, u'エラー', u'保存先として指定されたフォルダは空ではありません。\n処理を中止します。')
                return
            if not self.check_xml_7.isChecked():
                self.check_xml_8.setChecked(False)
            kukaku_path = dirname + '/kukaku/'
            chiban_path = dirname + '/chiban/'

        # zipの場合は解凍する
        if filename[-4:] == ".zip":
            shutil.unpack_archive(filename, dirname)
            for file in os.listdir(dirname):
                if file.endswith('.zip'):
                    shutil.unpack_archive(dirname + "/" + file, dirname)

        # オプション設定
        if self.check_xml_1.isChecked():
            op1 = " -e"
        else:
            op1 = ""
        if self.check_xml_2.isChecked():
            op2 = " -u"
        else:
            op2 = ""
        if self.check_xml_3.isChecked():
            op3 = " -t"
        else:
            op3 = ""
        if self.check_xml_4.isChecked():
            op4 = " -d"
        else:
            op4 = ""
        if self.check_xml_5.isChecked():
            op5 = " -x"
        else:
            op5 = ""
        if self.check_xml_6.isChecked():
            op6 = " -c"
        else:
            op6 = ""

        cmd = ""
        bat_name = self.mojxml2geojson_folder.text() + "/run.bat"
        python_path = self.python_path.text().replace("/python.exe", "").replace("/python3.exe", "")
        #print(python_path)
        if filename[-4:] == ".zip":
            for file in os.listdir(dirname):
                if file.endswith('.xml'):
                    cmd = cmd + '"' + python_path + "/Scripts/mojxml2geojson.exe" + '"' + op1 + op2 + op3 + op4 + op5 + op6 + ' "' + dirname + '/' + file + '"\n'
        else:
            cmd = '"' + python_path + "/Scripts/mojxml2geojson.exe" + '"' + op1 + op2 + op3 + op4 + op5 + op6 + ' "' + filename + '"\n'
        fname = codecs.open(bat_name, 'w', 'shift-jis')
        fname.write(cmd)
        fname.close()
        result = subprocess.run(bat_name, shell=False)
        if result.returncode != 0:
            QMessageBox.information(self, u'地図XML→GeoJSON変換', u'変換に失敗しました。（mojxml2geojson）')
            return
        else:
            if not self.check_xml_7.isChecked():
                QMessageBox.information(self, u'地図XML→GeoJSON変換', u'変換が完了しました。（mojxml2geojson）')

        # FlatGeobuf作成
        if self.check_xml_7.isChecked():
            if filename[-4:] == ".zip":
                fgb1 = dirname + "/" + fgb_name + ".fgb"
                if os.path.exists(fgb1):
                    os.remove(fgb1)
            else:
                fgb1 = filepath + ".fgb"
                if os.path.exists(fgb1):
                    os.remove(fgb1)
            if self.check_xml_9.isChecked():
                epsg = "-t_srs EPSG:4326 "
            else:
                epsg = ""
            if filename[-4:] == ".zip":
                cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures " + epsg + "-o " + '"' + kukaku_path + f_name + ".fgb" + '" "' + kukaku_path + "*.geojson" + '"' + "\n"
            else:
                cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures " + epsg + "-o " + '"' + kukaku_path + f_name + ".fgb" + '" "' + kukaku_path + f_name + ".geojson" + '"' + "\n"
            #cmd = cmd + "pause"
            bat_name = self.mojxml2geojson_folder.text() + "/fgb.bat"
            fname = codecs.open(bat_name, 'w', 'shift-jis')
            fname.write(cmd)
            fname.close()
            result = subprocess.run(bat_name, shell=False)
            if result.returncode != 0:
                QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufの作成に失敗しました。（ogrmerge.py）')
                return
            else:
                if not self.check_xml_4.isChecked():
                    QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufを作成しました。（ogrmerge.py）')
            if os.path.exists(bat_name):
                os.remove(bat_name)

            # 代表点のFlatGeobuf
            if self.check_xml_4.isChecked():
                if self.check_xml_9.isChecked():
                    epsg = "-t_srs EPSG:4326 "
                else:
                    epsg = ""
                if filename[-4:] == ".zip":
                    cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures " + epsg + "-o " + '"' + chiban_path + f_name + "_daihyo.fgb" + '" "' + chiban_path + "*.geojson" + '"' + "\n"
                else:
                    cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures " + epsg + "-o " + '"' + chiban_path + f_name + "_daihyo.fgb" + '" "' + chiban_path + f_name + ".daihyo.geojson" + '"' + "\n"
                #cmd = cmd + "pause"
                bat_name = self.mojxml2geojson_folder.text() + "/fgb.bat"
                fname = codecs.open(bat_name, 'w', 'shift-jis')
                fname.write(cmd)
                fname.close()
                result = subprocess.run(bat_name, shell=False)
                if result.returncode != 0:
                    QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'代表点のFlatGeobufの作成に失敗しました。（ogrmerge.py）')
                    return
                else:
                    QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'代表点のFlatGeobufを作成しました。（ogrmerge.py）')
                if os.path.exists(bat_name):
                    os.remove(bat_name)

        # レイヤに追加＆スタイル適用
        if self.check_xml_8.isChecked():
            try:
                if self.check_xml_7.isChecked():
                    path_to_fgb = kukaku_path + f_name + ".fgb"
                else:
                    if filename[-4:] == ".xml":
                        path_to_fgb = kukaku_path + f_name + ".geojson"
                layer = QgsVectorLayer(path_to_fgb, f_name, 'ogr')
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon.qml')
            except:
                pass
            if self.check_xml_4.isChecked():
                try:
                    if self.check_xml_7.isChecked():
                        path_to_fgb = chiban_path + f_name + "_daihyo.fgb"
                    else:
                        if filename[-4:] == ".xml":
                            path_to_fgb = chiban_path + f_name + ".daihyo.geojson"
                    layer = QgsVectorLayer(path_to_fgb, f_name + "_daihyo", 'ogr')
                    QgsProject.instance().addMapLayer(layer)
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_point.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_point.qml')
                except:
                    pass


    # FlatGeobuf作成（フォルダ内にある全てのGeoJSONが対象）
    def pButton_fgb(self):
        if self.python_path.text() == "":
            QMessageBox.information(self, u'設定', u'QGIS附属のpython.exeのパスが設定されていません。\n次のウィンドウでpython.exeを選択してください。')
            self.pButton_python()
            return
        if not os.path.exists(self.python_path.text()):
            QMessageBox.information(self, u'設定', u'python.exeのパスが無効です。\n次のウィンドウでQGIS附属のpython.exeを選択してください。')
            self.pButton_python()
            return
        if self.python_path.text() == "":
            QMessageBox.information(self, u'設定', u'QGIS附属のpython.exeのパスが設定されていません。\n次のウィンドウでpython.exeを選択してください。')
            self.pButton_python()
            return

        default_dir = ""
        dirname = QFileDialog.getExistingDirectory(None, "GeoJSONのあるフォルダを選択してください。", default_dir)
        if dirname == '' or dirname == None:
            return

        os.chdir(dirname)
        filename = QFileDialog.getSaveFileName(self, u'FlatGeobufファイルを保存', 'FlatGeobuf', '*.fgb')
        if str(filename) == "('', '')":
            return
        fp = str(filename).split("'")
        fgb_name = fp[1]
        if os.path.exists(fgb_name):
            os.remove(fgb_name)

        # FlatGeobuf作成
        if self.check_xml_9.isChecked():
            epsg = "-t_srs EPSG:4326 "
        else:
            epsg = ""
        python_path = self.python_path.text().replace("/python.exe", "").replace("/python3.exe", "")
        cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures " + epsg + "-o " + '"' + str(fgb_name) + '" "' + dirname + "/*.geojson" + '"' + "\n"
        #cmd = cmd + "pause"
        bat_name = os.path.dirname(__file__) + u'/work/fgb.bat'
        fname = codecs.open(bat_name, 'w', 'shift-jis')
        fname.write(cmd)
        fname.close()
        result = subprocess.run(bat_name, shell=False)
        if result.returncode != 0:
            QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufの作成に失敗しました。（ogrmerge.py）')
            return
        else:
            QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufを作成しました。（ogrmerge.py）')
        if os.path.exists(bat_name):
            os.remove(bat_name)

        # レイヤに追加＆スタイル適用
        if self.check_xml_8.isChecked():
            try:
                layer = QgsVectorLayer(fgb_name, fgb_name, 'ogr')
                QgsProject.instance().addMapLayer(layer)
                if fgb_name[-10:] != "daihyo.fgb":
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon.qml')
                else:
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_point.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_point.qml')
            except:
                pass


    # PMTiles作成ウィンドウを開く
    def pButton_pmtiles1(self):
        self.scrollArea2.move(7, 120)
        self.scrollArea2.show()


    # PMTiles作成ウィンドウを閉じる
    def pButton_pmtiles2(self):
        self.scrollArea2.hide()


    # 変換元による振分
    def go_pmtiles(self):
        if self.radioButton_pm_1.isChecked() or self.radioButton_pm_2.isChecked():
            self.pButton_pmtiles3()
        elif self.radioButton_pm_3.isChecked():
            self.pButton_renzoku()
        elif self.radioButton_pm_4.isChecked() or self.radioButton_pm_5.isChecked:
            self.radioButton_kaitou3.setChecked(True)
            self.pButton_renzoku2()


    # 追加オプション設定
    def pButton_options(self):
        self.radioButton_layer_2.setChecked(True)
        if self.checkBox_pointonsurface.isChecked():
            self.pm_op_8.setText("-x 座標系 -x 市区町村名 -x 大字名 -x 丁目名 -x 小字名 -x 予備名 -x 精度区分 -x 座標値種別 -x 測地系判別 -x 地図番号 -x 地図XMLファイル")
        else:
            self.pm_op_8.setText("")


    # moj_map or chiban
    def select_layers(self):
        if self.radioButton_layer_1.isChecked():
            self.checkBox_pointonsurface.setChecked(False)
            self.pm_op_8.setText("")
        else:
            if self.checkBox_pointonsurface.isChecked():
                self.pm_op_8.setText("-x 座標系 -x 市区町村名 -x 大字名 -x 丁目名 -x 小字名 -x 予備名 -x 精度区分 -x 座標値種別 -x 測地系判別 -x 地図番号 -x 地図XMLファイル")


    # PMTiles作成（フォルダ内にある全てのFlatGeobuf又はGeoJSONが対象）
    def pButton_pmtiles3(self):
        if self.pm_ubuntu.text() == "" or self.pm_op_1.text() == "":
            return
        if self.radioButton_layer_1.isChecked():
             if self.pm_op_1.text() == "" or self.pm_op_2.text() == "" or self.pm_op_3.text() == "":
                 return
        if self.radioButton_layer_2.isChecked():
             if self.pm_op_5.text() == "" or self.pm_op_6.text() == "" or self.pm_op_7.text() == "":
                 return
        if self.pm_op_4.text() == "":
            return

        self.lineEdit_tippecanoe.setText("")
        default_dir = ""

        flag = 0
        if self.radioButton_pm_1.isChecked() and self.radioButton_layer_2.isChecked() and self.checkBox_pointonsurface.isChecked():# FlatGeobufから
            flag = 1
        if flag == 0:
            if self.radioButton_pm_1.isChecked():
                dirname = QFileDialog.getExistingDirectory(None, "FlatGeobufのあるフォルダを選択してください。", default_dir)
                if dirname == '' or dirname == None:
                    return
            else:
                dirname = QFileDialog.getExistingDirectory(None, "GeoJSONのあるフォルダを選択してください。", default_dir)
            if dirname == '' or dirname == None:
                return
        else:
            filter = "FlatGeobufファイル (*.fgb)"
            src_name, _ = QFileDialog.getOpenFileName(None, "FlatGeobufファイル（Polygon）を選択してください。", default_dir, filter)
            dirname = os.path.dirname(src_name)
            file_name = os.path.basename(src_name).split('.')[0]
            result = qgis.processing.run("native:pointonsurface", { 'ALL_PARTS' : False, 'INPUT' : src_name, 'OUTPUT' : dirname + "/" + file_name + "_pointonsurface.fgb" })

        # 同名のファイルがある場合は削除する
        if os.path.exists(dirname + "/" + self.pm_op_4.text() + ".pmtiles"):
            os.remove(dirname + "/" + self.pm_op_4.text() + ".pmtiles")

        dirname = ("/mnt/" + dirname.replace(":", "").replace("\\", "/")).lower()

        if self.pm_op_8.text() != "":
            op8 = self.pm_op_8.text() + " "
        else:
            op8 = ""
        if flag == 0:
            if self.radioButton_pm_1.isChecked():
                if self.radioButton_layer_1.isChecked():
                    cmd = "tippecanoe -l " + self.pm_op_1.text() + " -rg -z" + self.pm_op_2.text() + " -Z" + self.pm_op_3.text() + " " + op8 + "--force drop-densest-as-needed --no-tile-size-limit -o " + dirname + "/" + self.pm_op_4.text() + ".pmtiles " + dirname + "/*.fgb"
                else:
                    cmd = "tippecanoe -l " + self.pm_op_5.text() + " -rg -z" + self.pm_op_6.text() + " -Z" + self.pm_op_7.text() + " " + op8 + "--force drop-densest-as-needed --no-tile-size-limit -o " + dirname + "/" + self.pm_op_4.text() + ".pmtiles " + dirname + "/*.fgb"
            else:
                if self.radioButton_layer_1.isChecked():
                    cmd = "tippecanoe -l " + self.pm_op_1.text() + " -rg -z" + self.pm_op_2.text() + " -Z" + self.pm_op_3.text() + " " + op8 + "--force drop-densest-as-needed --no-tile-size-limit -o " + dirname + "/" + self.pm_op_4.text() + ".pmtiles " + dirname + "/*.geojson"
                else:
                    cmd = "tippecanoe -l " + self.pm_op_5.text() + " -rg -z" + self.pm_op_6.text() + " -Z" + self.pm_op_7.text() + " " + op8 + "--force drop-densest-as-needed --no-tile-size-limit -o " + dirname + "/" + self.pm_op_4.text() + ".pmtiles " + dirname + "/*.geojson"
            command = "wsl -d " + self.pm_ubuntu.text() + " " + cmd
            self.lineEdit_tippecanoe.setText(command)
            subprocess.run(command, shell=False)
        else:
            cmd = "tippecanoe -l " + self.pm_op_5.text() + " -rg -z" + self.pm_op_6.text() + " -Z" + self.pm_op_7.text() + " " + op8 + "--force drop-densest-as-needed --no-tile-size-limit -o " + dirname + "/" + self.pm_op_4.text() + ".pmtiles " + dirname + "/" + file_name + "_pointonsurface.fgb"
            command = "wsl -d " + self.pm_ubuntu.text() + " " + cmd
            self.lineEdit_tippecanoe.setText(command)
            subprocess.run(command, shell=False)


    # 代表点ファイル作成（ファイルから）
    def pButton_daihyo(self):
        default_dir = ""
        filter = "FlatGeobufファイル (*.fgb);;GeoJSONファイル (*.geojson)"
        src_name, _ = QFileDialog.getOpenFileName(None, "FlatGeobuf又はGeoJSONファイルを選択してください。", default_dir, filter)
        if src_name == '' or src_name == None:
            return
        folder_name = os.path.dirname(src_name)
        file_name = os.path.basename(src_name).split('.')[0]
        os.chdir(folder_name)
        try:
            layer = QgsVectorLayer(src_name, src_name, 'ogr')
            crs = layer.crs()                      # ソースファイルの座標参照系を取得
            EPSG = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得
            dst_name, _ = QFileDialog.getSaveFileName(None, "代表点ファイルを保存", folder_name + "/" + file_name + "_point_on_surface.geojson", "GeoJSON (*.geojson)")
            if dst_name == '' or dst_name == None:
                return
            dst_name2 = folder_name + "/" + file_name + "_point_on_surface.sim"
            folder_name = os.path.dirname(dst_name)
            file_name = os.path.basename(dst_name).split('.')[0]
            if os.path.exists(dst_name):
                os.remove(dst_name)
            if dst_name:
                if self.check_sima.isChecked():
                    sim = "G00,03,,\n"
                    sim = sim + "Z00, /* Digitixer3 */,\n"
                    sim = sim + "A00,\n"
                    n = 1
                daihyo_text = '{"type":"FeatureCollection","name":"daihyo","crs": {"type": "name","properties": {"name": "urn:ogc:def:crs:EPSG::' + EPSG + '"}},"features": ['
                features = layer.getFeatures()
                for feature in features:
                    geom = feature.geometry()
                    if geom.type() == QgsWkbTypes.PolygonGeometry:
                        #centroid = geom.centroid().asPoint()
                        centroid = geom.pointOnSurface().asPoint()
                        try:
                            centroid_x = str(centroid.x())
                            centroid_y = str(centroid.y())
                            #daihyo_text = daihyo_text + '{"type": "Feature","properties": {"地番": "' + feature["地番"] + '","X座標":"' + centroid_y + '", "Y座標":"' + centroid_x + '"},"geometry": {"type": "Point","coordinates": [' + centroid_x + ',' + centroid_y + ']}},'
                            daihyo_text = daihyo_text + '{"type": "Feature","properties": {"地番": "' + feature["地番"] + '"},"geometry": {"type": "Point","coordinates": [' + centroid_x + ',' + centroid_y + ']}},'
                            if self.check_sima.isChecked():
                                sim = sim + 'A01,' + str(n) + ',' + feature["地番"] + ',' + centroid_y + ',' + centroid_x + ',,\n'
                                n = n + 1
                        except:
                            pass
                daihyo_text = daihyo_text[:-1]
                daihyo_text = daihyo_text + ']}'
                with open(dst_name, 'w', encoding='utf-8') as f:
                    f.write(daihyo_text)
                    f.close()
                if self.check_sima.isChecked():
                    sim = sim + 'A99,'
                    with open(dst_name2, 'w', encoding='shift-jis') as f:
                        f.write(sim)
                        f.close()
                # FlatGeobuf作成
                if self.check_xml_7.isChecked():
                    if os.path.exists( folder_name + "/" + file_name + ".fgb"):
                        os.remove( folder_name + "/" + file_name + ".fgb")
                    python_path = self.python_path.text().replace("/python.exe", "").replace("/python3.exe", "")
                    epsg = "-t_srs EPSG:" + EPSG
                    fgb_name = folder_name + "/" + file_name + ".fgb"
                    cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures " + epsg + " -o " + '"' + fgb_name + '" "' + dst_name + '"' + "\n"
                    #cmd = cmd + "pause"
                    bat_name = os.path.dirname(__file__) + u'/work/fgb.bat'
                    fname = codecs.open(bat_name, 'w', 'shift-jis')
                    fname.write(cmd)
                    fname.close()
                    result = subprocess.run(bat_name, shell=False)
                    if result.returncode != 0:
                        QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufの作成に失敗しました。（ogrmerge.py）')
                        return
                    if os.path.exists(bat_name):
                        os.remove(bat_name)
                # レイヤに追加＆スタイル適用
                if self.check_xml_8.isChecked():
                    try:
                        layer_name = "代表点"
                        if self.check_xml_7.isChecked():
                            layer = QgsVectorLayer(fgb_name, layer_name, "ogr")
                        else:
                            layer = QgsVectorLayer(dst_name, layer_name, "ogr")
                        if layer.isValid():
                            QgsProject.instance().addMapLayer(layer)
                            if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_point2.qml'):
                                layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_point2.qml')
                    except:
                        pass
                else:
                    if self.check_xml_7.isChecked():
                       if os.path.exists(fgb_name):
                           QMessageBox.information(self, '代表点ファイル作成', u'GeoJSONファイルとFlatGeobufファイルを作成しました。')
                    else:
                       if os.path.exists(dst_name):
                           QMessageBox.information(self, '代表点ファイル作成', u'GeoJSONファイルを作成しました。')
        except:
            pass

    # 代表点ファイル作成（レイヤから）
    def pButton_daihyo2(self):
        try:
            layer = qgis.utils.iface.activeLayer() # アクティブなレイヤを取得
            crs = layer.crs()                      # レイヤの座標参照系を取得
            EPSG = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得
            dst_name, _ = QFileDialog.getSaveFileName(None, "代表点ファイルを保存", "point_surface.geojson", "GeoJSON (*.geojson)")
            if dst_name == '' or dst_name == None:
                return
            dst_name2 = "point_on_surface.sim"
            folder_name = os.path.dirname(dst_name)
            file_name = os.path.basename(dst_name).split('.')[0]
            if os.path.exists(dst_name):
                os.remove(dst_name)
            if self.check_sima.isChecked():
                sim = "G00,03,,\n"
                sim = sim + "Z00, /* Digitixer3 */,\n"
                sim = sim + "A00,\n"
                n = 1
            daihyo_text = '{"type":"FeatureCollection","name":"daihyo","crs": {"type": "name","properties": {"name": "urn:ogc:def:crs:EPSG::' + EPSG + '"}},"features": ['
            features = layer.getFeatures()
            for feature in features:
                geom = feature.geometry()
                if geom.type() == QgsWkbTypes.PolygonGeometry:
                    #centroid = geom.centroid().asPoint()
                    centroid = geom.pointOnSurface().asPoint()
                    try:
                        centroid_x = str(centroid.x())
                        centroid_y = str(centroid.y())
                        daihyo_text = daihyo_text + '{"type": "Feature","properties": {"point": "' + feature["地番"] + '"},"geometry": {"type": "Point","coordinates": [' + centroid_x + ',' + centroid_y + ']}},'
                        if self.check_sima.isChecked():
                            sim = sim + 'A01,' + str(n) + ',' + feature["地番"] + ',' + centroid_y + ',' + centroid_x + ',,\n'
                            n = n + 1
                    except:
                        pass
            daihyo_text = daihyo_text[:-1]
            daihyo_text = daihyo_text + ']}'
            with open(dst_name, 'w', encoding='utf-8') as f:
                f.write(daihyo_text)
                f.close()
            if self.check_sima.isChecked():
                sim = sim + 'A99,'
                with open(dst_name2, 'w', encoding='shift-jis') as f:
                    f.write(sim)
                    f.close()
            # FlatGeobuf作成
            if self.check_xml_7.isChecked():
                if os.path.exists( folder_name + "/" + file_name + ".fgb"):
                    os.remove( folder_name + "/" + file_name + ".fgb")
                python_path = self.python_path.text().replace("/python.exe", "").replace("/python3.exe", "")
                epsg = "-t_srs EPSG:" + EPSG
                fgb_name = folder_name + "/" + file_name + ".fgb"
                cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures " + epsg + " -o " + '"' + fgb_name + '" "' + dst_name + '"' + "\n"
                #cmd = cmd + "pause"
                bat_name = os.path.dirname(__file__) + u'/work/fgb.bat'
                fname = codecs.open(bat_name, 'w', 'shift-jis')
                fname.write(cmd)
                fname.close()
                result = subprocess.run(bat_name, shell=False)
                if result.returncode != 0:
                    QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufの作成に失敗しました。（ogrmerge.py）')
                    return
                if os.path.exists(bat_name):
                    os.remove(bat_name)
            # レイヤに追加＆スタイル適用
            if self.check_xml_8.isChecked():
                try:
                    layer_name = "代表点"
                    if self.check_xml_7.isChecked():
                        layer = QgsVectorLayer(fgb_name, layer_name, "ogr")
                    else:
                        layer = QgsVectorLayer(dst_name, layer_name, "ogr")
                    if layer.isValid():
                        QgsProject.instance().addMapLayer(layer)
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_point.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_point.qml')
                except:
                    pass
            else:
                if self.check_xml_7.isChecked():
                   if os.path.exists(fgb_name):
                       QMessageBox.information(self, '代表点ファイル作成', u'GeoJSONファイルとFlatGeobufファイルを作成しました。')
                else:
                   if os.path.exists(dst_name):
                       QMessageBox.information(self, '代表点ファイル作成', u'GeoJSONファイルを作成しました。')
        except:
            pass

    # xml/zip→pmtiles
    def pButton_renzoku(self):
        # →FLatGeobuf
        if self.python_path.text() == "":
            QMessageBox.information(self, u'設定', u'QGIS附属のpython.exeのパスが設定されていません。\n次のウィンドウでpython.exeを選択してください。')
            self.pButton_python()
            return
        if not os.path.exists(self.python_path.text()):
            QMessageBox.information(self, u'設定', u'python.exeのパスが無効です。\n次のウィンドウでQGIS附属のpython.exeを選択してください。')
            self.pButton_python()
            return
        if self.python_path.text() == "":
            QMessageBox.information(self, u'設定', u'QGIS附属のpython.exeのパスが設定されていません。\n次のウィンドウでpython.exeを選択してください。')
            self.pButton_python()
            return
        if self.mojxml2geojson_folder.text() == "":
            QMessageBox.information(self, u'設定', u'mojxml2geojsonのパスが設定されていません。\n次のウィンドウでmojxml2geojsonのフォルダを選択してください。')
            self.pButton_folder()
            return
        if not os.path.exists(self.mojxml2geojson_folder.text()):
            QMessageBox.information(self, u'設定', u'mojxml2geojsonのパスが無効です。\n次のウィンドウでmojxml2geojsonのフォルダを選択してください。')
            self.pButton_folder()
            return

        # →PMTiles
        if self.pm_ubuntu.text() == "":
            QMessageBox.information(self, u'設定', u'「Ubuntu」のバージョンが設定されていません。\n処理を中止します。')
            return
        if self.pm_op_1.text() == "":
            QMessageBox.information(self, u'設定', u'「区画」のレイヤ名が設定されていません。\n処理を中止します。')
            return
        if self.pm_op_2.text() == "":
            QMessageBox.information(self, u'設定', u'「区画」の最大ズームが設定されていません。\n処理を中止します。')
            return
        if self.pm_op_3.text() == "":
            QMessageBox.information(self, u'設定', u'「区画」の最小ズームが設定されていません。\n処理を中止します。')
            return
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab":
            if self.pm_op_5.text() == "":
                QMessageBox.information(self, u'設定', u'「地番」のレイヤ名が設定されていません。\n処理を中止します。')
                return
            if self.pm_op_6.text() == "":
                QMessageBox.information(self, u'設定', u'「地番」の最大ズームが設定されていません。\n処理を中止します。')
                return
            if self.pm_op_7.text() == "":
                QMessageBox.information(self, u'設定', u'「地番」の最小ズームが設定されていません。\n処理を中止します。')
                return

        if self.pm_op_4.text() == "":
                QMessageBox.information(self, u'設定', u'保存ファイル名が設定されていません。\n処理を中止します。')
                return

        filter = "ZIPファイル (*.zip);;XMLファイル (*.xml)"
        default_dir = ""
        filename, _ = QFileDialog.getOpenFileName(None, "XML/ZIPファイルを選択してください。", default_dir, filter)
        if filename == '' or filename == None:
            return
        filepath, ext = os.path.splitext(filename)
        dirname = os.path.dirname(filepath)
        fgb_name = self.pm_op_4.text()

        if filename[-4:].lower() == ".zip":
            dirname = QFileDialog.getExistingDirectory(None, "空の保存先フォルダを選択してください。", filepath)
            if dirname == '' or dirname == None:
                return
            files = os.listdir(dirname)
            if len(files) != 0:
                QMessageBox.information(self, u'エラー', u'保存先として指定されたフォルダは空ではありません。\n処理を中止します。')
                return
            # zipの場合は解凍する
            shutil.unpack_archive(filename, dirname)
            for file in os.listdir(dirname):
                if file.endswith('.zip'):
                    shutil.unpack_archive(dirname + "/" + file, dirname)

        # オプション設定
        if self.check_xml_1.isChecked():
            op1 = " -e"
        else:
            op1 = ""
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab":
            if self.check_xml_2.isChecked():
                op2 = " -u"
            else:
                op2 = ""
            if self.check_xml_3.isChecked():
                op3 = " -t"
            else:
                op3 = ""
            if self.check_xml_4.isChecked():
                op4 = " -d"
            else:
                op4 = ""
            if self.check_xml_5.isChecked():
                op5 = " -x"
            else:
                op5 = ""
            if self.check_xml_6.isChecked():
                op6 = " -c"
            else:
                op6 = ""
        else:
            op2 = ""
            op3 = ""
            op4 = ""
            op5 = ""
            op6 = ""

        bat_name = self.mojxml2geojson_folder.text() + "/run.bat"
        python_path = self.python_path.text().replace("/python.exe", "").replace("/python3.exe", "")
        cmd = "cd " + self.mojxml2geojson_folder.text()[:2] + "\n"
        cmd = cmd + "cd " + self.mojxml2geojson_folder.text() + "\n"
        if filename[-4:] == ".zip":
            for file in os.listdir(dirname):
                if file.endswith('.xml'):
                    if "qgis" in python_path.lower():
                        cmd = cmd + '"' + python_path + "/Scripts/mojxml2geojson.exe" + '"' + op1 + op2 + op3 + op4 + op5 + op6 + ' "' + dirname + '/' + file + '"\n'
                    else:
                        cmd = cmd + "mojxml2geojson" + op1 + op2 + op3 + op4 + op5 + op6 + ' "' + dirname + '/' + file + '"\n'
        else:
            if "qgis" in python_path.lower():
                cmd = '"' + python_path + "/Scripts/mojxml2geojson" + '"' + op1 + op2 + op3 + op4 + op5 + op6 + ' "' + filename + '"\n'
            else:
                cmd = "mojxml2geojson" + op1 + op2 + op3 + op4 + op5 + op6 + ' "' + filename + '"\n'
        fname = codecs.open(bat_name, 'w', 'shift-jis')
        fname.write(cmd)
        fname.close()
        result = subprocess.run(bat_name, shell=False)
        if result.returncode != 0:
            QMessageBox.information(self, u'地図XML→GeoJSON変換', u'変換に失敗しました。（mojxml2geojson）')
            return

        # 代表点フォルダ作成＆既存ファイル削除
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab" and self.check_xml_4.isChecked():
            dirname2 = dirname + "/daihyo"
            if not os.path.exists(dirname2):
                os.mkdir(dirname2)
            for file in os.listdir(dirname):
                if file[-15:] == ".daihyo.geojson":
                    if os.path.exists(dirname2 + "/" + file):
                        os.remove(dirname2 + "/" + file)
                    shutil.move(dirname + "/" + file, dirname2)
            if os.path.exists(bat_name):
                os.remove(bat_name)

        # FlatGeobuf作成
        if not self.check_xml_6.isChecked():
            fgb1 = dirname + "/" + fgb_name + ".fgb"
            if os.path.exists(fgb1):
                os.remove(fgb1)
            self.check_xml_9.setChecked(True)
            cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures -t_srs EPSG:4326 -o " + '"' + fgb1 + '" "' + dirname + "/*.geojson" + '"' + "\n"
            bat_name = self.mojxml2geojson_folder.text() + "/fgb.bat"
            fname = codecs.open(bat_name, 'w', 'shift-jis')
            fname.write(cmd)
            fname.close()
            result = subprocess.run(bat_name, shell=False)
            if result.returncode != 0:
                QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufの作成に失敗しました。（ogrmerge.py）')
                return
            # レイヤに追加＆スタイル適用
            if self.check_xml_8.isChecked():
                try:
                    layer = QgsVectorLayer(fgb1, self.pm_op_4.text() + '_kukaku', 'ogr')
                    QgsProject.instance().addMapLayer(layer)
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon.qml')
                except:
                    pass
                crs = layer.crs()
                epsg = str(crs.postgisSrid())
                new_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
                QgsProject.instance().setCrs(new_crs)
                self.set_Combo()

        # K'z lab版の場合は、代表点ファイル作成
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab" and self.check_xml_4.isChecked():
            fgb2 = dirname2 + "/" + fgb_name + ".fgb"
            if os.path.exists(fgb2):
                os.remove(fgb2)
            self.check_xml_9.setChecked(True)
            cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures -t_srs EPSG:4326 -o " + '"' + fgb2 + '" "' + dirname2 + "/*.geojson" + '"' + "\n"
            bat_name = self.mojxml2geojson_folder.text() + "/fgb.bat"
            fname = codecs.open(bat_name, 'w', 'shift-jis')
            fname.write(cmd)
            fname.close()
            result = subprocess.run(bat_name, shell=False)
            if result.returncode != 0:
                QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'代表点のFlatGeobufの作成に失敗しました。（ogrmerge.py）')
                return
            if os.path.exists(bat_name):
                os.remove(bat_name)
            # レイヤに追加＆スタイル適用
            if self.check_xml_8.isChecked():
                try:
                    layer2 = QgsVectorLayer(fgb2, self.pm_op_4.text() + '_chiban', 'ogr')
                    QgsProject.instance().addMapLayer(layer2)
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_point.qml'):
                        layer2.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_point.qml')
                except:
                    pass
                crs = layer2.crs()
                epsg = str(crs.postgisSrid())
                new_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
                QgsProject.instance().setCrs(new_crs)
                self.set_Combo()

        # PMTiles作成
        self.lineEdit_tippecanoe.setText("")
        if os.path.exists(dirname + "/" + fgb_name + ".pmtiles"):
            os.remove(dirname + "/" + fgb_name + ".pmtiles")

        dirname = ("/mnt/" + dirname.replace(":", "").replace("\\", "/")).lower()

        if self.pm_op_8.text() != "":
            op8 = self.pm_op_8.text()
        else:
            op8 = ""
        if not self.check_xml_6.isChecked():
            cmd = "tippecanoe -l " + self.pm_op_1.text() + " -rg -z" + self.pm_op_2.text() + " -Z" + self.pm_op_3.text() + " " + op8 + " --force drop-densest-as-needed --no-tile-size-limit -o " + dirname + "/" + fgb_name + ".pmtiles " + dirname + "/*.fgb"
            command = "wsl -d " + self.pm_ubuntu.text() + " " + cmd
            os.system(command)

        # K'z lab版の場合は、代表点ファイル作成
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab" and self.check_xml_4.isChecked():
            if os.path.exists(dirname2 + "/" + fgb_name + ".pmtiles"):
                os.remove(dirname2 + "/" + fgb_name + ".pmtiles")
            dirname2 = ("/mnt/" + dirname2.replace(":", "").replace("\\", "/")).lower()
            cmd = "tippecanoe -l " + self.pm_op_5.text() + " -rg -z" + self.pm_op_6.text() + " -Z" + self.pm_op_7.text() + " " + op8 + " --force drop-densest-as-needed --no-tile-size-limit -o " + dirname2 + "/" + fgb_name + ".pmtiles " + dirname2 + "/*.fgb"
            command = "wsl -d " + self.pm_ubuntu.text() + " " + cmd
            os.system(command)


    # zip→geojson→fgb→pmtiles／xml→geojson→fgb→pmtiles
    def pButton_renzoku2(self):
        # →FLatGeobuf
        if self.python_path.text() == "":
            QMessageBox.information(self, u'設定', u'QGIS附属のpython.exeのパスが設定されていません。\n次のウィンドウでpython.exeを選択してください。')
            self.pButton_python()
            return
        if not os.path.exists(self.python_path.text()):
            QMessageBox.information(self, u'設定', u'python.exeのパスが無効です。\n次のウィンドウでQGIS附属のpython.exeを選択してください。')
            self.pButton_python()
            return
        if self.python_path.text() == "":
            QMessageBox.information(self, u'設定', u'QGIS附属のpython.exeのパスが設定されていません。\n次のウィンドウでpython.exeを選択してください。')
            self.pButton_python()
            return
        if self.mojxml2geojson_folder.text() == "":
            QMessageBox.information(self, u'設定', u'mojxml2geojsonのパスが設定されていません。\n次のウィンドウでmojxml2geojsonのフォルダを選択してください。')
            self.pButton_folder()
            return
        if not os.path.exists(self.mojxml2geojson_folder.text()):
            QMessageBox.information(self, u'設定', u'mojxml2geojsonのパスが無効です。\n次のウィンドウでmojxml2geojsonのフォルダを選択してください。')
            self.pButton_folder()
            return

        # →PMTiles
        if self.pm_ubuntu.text() == "":
            QMessageBox.information(self, u'設定', u'「Ubuntu」のバージョンが設定されていません。\n処理を中止します。')
            return
        if self.pm_op_1.text() == "":
            QMessageBox.information(self, u'設定', u'「区画」のレイヤ名が設定されていません。\n処理を中止します。')
            return
        if self.pm_op_2.text() == "":
            QMessageBox.information(self, u'設定', u'「区画」の最大ズームが設定されていません。\n処理を中止します。')
            return
        if self.pm_op_3.text() == "":
            QMessageBox.information(self, u'設定', u'「区画」の最小ズームが設定されていません。\n処理を中止します。')
            return
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab":
            if self.pm_op_5.text() == "":
                QMessageBox.information(self, u'設定', u'「地番」のレイヤ名が設定されていません。\n処理を中止します。')
                return
            if self.pm_op_6.text() == "":
                QMessageBox.information(self, u'設定', u'「地番」の最大ズームが設定されていません。\n処理を中止します。')
                return
            if self.pm_op_7.text() == "":
                QMessageBox.information(self, u'設定', u'「地番」の最小ズームが設定されていません。\n処理を中止します。')
                return

        if self.pm_op_4.text() == "":
                QMessageBox.information(self, u'設定', u'保存ファイル名が設定されていません。\n処理を中止します。')
                return

        default_dir = ""
        if self.radioButton_pm_4.isChecked():
            src_folder = QFileDialog.getExistingDirectory(None, "ZIPファイルのあるフォルダを選択してください。", default_dir)
            if src_folder == '' or src_folder == None:
                return
            zip_count = 0
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    zip_count = zip_count + 1
            if zip_count == 0:
                QMessageBox.information(self, u'エラー', u'指定のファルダ内にzipファイルがありません。')
                return
            dst_folder = src_folder + '/' + 'zip2'
            if not os.path.exists(dst_folder):
                os.mkdir(dst_folder)
            self.progressBar2.setMinimum(0)
            self.progressBar2.setMaximum(zip_count)
            self.progressBar2.setValue(0)
            n = 0
            self.progressBar2.setFormat("一次解凍 ...　%v / %m")
            files = os.listdir(src_folder)
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    n = n + 1
                    shutil.unpack_archive(src_folder + "/" + file, dst_folder)
                    pythoncom.PumpWaitingMessages()
                    self.progressBar2.setValue(n)
            row_count = self.listWidget_kensaku.count()
            dst_folder2 = src_folder + '/' + 'xml'
            src_folder = dst_folder
            if not os.path.exists(dst_folder2):
                os.mkdir(dst_folder2)
            zip_count = 0
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    zip_count = zip_count + 1
            if zip_count == 0:
                QMessageBox.information(self, u'エラー', u'指定のファルダ内にzipファイルはありません。')
                return
            self.progressBar2.setMinimum(0)
            self.progressBar2.setMaximum(zip_count)
            self.progressBar2.setValue(0)
            files = os.listdir(src_folder)
            n = 0
            self.progressBar2.setFormat("二次解凍 ...　%v / %m")
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    code = os.path.basename(file)[0 : 5]
                    n = n + 1
                    shutil.unpack_archive(src_folder + "/" + file, dst_folder2)
                    pythoncom.PumpWaitingMessages()
                    self.progressBar2.setValue(n)
                    for i in range(row_count):
                       dat = self.listWidget_kensaku.item(i).text().split(',')
                       if dat[1] == code:
                           self.lineEdit_city2.setText(dat[0])
                           break
            dirname = dst_folder2
            self.progressBar2.setFormat(u"解凍完了 ...　%v / %m")

        elif self.radioButton_pm_5.isChecked():

            src_folder = QFileDialog.getExistingDirectory(None, "地図XMLファイルのあるフォルダを選択してください。", default_dir)
            if src_folder == '' or src_folder == None:
                return
            xml_count = 0
            for file in os.listdir(src_folder):
                if file.lower().endswith('.xml'):
                    xml_count = xml_count + 1
            if xml_count == 0:
                QMessageBox.information(self, u'エラー', u'指定のファルダ内に地図XMLファイルがありません。')
                return
            dirname = src_folder

        # オプション設定
        if self.check_xml_1.isChecked():
            op1 = " -e"
        else:
            op1 = ""
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab":
            if self.check_xml_2.isChecked():
                op2 = " -u"
            else:
                op2 = ""
            if self.check_xml_3.isChecked():
                op3 = " -t"
            else:
                op3 = ""
            if self.check_xml_4.isChecked():
                op4 = " -d"
            else:
                op4 = ""
            if self.check_xml_5.isChecked():
                op5 = " -x"
            else:
                op5 = ""
            if self.check_xml_6.isChecked():
                op6 = " -c"
            else:
                op6 = ""
        else:
            op2 = ""
            op3 = ""
            op4 = ""
            op5 = ""
            op6 = ""

        cmd = "cd " + self.mojxml2geojson_folder.text()[:2] + "\n"
        cmd = cmd + "cd " + self.mojxml2geojson_folder.text() + "\n"
        bat_name = self.mojxml2geojson_folder.text() + "/run.bat"
        python_path = self.python_path.text().replace("/python.exe", "").replace("/python3.exe", "")
        for file in os.listdir(dirname):
            if file.endswith('.xml'):
                cmd = cmd + "mojxml2geojson" + op1 + op2 + op3 + op4 + op5 + op6 + " " + dirname + "/" + file + "\n"
        fname = codecs.open(bat_name, 'w', 'shift-jis')
        fname.write(cmd)
        fname.close()
        result = subprocess.run(bat_name, shell=False)
        if result.returncode != 0:
            QMessageBox.information(self, u'地図XML→GeoJSON変換', u'変換に失敗しました。（mojxml2geojson）')
            return

        # 代表点フォルダ作成＆既存ファイル削除
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab" and self.check_xml_4.isChecked():
            dirname2 = dirname + "/daihyo"
            if not os.path.exists(dirname2):
                os.mkdir(dirname2)
            for file in os.listdir(dirname):
                if file[-15:] == ".daihyo.geojson":
                    if os.path.exists(dirname2 + "/" + file):
                        os.remove(dirname2 + "/" + file)
                    shutil.move(dirname + "/" + file, dirname2)
            if os.path.exists(bat_name):
                os.remove(bat_name)

        # FlatGeobuf作成
        if not self.check_xml_6.isChecked():
            self.check_xml_9.setChecked(True)
            fgb = dirname + "/" + self.pm_op_4.text() + ".fgb"
            if os.path.exists(fgb):
                os.remove(fgb)
            self.check_xml_9.setChecked(True)
            cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures -t_srs EPSG:4326 -o " + '"' + fgb + '" "' + dirname + "/*.geojson" + '"' + "\n"
            bat_name = self.mojxml2geojson_folder.text() + "/fgb.bat"
            fname = codecs.open(bat_name, 'w', 'shift-jis')
            fname.write(cmd)
            fname.close()
            result = subprocess.run(bat_name, shell=False)
            if result.returncode != 0:
                QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufの作成に失敗しました。（ogrmerge.py）')
                return
            if os.path.exists(bat_name):
                os.remove(bat_name)
            # レイヤに追加＆スタイル適用
            if self.check_xml_8.isChecked():
                try:
                    layer = QgsVectorLayer(fgb, self.pm_op_4.text() + '_kukaku', 'ogr')
                    QgsProject.instance().addMapLayer(layer)
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon.qml')
                except:
                    pass
                crs = layer.crs()
                epsg = str(crs.postgisSrid())
                new_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
                QgsProject.instance().setCrs(new_crs)
                self.set_Combo()

        # K'z lab版の場合は、代表点ファイル作成
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab" and self.check_xml_4.isChecked():
            fgb2 = dirname2 + "/" + self.pm_op_4.text() + ".fgb"
            if os.path.exists(fgb2):
                os.remove(fgb2)
            self.check_xml_9.setChecked(True)
            cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures -t_srs EPSG:4326 -o " + '"' + fgb2 + '" "' + dirname2 + "/*.geojson" + '"' + "\n"
            bat_name = self.mojxml2geojson_folder.text() + "/fgb.bat"
            fname = codecs.open(bat_name, 'w', 'shift-jis')
            fname.write(cmd)
            fname.close()
            result = subprocess.run(bat_name, shell=False)
            if result.returncode != 0:
                QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'代表点のFlatGeobufの作成に失敗しました。（ogrmerge.py）')
                return
            if os.path.exists(bat_name):
                os.remove(bat_name)
            # レイヤに追加＆スタイル適用
            if self.check_xml_8.isChecked():
                try:
                    layer2 = QgsVectorLayer(fgb2, self.pm_op_4.text() + '_chiban', 'ogr')
                    QgsProject.instance().addMapLayer(layer2)
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_point.qml'):
                        layer2.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_point.qml')
                except:
                    pass
                crs = layer2.crs()
                epsg = str(crs.postgisSrid())
                new_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
                QgsProject.instance().setCrs(new_crs)
                self.set_Combo()

        # PMTiles作成
        # 同名のファイルがある場合は削除する
        if os.path.exists(dirname + "/" + self.pm_op_4.text() + ".pmtiles"):
            os.remove(dirname + "/" + self.pm_op_4.text() + ".pmtiles")
        dirname = ("/mnt/" + dirname.replace(":", "").replace("\\", "/")).lower()
        if self.pm_op_8.text() != "":
            op8 = self.pm_op_8.text() + " "
        else:
            op8 = ""

        if not self.check_xml_6.isChecked():
            cmd = "tippecanoe -l " + self.pm_op_1.text() + " -rg -z" + self.pm_op_2.text() + " -Z" + self.pm_op_3.text() + " " + op8 + "--force drop-densest-as-needed --no-tile-size-limit -o " + dirname + "/" + self.pm_op_4.text() + ".pmtiles " + dirname + "/" + self.pm_op_4.text() + ".fgb"
            command = "wsl -d " + self.pm_ubuntu.text() + " " + cmd
            self.lineEdit_tippecanoe.setText(command)
            subprocess.run(command, shell=False)

        # K'z lab版の場合は、代表点ファイル作成
        if self.mojxml2geojson_folder.text()[-6:] == "-kzlab" and self.check_xml_4.isChecked():
            if os.path.exists(dirname2 + "/" + self.pm_op_4.text() + ".pmtiles"):
                os.remove(dirname2 + "/" + self.pm_op_4.text() + ".pmtiles")
            dirname2 = ("/mnt/" + dirname2.replace(":", "").replace("\\", "/")).lower()
            cmd = "tippecanoe -l " + self.pm_op_5.text() + " -rg -z" + self.pm_op_6.text() + " -Z" + self.pm_op_7.text() + " " + op8 + " --force drop-densest-as-needed --no-tile-size-limit -o " + dirname2 + "/" + self.pm_op_4.text() + ".pmtiles " + dirname2 + "/*.fgb"
            command = "wsl -d " + self.pm_ubuntu.text() + " " + cmd
            os.system(command)


    # SIMA作成ウィンドウを開く
    def pButton_sima(self):
        try:
            layer = qgis.utils.iface.activeLayer()
            if layer.selectedFeatures():
                self.radioButton_SIMA2.setChecked(True)
            else:
                self.radioButton_SIMA1.setChecked(True)
        except:
            self.radioButton_SIMA3.setChecked(True)
        self.scrollArea4.move(7, 120)
        self.scrollArea4.show()


    # SIMA作成ウィンドウを閉じる
    def pButton_sima4(self):
        self.scrollArea4.hide()


    # SIMA作成実行
    def pButton_sima0(self):
        if self.radioButton_SIMA1.isChecked():    # アクティブレイヤの表示領域から
            self.pButton_sima1()
        elif  self.radioButton_SIMA2.isChecked(): # アクティブレイヤの選択地物から
            self.pButton_sima2()
        else:                                     # ファイルから
            self.pButton_sima3()


    # 地番区域・属性情報 取得
    def pButton_sima5(self):
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        if self.radioButton_SIMA3.isChecked(): # ファイルから
            default_dir = ""
            filter = "GeoJSON (*.geojson);;FlatGeobuf (*.fgb)"
            geojson_path, _ = QFileDialog.getOpenFileName(None, "GeoJSON/FlatGeobufファイルを選択してください。", default_dir, filter)
            #if not geojson_path:
            #    return
        else:                                  # レイヤから
            layer = qgis.utils.iface.activeLayer()
            geojson_path = (layer.dataProvider().dataSourceUri()).split('|')[0]

        tmp2_path = workPath + u'/tmp2.geojson'
        if os.path.exists(tmp2_path): 
            os.remove(tmp2_path)
        fgb2geojson_path = workPath + u'/fgb.geojson'
        if os.path.exists(fgb2geojson_path): 
            os.remove(fgb2geojson_path)
        self.lineEdit_src.setText('')
        self.lineEdit_src2.setText('')

        self.lineEdit_src2.setText('')
        ext = geojson_path[-4:].lower()
        if ext == '.fgb':
            self.lineEdit_src2.setText(geojson_path)
            bin_dir = self.lineEdit_bin.text()
            command = '"' + 'ogr2ogr.exe" ' + fgb2geojson_path + " " + geojson_path
            os.system(command)
            geojson_path = fgb2geojson_path
        self.lineEdit_src.setText(geojson_path)

        # 地番区域取得
        try:
            with open(geojson_path) as f:
                data = json.load(f)
            features = data['features']
            n = 1
            self.listWidget_address.clear()
            for feature in features:
                city = feature["properties"]["市区町村名"]
                oaza = feature["properties"]["大字名"]
                chome = feature["properties"]["丁目名"]
                koaza = feature["properties"]["小字名"]
                yobi = feature["properties"]["予備名"]
                chibankuiki = city + oaza + chome + koaza + yobi
                flag = 0
                count = self.listWidget_address.count()
                for i in range(count):
                    item = self.listWidget_address.item(i)
                    chibankuiki2 = item.text()
                    if chibankuiki == chibankuiki2:
                        flag = 1
                if flag == 0:
                    self.listWidget_address.addItem(chibankuiki)
        except:
            try:
                with open(geojson_path) as f:
                    data = json.load(f)
                features = data['features']
                n = 1
                self.listWidget_address.clear()
                for feature in features:
                    chibankuiki = feature["properties"]["地番区域"]
                    flag = 0
                    count = self.listWidget_address.count()
                    for i in range(count):
                        item = self.listWidget_address.item(i)
                        chibankuiki2 = item.text()
                        if chibankuiki == chibankuiki2:
                            flag = 1
                    if flag == 0:
                        self.listWidget_address.addItem(chibankuiki)
            except:
                QMessageBox.information(self, u'情報取得', u'地番区域情報の取得に失敗しました。')
                return

        # 属性取得
        with open(geojson_path) as f:
            data = json.load(f)
        features = data['features']
        n = 1
        self.listWidget_zokusei.clear()
        for feature in features:
            properties = feature['properties']
            for key in properties:
                if n == 1:
                   self.listWidget_zokusei.addItem(key)
            n = n + 1
            if n == 2:
                break


    # 抽出
    def pButton_sima6(self):
        try:
            layer = qgis.utils.iface.activeLayer()
            src_Layer_ID = layer.id()
            original_layer = QgsProject.instance().mapLayer(src_Layer_ID)
        except:
            pass
        geojson_path = self.lineEdit_src.text()
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        tmp1_path = workPath + u'/tmp1.geojson'
        tmp2_path = workPath + u'/tmp2.geojson'
        fgb_path = self.lineEdit_src2.text()
        if fgb_path == '':
            foldername = os.path.dirname(geojson_path)
            filename = os.path.basename(geojson_path).split('.')[0]
        else:
            foldername = os.path.dirname(fgb_path)
            filename = os.path.basename(fgb_path).split('.')[0]

        global Point_Layer_ID2
        item = self.listWidget_address.currentItem()
        if item is None:
            QMessageBox.information(self, '抽出', u'選択された地番区域がありません。\n処理を中止します。')
            return

        if self.checkBox_zokusei1.isChecked():
            row_count = self.listWidget_zokusei.count()
            for i in range(row_count):
                if self.listWidget_zokusei.item(i).text() == '地番区域':
                    self.checkBox_zokusei1.setChecked(False)
                    QMessageBox.information(self, 'エラー', u'データに、「地番区域」属性が、既に存在しています。\n処理を中止します。')
                    return

        if self.checkBox_zokusei2.isChecked():
            row_count = self.listWidget_zokusei.count()
            for i in range(row_count):
                if self.listWidget_zokusei.item(i).text() == '面積':
                    self.checkBox_zokusei2.setChecked(False)
                    QMessageBox.information(self, 'エラー', u'データに、「面積」属性が、既に存在しています。\n処理を中止します。')
                    return

        try:
            os.chdir(foldername)
        except:
            pass

        if self.checkBox_sima1.isChecked():    # GeoJSON/FlatGeobufで保存
            filter = "GeoJSON (*.geojson);;FlatGeobuf (*.fgb)"
            dst_path, ext = QFileDialog.getSaveFileName(None, "GeoJSON/FlatGeobufで保存", filename + "_selected.geojson", filter)
            if not dst_path:
                return
        else:
            sima_name, _ = QFileDialog.getSaveFileName(None, "SIMAファイルを保存", filename + "_selected.sim", "SIMA (*.sim)")
            folder_name = os.path.dirname(sima_name)
            file_name = os.path.basename(sima_name).split('.')[0]
            if not sima_name:
                return

        if not os.path.exists(tmp2_path):
            # 頂点抽出
            command = "qgis_process run native:extractvertices --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --geometryCheck=QgsFeatureRequest.GeometryNoCheck --INPUT=" + geojson_path + " --OUTPUT=" + tmp1_path
            os.system(command)
            # 不要な属性削除
            command = "qgis_process run native:deletecolumn --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --geometryCheck=QgsFeatureRequest.GeometryNoCheck --INPUT=" + tmp1_path + " --COLUMN=座標系 --COLUMN=精度区分 --COLUMN=座標値種別 --COLUMN=測地系判別 --COLUMN=縮尺分母 --COLUMN=地図番号 --COLUMN=地図XMLファイル --COLUMN=筆界未定構成筆 --COLUMN=筆界未定構成筆[地番] --COLUMN=所在 --COLUMN=代表点緯度／X座標 --COLUMN=代表点経度／Y座標 --COLUMN=地番区域 --COLUMN=面積 --COLUMN=バージョン --COLUMN=vertex_index --COLUMN=vertex_part --COLUMN=vertex_part_ring --COLUMN=vertex_part_index --COLUMN=distance --COLUMN=angle --OUTPUT=" + tmp2_path
            os.system(command)

        layer = QgsVectorLayer(geojson_path, 'temp', 'ogr')
        crs = layer.crs()                      # 元データの座標参照系を取得
        epsg = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得

        if self.checkBox_sima1.isChecked():    # GeoJSON/FlatGeobufで保存
            geojson_path0 = workPath + '/temp0.geojson'
            command = "qgis_process run native:deletecolumn --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --geometryCheck=QgsFeatureRequest.GeometryNoCheck --INPUT=" + geojson_path + " --COLUMN=所在 --COLUMN=バージョン --COLUMN=vertex_index --COLUMN=vertex_part --COLUMN=vertex_part_ring --COLUMN=vertex_part_index --COLUMN=distance --COLUMN=angle --OUTPUT=" + geojson_path0
            os.system(command)
            geojson_path2 = workPath + '/temp.geojson'

            # 地番区域による抽出
            txt = ''
            selected_items = self.listWidget_address.selectedItems()
            #for line in codecs.open(geojson_path2, 'r', 'utf-8'):
            for line in codecs.open(geojson_path0, 'r', 'utf-8'):
                if "市区町村名" in line:
                    a = line.split('市区町村名')
                    b = a[1].replace('"', '').replace(': ', '')
                    c = b.split(',')
                    shikuchouson = c[0]
                    a = line.split('大字名')
                    b = a[1].replace('"', '').replace(': ', '')
                    c = b.split(',')
                    ooaza = c[0]
                    a = line.split('丁目名')
                    b = a[1].replace('"', '').replace(': ', '')
                    c = b.split(',')
                    choume = c[0]
                    a = line.split('小字名')
                    b = a[1].replace('"', '').replace(': ', '')
                    c = b.split(',')
                    koaza = c[0]
                    a = line.split('予備名')
                    b = a[1].replace('"', '').replace(': ', '')
                    c = b.split(',')
                    yobi = c[0]
                    chibankuiki = shikuchouson + ooaza + choume + koaza + yobi
                    for item in selected_items:
                        if chibankuiki == item.text().replace('\n', ''):
                            txt = txt + line
                else:
                    if line == ']\n' and txt[-2] == ',':
                        txt = txt[:-2] + '\n'
                    txt = txt + line
                    #last_line = line
            fname = codecs.open(geojson_path2, 'w', 'utf-8')
            fname.write(txt)
            fname.close()

            # 属性追加（地番区域）
            gdf = gpd.read_file(geojson_path2)
            if self.checkBox_zokusei1.isChecked():
                gdf["地番区域"] = gdf["市区町村名"] + gdf["大字名"] + gdf["丁目名"] + gdf["小字名"] + gdf["予備名"]
                gdf.to_file(geojson_path2, driver="GeoJSON")

            # 属性削除
            gdf = gpd.read_file(geojson_path2)
            item = self.listWidget_zokusei.currentItem()
            if self.checkBox_zokusei.isChecked() and item is not None:
                zokusei = ''
                selected_items = self.listWidget_zokusei.selectedItems()
                for item in selected_items:
                    zokusei = item.text().replace('\n', '')
                    gdf = gdf.drop(columns=[zokusei])
                gdf.to_file(geojson_path2, driver="GeoJSON")
            geojson_path3 = geojson_path2

            # 属性追加（面積）...上書きできないので、属性削除の後
            if self.checkBox_zokusei2.isChecked():
                geojson_path3 = workPath + '/temp2.geojson'
                command = "qgis_process run native:fieldcalculator --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + geojson_path2 + " --FIELD_NAME=面積 --FIELD_TYPE=0 --FIELD_LENGTH=0 --FIELD_PRECISION=0 --FORMULA=area(@geometry) --OUTPUT=" + geojson_path3
                os.system(command)

            # 保存
            if ext == 'geojson':
                shutil.copy(geojson_path3, dst_path)
            else:
                bin_dir = self.lineEdit_bin.text()
                command = '"' + bin_dir + 'ogr2ogr.exe" ' + dst_path + " " + geojson_path3
                os.system(command)

            if self.check_xml_8.isChecked():
                layer = QgsVectorLayer(dst_path, u"chibankuiki", "ogr")
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon.qml')
                self.zoom()
            else:
                if len(dst_path) != 0:
                    QMessageBox.information(self, 'GeoJSON→GeoJSON変換', dst_path + u'を作成しました。')
                else:
                    QMessageBox.information(self, 'GeoJSON→GeoJSON変換', dst_path + u'の作成に失敗しました。')
#            if os.path.exists(geojson_path2):
#                os.remove(geojson_path2)
#            if os.path.exists(geojson_path3):
#                os.remove(geojson_path3)

        else: # SIMAで保存

            if (int(epsg) > 2442 and int(epsg) < 2462) or (int(epsg) > 6668 and int(epsg) < 6688)  or (int(epsg) > 30160 and int(epsg) < 30180):
                pass
            else:
                if not self.checkBox_sima1.isChecked():
                    QMessageBox.information(self, 'GeoJSON→SIMA変換', u'平面直角座標系のデータではありません。\n処理を中止します。')
                    return
            new_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
            QgsProject.instance().setCrs(new_crs)

            dat = ""
            for line in codecs.open(tmp2_path, 'r', 'utf-8'):
                if "Point" in line:
                    line = line.replace('"', "")
                    line = line.replace("{ type: Feature, properties: { 地番: ", "")
                    line = line.replace("{ type: Feature,properties: { ", "")
                    line = line.replace(", ", ",")
                    line = line.replace("市区町村名: ", "")
                    line = line.replace("大字名: ", "")
                    line = line.replace("丁目名: ", "")
                    line = line.replace("小字名: ", "")
                    line = line.replace("予備名: ", "")
                    line = line.replace(" }", "")
                    line = line.replace("geometry: { type: Point,coordinates: [ ", "")
                    line = line.replace(" ]", "")
                    line = line.replace("null", "")
                    d = line.split(",")
                    x = "{:.3f}".format(float(d[6]))
                    y = "{:.3f}".format(float(d[7]))
                    dat = dat +  d[0] + ","+ d[1] + ","+ d[2] + ","+ d[3] + ","+ d[4] + ","+ d[5] + ","+ str(x) + ","+ str(y) + "\n"
            csv_path1 = workPath + '/temp1.csv'
            with open(csv_path1, 'w', encoding='shift-jis') as f:
                f.write(dat)
                f.close()

            txt = ''
            selected_items = self.listWidget_address.selectedItems()
            for line in codecs.open(csv_path1, 'r', 'shift-jis'):
                dat = line.split(",")
                chibankuiki = dat[1] + dat[2] + dat[3] + dat[4] + dat[5]
                for item in selected_items:
                    if chibankuiki == item.text().replace('\n', ''):
                        txt = txt + line.replace('\r', '')
            csv_path2 = workPath + '/temp11.csv'
            with codecs.open(csv_path2, 'w', encoding='shift-jis') as f:
                f.write(txt)
                f.close()
            
            with codecs.open(csv_path2, 'r', 'shift-jis') as csvfile:
                reader = csv.reader(csvfile, delimiter=',')
                duplicate_rows = []
                txt = ""
                for row in reader:
                    dat = str(row).replace(' ', '').replace('[', '').replace(']', '').replace("'", '').split(',')
                    row2 = dat[6] + ',' + dat[7] + '\n'
                    if row2 not in duplicate_rows:
                        txt += row2
                        duplicate_rows.append(row2)
            csv_path3 = workPath + '/temp12.csv'
            with codecs.open(csv_path3, 'w', encoding='shift-jis') as txtfile:
                txtfile.write(txt)
            txt = ''
            n = 1
            for line in codecs.open(csv_path3, 'r', 'shift-jis'):
                txt = txt + str(n) + ',' + line
                n = n + 1
            csv_path4 = workPath + '/temp13.csv'
            with codecs.open(csv_path4, 'w', encoding='shift-jis') as txtfile:
                txtfile.write(txt)

            dat3 = ""
            for line1 in codecs.open(csv_path2, 'r', 'shift-jis'):     # 抽出データ
                dat1 = line1.split(",")
                for line2 in codecs.open(csv_path4, 'r', 'shift-jis'): # 重複削除データ
                    dat2 = line2.split(",")
                    if (dat1[6] == dat2[1]) and (dat1[7] == dat2[2]):
                        dat3 = dat3 + dat2[0] + "," + dat1[0] + "," + dat1[1] + "," + dat1[2] + "," + dat1[3] + "," + dat1[4] + "," + dat1[5] + "," + dat1[6] + "," + dat1[7].replace("\r", "")
                        break
            csv_path5 = workPath + '/temp14.csv'
            with open(csv_path5, 'w', encoding='shift-jis') as f:
                f.write(dat3)
                f.close()

            sim = "G00,03,,\n"
            sim = sim + "Z00, /* Digitixer3 */,\n"
            sim = sim + "A00,\n"
            for line in codecs.open(csv_path4, 'r', 'shift-jis'):
                dat = line.split(",")
                sim = sim + "A01," + dat[0] + "," + dat[0] + "," + dat[2].replace("\r", "").replace("\n", "") + "," + dat[1] + ",," + "\n"
            sim = sim + "A99,\n"
            chiban0 = ""
            n = 0
            for line in codecs.open(csv_path5, 'r', 'shift-jis'):
                dat = line.split(",")
                chiban = dat[1] + dat[2] + dat[3] + dat[4] + dat[5]
                if chiban != chiban0:
                    n = n + 1
                    if n != 1:
                        sim = sim + "D99,\n"
                    chiban0 = chiban
                    sim = sim + "D00," + str(n) + "," + dat[1] + ",1,\n"
                else:
                    sim = sim + "B01," +  dat[0] + "," + dat[0] + ",\n"
            sim = sim + "D99,\n"
            with open(sima_name, 'w', encoding='shift-jis') as f:
                f.write(sim)
                f.close()

            if self.check_xml_8.isChecked():
                simaname = workPath + '/sima.txt'
                self.lineEdit_SIMA_View.setText(sima_name)
                self.sima_view()
            else:
                if len(sima_name) != 0:
                    QMessageBox.information(self, 'GeoJSON→SIMA変換', sima_name + u'を作成しました。')
                else:
                    QMessageBox.information(self, 'GeoJSON→SIMA変換', sima_name + u'の作成に失敗しました。')
                    QgsProject.instance().addMapLayer(layer)
            if os.path.exists(csv_path1):
                os.remove(csv_path1)
            if os.path.exists(csv_path2):
                os.remove(csv_path2)
            if os.path.exists(csv_path3):
                os.remove(csv_path3)
            if os.path.exists(csv_path4):
                os.remove(csv_path4)
            if os.path.exists(csv_path5):
                os.remove(csv_path5)

        try:
            qgis.utils.iface.setActiveLayer(original_layer)
        except:
            pass
        geojson_path = self.lineEdit_src.text()

    # 変換（アクティブレイヤの表示領域から）
    def pButton_sima1(self):
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        layer = qgis.utils.iface.activeLayer()
        src_Layer_ID = layer.id()
        original_layer = QgsProject.instance().mapLayer(src_Layer_ID)
        crs = layer.crs()                      # 元データの座標参照系を取得
        epsg = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得
        if epsg == '520003159':
            epsg = '4326'

        new_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
        QgsProject.instance().setCrs(new_crs)
        self.set_Combo()

        src_path = (layer.dataProvider().dataSourceUri()).split('|')[0]
        fgb_path = self.lineEdit_src2.text()

        if fgb_path == '':
            foldername = os.path.dirname(src_path)
            filename = os.path.basename(src_path).split('.')[0]
        else:
            foldername = os.path.dirname(fgb_path)
            filename = os.path.basename(fgb_path).split('.')[0]

        try:
            os.chdir(foldername)
        except:
            pass

        if self.checkBox_sima1.isChecked():    # GeoJSON/FlatGeobufで保存
            filter = "GeoJSON (*.geojson);;FlatGeobuf (*.fgb)"
            dst_path2, ext = QFileDialog.getSaveFileName(None, "GeoJSON/FlatGeobufで保存", filename + "_extent.geojson", filter)
            if not dst_path2:
                return
        else:
            sima_name, _ = QFileDialog.getSaveFileName(None, "SIMAファイルを保存", filename + "_extent.sim", "SIMA (*.sim)")
            folder_name = os.path.dirname(sima_name)
            file_name = os.path.basename(sima_name).split('.')[0]
            if not sima_name:
                return

        # アクティブレイヤの表示領域による抽出
        dst_path = workPath + "/temp0.geojson"
        canvas = qgis.utils.iface.mapCanvas()
        extent = canvas.extent()
        xmin, ymin, xmax, ymax = extent.xMinimum(), extent.yMinimum(), extent.xMaximum(), extent.yMaximum()
        bin_dir = self.lineEdit_bin.text()
        command = '"' + bin_dir + 'ogr2ogr.exe" -spat ' + str(xmin) + " " +  str(ymin) + " " + str(xmax) + " " + str(ymax) + " " + dst_path + " " + src_path
        os.system(command)

        if self.checkBox_sima1.isChecked():    # GeoJSON/FlatGeobufで保存

            # 属性追加（地番区域）
            gdf = gpd.read_file(dst_path)
            if self.checkBox_zokusei1.isChecked():
                gdf["地番区域"] = gdf["市区町村名"] + gdf["大字名"] + gdf["丁目名"] + gdf["小字名"] + gdf["予備名"]
                gdf.to_file(dst_path, driver="GeoJSON")

            # 属性削除
            gdf = gpd.read_file(dst_path)
            item = self.listWidget_zokusei.currentItem()
            if self.checkBox_zokusei.isChecked() and item is not None:
                zokusei = ''
                selected_items = self.listWidget_zokusei.selectedItems()
                for item in selected_items:
                    zokusei = item.text().replace('\n', '')
                    gdf = gdf.drop(columns=[zokusei])
                gdf.to_file(dst_path, driver="GeoJSON")
            dst_path3 = dst_path

            # 属性追加（面積）...上書きできないので、属性削除の後
            if self.checkBox_zokusei2.isChecked():
                dst_path3 = workPath + '/temp1.geojson'
                command = "qgis_process run native:fieldcalculator --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + dst_path + " --FIELD_NAME=面積 --FIELD_TYPE=0 --FIELD_LENGTH=0 --FIELD_PRECISION=0 --FORMULA=area(@geometry) --OUTPUT=" + dst_path3
                os.system(command)

            shutil.copy(dst_path3, dst_path2)
            if self.check_xml_8.isChecked():
                layer = QgsVectorLayer(dst_path2, u"extent", "ogr")
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon.qml')
                self.zoom()
            else:
                if len(dst_path2) != 0:
                    QMessageBox.information(self, 'GeoJSON→GeoJSON変換', dst_path2 + u'を作成しました。')
                else:
                    QMessageBox.information(self, 'GeoJSON→GeoJSON変換', dst_path2 + u'の作成に失敗しました。')

            if os.path.exists(dst_path):
                    os.remove(dst_path)
            if os.path.exists(dst_path3):
                    os.remove(dst_path3)

            qgis.utils.iface.setActiveLayer(original_layer)

        else:

            geojson2_path = workPath + '/tmp0.geojson'
            tmp1_path = workPath + '/tmp1.geojson'
            tmp2_path = workPath + '/tmp2.geojson'
            csv_path1 = workPath + '/temp1.csv'
            csv_path2 = workPath + '/temp12.csv'
            csv_path3 = workPath + '/temp13.csv'
            csv_path4 = workPath + '/temp14.csv'
            sima_name2 = workPath + '/tmp2.sim'
            try:
                os.remove(geojson2_path)
            except:
                pass
            try:
                os.remove(tmp1_path)
            except:
                pass
            try:
                os.remove(tmp2_path)
            except:
                pass
            try:
                os.remove(csv_path1)
            except:
                pass
            try:
                os.remove(csv_path2)
            except:
                pass
            try:
                os.remove(csv_path3)
            except:
                pass
            try:
                os.remove(csv_path4)
            except:
                pass
            try:
                os.remove(sima_name)
            except:
                pass
            try:
                os.remove(sima_name2)
            except:
                pass

            # ID属性追加（同一地番が連続しているデータへの対応）
            command = "qgis_process run native:addautoincrementalfield --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + dst_path + " --FIELD_NAME=ID --START=1 --MODULUS=0 --SORT_EXPRESSION= --SORT_ASCENDING=true --SORT_NULLS_FIRST=false --OUTPUT=" + geojson2_path
            os.system(command)
            # 頂点抽出
            command = "qgis_process run native:extractvertices --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --geometryCheck=QgsFeatureRequest.GeometryNoCheck --INPUT=" + geojson2_path + " --OUTPUT=" + tmp1_path
            os.system(command)
            # 「地番」と「ID」以外の属性削除
            command = "qgis_process run native:retainfields --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --FIELDS=地番 --FIELDS=ID --INPUT=" + tmp1_path +" --OUTPUT=" + tmp2_path
            os.system(command)

            layer = QgsVectorLayer(dst_path, 'temp', 'ogr')
            crs = layer.crs()                      # 元データの座標参照系を取得
            epsg = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得
            if epsg == '520003159':
                epsg = '4326'

            # 抽出データ（地番,市区町村名,大字名,丁目名,小字名,予備名,X座標,Y座標）
            dat = ""
            for line in codecs.open(tmp2_path, 'r', 'utf-8'):
                if "Point" in line:
                    line = line.replace('"', "")
                    line = line.replace("{ type: Feature, properties: { 地番: ", "")
                    line = line.replace(" ID: ", "")
                    line = line.replace("{ type: Feature,properties: { ", "")
                    line = line.replace(" }, geometry: { type: Point, coordinates: [ ", ",")
                    line = line.replace(", ", ",")
                    line = line.replace(" }", "")
                    line = line.replace(" ]", "")
                    line = line.replace("null", "")
                    d = line.split(",")
                    if (int(epsg) > 2442 and int(epsg) < 2462) or (int(epsg) > 6668 and int(epsg) < 6688) or (int(epsg) > 30160 and int(epsg) < 30180):
                        x = "{:.3f}".format(float(d[2]))
                        y = "{:.3f}".format(float(d[3]))
                    else:
                        x = "{:.15f}".format(float(d[2]))
                        y = "{:.15f}".format(float(d[3]))
                    dat = dat +  d[0] + "," + str(x) + ","+ str(y) + "," + d[1] + ",\n"
            with open(csv_path1, 'w', encoding='shift-jis') as f:
                f.write(dat)
                f.close()

            # 重複削除
            with codecs.open(csv_path1, 'r', 'shift-jis') as csvfile:
                reader = csv.reader(csvfile, delimiter=',')
                duplicate_rows = []
                txt = ""
                for row in reader:
                    dat = str(row).replace(' ', '').replace('[', '').replace(']', '').replace("'", '').split(',')
                    row2 = dat[1] + ',' + dat[2] + ',\n'
                    if row2 not in duplicate_rows:
                        txt += row2
                        duplicate_rows.append(row2)
            with codecs.open(csv_path2, 'w', encoding='shift-jis') as txtfile:
                txtfile.write(txt)

            # 重複削除データに点番を付ける
            txt = ''
            n = 1
            for line in codecs.open(csv_path2, 'r', 'shift-jis'):
                txt = txt + str(n) + ',' + line
                n = n + 1
            with codecs.open(csv_path3, 'w', encoding='shift-jis') as txtfile:
                txtfile.write(txt)

            # 重複削除データを参照して、抽出データに点番を付ける
            dat3 = ""
            for line1 in codecs.open(csv_path1, 'r', 'shift-jis'):     # 抽出データ
                dat1 = line1.split(",")
                for line2 in codecs.open(csv_path3, 'r', 'shift-jis'): # 重複削除データ
                    dat2 = line2.split(",")
                    if (dat1[1] == dat2[1]) and (dat1[2] == dat2[2]):
                        dat3 = dat3 + dat2[0] + "," + dat1[0] + "," + dat1[1] + "," + dat1[2] + "," + dat1[3] + ",\n"
                        break
            with codecs.open(csv_path4, 'w', encoding='shift-jis') as f:
                f.write(dat3)
                f.close()

            # SIMA作成----------------------------------------------------------------------------------------------
            sim = "G00,03,,\n"
            sim = sim + "Z00, /* Digitizer3 */,\n"
            sim = sim + "A00,\n"
            for line in codecs.open(csv_path3, 'r', 'shift-jis'):
                dat = line.split(",")
                sim = sim + "A01," + dat[0] + "," + dat[0] + "," + dat[2] + "," + dat[1] + ",," + "\n"
            sim = sim + "A99,\n"

            all_data = []
            # ファイル読み込み処理
            try:
                with codecs.open(csv_path4, 'r', 'shift-jis') as f:
                    for line in f:
                        stripped_line = line.strip()
                        if stripped_line:
                            all_data.append(stripped_line)
            except Exception as e:
                print(f"An error occurred: {e}")
                return None
            # --- D00/B01/D99 の生成 ---
            chiban_id0 = "" 
            n = 0
            start_point_id = None    # 現在処理中の境界の始点の点番号（閉鎖判定用）
            is_donut = False
            closure_count = 0
            outer_start_point = None # 外周の始点の点番号を保持 (9978)
            # ドーナツ形状判定のヘルパー関数 (今回は主に外周終点の判定に使用)
            def check_for_donut(start_index, current_chiban_id):
                # 1回目の閉鎖点以降に、同じ区画IDが続くかどうかで簡易的にドーナツを判定
                if start_index < len(all_data):
                    k_dat = all_data[start_index].split(",")
                    if len(k_dat) >= 5 and f"{k_dat[1].strip()}-{k_dat[4].strip()}" == current_chiban_id:
                        return True
                return False
            for i, line in enumerate(all_data):
                dat = line.split(",")
                if len(dat) < 5:
                    continue
                point_id = dat[0].strip()
                chiban = dat[1].strip()
                polygon_id = dat[4].strip()
                chiban_id = f"{chiban}-{polygon_id}"
                # === 1. 新しい区画の開始 (D00 の出力) ===
                if chiban_id != chiban_id0:
                    if chiban_id0 != "":
                        # 最後の処理として、前の区画で未処理のドーナツ切り替え処理を実行
                        # ここで外周の終点が未処理の場合に強制処理を行うのが理想的だが、今回はループ内で対処
                        sim = sim + "D99,\n"
                    n += 1
                    chiban_id0 = chiban_id
                    closure_count = 0
                    is_donut = False
                    sim = sim + f"D00,{n},{chiban},1,\n"
                    start_point_id = point_id 
                    outer_start_point = point_id 
                    sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                    continue 
                # === 2. 同一区画の点データ (B01) の処理 (i=1以降) ===
                else:
                    # 閉鎖判定: 現在の点番号が、現在の境界の始点の点番号と一致するか
                    # V5/V6と同様、点番号ベースで閉鎖を判定
                    is_closure_point = (point_id == start_point_id)
                    # --- 実行時の状況に基づいた特殊な閉鎖判定 (外周の終点 9975 の検出) ---
                    # 1. 現在の点(i)が最後の点(9975)であり、かつ
                    # 2. 次の点が同じ区画IDでない（またはファイル終端）前に、
                    # 3. さらに後続の点がある（内周がある）場合、ここで強制的にドーナツ処理を実行する。
                    next_chiban_id = None
                    if i + 1 < len(all_data):
                        next_dat = all_data[i + 1].split(",")
                        if len(next_dat) >= 5:
                            next_chiban_id = f"{next_dat[1].strip()}-{next_dat[4].strip()}"
                    # 外周の終点（9975）の行に到達したかを検出する主要なロジック
                    # 始点と終点が一致しない特殊ケースで、内周があることを確認する。
                    if not is_closure_point and check_for_donut(i + 1, chiban_id):
                        # 次の点が同じ区画IDであり、かつ、その次で始点に戻ることが確認できれば、
                        # ここが外周の終点であると見なす。
                        # --- 強制ドーナツ切り替え処理 ---
                        if point_id == '9975' and next_chiban_id == chiban_id:
                            # 9975 の B01 を通常通り出力
                            sim = sim + f"B01,{point_id},{point_id},\n"
                            # 外周の始点 (9978) を再出力して内周の開始を示す
                            sim = sim + f"B01,{outer_start_point},{outer_start_point},\n"
                            # 内周の始点への切り替え
                            next_line = all_data[i + 1]
                            next_dat = next_line.split(",")
                            next_point_id = next_dat[0].strip()
                            start_point_id = next_point_id # start_point_id を内周の始点に更新 (9920)
                            # 内周の始点の B01 を明示的に出力 (9920)
                            sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                            # 以降の処理が内周の点として処理されるように、iを一つ進める
                            # ただし、ループ処理のため i は直接変更できない。
                            # 後の閉鎖判定で混乱しないように closure_count をリセット
                            closure_count = 0 
                            is_donut = True # ドーナツフラグをセット
                            # 次のデータへ進む (次のデータは内周の点として処理される)
                            continue 
                    # --- 通常の閉鎖点処理 (始点と終点の点番号が一致する場合) ---
                    if is_closure_point:
                        # 閉鎖点に到達
                        closure_count += 1
                        # ドーナツ判定
                        if closure_count == 1:
                            # 厳密なドーナツ判定: 始点と同じ点番号が後続のデータに存在するか
                            is_donut = check_for_donut(i + 1, chiban_id)
                        if is_donut:
                            if closure_count == 1:
                                # 始点と終点が一致し、さらに後続点がある場合の処理
                                # A. 終点データ の B01 を通常通り出力
                                sim = sim + f"B01,{point_id},{point_id},\n" 
                                # B. 外周の始点 (outer_start_point) を再出力して内周の開始を示す
                                sim = sim + f"B01,{outer_start_point},{outer_start_point},\n"
                                # C. 内周の始点への切り替えと B01 出力
                                if i + 1 < len(all_data):
                                    next_line = all_data[i + 1]
                                    next_dat = next_line.split(",")
                                    if len(next_dat) >= 5 and f"{next_dat[1].strip()}-{next_dat[4].strip()}" == chiban_id:
                                        next_point_id = next_dat[0].strip()
                                        start_point_id = next_point_id
                                        sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                                closure_count = 0 
                                continue 
                            elif closure_count == 2:
                                # 2. ドーナツ形状の**内周の終点**
                                pass 
                        else:
                            # 3. 通常の区画の終点
                            pass 
                    # B01 の出力:
                    # - 通常の点
                    # - ドーナツ形状の2回目の閉鎖点
                    # のみ出力する。
                    if not is_closure_point or (is_donut and closure_count == 2):
                        sim = sim + f"B01,{point_id},{point_id},\n"
            # === 3. ループ後の最終的な D99 の出力 ===
            if chiban_id0 != "":
                sim = sim + "D99,\n"

            # ここで sim_raw の文字列を行リストに変換
            sim_lines = [line.strip() for line in sim.strip().split('\n') if line.strip()]
            # =========================================================
            ## 処理 1: D00行の次の行の3つ目以降の出現を全て削除 (sim -> sim2)
            # =========================================================
            sim2_lines = []
            i = 0
            while i < len(sim_lines):
                current_line = sim_lines[i]
                if current_line.startswith("D00,"):
                    sim2_lines.append(current_line)
                    i += 1
                    start_b01_line = sim_lines[i] if i < len(sim_lines) and sim_lines[i].startswith("B01,") else None
                    if start_b01_line:
                        sim2_lines.append(start_b01_line) # 1つ目
                        i += 1
                        start_b01_count = 1
                        while i < len(sim_lines) and not sim_lines[i].startswith("D99,"):
                            line_to_check = sim_lines[i]
                            if line_to_check == start_b01_line:
                                start_b01_count += 1
                                # 2つ目までは追加し、3つ目以降はスキップ
                                if start_b01_count <= 2:
                                    sim2_lines.append(line_to_check)
                            else:
                                sim2_lines.append(line_to_check)
                            i += 1
                    if i < len(sim_lines) and sim_lines[i].startswith("D99,"):
                        sim2_lines.append(sim_lines[i])
                        i += 1
                else:
                    sim2_lines.append(current_line)
                    i += 1
            # =========================================================
            ## 処理 2: 2行連続して同じ行がある場合、後の行を削除 (sim2 -> sim3)
            # =========================================================
            sim3_lines = []
            last_line = None
            for current_line in sim2_lines:
                if current_line != last_line:
                    sim3_lines.append(current_line)
                    last_line = current_line
            final_sim_data = "\n".join(sim3_lines)
            # SIMA作成----------------------------------------------------------------------------------------------

            if (int(epsg) > 2442 and int(epsg) < 2462) or (int(epsg) > 6668 and int(epsg) < 6688) or (int(epsg) > 30160 and int(epsg) < 30180):
                with open(sima_name, 'w', encoding='shift-jis') as f:
                    #f.write(sim)
                    f.write(final_sim_data + "\n")
                    f.close()
            else:
                if not self.checkBox_sima1.isChecked():
                    with open(sima_name2, 'w', encoding='shift-jis') as f:
                        #f.write(sim)
                        f.write(final_sim_data + "\n")
                        f.close()
                    Src_crs = QgsCoordinateReferenceSystem()
                    Src_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
                    crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                    epsg2 = self.lineEdit_dstEPSG.text()
                    Dst_crs = QgsCoordinateReferenceSystem()
                    Dst_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.EpsgCrsId)
                    crsDst = QgsCoordinateReferenceSystem(Dst_crs)
                    sim = ""
                    for line in codecs.open(sima_name2, 'r', 'shift-jis'):
                        d = line.replace('\n', '').replace('\r', '')
                        dat = line.split(",")
                        if dat[0] == 'A01':
                            x1 = float(dat[3])
                            y1 = float(dat[4])
                            trans = QgsCoordinateTransform(crsSrc, crsDst, QgsProject.instance())
                            y2, x2 = trans.transform(y1, x1)
                            sim = sim + 'A01,' + dat[1] + ',' + dat[2] + ',' + "{:.3f}".format(float(x2)) + ',' +"{:.3f}".format(float(y2)) + ',,\n'
                        else:
                            sim = sim + d + '\n'
                        with open(sima_name, 'w', encoding='shift-jis') as f:
                            f.write(sim)
                            f.close()
                        epsg = epsg2

            if self.check_xml_8.isChecked():
                 self.lineEdit_SIMA_View.setText(sima_name)
                 self.sima_view()
            else:
                if len(sima_name) != 0:
                    QMessageBox.information(self, 'GeoJSON→SIMA変換', sima_name + u'を作成しました。')
                else:
                    QMessageBox.information(self, 'GeoJSON→SIMA変換', sima_name + u'の作成に失敗しました。')
                    QgsProject.instance().addMapLayer(layer)

        try:
            os.remove(geojson2_path)
        except:
            pass
        try:
            os.remove(tmp1_path)
        except:
            pass
        try:
            os.remove(tmp2_path)
        except:
            pass
        try:
            os.remove(csv_path1)
        except:
            pass
        try:
            os.remove(csv_path2)
        except:
            pass
        try:
            os.remove(csv_path3)
        except:
            pass
        try:
            os.remove(csv_path4)
        except:
            pass
        try:
            os.remove(sima_name2)
        except:
            pass


    # 変換（アクティブレイヤの選択地物から）
    def pButton_sima2(self):
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        layer = qgis.utils.iface.activeLayer()
        src_Layer_ID = layer.id()
        original_layer = QgsProject.instance().mapLayer(src_Layer_ID)
        crs = layer.crs()                      # 元データの座標参照系を取得
        epsg = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得
        if epsg == '520003159':
            epsg = '4326'

        new_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
        QgsProject.instance().setCrs(new_crs)
        self.set_Combo()

        src_path = (layer.dataProvider().dataSourceUri()).split('|')[0]
        fgb_path = self.lineEdit_src2.text()

        if fgb_path == '':
            foldername = os.path.dirname(src_path)
            filename = os.path.basename(src_path).split('.')[0]
        else:
            foldername = os.path.dirname(fgb_path)
            filename = os.path.basename(fgb_path).split('.')[0]
        dst_path = workPath + "/temp0.geojson"

        if not layer.selectedFeatures():
            QMessageBox.information(self, 'GeoJSON→SIMA変換', u'アクティブレイヤの地物が選択されていません。\n処理を中止します。')
            return

        try:
            os.chdir(foldername)
        except:
            pass

        if self.checkBox_sima1.isChecked():    # GeoJSON/FlatGeobufで保存
            filter = "GeoJSON (*.geojson);;FlatGeobuf (*.fgb)"
            dst_path2, ext = QFileDialog.getSaveFileName(None, "GeoJSON/FlatGeobufで保存", filename + "_selected.geojson", filter)
            if not dst_path2:
                return
        else:
            sima_name, _ = QFileDialog.getSaveFileName(None, "SIMAファイルを保存", filename + "_selected.sim", "SIMA (*.sim)")
            folder_name = os.path.dirname(sima_name)
            file_name = os.path.basename(sima_name).split('.')[0]
            if not sima_name:
                return

        # アクティブレイヤの選択地物による抽出
        QgsVectorFileWriter.writeAsVectorFormat(layer, dst_path, 'utf-8', layer.crs(), 'GeoJSON', onlySelected=True)

        if self.checkBox_sima1.isChecked():

            # 属性追加（地番区域）
            gdf = gpd.read_file(dst_path)
            if self.checkBox_zokusei1.isChecked():
                gdf["地番区域"] = gdf["市区町村名"] + gdf["大字名"] + gdf["丁目名"] + gdf["小字名"] + gdf["予備名"]
                gdf.to_file(dst_path, driver="GeoJSON")

            # 属性削除
            gdf = gpd.read_file(dst_path)
            item = self.listWidget_zokusei.currentItem()
            if self.checkBox_zokusei.isChecked() and item is not None:
                zokusei = ''
                selected_items = self.listWidget_zokusei.selectedItems()
                for item in selected_items:
                    zokusei = item.text().replace('\n', '')
                    gdf = gdf.drop(columns=[zokusei])
                gdf.to_file(dst_path, driver="GeoJSON")
            dst_path3 = dst_path

            # 属性追加（面積）...上書きできないので、属性削除の後
            if self.checkBox_zokusei2.isChecked():
                dst_path3 = workPath + '/temp1.geojson'
                command = "qgis_process run native:fieldcalculator --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + dst_path + " --FIELD_NAME=面積 --FIELD_TYPE=0 --FIELD_LENGTH=0 --FIELD_PRECISION=0 --FORMULA=area(@geometry) --OUTPUT=" + dst_path3
                os.system(command)

            shutil.copy(dst_path3, dst_path2)
            if self.check_xml_8.isChecked():
                layer = QgsVectorLayer(dst_path2, u"selected", "ogr")
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon.qml')
                self.zoom()
            else:
                if len(dst_path2) != 0:
                    QMessageBox.information(self, 'GeoJSON→GeoJSON変換', dst_path2 + u'を作成しました。')
                else:
                    QMessageBox.information(self, 'GeoJSON→GeoJSON変換', dst_path2 + u'の作成に失敗しました。')

            qgis.utils.iface.setActiveLayer(original_layer)

        else:

            geojson2_path = workPath + '/tmp0.geojson'
            tmp1_path = workPath + '/tmp1.geojson'
            tmp2_path = workPath + '/tmp2.geojson'
            csv_path1 = workPath + '/temp1.csv'
            csv_path2 = workPath + '/temp12.csv'
            csv_path3 = workPath + '/temp13.csv'
            csv_path4 = workPath + '/temp14.csv'
            sima_name2 = workPath + '/tmp2.sim'
            try:
                os.remove(geojson2_path)
            except:
                pass
            try:
                os.remove(tmp1_path)
            except:
                pass
            try:
                os.remove(tmp2_path)
            except:
                pass
            try:
                os.remove(csv_path1)
            except:
                pass
            try:
                os.remove(csv_path2)
            except:
                pass
            try:
                os.remove(csv_path3)
            except:
                pass
            try:
                os.remove(csv_path4)
            except:
                pass
            try:
                os.remove(sima_name)
            except:
                pass
            try:
                os.remove(sima_name2)
            except:
                pass

            # ID属性追加（同一地番が連続しているデータへの対応）
            command = "qgis_process run native:addautoincrementalfield --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + dst_path + " --FIELD_NAME=ID --START=1 --MODULUS=0 --SORT_EXPRESSION= --SORT_ASCENDING=true --SORT_NULLS_FIRST=false --OUTPUT=" + geojson2_path
            os.system(command)
            # 頂点抽出
            command = "qgis_process run native:extractvertices --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --geometryCheck=QgsFeatureRequest.GeometryNoCheck --INPUT=" + geojson2_path + " --OUTPUT=" + tmp1_path
            os.system(command)
            # 「地番」と「ID」以外の属性削除
            command = "qgis_process run native:retainfields --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --FIELDS=地番 --FIELDS=ID --INPUT=" + tmp1_path +" --OUTPUT=" + tmp2_path
            os.system(command)

            layer = QgsVectorLayer(dst_path, 'temp', 'ogr')
            crs = layer.crs()                      # 元データの座標参照系を取得
            epsg = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得
            if epsg == '520003159':
                epsg = '4326'

            # 抽出データ（地番,市区町村名,大字名,丁目名,小字名,予備名,X座標,Y座標）
            dat = ""
            for line in codecs.open(tmp2_path, 'r', 'utf-8'):
                if "Point" in line:
                    line = line.replace('"', "")
                    line = line.replace("{ type: Feature, properties: { 地番: ", "")
                    line = line.replace(" ID: ", "")
                    line = line.replace("{ type: Feature,properties: { ", "")
                    line = line.replace(" }, geometry: { type: Point, coordinates: [ ", ",")
                    line = line.replace(", ", ",")
                    line = line.replace(" }", "")
                    line = line.replace(" ]", "")
                    line = line.replace("null", "")
                    d = line.split(",")
                    if (int(epsg) > 2442 and int(epsg) < 2462) or (int(epsg) > 6668 and int(epsg) < 6688) or (int(epsg) > 30160 and int(epsg) < 30180):
                        x = "{:.3f}".format(float(d[2]))
                        y = "{:.3f}".format(float(d[3]))
                    else:
                        x = "{:.15f}".format(float(d[2]))
                        y = "{:.15f}".format(float(d[3]))
                    dat = dat +  d[0] + "," + str(x) + ","+ str(y) + "," + d[1] + ",\n"
            with open(csv_path1, 'w', encoding='shift-jis') as f:
                f.write(dat)
                f.close()

            # 重複削除
            with codecs.open(csv_path1, 'r', 'shift-jis') as csvfile:
                reader = csv.reader(csvfile, delimiter=',')
                duplicate_rows = []
                txt = ""
                for row in reader:
                    dat = str(row).replace(' ', '').replace('[', '').replace(']', '').replace("'", '').split(',')
                    row2 = dat[1] + ',' + dat[2] + ',\n'
                    if row2 not in duplicate_rows:
                        txt += row2
                        duplicate_rows.append(row2)
            with codecs.open(csv_path2, 'w', encoding='shift-jis') as txtfile:
                txtfile.write(txt)

            # 重複削除データに点番を付ける
            txt = ''
            n = 1
            for line in codecs.open(csv_path2, 'r', 'shift-jis'):
                txt = txt + str(n) + ',' + line
                n = n + 1
            with codecs.open(csv_path3, 'w', encoding='shift-jis') as txtfile:
                txtfile.write(txt)

            # 重複削除データを参照して、抽出データに点番を付ける
            dat3 = ""
            for line1 in codecs.open(csv_path1, 'r', 'shift-jis'):     # 抽出データ
                dat1 = line1.split(",")
                for line2 in codecs.open(csv_path3, 'r', 'shift-jis'): # 重複削除データ
                    dat2 = line2.split(",")
                    if (dat1[1] == dat2[1]) and (dat1[2] == dat2[2]):
                        dat3 = dat3 + dat2[0] + "," + dat1[0] + "," + dat1[1] + "," + dat1[2] + "," + dat1[3] + ",\n"
                        break
            with codecs.open(csv_path4, 'w', encoding='shift-jis') as f:
                f.write(dat3)
                f.close()

            # SIMA作成----------------------------------------------------------------------------------------------
            sim = "G00,03,,\n"
            sim = sim + "Z00, /* Digitizer3 */,\n"
            sim = sim + "A00,\n"
            for line in codecs.open(csv_path3, 'r', 'shift-jis'):
                dat = line.split(",")
                sim = sim + "A01," + dat[0] + "," + dat[0] + "," + dat[2] + "," + dat[1] + ",," + "\n"
            sim = sim + "A99,\n"

            all_data = []
            # ファイル読み込み処理
            try:
                with codecs.open(csv_path4, 'r', 'shift-jis') as f:
                    for line in f:
                        stripped_line = line.strip()
                        if stripped_line:
                            all_data.append(stripped_line)
            except Exception as e:
                print(f"An error occurred: {e}")
                return None
            # --- D00/B01/D99 の生成 ---
            chiban_id0 = "" 
            n = 0
            start_point_id = None    # 現在処理中の境界の始点の点番号（閉鎖判定用）
            is_donut = False
            closure_count = 0
            outer_start_point = None # 外周の始点の点番号を保持 (9978)
            # ドーナツ形状判定のヘルパー関数 (今回は主に外周終点の判定に使用)
            def check_for_donut(start_index, current_chiban_id):
                # 1回目の閉鎖点以降に、同じ区画IDが続くかどうかで簡易的にドーナツを判定
                if start_index < len(all_data):
                    k_dat = all_data[start_index].split(",")
                    if len(k_dat) >= 5 and f"{k_dat[1].strip()}-{k_dat[4].strip()}" == current_chiban_id:
                        return True
                return False
            for i, line in enumerate(all_data):
                dat = line.split(",")
                if len(dat) < 5:
                    continue
                point_id = dat[0].strip()
                chiban = dat[1].strip()
                polygon_id = dat[4].strip()
                chiban_id = f"{chiban}-{polygon_id}"
                # === 1. 新しい区画の開始 (D00 の出力) ===
                if chiban_id != chiban_id0:
                    if chiban_id0 != "":
                        # 最後の処理として、前の区画で未処理のドーナツ切り替え処理を実行
                        # ここで外周の終点が未処理の場合に強制処理を行うのが理想的だが、今回はループ内で対処
                        sim = sim + "D99,\n"
                    n += 1
                    chiban_id0 = chiban_id
                    closure_count = 0
                    is_donut = False
                    sim = sim + f"D00,{n},{chiban},1,\n"
                    start_point_id = point_id 
                    outer_start_point = point_id 
                    sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                    continue 
                # === 2. 同一区画の点データ (B01) の処理 (i=1以降) ===
                else:
                    # 閉鎖判定: 現在の点番号が、現在の境界の始点の点番号と一致するか
                    # V5/V6と同様、点番号ベースで閉鎖を判定
                    is_closure_point = (point_id == start_point_id)
                    # --- 実行時の状況に基づいた特殊な閉鎖判定 (外周の終点 9975 の検出) ---
                    # 1. 現在の点(i)が最後の点(9975)であり、かつ
                    # 2. 次の点が同じ区画IDでない（またはファイル終端）前に、
                    # 3. さらに後続の点がある（内周がある）場合、ここで強制的にドーナツ処理を実行する。
                    next_chiban_id = None
                    if i + 1 < len(all_data):
                        next_dat = all_data[i + 1].split(",")
                        if len(next_dat) >= 5:
                            next_chiban_id = f"{next_dat[1].strip()}-{next_dat[4].strip()}"
                    # 外周の終点（9975）の行に到達したかを検出する主要なロジック
                    # 始点と終点が一致しない特殊ケースで、内周があることを確認する。
                    if not is_closure_point and check_for_donut(i + 1, chiban_id):
                        # 次の点が同じ区画IDであり、かつ、その次で始点に戻ることが確認できれば、
                        # ここが外周の終点であると見なす。
                        # --- 強制ドーナツ切り替え処理 ---
                        if point_id == '9975' and next_chiban_id == chiban_id:
                            # 9975 の B01 を通常通り出力
                            sim = sim + f"B01,{point_id},{point_id},\n"
                            # 外周の始点 (9978) を再出力して内周の開始を示す
                            sim = sim + f"B01,{outer_start_point},{outer_start_point},\n"
                            # 内周の始点への切り替え
                            next_line = all_data[i + 1]
                            next_dat = next_line.split(",")
                            next_point_id = next_dat[0].strip()
                            start_point_id = next_point_id # start_point_id を内周の始点に更新 (9920)
                            # 内周の始点の B01 を明示的に出力 (9920)
                            sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                            # 以降の処理が内周の点として処理されるように、iを一つ進める
                            # ただし、ループ処理のため i は直接変更できない。
                            # 後の閉鎖判定で混乱しないように closure_count をリセット
                            closure_count = 0 
                            is_donut = True # ドーナツフラグをセット
                            # 次のデータへ進む (次のデータは内周の点として処理される)
                            continue 
                    # --- 通常の閉鎖点処理 (始点と終点の点番号が一致する場合) ---
                    if is_closure_point:
                        # 閉鎖点に到達
                        closure_count += 1
                        # ドーナツ判定
                        if closure_count == 1:
                            # 厳密なドーナツ判定: 始点と同じ点番号が後続のデータに存在するか
                            is_donut = check_for_donut(i + 1, chiban_id)
                        if is_donut:
                            if closure_count == 1:
                                # 始点と終点が一致し、さらに後続点がある場合の処理
                                # A. 終点データ の B01 を通常通り出力
                                sim = sim + f"B01,{point_id},{point_id},\n" 
                                # B. 外周の始点 (outer_start_point) を再出力して内周の開始を示す
                                sim = sim + f"B01,{outer_start_point},{outer_start_point},\n"
                                # C. 内周の始点への切り替えと B01 出力
                                if i + 1 < len(all_data):
                                    next_line = all_data[i + 1]
                                    next_dat = next_line.split(",")
                                    if len(next_dat) >= 5 and f"{next_dat[1].strip()}-{next_dat[4].strip()}" == chiban_id:
                                        next_point_id = next_dat[0].strip()
                                        start_point_id = next_point_id
                                        sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                                closure_count = 0 
                                continue 
                            elif closure_count == 2:
                                # 2. ドーナツ形状の**内周の終点**
                                pass 
                        else:
                            # 3. 通常の区画の終点
                            pass 
                    # B01 の出力:
                    # - 通常の点
                    # - ドーナツ形状の2回目の閉鎖点
                    # のみ出力する。
                    if not is_closure_point or (is_donut and closure_count == 2):
                        sim = sim + f"B01,{point_id},{point_id},\n"
            # === 3. ループ後の最終的な D99 の出力 ===
            if chiban_id0 != "":
                sim = sim + "D99,\n"

            # ここで sim_raw の文字列を行リストに変換
            sim_lines = [line.strip() for line in sim.strip().split('\n') if line.strip()]
            # =========================================================
            ## 処理 1: D00行の次の行の3つ目以降の出現を全て削除 (sim -> sim2)
            # =========================================================
            sim2_lines = []
            i = 0
            while i < len(sim_lines):
                current_line = sim_lines[i]
                if current_line.startswith("D00,"):
                    sim2_lines.append(current_line)
                    i += 1
                    start_b01_line = sim_lines[i] if i < len(sim_lines) and sim_lines[i].startswith("B01,") else None
                    if start_b01_line:
                        sim2_lines.append(start_b01_line) # 1つ目
                        i += 1
                        start_b01_count = 1
                        while i < len(sim_lines) and not sim_lines[i].startswith("D99,"):
                            line_to_check = sim_lines[i]
                            if line_to_check == start_b01_line:
                                start_b01_count += 1
                                # 2つ目までは追加し、3つ目以降はスキップ
                                if start_b01_count <= 2:
                                    sim2_lines.append(line_to_check)
                            else:
                                sim2_lines.append(line_to_check)
                            i += 1
                    if i < len(sim_lines) and sim_lines[i].startswith("D99,"):
                        sim2_lines.append(sim_lines[i])
                        i += 1
                else:
                    sim2_lines.append(current_line)
                    i += 1
            # =========================================================
            ## 処理 2: 2行連続して同じ行がある場合、後の行を削除 (sim2 -> sim3)
            # =========================================================
            sim3_lines = []
            last_line = None
            for current_line in sim2_lines:
                if current_line != last_line:
                    sim3_lines.append(current_line)
                    last_line = current_line
            final_sim_data = "\n".join(sim3_lines)
            # SIMA作成----------------------------------------------------------------------------------------------

            if (int(epsg) > 2442 and int(epsg) < 2462) or (int(epsg) > 6668 and int(epsg) < 6688) or (int(epsg) > 30160 and int(epsg) < 30180):
                with open(sima_name, 'w', encoding='shift-jis') as f:
                    #f.write(sim)
                    f.write(final_sim_data + "\n")
                    f.close()
            else:
                if not self.checkBox_sima1.isChecked():
                    with open(sima_name2, 'w', encoding='shift-jis') as f:
                        #f.write(sim)
                        f.write(final_sim_data + "\n")
                        f.close()
                    Src_crs = QgsCoordinateReferenceSystem()
                    Src_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
                    crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                    epsg2 = self.lineEdit_dstEPSG.text()
                    Dst_crs = QgsCoordinateReferenceSystem()
                    Dst_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.EpsgCrsId)
                    crsDst = QgsCoordinateReferenceSystem(Dst_crs)
                    sim = ""
                    for line in codecs.open(sima_name2, 'r', 'shift-jis'):
                        d = line.replace('\n', '').replace('\r', '')
                        dat = line.split(",")
                        if dat[0] == 'A01':
                            x1 = float(dat[3])
                            y1 = float(dat[4])
                            trans = QgsCoordinateTransform(crsSrc, crsDst, QgsProject.instance())
                            y2, x2 = trans.transform(y1, x1)
                            sim = sim + 'A01,' + dat[1] + ',' + dat[2] + ',' + "{:.3f}".format(float(x2)) + ',' +"{:.3f}".format(float(y2)) + ',,\n'
                        else:
                            sim = sim + d + '\n'
                        with open(sima_name, 'w', encoding='shift-jis') as f:
                            f.write(sim)
                            f.close()
                        epsg = epsg2

            if self.check_xml_8.isChecked():
                 self.lineEdit_SIMA_View.setText(sima_name)
                 self.sima_view()
            else:
                if len(sima_name) != 0:
                    QMessageBox.information(self, 'GeoJSON→SIMA変換', sima_name + u'を作成しました。')
                else:
                    QMessageBox.information(self, 'GeoJSON→SIMA変換', sima_name + u'の作成に失敗しました。')
                    QgsProject.instance().addMapLayer(layer)

        try:
            os.remove(geojson2_path)
        except:
            pass
        try:
            os.remove(tmp1_path)
        except:
            pass
        try:
            os.remove(tmp2_path)
        except:
            pass
        try:
            os.remove(csv_path1)
        except:
            pass
        try:
            os.remove(csv_path2)
        except:
            pass
        try:
            os.remove(csv_path3)
        except:
            pass
        try:
            os.remove(csv_path4)
        except:
            pass
        try:
            os.remove(sima_name2)
        except:
            pass


    # 変換（ファイルから）
    def pButton_sima3(self):
        default_dir = ""
        filter = "GeoJSON (*.geojson);;FlatGeobuf (*.fgb);;Shape (*.shp);;全てのファイル (*.*)"
        geojson_path, ext = QFileDialog.getOpenFileName(None, "ファイルを選択してください。", default_dir, filter)
        if not geojson_path:
            return
        self.checkBox_sima1.setChecked(False)
        self.lineEdit_src.setText(geojson_path)
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')

        fgb_path = ""
        self.lineEdit_src2.setText("")
        foldername = os.path.dirname(geojson_path)
        filename = os.path.basename(geojson_path).split('.')[0]

        global Point_Layer_ID2

        try:
            os.chdir(foldername)
        except:
            pass

        sima_name, _ = QFileDialog.getSaveFileName(None, "SIMAファイルを保存", filename + ".sim", "SIMA (*.sim)")
        folder_name = os.path.dirname(sima_name)
        file_name = os.path.basename(sima_name).split('.')[0]
        if not sima_name:
            return

        geojson2_path = workPath + '/tmp0.geojson'
        tmp1_path = workPath + '/tmp1.geojson'
        tmp2_path = workPath + '/tmp2.geojson'
        csv_path1 = workPath + '/temp1.csv'
        csv_path2 = workPath + '/temp12.csv'
        csv_path3 = workPath + '/temp13.csv'
        csv_path4 = workPath + '/temp14.csv'
        sima_name2 = workPath + '/tmp2.sim'
        try:
            os.remove(geojson2_path)
        except:
            pass
        try:
            os.remove(tmp1_path)
        except:
            pass
        try:
            os.remove(tmp2_path)
        except:
            pass
        try:
            os.remove(csv_path1)
        except:
            pass
        try:
            os.remove(csv_path2)
        except:
            pass
        try:
            os.remove(csv_path3)
        except:
            pass
        try:
            os.remove(csv_path4)
        except:
            pass
        try:
            os.remove(sima_name)
        except:
            pass
        try:
            os.remove(sima_name2)
        except:
            pass

        # ID属性追加（同一地番が連続しているデータへの対応）
        command = "qgis_process run native:addautoincrementalfield --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + geojson_path + " --FIELD_NAME=ID --START=1 --MODULUS=0 --SORT_EXPRESSION= --SORT_ASCENDING=true --SORT_NULLS_FIRST=false --OUTPUT=" + geojson2_path
        os.system(command)

        # 頂点抽出
        command = "qgis_process run native:extractvertices --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --geometryCheck=QgsFeatureRequest.GeometryNoCheck --INPUT=" + geojson2_path + " --OUTPUT=" + tmp1_path
        os.system(command)

        # 「地番」と「ID」以外の属性削除
        command = "qgis_process run native:retainfields --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --FIELDS=地番 --FIELDS=ID --INPUT=" + tmp1_path +" --OUTPUT=" + tmp2_path
        os.system(command)

        layer = QgsVectorLayer(geojson_path, 'temp', 'ogr')
        crs = layer.crs()                      # 元データの座標参照系を取得
        epsg = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得
        if epsg == '520003159':
            epsg = '4326'

        # 抽出データ（地番,市区町村名,大字名,丁目名,小字名,予備名,X座標,Y座標）
        dat = ""
        for line in codecs.open(tmp2_path, 'r', 'utf-8'):
            if "Point" in line:
                line = line.replace('"', "")
                line = line.replace("{ type: Feature, properties: { 地番: ", "")
                line = line.replace(" ID: ", "")
                line = line.replace("{ type: Feature,properties: { ", "")
                line = line.replace(" }, geometry: { type: Point, coordinates: [ ", ",")
                line = line.replace(", ", ",")
                line = line.replace(" }", "")
                line = line.replace(" ]", "")
                line = line.replace("null", "")
                d = line.split(",")
                if (int(epsg) > 2442 and int(epsg) < 2462) or (int(epsg) > 6668 and int(epsg) < 6688) or (int(epsg) > 30160 and int(epsg) < 30180):
                    x = "{:.3f}".format(float(d[2]))
                    y = "{:.3f}".format(float(d[3]))
                else:
                    x = "{:.15f}".format(float(d[2]))
                    y = "{:.15f}".format(float(d[3]))
                dat = dat +  d[0] + "," + str(x) + ","+ str(y) + "," + d[1] + ",\n"
        with open(csv_path1, 'w', encoding='shift-jis') as f:
            f.write(dat)
            f.close()

        # 重複削除
        with codecs.open(csv_path1, 'r', 'shift-jis') as csvfile:
            reader = csv.reader(csvfile, delimiter=',')
            duplicate_rows = []
            txt = ""
            for row in reader:
                dat = str(row).replace(' ', '').replace('[', '').replace(']', '').replace("'", '').split(',')
                row2 = dat[1] + ',' + dat[2] + ',\n'
                if row2 not in duplicate_rows:
                    txt += row2
                    duplicate_rows.append(row2)
        with codecs.open(csv_path2, 'w', encoding='shift-jis') as txtfile:
            txtfile.write(txt)

        # 重複削除データに点番を付ける
        txt = ''
        n = 1
        for line in codecs.open(csv_path2, 'r', 'shift-jis'):
            txt = txt + str(n) + ',' + line
            n = n + 1
        with codecs.open(csv_path3, 'w', encoding='shift-jis') as txtfile:
            txtfile.write(txt)

        # 重複削除データを参照して、抽出データに点番を付ける
        dat3 = ""
        for line1 in codecs.open(csv_path1, 'r', 'shift-jis'):     # 抽出データ
            dat1 = line1.split(",")
            for line2 in codecs.open(csv_path3, 'r', 'shift-jis'): # 重複削除データ
                dat2 = line2.split(",")
                if (dat1[1] == dat2[1]) and (dat1[2] == dat2[2]):
                    dat3 = dat3 + dat2[0] + "," + dat1[0] + "," + dat1[1] + "," + dat1[2] + "," + dat1[3] + ",\n"
                    break
        with codecs.open(csv_path4, 'w', encoding='shift-jis') as f:
            f.write(dat3)
            f.close()

        # SIMA作成----------------------------------------------------------------------------------------------
        sim = "G00,03,,\n"
        sim = sim + "Z00, /* Digitizer3 */,\n"
        sim = sim + "A00,\n"
        for line in codecs.open(csv_path3, 'r', 'shift-jis'):
            dat = line.split(",")
            sim = sim + "A01," + dat[0] + "," + dat[0] + "," + dat[2] + "," + dat[1] + ",," + "\n"
        sim = sim + "A99,\n"

        all_data = []
        # ファイル読み込み処理
        try:
            with codecs.open(csv_path4, 'r', 'shift-jis') as f:
                for line in f:
                    stripped_line = line.strip()
                    if stripped_line:
                        all_data.append(stripped_line)
        except Exception as e:
            print(f"An error occurred: {e}")
            return None
        # --- D00/B01/D99 の生成 ---
        chiban_id0 = "" 
        n = 0
        start_point_id = None    # 現在処理中の境界の始点の点番号（閉鎖判定用）
        is_donut = False
        closure_count = 0
        outer_start_point = None # 外周の始点の点番号を保持 (9978)
        # ドーナツ形状判定のヘルパー関数 (今回は主に外周終点の判定に使用)
        def check_for_donut(start_index, current_chiban_id):
            # 1回目の閉鎖点以降に、同じ区画IDが続くかどうかで簡易的にドーナツを判定
            if start_index < len(all_data):
                k_dat = all_data[start_index].split(",")
                if len(k_dat) >= 5 and f"{k_dat[1].strip()}-{k_dat[4].strip()}" == current_chiban_id:
                    return True
            return False
        for i, line in enumerate(all_data):
            dat = line.split(",")
            if len(dat) < 5:
                continue
            point_id = dat[0].strip()
            chiban = dat[1].strip()
            polygon_id = dat[4].strip()
            chiban_id = f"{chiban}-{polygon_id}"
            # === 1. 新しい区画の開始 (D00 の出力) ===
            if chiban_id != chiban_id0:
                if chiban_id0 != "":
                    # 最後の処理として、前の区画で未処理のドーナツ切り替え処理を実行
                    # ここで外周の終点が未処理の場合に強制処理を行うのが理想的だが、今回はループ内で対処
                    sim = sim + "D99,\n"
                n += 1
                chiban_id0 = chiban_id
                closure_count = 0
                is_donut = False
                sim = sim + f"D00,{n},{chiban},1,\n"
                start_point_id = point_id 
                outer_start_point = point_id 
                sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                continue 
            # === 2. 同一区画の点データ (B01) の処理 (i=1以降) ===
            else:
                # 閉鎖判定: 現在の点番号が、現在の境界の始点の点番号と一致するか
                # V5/V6と同様、点番号ベースで閉鎖を判定
                is_closure_point = (point_id == start_point_id)
                # --- 実行時の状況に基づいた特殊な閉鎖判定 (外周の終点 9975 の検出) ---
                # 1. 現在の点(i)が最後の点(9975)であり、かつ
                # 2. 次の点が同じ区画IDでない（またはファイル終端）前に、
                # 3. さらに後続の点がある（内周がある）場合、ここで強制的にドーナツ処理を実行する。
                next_chiban_id = None
                if i + 1 < len(all_data):
                    next_dat = all_data[i + 1].split(",")
                    if len(next_dat) >= 5:
                        next_chiban_id = f"{next_dat[1].strip()}-{next_dat[4].strip()}"
                # 外周の終点（9975）の行に到達したかを検出する主要なロジック
                # 始点と終点が一致しない特殊ケースで、内周があることを確認する。
                if not is_closure_point and check_for_donut(i + 1, chiban_id):
                    # 次の点が同じ区画IDであり、かつ、その次で始点に戻ることが確認できれば、
                    # ここが外周の終点であると見なす。
                    # --- 強制ドーナツ切り替え処理 ---
                    if point_id == '9975' and next_chiban_id == chiban_id:
                        # 9975 の B01 を通常通り出力
                        sim = sim + f"B01,{point_id},{point_id},\n"
                        # 外周の始点 (9978) を再出力して内周の開始を示す
                        sim = sim + f"B01,{outer_start_point},{outer_start_point},\n"
                        # 内周の始点への切り替え
                        next_line = all_data[i + 1]
                        next_dat = next_line.split(",")
                        next_point_id = next_dat[0].strip()
                        start_point_id = next_point_id # start_point_id を内周の始点に更新 (9920)
                        # 内周の始点の B01 を明示的に出力 (9920)
                        sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                        # 以降の処理が内周の点として処理されるように、iを一つ進める
                        # ただし、ループ処理のため i は直接変更できない。
                        # 後の閉鎖判定で混乱しないように closure_count をリセット
                        closure_count = 0 
                        is_donut = True # ドーナツフラグをセット
                        # 次のデータへ進む (次のデータは内周の点として処理される)
                        continue 
                # --- 通常の閉鎖点処理 (始点と終点の点番号が一致する場合) ---
                if is_closure_point:
                    # 閉鎖点に到達
                    closure_count += 1
                    # ドーナツ判定
                    if closure_count == 1:
                        # 厳密なドーナツ判定: 始点と同じ点番号が後続のデータに存在するか
                        is_donut = check_for_donut(i + 1, chiban_id)
                    if is_donut:
                        if closure_count == 1:
                            # 始点と終点が一致し、さらに後続点がある場合の処理
                            # A. 終点データ の B01 を通常通り出力
                            sim = sim + f"B01,{point_id},{point_id},\n" 
                            # B. 外周の始点 (outer_start_point) を再出力して内周の開始を示す
                            sim = sim + f"B01,{outer_start_point},{outer_start_point},\n"
                            # C. 内周の始点への切り替えと B01 出力
                            if i + 1 < len(all_data):
                                next_line = all_data[i + 1]
                                next_dat = next_line.split(",")
                                if len(next_dat) >= 5 and f"{next_dat[1].strip()}-{next_dat[4].strip()}" == chiban_id:
                                    next_point_id = next_dat[0].strip()
                                    start_point_id = next_point_id
                                    sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                            closure_count = 0 
                            continue 
                        elif closure_count == 2:
                            # 2. ドーナツ形状の**内周の終点**
                            pass 
                    else:
                        # 3. 通常の区画の終点
                        pass 
                # B01 の出力:
                # - 通常の点
                # - ドーナツ形状の2回目の閉鎖点
                # のみ出力する。
                if not is_closure_point or (is_donut and closure_count == 2):
                    sim = sim + f"B01,{point_id},{point_id},\n"
        # === 3. ループ後の最終的な D99 の出力 ===
        if chiban_id0 != "":
            sim = sim + "D99,\n"

        # ここで sim_raw の文字列を行リストに変換
        sim_lines = [line.strip() for line in sim.strip().split('\n') if line.strip()]
        # =========================================================
        ## 処理 1: D00行の次の行の3つ目以降の出現を全て削除 (sim -> sim2)
        # =========================================================
        sim2_lines = []
        i = 0
        while i < len(sim_lines):
            current_line = sim_lines[i]
            if current_line.startswith("D00,"):
                sim2_lines.append(current_line)
                i += 1
                start_b01_line = sim_lines[i] if i < len(sim_lines) and sim_lines[i].startswith("B01,") else None
                if start_b01_line:
                    sim2_lines.append(start_b01_line) # 1つ目
                    i += 1
                    start_b01_count = 1
                    while i < len(sim_lines) and not sim_lines[i].startswith("D99,"):
                        line_to_check = sim_lines[i]
                        if line_to_check == start_b01_line:
                            start_b01_count += 1
                            # 2つ目までは追加し、3つ目以降はスキップ
                            if start_b01_count <= 2:
                                sim2_lines.append(line_to_check)
                        else:
                            sim2_lines.append(line_to_check)
                        i += 1
                if i < len(sim_lines) and sim_lines[i].startswith("D99,"):
                    sim2_lines.append(sim_lines[i])
                    i += 1
            else:
                sim2_lines.append(current_line)
                i += 1
        # =========================================================
        ## 処理 2: 2行連続して同じ行がある場合、後の行を削除 (sim2 -> sim3)
        # =========================================================
        sim3_lines = []
        last_line = None
        for current_line in sim2_lines:
            if current_line != last_line:
                sim3_lines.append(current_line)
                last_line = current_line
        final_sim_data = "\n".join(sim3_lines)
        # SIMA作成----------------------------------------------------------------------------------------------

        if (int(epsg) > 2442 and int(epsg) < 2462) or (int(epsg) > 6668 and int(epsg) < 6688) or (int(epsg) > 30160 and int(epsg) < 30180):
            with open(sima_name, 'w', encoding='shift-jis') as f:
                #f.write(sim)
                f.write(final_sim_data + "\n")
                f.close()
        else:
            if not self.checkBox_sima1.isChecked():
                with open(sima_name2, 'w', encoding='shift-jis') as f:
                    #f.write(sim)
                    f.write(final_sim_data + "\n")
                    f.close()
                Src_crs = QgsCoordinateReferenceSystem()
                Src_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
                crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                epsg2 = self.lineEdit_dstEPSG.text()
                Dst_crs = QgsCoordinateReferenceSystem()
                Dst_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.EpsgCrsId)
                crsDst = QgsCoordinateReferenceSystem(Dst_crs)
                sim = ""
                for line in codecs.open(sima_name2, 'r', 'shift-jis'):
                    d = line.replace('\n', '').replace('\r', '')
                    dat = line.split(",")
                    if dat[0] == 'A01':
                        x1 = float(dat[3])
                        y1 = float(dat[4])
                        trans = QgsCoordinateTransform(crsSrc, crsDst, QgsProject.instance())
                        y2, x2 = trans.transform(y1, x1)
                        sim = sim + 'A01,' + dat[1] + ',' + dat[2] + ',' + "{:.3f}".format(float(x2)) + ',' +"{:.3f}".format(float(y2)) + ',,\n'
                    else:
                        sim = sim + d + '\n'
                    with open(sima_name, 'w', encoding='shift-jis') as f:
                        f.write(sim)
                        f.close()
                    epsg = epsg2
 
        if self.check_xml_8.isChecked():
             self.lineEdit_SIMA_View.setText(sima_name)
             self.sima_view()
        else:
            if len(sima_name) != 0:
                QMessageBox.information(self, 'GeoJSON→SIMA変換', sima_name + u'を作成しました。')
            else:
                QMessageBox.information(self, 'GeoJSON→SIMA変換', sima_name + u'の作成に失敗しました。')
                QgsProject.instance().addMapLayer(layer)

        try:
            os.remove(geojson2_path)
        except:
            pass
        try:
            os.remove(tmp1_path)
        except:
            pass
        try:
            os.remove(tmp2_path)
        except:
            pass
        try:
            os.remove(csv_path1)
        except:
            pass
        try:
            os.remove(csv_path2)
        except:
            pass
        try:
            os.remove(csv_path3)
        except:
            pass
        try:
            os.remove(csv_path4)
        except:
            pass
        try:
            os.remove(sima_name2)
        except:
            pass


    # SIMAの表示（I/O SIMA変換）
    def sima_view(self):
        # 現在のマップキャンバスの中心座標を取得
        center_point = map.center()
        #print(f"現在のマップキャンバスの中心座標: X={center_point.x()}, Y={center_point.y()}")
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        # EPSGの指定がない場合は、プロジェクトのCRSを適用する
        if self.lineEdit_8.text() == '':
            self.lineEdit_8.setText(code)
        # プロジェクトのEPSGと異なる場合
        code2 = self.lineEdit_8.text()
        if code2 != code:
            flag = 1
        else:
            flag = 0
        # 読み込むデータのEPSGの判別（custom=''ならカスタムCRS）
        custom = str(QgsCoordinateReferenceSystem(int(code2)).authid())

        fname = self.lineEdit_SIMA_View.text()
#        QMessageBox.information(self, 'GeoJSON→SIMA変換', fname)

        # プロジェクトのEPSGと異なる場合、プロジェクトのCRSを指定のEPSGに変更する
        if flag == 1:
            #　データのCRSがカスタムCRSでない場合
            if custom != '':
                new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.EpsgCrsId)
            #　データのCRSがカスタムCRSの場合
            else:
                new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
            map.refresh()

        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')

        # 日本語の文字化け対策のため、utf-8に変換
        savename0 = workPath + u'/utf-8.sim'
        fin = codecs.open(fname, "r", "shift_jis")
        fout = codecs.open(savename0, "w", "utf-8")
        for row in fin:
            fout.write(row)
        fin.close()
        fout.close()
        fname = savename0
        savename = workPath + u'/sim2point.txt'
        savename2 = workPath + u'/sim2geojson1.txt'
        savename3 = workPath + u'/sim2geojson2.txt'
        savename4 = workPath + u'/sim2geojson3.txt'
        savename5 = workPath + u'/sim2geojson4.txt'
        savename6 = workPath + u'/sima.geojson'
        savename7 = workPath + u'/sima2.geojson'
        fin = codecs.open(fname, 'r', 'utf-8')
        fout = codecs.open(savename, 'w', 'utf-8')
        fout2 = codecs.open(savename2, 'w', 'utf-8')
        fout3 = codecs.open(savename4, 'w', 'utf-8')
        # sim2point.txt/sim2geojson1.txt/sim2geojson3.txt
        fout.writelines('A01,no,name,x,y,h,\n')
        d_flag = 0
        f_flag = 0
        for line in fin:
            if line[:4] == 'A01,':
                fout.writelines(line)
            if line[:4] == 'D00,':
                fout2.writelines(line)
                d_flag = 1
            if line[:4] == 'F00,':
                fout3.writelines(line)
                f_flag = 1
            if (line[:4] == 'B01,') and (d_flag == 1) and (f_flag == 0):
                fout2.writelines(line)
            if (line[:4] == 'B01,') and (f_flag == 1) and (d_flag == 0):
                fout3.writelines(line)
            if line[:4] == 'D99,':
                fout2.writelines(line)
                d_flag = 0
            if line[:4] == 'F99,':
                fout3.writelines(line)
                f_flag = 0
        fin.close()
        fout.close()
        fout2.close()
        fout3.close()
        # polyline ------------------------------------------------------------------------------------------------------------
        # polygonの前にpolylineを作成しないとpolylineが表示できない場合がある（原因不明）
        # sim2geojson4.txt
        fin2 = codecs.open(savename4, 'r', 'utf-8')
        fout = codecs.open(savename5, 'w', 'utf-8')
        txt = ''
        for line2 in fin2:
            if line2[:4] == 'F00,':
                d2 = line2.split(',')
                chiban = d2[3].replace('\\', '(')
                fout.writelines('F00,' + chiban + ',\n')
            if line2[:4] == 'F99,':
                fout.writelines('F99,\n')
            if line2[:4] == 'B01,':
                fin1 = codecs.open(savename, 'r', 'utf-8')
                d2 = line2.split(',')
                p_no2 = d2[1]
                for line1 in fin1:
                    d1 = line1.split(',')
                    p_no1 = d1[1]
                    x = d1[3]
                    y = d1[4]
                    if p_no2 == p_no1:
                        break
                fout.writelines(y + ',' + x + ',\n')
                fin1.close()
        fin2.close()
        fout.close()
        # sima2.geojson
        count = 0
        with open(savename5) as f:
            for line in f:
                count += 1
        fin = codecs.open(savename5, 'r', 'utf-8')
        txt = '{\r\n'
        txt = txt + "  " + '"' + "type" + '"' + ":" + '"' + "FeatureCollection" + '"' + ",\r\n"
        txt = txt + "  " + '"' + "name" + '"' + ":" + '"' + "entities" + '"' + ",\r\n"
        txt = txt + "  " + '"' + "crs" + '"' + ": {" + '"' + "type" + '"' + ": " + '"' + "name" + '"' + "," + '"' + "properties" + '"' + ": {" + '"' + "name" + '"' + ": " + '"' + "urn:ogc:def:crs:EPSG::" + code + '"' + "}},\r\n"
        txt = txt + "  " + '"' + "features" + '"' + ": [\r\n"
        fout = codecs.open(savename7, 'w', 'utf-8')
        l = 0
        for line in fin:
            l = l + 1
            d = line.split(',')
            if line[:4] == 'F00,':
                chiban = d[1].replace('\\', '(')
                txt = txt + '    {\r\n'
                txt = txt + '      ' + '"' + 'type' + '"' + ":" + '"' + "Feature" + '"' + ',\r\n'
                txt = txt + '      ' + '"' + 'properties' + '"' + ': {\r\n'
                txt = txt + '        ' + '"' + 'line' + '"' + ": " + '"' + chiban + '"' + '\n'
                txt = txt + '      },\r\n'
                txt = txt + '        ' + '"' + 'geometry' + '"' + ": {\r\n"
                txt = txt + '        ' + '"' + 'type' + '"' + ": " + '"' + "LineString" + '"' + ',\r\n'
                txt = txt + '        ' + '"' + 'coordinates' + '"' + ': [\r\n'
            elif line[:4] == 'F99,':
                txt = txt + '        ]\r\n'
                txt = txt + '      }\r\n'
                if l == count:
                    txt = txt + '    }\r\n'
                else:
                    txt = txt + '    },\r\n'
            else:
                dat = d[0] + ',' + d[1]
                txt = txt + '          [' + dat + '],\r\n'
        txt = txt + '  ]\r\n'
        txt = txt + '}\r\n'
        txt = txt.replace('],\r\n        ]', ']\r\n        ]')
        fin.close()
        fout.write(txt)
        try:
            if os.path.exists(savename4):
                fs = os.path.getsize(savename4)
                if fs == 0:
                    os.remove(savename4)
        except:
            pass
        try:
            if os.path.exists(savename5):
                fs = os.path.getsize(savename5)
                if fs == 0:
                    os.remove(savename5)
        except:
            pass
        # polygon -------------------------------------------------------------------------------------------------------------
        # sim2geojson2.txt
        fin2 = codecs.open(savename2, 'r', 'utf-8')
        fout = codecs.open(savename3, 'w', 'utf-8')
        txt = ''
        for line2 in fin2:
            if line2[:4] == 'D00,':
                d2 = line2.split(',')
                chiban = d2[2]
                fout.writelines('D00,' + chiban + ',\n')
            if line2[:4] == 'D99,':
                fout.writelines('D99,\n')
            if line2[:4] == 'B01,':
                fin1 = codecs.open(savename, 'r', 'utf-8')
                d2 = line2.split(',')
                p_no2 = d2[1]
                for line1 in fin1:
                    d1 = line1.split(',')
                    p_no1 = d1[1]
                    x = d1[3]
                    y = d1[4]
                    if p_no2 == p_no1:
                        break
                fout.writelines(y + ',' + x + ',\n')
                fin1.close()
        fin2.close()
        fout.close()
        # sima.geojson
        count = 0
        with open(savename3) as f:
            for line in f:
                count += 1
        fin = codecs.open(savename3, 'r', 'utf-8')
        txt = '{\r\n'
        txt = txt + "  " + '"' + "type" + '"' + ":" + '"' + "FeatureCollection" + '"' + ",\r\n"
        txt = txt + "  " + '"' + "name" + '"' + ":" + '"' + "entities" + '"' + ",\r\n"
        txt = txt + "  " + '"' + "crs" + '"' + ": {" + '"' + "type" + '"' + ": " + '"' + "name" + '"' + "," + '"' + "properties" + '"' + ": {" + '"' + "name" + '"' + ": " + '"' + "urn:ogc:def:crs:EPSG::" + code + '"' + "}},\r\n"
        txt = txt + "  " + '"' + "features" + '"' + ": [\r\n"
        fout = codecs.open(savename6, 'w', 'utf-8')
        l = 0
        for line in fin:
            l = l + 1
            d = line.split(',')
            if line[:4] == 'D00,':
                n = 1
                chiban = d[1].replace('\\', '(')
                txt = txt + '    {\r\n'
                txt = txt + '      ' + '"' + 'type' + '"' + ":" + '"' + "Feature" + '"' + ',\r\n'
                txt = txt + '      ' + '"' + 'properties' + '"' + ': {\r\n'
                txt = txt + '        ' + '"' + '地番' + '"' + ": " + '"' + chiban + '"' + '\n'
                txt = txt + '      },\r\n'
                txt = txt + '        ' + '"' + 'geometry' + '"' + ": {\r\n"
                txt = txt + '        ' + '"' + 'type' + '"' + ": " + '"' + "MultiPolygon" + '"' + ',\r\n'
                txt = txt + '        ' + '"' + 'coordinates' + '"' + ': [\r\n'
                txt = txt + '          [[\r\n'
            elif line[:4] == 'D99,':
                txt = txt + '            [' + dat1 + ']\r\n'
                txt = txt + '          ]]\r\n'
                txt = txt + '        ]\r\n'
                txt = txt + '      }\r\n'
                if l == count:
                    txt = txt + '    }\r\n'
                else:
                    txt = txt + '    },\r\n'
            else:
                dat = d[0] + ',' + d[1]
                txt = txt + '            [' + dat + '],\r\n'
                if n == 1:
                    dat1 = dat
                n = 2
        txt = txt + '  ]\r\n'
        txt = txt + '}\r\n'
        fin.close()
        fout.write(txt)
        fout.close()
        try:
            if os.path.exists(savename2):
                fs = os.path.getsize(savename2)
                if fs == 0:
                    os.remove(savename2)
        except:
            pass
        try:
            if os.path.exists(savename3):
                fs = os.path.getsize(savename3)
                if fs == 0:
                    os.remove(savename3)
        except:
            pass
        # ポリゴンレイヤの追加+
        if os.path.exists(savename3):
            layer = QgsVectorLayer(savename6, '区画', 'ogr')
            QgsProject.instance().addMapLayer(layer)
            if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml')
        # ポリラインレイヤの追加+
        if os.path.exists(savename5):
            layer = QgsVectorLayer(savename7, '結線', 'ogr')
            QgsProject.instance().addMapLayer(layer)
            if os.path.exists(os.path.dirname(__file__) + u'/qml/kessen(green).qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/kessen(green).qml')
        # ポイントレイヤの追加+
        uri = 'file:///' + savename + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_5', 'field_4' + '&crs=epsg:' + self.lineEdit_8.text())
        layer = QgsVectorLayer(uri, '頂点', 'delimitedtext')
        QgsProject.instance().addMapLayer(layer)
        flag = 0

        # カレントPathを記録する
        reg_path = os.path.dirname(fname)
        ws.setValue("setting/reg_path", reg_path)

        if not self.radioButton_Layer_3.isChecked():
            # スタイルの設定
            if self.comboBox_2.currentText() != '':
                qmlfile = str(self.comboBox_2.currentText())
                if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
            # レイヤの領域に移動する
            self.zoom()
        if flag == 1:
            QMessageBox.information(self, u'空間参照系変更', u'プロジェクトのCRSを、EPSG:' + code2 + u' に変更しました。')
        # プロジェクトのCRSのコンボボックスを更新
        self.set_Combo()
        # スケール取得
        QgsApplication.processEvents()
        self.pButton_49()
        QgsApplication.processEvents()
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))

        # 読み込んだレイヤをマップキャンバスの中心に移動させる
        if self.checkCenter.isChecked():
            # レイヤが正常に読み込まれたか確認
            if layer.isValid():
                # レイヤをQGISのマップに追加
                QgsProject.instance().addMapLayer(layer)
                #print(f"'{layer_name}' を正常に読み込みました。")
                # 3. 地物全体の中心座標を取得する
                # ----------------------------------------------------
                # 地物全体の境界ボックス (extent) を取得
                extent = layer.extent()
                # 境界ボックスの中心座標を計算
                features_center_x = (extent.xMinimum() + extent.xMaximum()) / 2
                features_center_y = (extent.yMinimum() + extent.yMaximum()) / 2
                features_center_point = QgsPointXY(features_center_x, features_center_y)
                #print(f"地物全体の中心座標: X={features_center_point.x()}, Y={features_center_point.y()}")
                # 4. 地物全体をマップキャンバスの中心に移動する
                # ----------------------------------------------------
                # 移動の差分を計算
                delta_x = center_point.x() - features_center_point.x()
                delta_y = center_point.y() - features_center_point.y()
                # レイヤの編集モードを開始
                layer.startEditing()
                # 各地物をループして移動
                for feature in layer.getFeatures():
                    geometry = feature.geometry()
                    # ジオメトリを移動
                    geometry.translate(delta_x, delta_y)
                    # 地物のジオメトリを更新
                    layer.changeGeometry(feature.id(), geometry)
                # 編集を保存して終了
                #layer.commitChanges()
                # マップビューを更新
                map.refresh()
                #print("地物全体をマップキャンバスの中心に移動しました。")
                # スタイルの設定
                if os.path.exists(os.path.dirname(__file__) + u'/qml/center.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/center.qml')
                # レイヤの領域に移動する
                self.zoom()
        self.lineEdit_SIMA_View.setText('')

        if os.path.exists(savename0):
            os.remove(savename0)
        if os.path.exists(savename2):
            os.remove(savename2)
        if os.path.exists(savename3):
            os.remove(savename3)
        if os.path.exists(savename4):
            os.remove(savename4)
        if os.path.exists(savename5):
            os.remove(savename5)
        if os.path.exists(savename7):
            os.remove(savename7)
        try:
            os.remove(savename)
        except:
            pass
        try:
            os.remove(savename6)
        except:
            pass


    # ダウンロートウィンドウを開く
    def pButton_download(self):
        self.scrollArea5.move(7, 120)
        self.scrollArea5.show()


    # リスト取得
    def pButton_ziplist(self):
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dst_path = workPath + "/url.txt"
        dst_path2 = workPath + "/url2.txt"
        dst_path3 = workPath + "/url3.txt"
        dst_path4 = os.path.dirname(__file__) + "/url.txt"
        #url = "https://www.geospatial.jp/ckan/api/3/action/resource_search?query=name:-" + self.lineEdit_year.text() + ".zip&limit=9999&order_by=name"
        url = "https://www.geospatial.jp/ckan/api/3/action/resource_search?query=name:-" + self.lineEdit_year.text() + ".zip&order_by=name"
        urllib.request.urlretrieve(url, dst_path)
        fout = codecs.open(dst_path2, 'w', 'Shift_JIS')
        fin = codecs.open(dst_path, 'r', 'Shift_JIS')
        for line in fin:
            dat = line.replace('", "url": "', '\n')
            fout.writelines(dat)
            break
        fin.close()
        fout.close()
        fout = codecs.open(dst_path3, 'w', 'Shift_JIS')
        fin = codecs.open(dst_path2, 'r', 'Shift_JIS')
        for line in fin:
            if line[0 : 5] == 'https':
                dat = line.split(',')[0].replace('"', '') + '\n'
                fout.writelines(dat)
        fin.close()
        fout.close()
        with open(dst_path3, 'r') as f_in, open(dst_path4, 'w') as f_out:
            lines = f_in.readlines()
            lines.sort(key=lambda line: line[-20:], reverse=False)
            f_out.writelines(lines)
        # ZIPリストを更新
        self.listWidget_ziplist.clear()
        self.listWidget_ziplist2.clear()
        if os.path.exists(dst_path4):
            for line in codecs.open(dst_path4,'r', 'utf-8'):
                dat = line.rstrip('\r\n').split('/download/')
                self.listWidget_ziplist.addItem(dat[1])
                self.listWidget_ziplist2.addItem(line.rstrip('\r\n'))
        if os.path.exists(dst_path):
            os.remove(dst_path)
        if os.path.exists(dst_path2):
            os.remove(dst_path2)
        if os.path.exists(dst_path3):
            os.remove(dst_path3)

    # 保存先フォルダ設定（GDAL/OGR）
    def pButton_savefolder(self):
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        dialog.setOption(QFileDialog.ShowDirsOnly)
        foldername = dialog.getExistingDirectory(self, u'フォルダを選択してください。')
        if foldername == '' or foldername == None:
            return
        #if " " in foldername:
        #    QMessageBox.information(self, u'エラー', u'Path に半角スペースを含んだフォルダは、保存先に使用できません。')
        #    self.lineEdit_savefolder.setText("")
        #    return
        self.lineEdit_savefolder.setText(foldername)
        ws.setValue("setting/savefolder", foldername)


    # curl.exeのパス設定（GDAL/OGR）
    def pButton_curl(self):
        default_dir = ""
        filter = "EXEファイル (*.exe)"
        filename, _ = QFileDialog.getOpenFileName(None, "curl.exeを選択してください。", default_dir, filter)
        if filename == '' or filename == None:
            filename = ""
        self.lineEdit_curl.setText(filename)
        ws.setValue("setting/curl_Path", filename)


    # 全選択1
    def pButton_select1(self):
        self.listWidget_ziplist.selectAll()
        self.listWidget_pref.selectAll()
        self.listWidget_ziplist2.selectAll()
        self.listWidget_ziplist.setFocus()


    # 全解除1
    def pButton_select2(self):
        self.listWidget_ziplist.clearSelection()
        self.listWidget_pref.clearSelection()
        self.listWidget_ziplist2.clearSelection()


    # ダウンロード
    def pButton_download2(self):
        n = 0
        row_count = self.listWidget_ziplist.count()
        row_count2 = self.listWidget_kensaku.count()
        zip_count = 0
        for i in range(row_count):
            if self.listWidget_ziplist.item(i).isSelected():
                zip_count = zip_count + 1
        if zip_count == 0:
            QMessageBox.information(self, u'エラー', u'zipファイルが選択されていません。')
            return

        if self.checkBox_henkan.isChecked():
            if self.mojxml2geojson_folder.text()[-20:] != "mojxml2geojson-kzlab":
                QMessageBox.information(self, u'エラー', u"変換してレイヤに追加するには、K'z lab改造版の「mojxml2geojson」が必要です。\nダウンロードのみ続行します。")
                self.checkBox_henkan.setChecked(False)
            else:
                if zip_count == 1:
                    msg = "ダウンロード後、GeoJSON・FlatGeobufに変換する\n"
                    msg = msg + "変換後レイヤに追加する\n\n"
                    if self.check_xml_1.isChecked():
                        msg = msg + "地区外・別図・区域外・調査外を除外する\n"
                    else:
                        msg = msg + "地区外・別図・区域外・調査外を除外しない\n"
                    if self.check_xml_5.isChecked():
                        msg = msg + "緯度・経度に変換しない\n"
                    else:
                        msg = msg + "緯度・経度に変換する\n"
                    if self.check_xml_2.isChecked():
                        msg = msg + "公共座標系のみ変換する\n"
                    else:
                        msg = msg + "任意座標系のみ変換する\n"
                    if self.check_xml_6.isChecked():
                        msg = msg + "代表点ファイルのみ作成する\n"
                    if self.check_xml_4.isChecked():
                        if not self.check_xml_6.isChecked():
                            msg = msg + "代表点ファイルも作成する\n"
                    else:
                        msg = msg + "代表点ファイルを作成しない\n"
                    if self.check_xml_7.isChecked():
                        msg = msg + "EPSG:4326に変換する\n\n"
                    else:
                        msg = msg + "CRS変換しない\n\n"
                else:
                    msg = "複数ファイル選択のため、変換処理はしません\n"
                    msg = msg + "フォルダーの振分処理まで実行します\n\n"
                msg = msg + "以上の条件で開始してよろしいですか？\n"
                jouken = QMessageBox.question(self,u'変換条件確認', msg,QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
                if jouken != QMessageBox.Yes:
                    self.pButton_close()
                    return
        self.progressBar.setMinimum(0)
        self.progressBar.setMaximum(zip_count)
        self.progressBar.setValue(0)
        self.progressBar.setFormat("ダウンロード ...　%v / %m")
        for i in range(row_count):
            if self.listWidget_ziplist.item(i).isSelected():
                pythoncom.PumpWaitingMessages()
                code = self.listWidget_ziplist.item(i).text()[0 : 5]
                for k in range(row_count2):
                    dat = self.listWidget_kensaku.item(k).text().split(',')
                    if dat[1] == code:
                        self.lineEdit_city.setText(dat[0])
                        self.lineEdit_kei.setText(dat[2])
                        break
                n = n + 1
                fn = self.listWidget_ziplist.item(i).text()
                url = self.listWidget_ziplist2.item(i).text()
                dst_path = '"' + self.lineEdit_savefolder.text() + '/' + fn + '"'
                curl_path = self.lineEdit_curl.text()
                cmd = '"' + curl_path + " -L -H" + '"' + "X-CKAN-API-Key:" + self.lineEdit_apikey.text() + '"' + " " + url + ' -o ' + dst_path + '"'
                os.system(cmd)
                # urllibでもダウンロードは可能だが、API Keyが送れない
                #urllib.request.urlretrieve(url, dst_path)
                pythoncom.PumpWaitingMessages()
                self.progressBar.setValue(n)
            self.progressBar.setFormat(u"ダウンロード完了 ...　%v / %m")

        # download.log作成
        txt = "ファイル名,ダウンロード状況,ファイルサイズ（byte）,\n"
        for i in range(row_count):
            fn = self.listWidget_ziplist.item(i).text()
            fpath = self.lineEdit_savefolder.text() + '/' + fn
            if os.path.exists(fpath):
                fsize = os.path.getsize(fpath)
                if self.listWidget_ziplist.item(i).isSelected():
                    txt = txt + fn + "," + "新規" + "," + str(fsize) + ",\n"
                else:
                    txt = txt + fn + "," + "ダウンロード済" + "," + str(fsize) + ",\n"
                fn2, ext = os.path.splitext(fn)
            else:
                txt = txt + fn + ",,,\n"
        log_path = self.lineEdit_savefolder.text() + '/download.log'
        fout = codecs.open(log_path, 'w', 'Shift_JIS')
        fout.writelines(txt)
        fout.close()

        if n == 0:
            self.checkBox_henkan.setChecked(False)
            return
        elif n == 1:
            pass
        else: # 複数ファイルのダウンロードの場合は、「移動」まで
            self.checkBox_henkan.setChecked(False)
            self.pButton_idou()
            QMessageBox.information(self, u'完了', log_path + u'を作成しました')
            return

        # 解凍してFlatGeobufに変換後、レイヤに追加
        if self.checkBox_henkan.isChecked():
            src_folder = self.lineEdit_savefolder.text()
            dst_folder = src_folder + '/' + fn2
            if not os.path.exists(dst_folder):
                os.mkdir(dst_folder)
            shutil.unpack_archive(src_folder + "/" + fn2 + '.zip', dst_folder)
            src_folder = dst_folder
            if not os.path.exists(dst_folder):
                os.mkdir(dst_folder)
            zip_count = 0
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    zip_count = zip_count + 1
            if zip_count == 0:
                QMessageBox.information(self, u'エラー', u'指定のファルダ内にzipファイルはありません。')
                return
            self.progressBar.setMinimum(0)
            self.progressBar.setMaximum(zip_count)
            self.progressBar.setValue(0)
            files = os.listdir(src_folder)
            n = 0
            self.progressBar.setFormat("二次解凍 ...　%v / %m")
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    code = os.path.basename(file)[0 : 5]
                    n = n + 1
                    shutil.unpack_archive(src_folder + "/" + file, dst_folder)
                    pythoncom.PumpWaitingMessages()
                    self.progressBar.setValue(n)
                    for i in range(row_count):
                       dat = self.listWidget_kensaku.item(i).text().split(',')
                       if dat[1] == code:
                           self.lineEdit_city.setText(dat[0])
                           self.lineEdit_kei.setText(dat[2])
                           break
            dirname = dst_folder
            self.progressBar.setFormat(u"解凍完了 ...　%v / %m")

            # オプション設定
            if self.check_xml_1.isChecked():
                op1 = " -e"
            else:
                op1 = ""

            if self.check_xml_2.isChecked():
                op2 = " -u"
            else:
                op2 = ""
            if self.check_xml_3.isChecked():
                op3 = " -t"
            else:
                op3 = ""
            if self.check_xml_4.isChecked():
                op4 = " -d"
            else:
                op4 = ""
            if self.check_xml_5.isChecked():
                op5 = " -x"
            else:
                op5 = ""
            if self.check_xml_6.isChecked():
                op6 = " -c"
            else:
                op6 = ""
            if self.check_xml_9.isChecked():
                op7 = " -t_srs EPSG:4326"
            else:
                op7 = ""

            cmd = ""
            bat_name = self.mojxml2geojson_folder.text() + "/run.bat"
            python_path = self.python_path.text().replace("/python.exe", "").replace("/python3.exe", "")
            cmd = "cd " + self.mojxml2geojson_folder.text()[:2] + "\n"
            cmd = cmd + "cd " + self.mojxml2geojson_folder.text() + "\n"
            for file in os.listdir(dirname):
                if file.endswith('.xml'):
                    cmd = cmd + '"' + python_path + "/Scripts/mojxml2geojson.exe" + '"' + op1 + op2 + op3 + op4 + op5 + op6 + ' "' + dirname + '/' + file + '"\n'
            fname = codecs.open(bat_name, 'w', 'shift-jis')
            fname.write(cmd)
            fname.close()
            result = subprocess.run(bat_name, shell=False)
            if os.path.exists(bat_name):
                os.remove(bat_name)
            if result.returncode != 0:
                QMessageBox.information(self, u'地図XML→GeoJSON変換', u'変換に失敗しました。（mojxml2geojson）')
                return

            # FlatGeobuf作成
            if not self.check_xml_6.isChecked():
                kukaku_path = dst_folder + '/kukaku/'
                if os.path.exists(kukaku_path + 'kukaku.fgb'):
                    os.remove(kukaku_path + 'kukaku.fgb')
                cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures" + op7 + ' -o "' + kukaku_path + 'kukaku.fgb' + '" "' + kukaku_path + "*.geojson" + '"' + "\n"
                bat_name = self.mojxml2geojson_folder.text() + "/fgb.bat"
                fname = codecs.open(bat_name, 'w', 'shift-jis')
                fname.write(cmd)
                fname.close()
                result = subprocess.run(bat_name, shell=False)
                if result.returncode != 0:
                    QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufの作成に失敗しました。（ogrmerge.py）')
                    return
                if os.path.exists(bat_name):
                    os.remove(bat_name)
                # レイヤに追加＆スタイル適用
                try:
                    layer = QgsVectorLayer(kukaku_path + 'kukaku.fgb', 'kukaku.fgb' + '_kukaku', 'ogr')
                    QgsProject.instance().addMapLayer(layer)
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon.qml')
                except:
                    pass
                crs = layer.crs()
                epsg2 = str(crs.postgisSrid())
                new_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.EpsgCrsId)
                QgsProject.instance().setCrs(new_crs)
                self.set_Combo()

            # 代表点ファイル作成
            if self.check_xml_4.isChecked():
                chiban_path = dst_folder + '/chiban/'
                if os.path.exists(chiban_path + 'chiban.fgb'):
                    os.remove(chiban_path + 'chiban.fgb')
                cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures" + op7 + ' -o "' + chiban_path + 'chiban.fgb' + '" "' + chiban_path + "*.daihyo.geojson" + '"' + "\n"
                bat_name = self.mojxml2geojson_folder.text() + "/fgb.bat"
                fname = codecs.open(bat_name, 'w', 'shift-jis')
                fname.write(cmd)
                fname.close()
                result = subprocess.run(bat_name, shell=False)
                if result.returncode != 0:
                    QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'代表点のFlatGeobufの作成に失敗しました。（ogrmerge.py）')
                    return
                if os.path.exists(bat_name):
                    os.remove(bat_name)
                # レイヤに追加＆スタイル適用
                try:
                    layer2 = QgsVectorLayer(chiban_path + 'chiban.fgb', 'chiban.fgb', 'ogr')
                    QgsProject.instance().addMapLayer(layer2)
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_point.qml'):
                        layer2.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_point.qml')
                except:
                    pass
                crs = layer2.crs()
                epsg2 = str(crs.postgisSrid())
                new_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.EpsgCrsId)
                QgsProject.instance().setCrs(new_crs)
                self.set_Combo()


    # 移動
    def pButton_idou(self):
        for root, dirs, files in os.walk(self.lineEdit_savefolder.text()):
            for file in files:
                if file.lower()[-4:] == '.zip':
                    code = file[0 : 2]
                    if code == '01':
                        pref = '01_hokkaido'
                    elif code == '02':
                        pref = '02_aomori'
                    elif code == '03':
                        pref = '03_iwate'
                    elif code == '04':
                        pref = '04_miyagi'
                    elif code == '05':
                        pref = '05_akita'
                    elif code == '06':
                        pref = '06_yamagata'
                    elif code == '07':
                        pref = '07_fukushima'
                    elif code == '08':
                        pref = '08_ibaraki'
                    elif code == '09':
                        pref = '09_tochigi'
                    elif code == '10':
                        pref = '10_gumma'
                    elif code == '11':
                        pref = '11_saitama'
                    elif code == '12':
                        pref = '12_chiba'
                    elif code == '13':
                        pref = '13_tokyo'
                    elif code == '14':
                        pref = '14_kanagawa'
                    elif code == '15':
                        pref = '15_niigata'
                    elif code == '16':
                        pref = '16_toyama'
                    elif code == '17':
                        pref = '17_ishikawa'
                    elif code == '18':
                        pref = '18_fukui'
                    elif code == '19':
                        pref = '19_yamanashi'
                    elif code == '20':
                        pref = '20_nagano'
                    elif code == '21':
                        pref = '21_gifu'
                    elif code == '22':
                        pref = '22_shizuoka'
                    elif code == '23':
                        pref = '23_aichi'
                    elif code == '24':
                        pref = '24_mie'
                    elif code == '25':
                        pref = '25_shiga'
                    elif code == '26':
                        pref = '26_kyoto'
                    elif code == '27':
                        pref = '27_osaka'
                    elif code == '28':
                        pref = '28_hyogo'
                    elif code == '29':
                        pref = '29_nara'
                    elif code == '30':
                        pref = '30_wakayama'
                    elif code == '31':
                        pref = '31_tottori'
                    elif code == '32':
                        pref = '32_shimane'
                    elif code == '33':
                        pref = '33_okayama'
                    elif code == '34':
                        pref = '34_hiroshima'
                    elif code == '35':
                        pref = '35_yamaguchi'
                    elif code == '36':
                        pref = '36_tokushima'
                    elif code == '37':
                        pref = '37_kagawa'
                    elif code == '38':
                        pref = '38_ehime'
                    elif code == '39':
                        pref = '39_kochi'
                    elif code == '40':
                        pref = '40_fukuoka'
                    elif code == '41':
                        pref = '41_saga'
                    elif code == '42':
                        pref = '42_nagasaki'
                    elif code == '43':
                        pref = '43_kumamoto'
                    elif code == '44':
                        pref = '44_oita'
                    elif code == '45':
                        pref = '45_miyazaki'
                    elif code == '46':
                        pref = '46_kagoshima'
                    elif code == '47':
                        pref = '47_okinawa'
                    if not os.path.exists(self.lineEdit_savefolder.text() + '/' + pref):
                        os.mkdir(self.lineEdit_savefolder.text() + '/' + pref)
                    try:
                        shutil.move(self.lineEdit_savefolder.text() + '/' + file, self.lineEdit_savefolder.text() + '/' + pref +'/' + file)
                    except:
                        pass
        return


    # 解凍
    def pButton_unzip(self):
        if self.radioButton_kaitou1.isChecked() or self.radioButton_kaitou3.isChecked():
            default_dir = ""
            src_folder = QFileDialog.getExistingDirectory(None, "ZIPファイルのあるフォルダを選択してください。", default_dir)
            if src_folder == '' or src_folder == None:
                return
            zip_count = 0
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    zip_count = zip_count + 1
            if zip_count == 0:
                QMessageBox.information(self, u'エラー', u'指定のファルダ内にzipファイルがありません。')
                return
            dst_folder = src_folder + '/' + 'zip2'
            if not os.path.exists(dst_folder):
                os.mkdir(dst_folder)
            self.progressBar.setMinimum(0)
            self.progressBar.setMaximum(zip_count)
            self.progressBar.setValue(0)
            n = 0
            self.progressBar.setFormat("一次解凍 ...　%v / %m")
            files = os.listdir(src_folder)
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    n = n + 1
                    shutil.unpack_archive(src_folder + "/" + file, dst_folder)
                    pythoncom.PumpWaitingMessages()
                    self.progressBar.setValue(n)

        row_count = self.listWidget_kensaku.count()

        if self.radioButton_kaitou2.isChecked():
            default_dir = ""
            src_folder = QFileDialog.getExistingDirectory(None, "ZIPファイルのあるフォルダを選択してください。", default_dir)
            if src_folder == '' or src_folder == None:
                return
            dst_folder = src_folder + '/' + 'xml'
            if not os.path.exists(dst_folder):
                os.mkdir(dst_folder)
            zip_count = 0
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    zip_count = zip_count + 1
            if zip_count == 0:
                QMessageBox.information(self, u'エラー', u'指定のファルダ内にzipファイルはありません。')
                return
            self.progressBar.setMinimum(0)
            self.progressBar.setMaximum(zip_count)
            self.progressBar.setValue(0)
            n = 0
            self.progressBar.setFormat("二次解凍 ...　%v / %m")
            files = os.listdir(src_folder)
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    n = n + 1
                    shutil.unpack_archive(src_folder + "/" + file, dst_folder)
                    pythoncom.PumpWaitingMessages()
                    self.progressBar.setValue(n)
            dirname = dst_folder

        if self.radioButton_kaitou3.isChecked():
            dst_folder2 = src_folder + '/' + 'xml'
            src_folder = dst_folder
            if not os.path.exists(dst_folder2):
                os.mkdir(dst_folder2)
            zip_count = 0
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    zip_count = zip_count + 1
            if zip_count == 0:
                QMessageBox.information(self, u'エラー', u'指定のファルダ内にzipファイルはありません。')
                return
            self.progressBar.setMinimum(0)
            self.progressBar.setMaximum(zip_count)
            self.progressBar.setValue(0)
            files = os.listdir(src_folder)
            n = 0
            self.progressBar.setFormat("二次解凍 ...　%v / %m")
            for file in os.listdir(src_folder):
                if file.lower().endswith('.zip'):
                    code = os.path.basename(file)[0 : 5]
                    n = n + 1
                    shutil.unpack_archive(src_folder + "/" + file, dst_folder2)
                    pythoncom.PumpWaitingMessages()
                    self.progressBar.setValue(n)
                    for i in range(row_count):
                       dat = self.listWidget_kensaku.item(i).text().split(',')
                       if dat[1] == code:
                           self.lineEdit_city.setText(dat[0])
                           self.lineEdit_kei.setText(dat[2])
                           break
            dirname = dst_folder2

        self.progressBar.setFormat(u"解凍完了 ...　%v / %m")

        #if (not self.radioButton_kaitou1.isChecked() and self.checkBox_henkan.isChecked()) or (self.checkBox_henkan.isChecked() and download_ml != ""):#???
        if not self.radioButton_kaitou1.isChecked() and self.checkBox_henkan.isChecked():
            # オプション設定
            if self.check_xml_1.isChecked():
                op1 = " -e"
            else:
                op1 = ""
            if self.mojxml2geojson_folder.text()[-6:] == "-kzlab":
                if self.check_xml_2.isChecked():
                    op2 = " -u"
                else:
                    op2 = ""
                if self.check_xml_3.isChecked():
                    op3 = " -t"
                else:
                    op3 = ""
                op4 = ""
                if self.check_xml_5.isChecked():
                    op5 = " -x"
                else:
                    op5 = ""
                op6 = ""
            else:
                op2 = ""
                op3 = ""
                op4 = ""
                op5 = ""
                op6 = ""

            cmd = ""
            bat_name = self.mojxml2geojson_folder.text() + "/run.bat"
            python_path = self.python_path.text().replace("/python.exe", "").replace("/python3.exe", "")
            cmd = "cd " + self.mojxml2geojson_folder.text()[:2] + "\n"
            cmd = cmd + "cd " + self.mojxml2geojson_folder.text() + "\n"
            for file in os.listdir(dirname):
                if file.endswith('.xml'):
                    if "qgis" in python_path.lower():
                        cmd = cmd + '"' + python_path + "/Scripts/mojxml2geojson.exe" + '"' + op1 + op2 + op3 + op4 + op5 + op6 + ' "' + dirname + '/' + file + '"\n'
                    else:
                        cmd = cmd + "mojxml2geojson" + op1 + op2 + op3 + op4 + op5 + op6 + ' "' + dirname + '/' + file + '"\n'
            fname = codecs.open(bat_name, 'w', 'shift-jis')
            fname.write(cmd)
            fname.close()
            result = subprocess.run(bat_name, shell=False)
            if result.returncode != 0:
                QMessageBox.information(self, u'地図XML→GeoJSON変換', u'変換に失敗しました。（mojxml2geojson）')
                return

            # FlatGeobuf作成
            fgb = dirname + "/temp.fgb"
            if os.path.exists(fgb):
                os.remove(fgb)
            epsg = ""
            cmd = '"' + python_path + "/python.exe" + '" "' + python_path + "/Scripts/ogrmerge.py" + '"' + " -f FlatGeobuf -single -skipfailures " + epsg + "-o " + '"' + fgb + '" "' + dirname + "/*.geojson" + '"' + "\n"
            bat_name = self.mojxml2geojson_folder.text() + "/fgb.bat"
            fname = codecs.open(bat_name, 'w', 'shift-jis')
            fname.write(cmd)
            fname.close()
            result = subprocess.run(bat_name, shell=False)
            if result.returncode != 0:
                QMessageBox.information(self, 'GeoJSON→FlatGeobuf変換', u'FlatGeobufの作成に失敗しました。（ogrmerge.py）')
                return
            if os.path.exists(bat_name):
                os.remove(bat_name)

            # レイヤに追加＆スタイル適用
            try:
                path_to_fgb =  dirname + "/temp.fgb"
                layer = QgsVectorLayer(path_to_fgb, 'temp', 'ogr')
                QgsProject.instance().addMapLayer(layer)
                if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon.qml')
            except:
                pass
            crs = layer.crs()
            epsg = str(crs.postgisSrid())
            new_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
            QgsProject.instance().setCrs(new_crs)
            self.set_Combo()


    # 検索
    def pButton_kensaku(self):
        city_name = self.lineEdit_city.text()
        for row in range(self.listWidget_kensaku.count()):
            item = self.listWidget_kensaku.item(row).text().split(',')
            city = item[0]
            code = item[1]
            kei = item[2]
            if city == city_name:
                n = 0
                for row in range(self.listWidget_ziplist.count()):
                    txt = self.listWidget_ziplist.item(row).text()[0 : 5]
                    if txt == code:
                        self.listWidget_ziplist.setCurrentRow(n)
                        self.listWidget_ziplist.item(n).setSelected(True)
                        self.listWidget_ziplist2.item(n).setSelected(True)
                        self.listWidget_ziplist.setFocus()
                        return
                    n = n + 1


    # 検索2
    def kensaku(self):
        self.lineEdit_city.setText('')
        self.lineEdit_kei.setText('')
        city_list = self.listWidget_ziplist.currentItem()
        city_code = city_list.text()[0 : 5]
        for row in range(self.listWidget_kensaku.count()):
            item = self.listWidget_kensaku.item(row).text().split(',')
            city = item[0]
            code = item[1]
            kei = item[2]
            if code == city_code:
                self.lineEdit_city.setText(code + '：' + city)
                self.lineEdit_kei.setText(kei)
                return


    # 検索3
    def kensaku2(self):
        pref_list = self.listWidget_pref.currentItem()
        pref_code = pref_list.text()[0 : 2]
        if self.listWidget_pref.item(self.listWidget_pref.currentRow()).isSelected():
            for row in range(self.listWidget_ziplist.count()):
                txt = self.listWidget_ziplist.item(row).text()[0 : 2]
                if txt == pref_code:
                    self.listWidget_ziplist.item(row).setSelected(True)
                    self.listWidget_ziplist2.item(row).setSelected(True)
        else:
            for row in range(self.listWidget_ziplist.count()):
                txt = self.listWidget_ziplist.item(row).text()[0 : 2]
                if txt == pref_code:
                    self.listWidget_ziplist.item(row).setSelected(False)
                    self.listWidget_ziplist2.item(row).setSelected(False)


    # ダウンロートウィンドウを閉じる
    def pButton_close(self):
        self.scrollArea5.hide()

    # ヘルマート変換
    def pButton_Helmert(self):
        self.label_info.setText("")
        self.scrollArea_Helmert.move(8, 120)
        self.scrollArea_Helmert.show()
        # 表示と同時に座標取得モードを「1点目」にセット
        self.helmert_step = 1
        self.label_info.setText("　変換元基準点の1点目をクリックしてください。")

    # ヘルマート変換開始
    def pButton_Helmert2(self):
        # ここで計算処理を呼び出す（後述）
        self.execute_helmert_transformation()

    # ヘルマート変換を閉じる
    def pButton_Helmert3(self):
        #self.scrollArea_Helmert.move(8, 1560)
        self.label_info.setText("")
        self.scrollArea_Helmert.hide()
        self.click0.setChecked(False)
        self.click1.setChecked(False)
        self.click2.setChecked(False)
        self.click3.setChecked(False)
        self.click4.setChecked(False)
        self.label_info.setText("　変換元基準点の1点目をクリックしてください。")
        self.helmert_step = 0 # モード終了

    # ポイントレイヤ名を取得する
    def pButton_layername1(self):
        layer = qgis.utils.iface.activeLayer()
        layername = layer.name()
        self.layerName1.setText(layername)

    # ポリゴンレイヤ名を取得する
    def pButton_layername2(self):
        layer = qgis.utils.iface.activeLayer()
        layername = layer.name()
        self.layerName2.setText(layername)

    # リセット
    def pButton_reset(self):
        self.p1_x_src.setText("")
        self.p1_y_src.setText("")
        self.p2_x_src.setText("")
        self.p2_y_src.setText("")
        self.p1_x_dst.setText("")
        self.p1_y_dst.setText("")
        self.p2_x_dst.setText("")
        self.p2_y_dst.setText("")
        self.click0.setChecked(False)
        self.click1.setChecked(False)
        self.click2.setChecked(False)
        self.click3.setChecked(False)
        self.click4.setChecked(False)
        self.helmert_step = 1
        self.label_info.setText("　変換元基準点の1点目をクリックしてください。")

    # ヘルマート変換
    def execute_helmert_transformation(self):
        existing_layers1 = QgsProject.instance().mapLayersByName("区画（helmert）")
        existing_layers2 = QgsProject.instance().mapLayersByName("結線（helmert）")
        existing_layers3 = QgsProject.instance().mapLayersByName("頂点（helmert）")
        if existing_layers1 or existing_layers2 or existing_layers3:
            QtWidgets.QMessageBox.warning(self, "エラー", "区画（helmert）・結線（helmert）・頂点（helmert）レイヤがあると変換できません。")
            return
        # 既存ファイルの削除
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        geojson_path = workPath + "/helmert.geojson"
        if os.path.exists(geojson_path):
            os.remove(geojson_path)
        try:
            # テキストボックスから値を取得 (x: 縦軸/北, y: 横軸/東)
            x1_s, y1_s = float(self.p1_x_src.text()), float(self.p1_y_src.text())
            x2_s, y2_s = float(self.p2_x_src.text()), float(self.p2_y_src.text())
            x1_d, y1_d = float(self.p1_x_dst.text()), float(self.p1_y_dst.text())
            x2_d, y2_d = float(self.p2_x_dst.text()), float(self.p2_y_dst.text())
        except ValueError:
            QtWidgets.QMessageBox.warning(self, "エラー", "座標値が正しく入力されていません。")
            return
        # --- 距離とベクトルの計算 ---
        # 旧ベクトルと距離
        dx_old = y2_s - y1_s
        dy_old = x2_s - x1_s
        dist_old = math.sqrt(dx_old**2 + dy_old**2)
        angle_old = math.atan2(dy_old, dx_old)
        # 新ベクトルと距離
        dx_new = y2_d - y1_d
        dy_new = x2_d - x1_d
        dist_new = math.sqrt(dx_new**2 + dy_new**2)
        angle_new = math.atan2(dy_new, dx_new)
        # --- 縮率 (Scale) の決定 ---
        # チェックボックスの状態を確認 (checkBox_shukuritsu1)
        if self.checkBox_shukuritsu1.isChecked():
            scale = 1.0
        else:
            if dist_old == 0:
                scale = 1.0
            else:
                scale = dist_new / dist_old
        # 回転角 (Rotation)
        d_theta = angle_new - angle_old
        # 内部変換関数
        def transform_geometry(pt):
            # 1. 元の座標から旧1点目を引いて原点化
            tx = pt.x() - y1_s
            ty = pt.y() - x1_s
            # 2. 回転と縮率の適用
            # x' = scale * (x cosθ - y sinθ)
            # y' = scale * (x sinθ + y cosθ)
            rx = scale * (tx * math.cos(d_theta) - ty * math.sin(d_theta))
            ry = scale * (tx * math.sin(d_theta) + ty * math.cos(d_theta))
            # 3. 新1点目を足して移動
            return QgsPointXY(rx + y1_d, ry + x1_d)
        # --- 書き出し処理 ---
        try:
            layer_poly = QgsProject.instance().mapLayersByName(self.layerName2.text())[0]
        except IndexError:
            QtWidgets.QMessageBox.critical(self, "エラー", "レイヤ" + self.layerName2.text() + "が見つかりません。")
            return
        options = QgsVectorFileWriter.SaveVectorOptions()
        options.driverName = "GeoJSON"
        writer = QgsVectorFileWriter.create(
            geojson_path, 
            layer_poly.fields(), 
            layer_poly.wkbType(), 
            layer_poly.sourceCrs(), 
            QgsCoordinateTransformContext(), 
            options
        )
        for feat in layer_poly.getFeatures():
            new_feat = QgsFeature(feat)
            geom = feat.geometry()
            if not geom.isMultipart():
                new_rings = [[transform_geometry(p) for p in ring] for ring in geom.asPolygon()]
                new_feat.setGeometry(QgsGeometry.fromPolygonXY(new_rings))
            else:
                new_parts = [[[transform_geometry(p) for p in ring] for ring in poly] for poly in geom.asMultiPolygon()]
                new_feat.setGeometry(QgsGeometry.fromMultiPolygonXY(new_parts))
            writer.addFeature(new_feat)
        del writer

        # GeoJSON→SIMA--------------------------------------------------------------------------------------------------
        if not geojson_path:
            QtWidgets.QMessageBox.critical(self, "エラー", "GeoJSONの作成に失敗しました。")
            return
        self.checkBox_sima1.setChecked(False)
        self.lineEdit_src.setText(geojson_path)
        fgb_path = ""
        self.lineEdit_src2.setText("")
        foldername = os.path.dirname(geojson_path)
        filename = os.path.basename(geojson_path).split('.')[0]
        global Point_Layer_ID2
        try:
            os.chdir(foldername)
        except:
            pass
        sima_name, _ = QFileDialog.getSaveFileName(None, "SIMAファイルを保存", filename + ".sim", "SIMA (*.sim)")
        folder_name = os.path.dirname(sima_name)
        file_name = os.path.basename(sima_name).split('.')[0]
        if not sima_name:
            return
        geojson2_path = workPath + '/tmp0.geojson'
        tmp1_path = workPath + '/tmp1.geojson'
        tmp2_path = workPath + '/tmp2.geojson'
        csv_path1 = workPath + '/temp1.csv'
        csv_path2 = workPath + '/temp12.csv'
        csv_path3 = workPath + '/temp13.csv'
        csv_path4 = workPath + '/temp14.csv'
        sima_name2 = workPath + '/tmp2.sim'
        try:
            os.remove(geojson2_path)
        except:
            pass
        try:
            os.remove(tmp1_path)
        except:
            pass
        try:
            os.remove(tmp2_path)
        except:
            pass
        try:
            os.remove(csv_path1)
        except:
            pass
        try:
            os.remove(csv_path2)
        except:
            pass
        try:
            os.remove(csv_path3)
        except:
            pass
        try:
            os.remove(csv_path4)
        except:
            pass
        try:
            os.remove(sima_name)
        except:
            pass
        try:
            os.remove(sima_name2)
        except:
            pass
        # ID属性追加（同一地番が連続しているデータへの対応）
        command = "qgis_process run native:addautoincrementalfield --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --INPUT=" + geojson_path + " --FIELD_NAME=ID --START=1 --MODULUS=0 --SORT_EXPRESSION= --SORT_ASCENDING=true --SORT_NULLS_FIRST=false --OUTPUT=" + geojson2_path
        os.system(command)
        # 頂点抽出
        command = "qgis_process run native:extractvertices --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --geometryCheck=QgsFeatureRequest.GeometryNoCheck --INPUT=" + geojson2_path + " --OUTPUT=" + tmp1_path
        os.system(command)
        # 「地番」と「ID」以外の属性削除
        command = "qgis_process run native:retainfields --distance_units=meters --area_units=m2 --ellipsoid=EPSG:7019 --FIELDS=地番 --FIELDS=ID --INPUT=" + tmp1_path +" --OUTPUT=" + tmp2_path
        os.system(command)
        layer = QgsVectorLayer(geojson_path, 'temp', 'ogr')
        crs = layer.crs()                      # 元データの座標参照系を取得
        epsg = str(crs.postgisSrid())          # 座標参照系のEPSGコードを取得
        if epsg == '520003159':
            epsg = '4326'
        # 抽出データ（地番,市区町村名,大字名,丁目名,小字名,予備名,X座標,Y座標）
        dat = ""
        for line in codecs.open(tmp2_path, 'r', 'utf-8'):
            if "Point" in line:
                line = line.replace('"', "")
                line = line.replace("{ type: Feature, properties: { 地番: ", "")
                line = line.replace(" ID: ", "")
                line = line.replace("{ type: Feature,properties: { ", "")
                line = line.replace(" }, geometry: { type: Point, coordinates: [ ", ",")
                line = line.replace(", ", ",")
                line = line.replace(" }", "")
                line = line.replace(" ]", "")
                line = line.replace("null", "")
                d = line.split(",")
                if (int(epsg) > 2442 and int(epsg) < 2462) or (int(epsg) > 6668 and int(epsg) < 6688) or (int(epsg) > 30160 and int(epsg) < 30180):
                    x = "{:.3f}".format(float(d[2]))
                    y = "{:.3f}".format(float(d[3]))
                else:
                    x = "{:.15f}".format(float(d[2]))
                    y = "{:.15f}".format(float(d[3]))
                dat = dat +  d[0] + "," + str(x) + ","+ str(y) + "," + d[1] + ",\n"
        with open(csv_path1, 'w', encoding='shift-jis') as f:
            f.write(dat)
            f.close()
        # 重複削除
        with codecs.open(csv_path1, 'r', 'shift-jis') as csvfile:
            reader = csv.reader(csvfile, delimiter=',')
            duplicate_rows = []
            txt = ""
            for row in reader:
                dat = str(row).replace(' ', '').replace('[', '').replace(']', '').replace("'", '').split(',')
                row2 = dat[1] + ',' + dat[2] + ',\n'
                if row2 not in duplicate_rows:
                    txt += row2
                    duplicate_rows.append(row2)
        with codecs.open(csv_path2, 'w', encoding='shift-jis') as txtfile:
            txtfile.write(txt)
        # 重複削除データに点番を付ける
        txt = ''
        n = 1
        for line in codecs.open(csv_path2, 'r', 'shift-jis'):
            txt = txt + str(n) + ',' + line
            n = n + 1
        with codecs.open(csv_path3, 'w', encoding='shift-jis') as txtfile:
            txtfile.write(txt)
        # 重複削除データを参照して、抽出データに点番を付ける
        dat3 = ""
        for line1 in codecs.open(csv_path1, 'r', 'shift-jis'):     # 抽出データ
            dat1 = line1.split(",")
            for line2 in codecs.open(csv_path3, 'r', 'shift-jis'): # 重複削除データ
                dat2 = line2.split(",")
                if (dat1[1] == dat2[1]) and (dat1[2] == dat2[2]):
                    dat3 = dat3 + dat2[0] + "," + dat1[0] + "," + dat1[1] + "," + dat1[2] + "," + dat1[3] + ",\n"
                    break
        with codecs.open(csv_path4, 'w', encoding='shift-jis') as f:
            f.write(dat3)
            f.close()
        # SIMA作成----------------------------------------------------------------------------------------------
        sim = "G00,03,,\n"
        sim = sim + "Z00, /* Digitizer3 */,\n"
        sim = sim + "A00,\n"
        for line in codecs.open(csv_path3, 'r', 'shift-jis'):
            dat = line.split(",")
            sim = sim + "A01," + dat[0] + "," + dat[0] + "," + dat[2] + "," + dat[1] + ",," + "\n"
        sim = sim + "A99,\n"
        all_data = []
        # ファイル読み込み処理
        try:
            with codecs.open(csv_path4, 'r', 'shift-jis') as f:
                for line in f:
                    stripped_line = line.strip()
                    if stripped_line:
                        all_data.append(stripped_line)
        except Exception as e:
            print(f"An error occurred: {e}")
            return None
        # --- D00/B01/D99 の生成 ---
        chiban_id0 = "" 
        n = 0
        start_point_id = None    # 現在処理中の境界の始点の点番号（閉鎖判定用）
        is_donut = False
        closure_count = 0
        outer_start_point = None # 外周の始点の点番号を保持 (9978)
        # ドーナツ形状判定のヘルパー関数 (今回は主に外周終点の判定に使用)
        def check_for_donut(start_index, current_chiban_id):
            # 1回目の閉鎖点以降に、同じ区画IDが続くかどうかで簡易的にドーナツを判定
            if start_index < len(all_data):
                k_dat = all_data[start_index].split(",")
                if len(k_dat) >= 5 and f"{k_dat[1].strip()}-{k_dat[4].strip()}" == current_chiban_id:
                    return True
            return False
        for i, line in enumerate(all_data):
            dat = line.split(",")
            if len(dat) < 5:
                continue
            point_id = dat[0].strip()
            chiban = dat[1].strip()
            polygon_id = dat[4].strip()
            chiban_id = f"{chiban}-{polygon_id}"
            # === 1. 新しい区画の開始 (D00 の出力) ===
            if chiban_id != chiban_id0:
                if chiban_id0 != "":
                    # 最後の処理として、前の区画で未処理のドーナツ切り替え処理を実行
                    # ここで外周の終点が未処理の場合に強制処理を行うのが理想的だが、今回はループ内で対処
                    sim = sim + "D99,\n"
                n += 1
                chiban_id0 = chiban_id
                closure_count = 0
                is_donut = False
                sim = sim + f"D00,{n},{chiban},1,\n"
                start_point_id = point_id 
                outer_start_point = point_id 
                sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                continue 
            # === 2. 同一区画の点データ (B01) の処理 (i=1以降) ===
            else:
                # 閉鎖判定: 現在の点番号が、現在の境界の始点の点番号と一致するか
                # V5/V6と同様、点番号ベースで閉鎖を判定
                is_closure_point = (point_id == start_point_id)
                # --- 実行時の状況に基づいた特殊な閉鎖判定 (外周の終点 9975 の検出) ---
                # 1. 現在の点(i)が最後の点(9975)であり、かつ
                # 2. 次の点が同じ区画IDでない（またはファイル終端）前に、
                # 3. さらに後続の点がある（内周がある）場合、ここで強制的にドーナツ処理を実行する。
                next_chiban_id = None
                if i + 1 < len(all_data):
                    next_dat = all_data[i + 1].split(",")
                    if len(next_dat) >= 5:
                        next_chiban_id = f"{next_dat[1].strip()}-{next_dat[4].strip()}"
                # 外周の終点（9975）の行に到達したかを検出する主要なロジック
                # 始点と終点が一致しない特殊ケースで、内周があることを確認する。
                if not is_closure_point and check_for_donut(i + 1, chiban_id):
                    # 次の点が同じ区画IDであり、かつ、その次で始点に戻ることが確認できれば、
                    # ここが外周の終点であると見なす。
                    # --- 強制ドーナツ切り替え処理 ---
                    if point_id == '9975' and next_chiban_id == chiban_id:
                        # 9975 の B01 を通常通り出力
                        sim = sim + f"B01,{point_id},{point_id},\n"
                        # 外周の始点 (9978) を再出力して内周の開始を示す
                        sim = sim + f"B01,{outer_start_point},{outer_start_point},\n"
                        # 内周の始点への切り替え
                        next_line = all_data[i + 1]
                        next_dat = next_line.split(",")
                        next_point_id = next_dat[0].strip()
                        start_point_id = next_point_id # start_point_id を内周の始点に更新 (9920)
                        # 内周の始点の B01 を明示的に出力 (9920)
                        sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                        # 以降の処理が内周の点として処理されるように、iを一つ進める
                        # ただし、ループ処理のため i は直接変更できない。
                        # 後の閉鎖判定で混乱しないように closure_count をリセット
                        closure_count = 0 
                        is_donut = True # ドーナツフラグをセット
                        # 次のデータへ進む (次のデータは内周の点として処理される)
                        continue 
                # --- 通常の閉鎖点処理 (始点と終点の点番号が一致する場合) ---
                if is_closure_point:
                    # 閉鎖点に到達
                    closure_count += 1
                    # ドーナツ判定
                    if closure_count == 1:
                        # 厳密なドーナツ判定: 始点と同じ点番号が後続のデータに存在するか
                        is_donut = check_for_donut(i + 1, chiban_id)
                    if is_donut:
                        if closure_count == 1:
                            # 始点と終点が一致し、さらに後続点がある場合の処理
                            # A. 終点データ の B01 を通常通り出力
                            sim = sim + f"B01,{point_id},{point_id},\n" 
                            # B. 外周の始点 (outer_start_point) を再出力して内周の開始を示す
                            sim = sim + f"B01,{outer_start_point},{outer_start_point},\n"
                            # C. 内周の始点への切り替えと B01 出力
                            if i + 1 < len(all_data):
                                next_line = all_data[i + 1]
                                next_dat = next_line.split(",")
                                if len(next_dat) >= 5 and f"{next_dat[1].strip()}-{next_dat[4].strip()}" == chiban_id:
                                    next_point_id = next_dat[0].strip()
                                    start_point_id = next_point_id
                                    sim = sim + f"B01,{start_point_id},{start_point_id},\n"
                            closure_count = 0 
                            continue 
                        elif closure_count == 2:
                            # 2. ドーナツ形状の**内周の終点**
                            pass 
                    else:
                        # 3. 通常の区画の終点
                        pass 
                # B01 の出力:
                # - 通常の点
                # - ドーナツ形状の2回目の閉鎖点
                # のみ出力する。
                if not is_closure_point or (is_donut and closure_count == 2):
                    sim = sim + f"B01,{point_id},{point_id},\n"
        # === 3. ループ後の最終的な D99 の出力 ===
        if chiban_id0 != "":
            sim = sim + "D99,\n"
        # ここで sim_raw の文字列を行リストに変換
        sim_lines = [line.strip() for line in sim.strip().split('\n') if line.strip()]
        # =========================================================
        ## 処理 1: D00行の次の行の3つ目以降の出現を全て削除 (sim -> sim2)
        # =========================================================
        sim2_lines = []
        i = 0
        while i < len(sim_lines):
            current_line = sim_lines[i]
            if current_line.startswith("D00,"):
                sim2_lines.append(current_line)
                i += 1
                start_b01_line = sim_lines[i] if i < len(sim_lines) and sim_lines[i].startswith("B01,") else None
                if start_b01_line:
                    sim2_lines.append(start_b01_line) # 1つ目
                    i += 1
                    start_b01_count = 1
                    while i < len(sim_lines) and not sim_lines[i].startswith("D99,"):
                        line_to_check = sim_lines[i]
                        if line_to_check == start_b01_line:
                            start_b01_count += 1
                            # 2つ目までは追加し、3つ目以降はスキップ
                            if start_b01_count <= 2:
                                sim2_lines.append(line_to_check)
                        else:
                            sim2_lines.append(line_to_check)
                        i += 1
                if i < len(sim_lines) and sim_lines[i].startswith("D99,"):
                    sim2_lines.append(sim_lines[i])
                    i += 1
            else:
                sim2_lines.append(current_line)
                i += 1
        # =========================================================
        ## 処理 2: 2行連続して同じ行がある場合、後の行を削除 (sim2 -> sim3)
        # =========================================================
        sim3_lines = []
        last_line = None
        for current_line in sim2_lines:
            if current_line != last_line:
                sim3_lines.append(current_line)
                last_line = current_line
        final_sim_data = "\n".join(sim3_lines)
        # SIMA作成----------------------------------------------------------------------------------------------
        if (int(epsg) > 2442 and int(epsg) < 2462) or (int(epsg) > 6668 and int(epsg) < 6688) or (int(epsg) > 30160 and int(epsg) < 30180):
            with open(sima_name, 'w', encoding='shift-jis') as f:
                #f.write(sim)
                f.write(final_sim_data + "\n")
                f.close()
        else:
            if not self.checkBox_sima1.isChecked():
                with open(sima_name2, 'w', encoding='shift-jis') as f:
                    #f.write(sim)
                    f.write(final_sim_data + "\n")
                    f.close()
                Src_crs = QgsCoordinateReferenceSystem()
                Src_crs = QgsCoordinateReferenceSystem(int(epsg), QgsCoordinateReferenceSystem.EpsgCrsId)
                crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                epsg2 = self.lineEdit_dstEPSG.text()
                Dst_crs = QgsCoordinateReferenceSystem()
                Dst_crs = QgsCoordinateReferenceSystem(int(epsg2), QgsCoordinateReferenceSystem.EpsgCrsId)
                crsDst = QgsCoordinateReferenceSystem(Dst_crs)
                sim = ""
                for line in codecs.open(sima_name2, 'r', 'shift-jis'):
                    d = line.replace('\n', '').replace('\r', '')
                    dat = line.split(",")
                    if dat[0] == 'A01':
                        x1 = float(dat[3])
                        y1 = float(dat[4])
                        trans = QgsCoordinateTransform(crsSrc, crsDst, QgsProject.instance())
                        y2, x2 = trans.transform(y1, x1)
                        sim = sim + 'A01,' + dat[1] + ',' + dat[2] + ',' + "{:.3f}".format(float(x2)) + ',' +"{:.3f}".format(float(y2)) + ',,\n'
                    else:
                        sim = sim + d + '\n'
                    with open(sima_name, 'w', encoding='shift-jis') as f:
                        f.write(sim)
                        f.close()
                    epsg = epsg2
        self.lineEdit_SIMA_View.setText(sima_name)
        self.sima_view2()
        try:
            os.remove(geojson2_path)
        except:
            pass
        try:
            os.remove(tmp1_path)
        except:
            pass
        try:
            os.remove(tmp2_path)
        except:
            pass
        try:
            os.remove(csv_path1)
        except:
            pass
        try:
            os.remove(csv_path2)
        except:
            pass
        try:
            os.remove(csv_path3)
        except:
            pass
        try:
            os.remove(csv_path4)
        except:
            pass
        try:
            os.remove(sima_name2)
        except:
            pass
        existing_layers = QgsProject.instance().mapLayersByName("区画")
        if existing_layers:
            QgsProject.instance().removeMapLayers([l.id() for l in existing_layers])
        existing_layers = QgsProject.instance().mapLayersByName("結線")
        if existing_layers:
            QgsProject.instance().removeMapLayers([l.id() for l in existing_layers])
        existing_layers = QgsProject.instance().mapLayersByName("頂点")
        if existing_layers:
            QgsProject.instance().removeMapLayers([l.id() for l in existing_layers])
        print(f"変換実行: 縮率={scale:.6f}, 回転角={math.degrees(d_theta):.6f}度")
        QtWidgets.QMessageBox.information(self, "完了", f"変換が完了しました。\n縮率={scale:.6f}, 回転角={math.degrees(d_theta):.6f}度")

    # SIMAの表示（GDAL/OGR ヘルマート変換）
    def sima_view2(self):
        # 現在のマップキャンバスの中心座標を取得
        center_point = map.center()
        #print(f"現在のマップキャンバスの中心座標: X={center_point.x()}, Y={center_point.y()}")
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        # EPSGの指定がない場合は、プロジェクトのCRSを適用する
        if self.lineEdit_8.text() == '':
            self.lineEdit_8.setText(code)
        # プロジェクトのEPSGと異なる場合
        code2 = self.lineEdit_8.text()
        if code2 != code:
            flag = 1
        else:
            flag = 0
        # 読み込むデータのEPSGの判別（custom=''ならカスタムCRS）
        custom = str(QgsCoordinateReferenceSystem(int(code2)).authid())

        fname = self.lineEdit_SIMA_View.text()
#        QMessageBox.information(self, 'GeoJSON→SIMA変換', fname)

        # プロジェクトのEPSGと異なる場合、プロジェクトのCRSを指定のEPSGに変更する
        if flag == 1:
            #　データのCRSがカスタムCRSでない場合
            if custom != '':
                new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.EpsgCrsId)
            #　データのCRSがカスタムCRSの場合
            else:
                new_crs = QgsCoordinateReferenceSystem(int(code2), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
            map.refresh()

        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')

        # 日本語の文字化け対策のため、utf-8に変換
        savename0 = workPath + u'/utf-8.sim'
        fin = codecs.open(fname, "r", "shift_jis")
        fout = codecs.open(savename0, "w", "utf-8")
        for row in fin:
            fout.write(row)
        fin.close()
        fout.close()
        fname = savename0
        savename = workPath + u'/sim2point.txt'
        savename2 = workPath + u'/sim2geojson1.txt'
        savename3 = workPath + u'/sim2geojson2.txt'
        savename4 = workPath + u'/sim2geojson3.txt'
        savename5 = workPath + u'/sim2geojson4.txt'
        savename6 = workPath + u'/sima.geojson'
        savename7 = workPath + u'/sima2.geojson'
        fin = codecs.open(fname, 'r', 'utf-8')
        fout = codecs.open(savename, 'w', 'utf-8')
        fout2 = codecs.open(savename2, 'w', 'utf-8')
        fout3 = codecs.open(savename4, 'w', 'utf-8')
        # sim2point.txt/sim2geojson1.txt/sim2geojson3.txt
        fout.writelines('A01,no,name,x,y,h,\n')
        d_flag = 0
        f_flag = 0
        for line in fin:
            if line[:4] == 'A01,':
                fout.writelines(line)
            if line[:4] == 'D00,':
                fout2.writelines(line)
                d_flag = 1
            if line[:4] == 'F00,':
                fout3.writelines(line)
                f_flag = 1
            if (line[:4] == 'B01,') and (d_flag == 1) and (f_flag == 0):
                fout2.writelines(line)
            if (line[:4] == 'B01,') and (f_flag == 1) and (d_flag == 0):
                fout3.writelines(line)
            if line[:4] == 'D99,':
                fout2.writelines(line)
                d_flag = 0
            if line[:4] == 'F99,':
                fout3.writelines(line)
                f_flag = 0
        fin.close()
        fout.close()
        fout2.close()
        fout3.close()
        # polyline ------------------------------------------------------------------------------------------------------------
        # polygonの前にpolylineを作成しないとpolylineが表示できない場合がある（原因不明）
        # sim2geojson4.txt
        fin2 = codecs.open(savename4, 'r', 'utf-8')
        fout = codecs.open(savename5, 'w', 'utf-8')
        txt = ''
        for line2 in fin2:
            if line2[:4] == 'F00,':
                d2 = line2.split(',')
                chiban = d2[3].replace('\\', '(')
                fout.writelines('F00,' + chiban + ',\n')
            if line2[:4] == 'F99,':
                fout.writelines('F99,\n')
            if line2[:4] == 'B01,':
                fin1 = codecs.open(savename, 'r', 'utf-8')
                d2 = line2.split(',')
                p_no2 = d2[1]
                for line1 in fin1:
                    d1 = line1.split(',')
                    p_no1 = d1[1]
                    x = d1[3]
                    y = d1[4]
                    if p_no2 == p_no1:
                        break
                fout.writelines(y + ',' + x + ',\n')
                fin1.close()
        fin2.close()
        fout.close()
        # sima2.geojson
        count = 0
        with open(savename5) as f:
            for line in f:
                count += 1
        fin = codecs.open(savename5, 'r', 'utf-8')
        txt = '{\r\n'
        txt = txt + "  " + '"' + "type" + '"' + ":" + '"' + "FeatureCollection" + '"' + ",\r\n"
        txt = txt + "  " + '"' + "name" + '"' + ":" + '"' + "entities" + '"' + ",\r\n"
        txt = txt + "  " + '"' + "crs" + '"' + ": {" + '"' + "type" + '"' + ": " + '"' + "name" + '"' + "," + '"' + "properties" + '"' + ": {" + '"' + "name" + '"' + ": " + '"' + "urn:ogc:def:crs:EPSG::" + code + '"' + "}},\r\n"
        txt = txt + "  " + '"' + "features" + '"' + ": [\r\n"
        fout = codecs.open(savename7, 'w', 'utf-8')
        l = 0
        for line in fin:
            l = l + 1
            d = line.split(',')
            if line[:4] == 'F00,':
                chiban = d[1].replace('\\', '(')
                txt = txt + '    {\r\n'
                txt = txt + '      ' + '"' + 'type' + '"' + ":" + '"' + "Feature" + '"' + ',\r\n'
                txt = txt + '      ' + '"' + 'properties' + '"' + ': {\r\n'
                txt = txt + '        ' + '"' + 'line' + '"' + ": " + '"' + chiban + '"' + '\n'
                txt = txt + '      },\r\n'
                txt = txt + '        ' + '"' + 'geometry' + '"' + ": {\r\n"
                txt = txt + '        ' + '"' + 'type' + '"' + ": " + '"' + "LineString" + '"' + ',\r\n'
                txt = txt + '        ' + '"' + 'coordinates' + '"' + ': [\r\n'
            elif line[:4] == 'F99,':
                txt = txt + '        ]\r\n'
                txt = txt + '      }\r\n'
                if l == count:
                    txt = txt + '    }\r\n'
                else:
                    txt = txt + '    },\r\n'
            else:
                dat = d[0] + ',' + d[1]
                txt = txt + '          [' + dat + '],\r\n'
        txt = txt + '  ]\r\n'
        txt = txt + '}\r\n'
        txt = txt.replace('],\r\n        ]', ']\r\n        ]')
        fin.close()
        fout.write(txt)
        try:
            if os.path.exists(savename4):
                fs = os.path.getsize(savename4)
                if fs == 0:
                    os.remove(savename4)
        except:
            pass
        try:
            if os.path.exists(savename5):
                fs = os.path.getsize(savename5)
                if fs == 0:
                    os.remove(savename5)
        except:
            pass
        # polygon -------------------------------------------------------------------------------------------------------------
        # sim2geojson2.txt
        fin2 = codecs.open(savename2, 'r', 'utf-8')
        fout = codecs.open(savename3, 'w', 'utf-8')
        txt = ''
        for line2 in fin2:
            if line2[:4] == 'D00,':
                d2 = line2.split(',')
                chiban = d2[2]
                fout.writelines('D00,' + chiban + ',\n')
            if line2[:4] == 'D99,':
                fout.writelines('D99,\n')
            if line2[:4] == 'B01,':
                fin1 = codecs.open(savename, 'r', 'utf-8')
                d2 = line2.split(',')
                p_no2 = d2[1]
                for line1 in fin1:
                    d1 = line1.split(',')
                    p_no1 = d1[1]
                    x = d1[3]
                    y = d1[4]
                    if p_no2 == p_no1:
                        break
                fout.writelines(y + ',' + x + ',\n')
                fin1.close()
        fin2.close()
        fout.close()
        # sima.geojson
        count = 0
        with open(savename3) as f:
            for line in f:
                count += 1
        fin = codecs.open(savename3, 'r', 'utf-8')
        txt = '{\r\n'
        txt = txt + "  " + '"' + "type" + '"' + ":" + '"' + "FeatureCollection" + '"' + ",\r\n"
        txt = txt + "  " + '"' + "name" + '"' + ":" + '"' + "entities" + '"' + ",\r\n"
        txt = txt + "  " + '"' + "crs" + '"' + ": {" + '"' + "type" + '"' + ": " + '"' + "name" + '"' + "," + '"' + "properties" + '"' + ": {" + '"' + "name" + '"' + ": " + '"' + "urn:ogc:def:crs:EPSG::" + code + '"' + "}},\r\n"
        txt = txt + "  " + '"' + "features" + '"' + ": [\r\n"
        fout = codecs.open(savename6, 'w', 'utf-8')
        l = 0
        for line in fin:
            l = l + 1
            d = line.split(',')
            if line[:4] == 'D00,':
                n = 1
                chiban = d[1].replace('\\', '(')
                txt = txt + '    {\r\n'
                txt = txt + '      ' + '"' + 'type' + '"' + ":" + '"' + "Feature" + '"' + ',\r\n'
                txt = txt + '      ' + '"' + 'properties' + '"' + ': {\r\n'
                txt = txt + '        ' + '"' + '地番' + '"' + ": " + '"' + chiban + '"' + '\n'
                txt = txt + '      },\r\n'
                txt = txt + '        ' + '"' + 'geometry' + '"' + ": {\r\n"
                txt = txt + '        ' + '"' + 'type' + '"' + ": " + '"' + "MultiPolygon" + '"' + ',\r\n'
                txt = txt + '        ' + '"' + 'coordinates' + '"' + ': [\r\n'
                txt = txt + '          [[\r\n'
            elif line[:4] == 'D99,':
                txt = txt + '            [' + dat1 + ']\r\n'
                txt = txt + '          ]]\r\n'
                txt = txt + '        ]\r\n'
                txt = txt + '      }\r\n'
                if l == count:
                    txt = txt + '    }\r\n'
                else:
                    txt = txt + '    },\r\n'
            else:
                dat = d[0] + ',' + d[1]
                txt = txt + '            [' + dat + '],\r\n'
                if n == 1:
                    dat1 = dat
                n = 2
        txt = txt + '  ]\r\n'
        txt = txt + '}\r\n'
        fin.close()
        fout.write(txt)
        fout.close()
        try:
            if os.path.exists(savename2):
                fs = os.path.getsize(savename2)
                if fs == 0:
                    os.remove(savename2)
        except:
            pass
        try:
            if os.path.exists(savename3):
                fs = os.path.getsize(savename3)
                if fs == 0:
                    os.remove(savename3)
        except:
            pass
        # ポリゴンレイヤの追加+
        if os.path.exists(savename3):
            layer = QgsVectorLayer(savename6, '区画（helmert）', 'ogr')
            QgsProject.instance().addMapLayer(layer)
            if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/mojxml_polygon.qml')
        # ポリラインレイヤの追加+
        if os.path.exists(savename5):
            layer = QgsVectorLayer(savename7, '結線（helmert）', 'ogr')
            QgsProject.instance().addMapLayer(layer)
            if os.path.exists(os.path.dirname(__file__) + u'/qml/kessen(green).qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/kessen(green).qml')
        # ポイントレイヤの追加+
        uri = 'file:///' + savename + '?delimiter=%s&xField=%s&yField=%s' % (',', 'field_5', 'field_4' + '&crs=epsg:' + self.lineEdit_8.text())
        layer = QgsVectorLayer(uri, '頂点（helmert）', 'delimitedtext')
        QgsProject.instance().addMapLayer(layer)

        # カレントPathを記録する
        reg_path = os.path.dirname(fname)
        ws.setValue("setting/reg_path", reg_path)

        if not self.radioButton_Layer_3.isChecked():
            # スタイルの設定
            if self.comboBox_2.currentText() != '':
                qmlfile = str(self.comboBox_2.currentText())
                if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
            # レイヤの領域に移動する
            self.zoom()
        if flag == 1:
            QMessageBox.information(self, u'空間参照系変更', u'プロジェクトのCRSを、EPSG:' + code2 + u' に変更しました。')
        # プロジェクトのCRSのコンボボックスを更新
        self.set_Combo()
        # スケール取得
        QgsApplication.processEvents()
        self.pButton_49()
        QgsApplication.processEvents()
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))

        # 読み込んだレイヤをマップキャンバスの中心に移動させる
        if self.checkCenter.isChecked():
            # レイヤが正常に読み込まれたか確認
            if layer.isValid():
                # レイヤをQGISのマップに追加
                QgsProject.instance().addMapLayer(layer)
                #print(f"'{layer_name}' を正常に読み込みました。")
                # 3. 地物全体の中心座標を取得する
                # ----------------------------------------------------
                # 地物全体の境界ボックス (extent) を取得
                extent = layer.extent()
                # 境界ボックスの中心座標を計算
                features_center_x = (extent.xMinimum() + extent.xMaximum()) / 2
                features_center_y = (extent.yMinimum() + extent.yMaximum()) / 2
                features_center_point = QgsPointXY(features_center_x, features_center_y)
                #print(f"地物全体の中心座標: X={features_center_point.x()}, Y={features_center_point.y()}")
                # 4. 地物全体をマップキャンバスの中心に移動する
                # ----------------------------------------------------
                # 移動の差分を計算
                delta_x = center_point.x() - features_center_point.x()
                delta_y = center_point.y() - features_center_point.y()
                # レイヤの編集モードを開始
                layer.startEditing()
                # 各地物をループして移動
                for feature in layer.getFeatures():
                    geometry = feature.geometry()
                    # ジオメトリを移動
                    geometry.translate(delta_x, delta_y)
                    # 地物のジオメトリを更新
                    layer.changeGeometry(feature.id(), geometry)
                # 編集を保存して終了
                #layer.commitChanges()
                # マップビューを更新
                map.refresh()
                #print("地物全体をマップキャンバスの中心に移動しました。")
                # スタイルの設定
                if os.path.exists(os.path.dirname(__file__) + u'/qml/center.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/center.qml')
                # レイヤの領域に移動する
                self.zoom()
        self.lineEdit_SIMA_View.setText('')

        if os.path.exists(savename0):
            os.remove(savename0)
        if os.path.exists(savename2):
            os.remove(savename2)
        if os.path.exists(savename3):
            os.remove(savename3)
        if os.path.exists(savename4):
            os.remove(savename4)
        if os.path.exists(savename5):
            os.remove(savename5)
        if os.path.exists(savename7):
            os.remove(savename7)
        try:
            os.remove(savename)
        except:
            pass
        try:
            os.remove(savename6)
        except:
            pass


 # ----------WorldFile----------------------------------------------------------------------------------------------------------------
    # ラスタレイヤの追加(I/O、WorldFile、Georeference)
    def pButton_11(self):
        self.lineEdit_path.setText('')
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        file = dialog.getOpenFileName(self, u'画像ファイルを開く', '', u'すべてのファイル(*.*)')
        if not file or str(file) == "('', '')":
            return
        fp = str(file).split("'")
        file = fp[1]
        dirpath = os.path.dirname(file)
        filename = os.path.basename(file)
        fn, ext = os.path.splitext(filename)
        ws.setValue("setting/reg_path", dirpath)
        # ファイル名の日本語対策（一旦、作業ディレクトリに名前を変えてコピー）
        infile0 = workPath + u'/temp' + ext.lower()
        shutil.copy(file, infile0)
        os.chmod(infile0, 0o777)
        sleep(0.5)
        os.chdir(dirpath)
        if ext.lower() == '.pdf':
            file = dialog.getSaveFileName(self, u'PNGファイルの保存先', fn, '*.png')
            if not file or str(file) == "('', '')":
                return
            fp = str(file).split("'")
            file = fp[1]
            outfile = workPath + u'/temp.png'
            bin_dir = self.lineEdit_bin.text()
            cmd = '"' + bin_dir + 'gdal_translate.exe" -strict -of png ' + infile0 + ' ' +  outfile
            result = subprocess.run(cmd, shell=True)
            if result.returncode != 0:
                QMessageBox.information(self, u'gdal_translate', u'PDFの読み込みに失敗しました。（gdal_translate）')
                return
            sleep(0.5)
            shutil.copy(outfile, file)

            if self.tabWidget.currentIndex() == 3:#[WorldFile]
                # 図郭パターン解析
                img = Image.open(outfile)
                img.convert("RGB")
                r,g,b = img.getpixel((371,596))
                z1 = r + g + b
                r,g,b = img.getpixel((4306,596))
                z2 = r + g + b
                r,g,b = img.getpixel((4306,4563))
                z3 = r + g + b
                r,g,b = img.getpixel((371,4563))
                z4 = r + g + b
                if z1 + z2 + z3 + z4 == 0:             # 新見出有
                    self.comboBox.setCurrentIndex(0)
                    self.pButton_13()
                if z1 + z2 + z3 + z4 == 525:           # 旧見出有
                    self.comboBox.setCurrentIndex(1)
                    self.pButton_13()
                if z1 + z2 + z3 + z4 == 1530:          # 旧見出無
                    self.comboBox.setCurrentIndex(2)
                    self.pButton_13()

                # OCR（座標系と図郭座標の抽出）
                if self.checkBox_OCR.isChecked(): #「OCR」がチェックされている場合
                    # Tesseract-OCR の有無を調べる（Windows版「3.05.01」「3.05.02」、Mac版「3.05.01」で動作確認）
                    prgPath = ''
                    if sys.platform == "win32": # Windows
                        # Tesseract-OCR を prgPath1・prgPath2 以外にインストールした場合は、32bit・64bitに拘わらず prgPath2 を書き換えると良い。
                        prgPath1 = 'C:/PROGRA~1/Tesseract-OCR/tesseract.exe' # 32bit OS
                        prgPath2 = 'C:/PROGRA~2/Tesseract-OCR/tesseract.exe' # 64bit OS
                        if os.path.exists(prgPath1):
                            prgPath = prgPath1 + ' '
                            prgDir = prgPath1
                        elif os.path.exists(prgPath2):
                            prgPath = prgPath2 + ' '
                            prgDir = prgPath2
                    else: # Mac
                        if os.path.isdir('/usr/local/Cellar/tesseract/'):
                            for root, dirs, files in os.walk('/usr/local/Cellar/tesseract/'):
                                for fname in files:
                                    if os.path.join(root, fname)[-9:] == 'tesseract':
                                        prgPath = os.path.join(root, fname) + ' '
                                        prgDir = os.path.join(root, fname)

                    if prgPath != '': # Tesseract-OCR がインストールされている場合
                        dirpath = os.path.dirname(prgDir)
                        os.chdir(dirpath)
                        img = Image.open(outfile)
                        pt = 0
                        # 新見出有
                        if self.xt.text() == '-596' and self.yt.text() == '4306' and self.xb.text() == '-4563' and self.yb.text() == '371':
                            pt = 1
                        # 旧見出有
                        if self.xt.text() == '-596' and self.yt.text() == '4312' and self.xb.text() == '-4564' and self.yb.text() == '371':
                            pt = 2
                        # 旧見出無
                        if self.xt.text() == '-636' and self.yt.text() == '4312' and self.xb.text() == '-4604' and self.yb.text() == '371':
                            pt = 3

                        if pt != 0:
                            # 表示年月日切出(430×70)
                            fname = workPath + u'/date.png'
                            img.crop((545, 145, 975, 215)).save(fname)

                            # 平面直角座標系画像切出(240×110)
                            if pt == 1:
                                left = 1654
                                upper = 5515
                                right = 1894
                                lower = 5625
                            if pt == 2:
                                left = 1654
                                upper = 5515
                                right = 1894
                                lower = 5625
                            if pt == 3:
                                left = 1652
                                upper = 5305
                                right = 1892
                                lower = 5415
                            fname = workPath + u'/kei.png'
                            img.crop((left, upper, right, lower)).save(fname)

                            # 右上Ｘ座標画像切出(76×320)
                            if pt == 1:
                                left = 4315
                                upper = 601
                                right = 4391
                                lower = 921
                            if pt == 2:
                                left = 4315
                                upper = 601
                                right = 4391
                                lower = 921
                            if pt == 3:
                                left = 4315
                                upper = 641
                                right = 4391
                                lower = 961
                            fname = workPath + u'/x1.png'
                            img.crop((left, upper, right, lower)).save(fname)
                            # 回転が必要
                            img1 = Image.open(fname)
                            img2 = Image.new('RGB', (330, 330), (255, 255, 255))
                            img2.paste(img1, (165, 5))
                            img2 = img2.rotate(90).save(fname)

                            # 右上Ｙ座標画像切出(320×76)
                            if pt == 1:
                                left = 3979
                                upper = 498
                                right = 4299
                                lower = 574
                            if pt == 2:
                                left = 3990
                                upper = 498
                                right = 4310
                                lower = 574
                            if pt == 3:
                                left = 3990
                                upper = 542
                                right = 4310
                                lower = 618
                            fname = workPath + u'/y1.png'
                            img.crop((left, upper, right, lower)).save(fname)

                            # 左下Ｘ座標画像切出(76×320)
                            if pt == 1:
                                left = 288
                                upper = 4233
                                right = 364
                                lower = 4553
                            if pt == 2:
                                left = 288
                                upper = 4233
                                right = 364
                                lower = 4553
                            if pt == 3:
                                left = 288
                                upper = 4281
                                right = 364
                                lower = 4601
                            fname = workPath + u'/x2.png'
                            img.crop((left, upper, right, lower)).save(fname)
                            # OCR実行
                            cmd = prgPath + workPath + u'/date.png ' + workPath + u'/date -psm 7'
                            subprocess.call(cmd, shell=True)
                            img3 = Image.open(fname)
                            img4 = Image.new('RGB', (330, 330), (255, 255, 255))
                            img4.paste(img3, (165, 5))
                            # 表示年月日のOCR
                            tname = workPath + u'/date.txt'
                            line = ''
                            f = open(tname, 'r')
                            try:
                                line = f.readline()
                                line = line.replace('\r\n', '')
                                line = line.replace('\r', '')
                                line = line.replace('\n', '')
                                line = line.replace(' ', '')
                                line = line.replace(',', '.')
                                line = line.replace('=', '')
                                line = line.replace('+', '')
                                line = line.replace('＋', '')
                                line = line.replace('—', '-')
                                line = line.replace('E', '9')
                            except:
                                pass
                            # 回転が必要
                            if line != '':# 新見出有 2018/10/1以前
                                img4 = img4.rotate(270).save(fname)
                            else:# 新見出有 2018/10/1以降
                                img4 = img4.rotate(90).save(fname)

                            # 左下Ｙ座標画像切出(320×76)
                            if pt == 1:
                                left = 374
                                upper = 4587
                                right = 694
                                lower = 4663
                            if pt == 2:
                                left = 374
                                upper = 4587
                                right = 694
                                lower = 4663
                            if pt == 3:
                                left = 374
                                upper = 4630
                                right = 694
                                lower = 4706
                            fname = workPath + u'/y2.png'
                            img.crop((left, upper, right, lower)).save(fname)

                            # OCR実行
                            #sleep(0.5)
                            cmd = prgPath + workPath + u'/kei.png ' + workPath + u'/kei -psm 7'
                            subprocess.run(cmd, shell=True)
                            #sleep(0.5)
                            cmd = prgPath + workPath + u'/x1.png ' + workPath + u'/x1 -psm 7'
                            subprocess.run(cmd, shell=True)
                            #sleep(0.5)
                            cmd = prgPath + workPath + u'/y1.png ' + workPath + u'/y1 -psm 7'
                            subprocess.run(cmd, shell=True)
                            #sleep(0.5)
                            cmd = prgPath + workPath + u'/x2.png ' + workPath + u'/x2 -psm 7'
                            subprocess.run(cmd, shell=True)
                            #sleep(0.5)
                            cmd = prgPath + workPath + u'/y2.png ' + workPath + u'/y2 -psm 7'
                            subprocess.run(cmd, shell=True)

                            # OCR結果読込
                            sleep(1)
                            self.xt2.setText('')
                            self.yt2.setText('')
                            self.xb2.setText('')
                            self.yb2.setText('')

                            fname = workPath + u'/x1.txt'
                            try:
                                f = codecs.open(fname, 'r', 'utf-8')
                                line = f.readline()
                                line = line.replace('\r\n', '')
                                line = line.replace('\r', '')
                                line = line.replace('\n', '')
                                line = line.replace(' ', '')
                                line = line.replace(',', '.')
                                line = line.replace('=', '')
                                line = line.replace('+', '')
                                line = line.replace('＋', '')
                                line = line.replace('—', '-')
                                line = line.replace('E', '9')
                                n = 0
                                while line:
                                    if n == 0:
                                        self.xt2.setText(line)
                                    line = f.readline()
                                    n = n + 1
                                f.close()
                            except:
                                pass

                            fname = workPath + u'/y1.txt'
                            try:
                                f = codecs.open(fname, 'r', 'utf-8')
                                line = f.readline()
                                line = line.replace('\r\n', '')
                                line = line.replace('\r', '')
                                line = line.replace('\n', '')
                                line = line.replace(' ', '')
                                line = line.replace(',', '.')
                                line = line.replace('=', '')
                                line = line.replace('+', '')
                                line = line.replace('＋', '')
                                line = line.replace('—', '-')
                                line = line.replace('E', '9')
                                n = 0
                                while line:
                                    if n == 0:
                                        self.yt2.setText(line)
                                    line = f.readline()
                                    n = n + 1
                                f.close()
                            except:
                                pass

                            fname = workPath + u'/x2.txt'
                            try:
                                f = codecs.open(fname, 'r', 'utf-8')
                                line = f.readline()
                                line = line.replace('\r\n', '')
                                line = line.replace('\r', '')
                                line = line.replace('\n', '')
                                line = line.replace(' ', '')
                                line = line.replace(',', '.')
                                line = line.replace('=', '')
                                line = line.replace('+', '')
                                line = line.replace('＋', '')
                                line = line.replace('—', '-')
                                line = line.replace('E', '9')
                                n = 0
                                while line:
                                    if n == 0:
                                        self.xb2.setText(line)
                                    line = f.readline()
                                    n = n + 1
                                f.close()
                            except:
                                pass

                            fname = workPath + u'/y2.txt'
                            try:
                                f = codecs.open(fname, 'r', 'utf-8')
                                line = f.readline()
                                line = line.replace('\r\n', '')
                                line = line.replace('\r', '')
                                line = line.replace('\n', '')
                                line = line.replace(' ', '')
                                line = line.replace(',', '.')
                                line = line.replace('=', '')
                                line = line.replace('＋', '')
                                line = line.replace('+', '')
                                line = line.replace('—', '-')
                                line = line.replace('E', '9')
                                n = 0
                                while line:
                                    if n == 0:
                                        self.yb2.setText(line)
                                    line = f.readline()
                                    n = n + 1
                                f.close()
                            except:
                                pass
                            n = self.comboBox_3.currentIndex()
                            flag = 0
                            fname = workPath + u'/kei.txt'
                            try:
                                f = codecs.open(fname, 'r', 'utf-8')
                                line = f.readline()
                                line = line.replace('\r\n', '')
                                line = line.replace('\r', '')
                                line = line.replace('\n', '')
                                line = line.replace(' ', '')
                                line = line.replace('1', 'I')
                                line = line.replace('D', 'IX')
                                line = line.replace('ll', 'III')
                                line = line.replace('l', 'II')
                                line = line.replace('H', 'II')
                                while line:
                                    if line == 'I':
                                        self.comboBox_3.setCurrentIndex(4)
                                        line = f.readline()
                                        kei = 1
                                    elif line == 'II':
                                        self.comboBox_3.setCurrentIndex(5)
                                        kei = 2
                                        line = f.readline()
                                    elif line == 'III':
                                        self.comboBox_3.setCurrentIndex(6)
                                        line = f.readline()
                                        kei = 3
                                    elif line == 'IV':
                                        self.comboBox_3.setCurrentIndex(7)
                                        line = f.readline()
                                        kei = 4
                                    elif line == 'V':
                                        self.comboBox_3.setCurrentIndex(8)
                                        line = f.readline()
                                        kei = 5
                                    elif line == 'VI':
                                        self.comboBox_3.setCurrentIndex(9)
                                        line = f.readline()
                                        kei = 6
                                    elif line == 'VII':
                                        self.comboBox_3.setCurrentIndex(10)
                                        line = f.readline()
                                        kei = 7
                                    elif line == 'VIII':
                                        self.comboBox_3.setCurrentIndex(11)
                                        line = f.readline()
                                        kei = 8
                                    elif line == 'IX':
                                        self.comboBox_3.setCurrentIndex(12)
                                        line = f.readline()
                                        kei = 9
                                    elif line == 'X':
                                        self.comboBox_3.setCurrentIndex(13)
                                        line = f.readline()
                                        kei = 10
                                    elif line == 'XI':
                                        self.comboBox_3.setCurrentIndex(14)
                                        line = f.readline()
                                        kei = 11
                                    elif line == 'XII':
                                        self.comboBox_3.setCurrentIndex(15)
                                        line = f.readline()
                                        kei = 12
                                    elif line == 'XIII':
                                        self.comboBox_3.setCurrentIndex(16)
                                        line = f.readline()
                                        kei = 13
                                    elif line == 'XIV':
                                        self.comboBox_3.setCurrentIndex(17)
                                        line = f.readline()
                                        kei = 14
                                    elif line == 'XV':
                                        self.comboBox_3.setCurrentIndex(18)
                                        line = f.readline()
                                        kei = 15
                                    elif line == 'XVI':
                                        self.comboBox_3.setCurrentIndex(19)
                                        line = f.readline()
                                        kei = 16
                                    elif line == 'XVII':
                                        self.comboBox_3.setCurrentIndex(20)
                                        line = f.readline()
                                        kei = 17
                                    elif line == 'XVIII':
                                        self.comboBox_3.setCurrentIndex(21)
                                        line = f.readline()
                                        kei = 18
                                    elif line == 'XIX':
                                        self.comboBox_3.setCurrentIndex(22)
                                        line = f.readline()
                                        kei = 19
                                    else:
                                        flag = 1
                                        QMessageBox.information(self, u'エラー', u'認識結果：　' + line + '\n' + u'座標系の取得に失敗しました。' + '\n' + u'クリップボードのテキストを操作説明書に従って修正して、' + '\n' + u'「digitizer.py」に追加すると次回から正しく認識されます。')
                                        clipboard = QgsApplication.clipboard()
                                        clipboard.setText(u'                line = line.replace(' + u"'" +  line + u"'" + u', ' + u"'" + u'**' + u"'" + ')')
                                        line = f.readline()
                                    line = f.readline()
                                    f.close()
                                    # 座標系設定
                                    if flag == 0:
                                        crs = QMessageBox.question(self,u'座標系認識結果', str(kei) + u' 系と認識されました。\nこれをプロジェクトのCRSに設定してもいいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
                                        if crs == QMessageBox.Yes:
                                            try:
                                                self.pButton_47()
                                            except:
                                                pass
                                        else:
                                            self.comboBox_3.setCurrentIndex(n)
                            except:
                                pass

            # 作業用ファイルの削除
            if os.path.exists(infile0):
                os.remove(infile0)
            if os.path.exists(outfile):
                os.remove(outfile)
            if os.path.exists(workPath + u'/pdf.png.aux.xml'):
                os.remove(workPath + u'/pdf.png.aux.xml')
            if os.path.exists(workPath + u'/date.png'):
                os.remove(workPath + u'/date.png')
            if os.path.exists(workPath + u'/date.txt'):
                os.remove(workPath + u'/date.txt')
            if os.path.exists(workPath + u'/kei.png'):
                os.remove(workPath + u'/kei.png')
            if os.path.exists(workPath + u'/kei.txt'):
                os.remove(workPath + u'/kei.txt')
            if os.path.exists(workPath + u'/x1.png'):
                os.remove(workPath + u'/x1.png')
            if os.path.exists(workPath + u'/x1.txt'):
                os.remove(workPath + u'/x1.txt')
            if os.path.exists(workPath + u'/y1.png'):
                os.remove(workPath + u'/y1.png')
            if os.path.exists(workPath + u'/y1.txt'):
                os.remove(workPath + u'/y1.txt')
            if os.path.exists(workPath + u'/x2.png'):
                os.remove(workPath + u'/x2.png')
            if os.path.exists(workPath + u'/x2.txt'):
                os.remove(workPath + u'/x2.txt')
            if os.path.exists(workPath + u'/y2.png'):
                os.remove(workPath + u'/y2.png')
            if os.path.exists(workPath + u'/y2.txt'):
                os.remove(workPath + u'/y2.txt')
            if os.path.exists(workPath + u'/temp.png.aux.xml'):
                os.remove(workPath + u'/temp.png.aux.xml')

        # ラスタファイルのパスを記録
        self.lineEdit_path.setText(file)
        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')
        # レイヤ追加
        fileInfo = QFileInfo(file)
        layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
        QgsProject.instance().addMapLayer(layer)

        # レイヤのIDを取得（WorldFile & Georeference 共通：ワールドファイル作成前のレイヤ削除のため）
        global Layer_ID
        Layer_ID = layer.id()
        # 画像情報を取得
        if self.tabWidget.currentIndex() == 3:#[WorldFile]
            self.wk1.setText('')
            self.wk2.setText('')
            self.wk3.setText('')
            self.wk4.setText('')
            self.size_h.setText('')
            self.size_w.setText('')
            try:
                img = Image.open(file)
                yoko = img.size[0]
                tate = img.size[1]
                self.size_h.setText(str(tate))
                self.size_w.setText(str(yoko))
            except:
                QMessageBox.information(self, u'画像フォーマットによる制限', u'画像情報を取得できませんでした。\n画像の回転、透過処理はできません。')
            self.lineEdit_path_wf.setText(file)
            self.xt2.setFocus()
            # 元データにワールドファイルがある場合は、パラメータを取得
            filepath = self.lineEdit_path.text()
            dirpath = os.path.dirname(filepath)
            filename = os.path.basename(filepath)
            fn, ext = os.path.splitext(filename)
            wf1 = dirpath + '/' + fn + ext[0:2] + ext[-1:] + 'w'
            wf2 = filepath + 'w'
            wf3 = dirpath + '/' + fn + '.wld'
            n = 0
            if os.path.exists(wf1):
                n = 1
            if os.path.exists(wf2):
                n = n + 2
            if os.path.exists(wf3):
                n = n + 4
            if n != 0:
                global wf_path
                if n == 1 or n == 3 or n == 5 or n == 7:
                    wf_path = wf1
                if n == 2 or n == 6:
                    wf_path = wf2
                if n == 4:
                    wf_path = wf3
                self.readWorldFile()
        if self.tabWidget.currentIndex() == 4:#[Georeference]
            self.lineEdit_path_gcp.setText(file)
            self.radioButton8.setChecked(True)
            self.xp1.setFocus()
            if os.path.exists(filename + '.points'):
                self.textEdit_8.clear()
                for line in codecs.open(file + '.points', 'r', 'shift-jis'):
                    line = line.replace('\r\n', '')
                    line = line.replace('\r', '')
                    line = line.replace('\n', '')
                    self.textEdit_8.append(line)
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
        # レイヤの領域にズームする
        self.zoom()


    # ワールドファイル作成（WorldFile）
    def pButton_12(self):
        if self.xb.text() == '' or self.yb.text() == '' or self.xt.text() == '' or self.yt.text() == '' or self.xb2.text() == '' or self.yb2.text() == '' or self.xt2.text() == '' or self.yt2.text() == '':
            self.textEdit_7.clear()
            return
        global wf_path
        dx1 = float(self.xb.text()) - float(self.xt.text())
        dy1 = float(self.yt.text()) - float(self.yb.text())
        dx2 = float(self.xt2.text()) - float(self.xb2.text())
        dy2 = float(self.yt2.text()) - float(self.yb2.text())
        dx3 = dx2 / dx1
        dy3 = dy2 / dy1
        x3 = float(self.xt2.text()) + dx3 * float(self.xt.text())
        y3 = float(self.yb2.text()) - dy3 * float(self.yb.text())
        self.textEdit_7.clear()
        self.textEdit_7.append(str(dy3))
        self.textEdit_7.append('0')
        self.textEdit_7.append('0')
        self.textEdit_7.append(str(dx3))
        filepath = self.lineEdit_path.text()
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        if filepath != '' and self.checkBox_crop.isChecked():
            dirpath = os.path.dirname(filepath)
            filename = os.path.basename(filepath)
            fn, ext = os.path.splitext(filename)
            pic = Image.open(filepath)
            left = int(self.yb.text())
            upper = abs(int(self.xt.text()))
            right = int(self.yt.text())
            lower = abs(int(self.xb.text()))
            fname = str(dirpath) + '/' + fn + '_crop' + ext
            pic.crop((left, upper, right, lower)).save(fname)
            self.lineEdit_path.setText(fname)
            self.lineEdit_path_wf.setText(fname)
            self.textEdit_7.append(str(self.yb2.text()))
            self.textEdit_7.append(str(self.xt2.text()))
        else:
            self.textEdit_7.append(str(y3))
            self.textEdit_7.append(str(x3))
        if self.lineEdit_path.text() == '':
            # 画像ファイルを読み込まずにワールドファイルを作成する場合
            savename = dialog.getSaveFileName(self, u'ワールドファイルを保存', '', '*.wld')
            if not savename or str(savename) == "('', '')":
                return
            fp = str(savename).split("'")
            savename = fp[1]
            reg_path = os.path.dirname(savename)
            ws.setValue("setting/reg_path", reg_path)
        else:
            savename = self.lineEdit_path.text() + 'w'
        fname = codecs.open(savename, 'w', 'shift-jis')
        fname.write(self.textEdit_7.toPlainText() + '\n')
        fname.close()
        fname = self.lineEdit_path.text()
        f = codecs.open(savename, 'r', 'shift-jis')
        txt = f.read()
        txt = txt.replace('\n', '\r\n')
        f = codecs.open(savename, 'w', 'shift-jis')
        f.write(txt)
        f.close()
        wf_path = ''
        # レイヤに追加する
        if fname != '':
            # ワールドファイル作成前のラスタレイヤを削除
            QgsProject.instance().removeMapLayer(Layer_ID)
            if self.checkBox_3.isChecked():#変換する場合
                infile0 = self.lineEdit_path.text()
                infile = ''
                outfile = ''
                outfile3 = ''
                ext2 = self.comboBox_format.currentText().lower()
                dirpath = os.path.dirname(infile0)
                filename = os.path.basename(infile0)
                fn, ext = os.path.splitext(filename)
                if ext2 == 'kml':
                    QMessageBox.information(self, u'エラー', u'KMLの出力には対応していません。\n処理を中止します。')
                    return
                # ファイル名の日本語対策（一旦、作業ディレクトリに名前を変えてコピー）
                workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
                infile = workPath + u'/temp' + ext
                infile1 = workPath + u'/temp' + ext
                shutil.copy(infile0, infile)
                sleep(0.5)
                # ReadOnly属性解除
                os.chmod(infile, 0o777)
                if ext.lower() == '.tif' or ext.lower() == '.tiff':
                    try:
                        bin_dir = self.lineEdit_bin.text()
                        cmd = '"' + bin_dir + 'gdal_translate.exe" -co TFW=YES ' + infile + ' ' + workPath + u'/temp2.tif'
                        result = subprocess.run(cmd, shell=True)
                        if result.returncode != 0:
                            QMessageBox.information(self, u'gdal_translate', u'変換に失敗しました。（gdal_translate）1')
                            return
                        wf4 = workPath + u'/temp.pngw'
                        cmd = '"' + bin_dir + 'gdal_translate.exe" ' + infile + ' ' + workPath + u'/temp.png'
                        result = subprocess.run(cmd, shell=True)
                        if result.returncode != 0:
                            QMessageBox.information(self, u'gdal_translate', u'変換に失敗しました。（gdal_translate）2')
                            return
                        os.rename(workPath + u'/temp2.tfw', wf4)
                    except:
                      pass
                # 透過処理
                img = Image.open(infile).convert('RGBA')
                datas = img.getdata()
                newData = []
                for item in datas:
                    if item[0] == 255 and item[1] == 255 and item[2] == 255:
                        newData.append((255, 255, 255, 0))
                    else:
                        newData.append(item)
                img.putdata(newData)
                img.save(infile, "PNG")
                # ワールドファイルを作業フォルダにコピーする
                wf_path = workPath + u'/temp' + ext + 'w'
                shutil.copy(savename, wf_path)
                sleep(0.5)

                if ext2 == 'txt' or ext2 == 'laz':
                    xb = float(self.xb2.text())
                    yb = float(self.yb2.text())
                    xt = float(self.xt2.text())
                    yt = float(self.yt2.text())
                    dx = abs(xb - xt)
                    dy = abs(yb - yt)
                    self.label_file.setText(infile0)     # 画像ファイル
                    self.lineEdit_y_2.setText(str(dx))   # 縦実寸
                    self.lineEdit_x_2.setText(str(dy))   # 横実寸
                    self.lineEdit_dx.setText(str(xb))    # 左下x
                    self.lineEdit_dy.setText(str(yb))    # 左下y
                    img = Image.open(infile0)
                    size = img.size
                    self.label_x_2.setText(str(size[0])) # 横px
                    self.label_y_2.setText(str(size[1])) # 縦px
                    if ext2 == 'txt':
                        self.radioButton_g3.setChecked(True)
                    if ext2 == 'laz':
                        self.radioButton_g4.setChecked(True)
                    self.tabWidget.setCurrentIndex(1)
                    self.scrollArea.move(250, 25)
                    self.scrollArea.show()
                    # 作業ファイル削除
                    if os.path.exists(infile):
                        os.remove(infile)
                    if os.path.exists(outfile):
                        os.remove(outfile)
                    if os.path.exists(outfile3):
                        os.remove(outfile3)
                    if os.path.exists(wf_path):
                        os.remove(wf_path)
                    if os.path.exists(workPath + u'/pdf.pdf'):
                        os.remove(workPath + u'/pdf.pdf')
                    if os.path.exists(workPath + u'/temp2.tif'):
                        os.remove(workPath + u'/temp2.tif')
                    if os.path.exists(workPath + u'/temp.dbf'):
                        os.remove(workPath + u'/temp.dbf')
                    if os.path.exists(workPath + u'/temp.shx'):
                        os.remove(workPath + u'/temp.shx')
                    QMessageBox.information(self, 'WorldFile', u'ワールドファイル「' + savename + u'」を作成しました。')
                    return

                os.chdir(dirpath)
                outfile = workPath + u'/temp.' + ext2
                outfile2 = dialog.getSaveFileName(self, u'ベクタファイルの保存', fn, '*.' + ext2)
                if not outfile2:
                    return
                if not outfile2 or str(outfile2) == "('', '')":
                    return
                fp = str(outfile2).split("'")
                outfile2 = fp[1]
                # コマンド作成
                ext3 = ext2
                if ext2 == 'shp':
                    ext3 = '"ESRI Shapefile"'
                if ext2 == 'fgb':
                    ext3 = '"FlatGeobuf"'
                bin_dir = self.lineEdit_bin.text()
                try:
                    if ext3 == 'dxf':
                        # プロジェクトのCRSを取得
                        epsgGet()
                        if epsgcode != '':
                            code = epsgcode
                        else:
                            code = usercode
                        # 一旦、temp_fileを作成して（GeoJSON）、作成されたファイルに4行目にCRS情報を加えたtemp_file2（GeoJSON）を作成する。
                        temp_file = workPath + '/tmp.geojson'
                        temp_file2 = workPath + '/tmp2.geojson'
                        cmd = 'gdal_polygonize.bat ' + infile + ' -f geojson ' + temp_file
                        os.system(cmd)
                        with open(temp_file, 'r', encoding='utf-8') as f:
                            lines = f.readlines()
                        crs_line = '"crs": { "type": "name", "properties": { "name": "urn:ogc:def:crs:EPSG::' + code + '" } },\n'
                        lines.insert(3, crs_line)
                        with open(temp_file2, 'w', encoding='utf-8') as f:
                            f.writelines(lines)
                        # geojson→dxf変換
                        cmd = '"' + bin_dir + 'ogr2ogr.exe" ' + outfile + ' ' + temp_file2
                    else:
                        cmd = 'gdal_polygonize.bat ' + infile + ' -f ' + ext3 + ' ' + outfile
                    result = subprocess.run(cmd, shell=True)
                    if result.returncode != 0:
                        QMessageBox.information(self, u'gdal_polygonize', u'変換に失敗しました。（gdal_polygonize）3')
                        return
                    sleep(0.5)
                    if ext2 != 'geojson':
                        shutil.copy(outfile, outfile2)
                    else:
                        # GeoJSONの場合は、作成されたファイルに１行（CRS情報）加える。
                        outfile3 = outfile + '2'
                        fout = codecs.open(outfile3, 'w', 'utf-8')
                        # プロジェクトのCRSを取得する
                        epsgGet()
                        if epsgcode != '':
                            code = epsgcode
                        else:
                            code = usercode
                        for line in open(outfile, 'r'):
                            if line[:11] == '"' + 'features' + '":':
                                line2 = '"' + 'crs' + '"' + ': { ' + '"' + 'type' + '"' + ': ' + '"' + 'name' + '"' + ', ' + '"' + 'properties' + '"' + ': { ' + '"' + 'name' + '"' + ': ' + '"' + 'urn:ogc:def:crs:EPSG::' + code + '"' + ' } },\n'
                                fout.writelines(line2)
                            fout.writelines(line)
                        fout.close()
                        shutil.copy(outfile3, outfile2)
                    fn_dst, ext_dst = os.path.splitext(outfile2)
                    fname_dst = os.path.basename(outfile2)
                    if ext2 == 'shp':
                        shutil.copy(workPath + u'/temp.dbf', fn_dst + '.dbf')
                        shutil.copy(workPath + u'/temp.shx', fn_dst + '.shx')
                    # プロジェクトのCRSを使用するモード
                    settings.setValue('/Projections/defaultBehavior', 'useProject')
                    layer = QgsVectorLayer(outfile2, fname_dst, 'ogr')
                    QgsProject.instance().addMapLayer(layer)
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/polygonize.qml'):
                      layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/polygonize.qml')
                    QMessageBox.information(self, u'WorldFile', u'「' + savename + u'」と、\n「' + outfile2 + u'」を作成しました。')
                except:
                    if sys.platform == "win32":
                        QMessageBox.information(self, u'エラー', ext2 + u' の作成に失敗しました。')
                    else:
                        QMessageBox.information(self, u'エラー', ext2 + u' の作成に失敗しました。')
                # 作業ファイル削除
                if os.path.exists(infile):
                    os.remove(infile)
                if os.path.exists(outfile):
                    os.remove(outfile)
                if os.path.exists(outfile3):
                    os.remove(outfile3)
                if os.path.exists(wf_path):
                    os.remove(wf_path)
                if os.path.exists(workPath + u'/pdf.pdf'):
                    os.remove(workPath + u'/pdf.pdf')
                if os.path.exists(workPath + u'/temp2.tif'):
                    os.remove(workPath + u'/temp2.tif')
                if os.path.exists(workPath + u'/temp.dbf'):
                    os.remove(workPath + u'/temp.dbf')
                if os.path.exists(workPath + u'/temp.shx'):
                    os.remove(workPath + u'/temp.shx')
                if os.path.exists(workPath + u'/tmp.geojson'):
                    os.remove(workPath + u'/tmp.geojson')
                if os.path.exists(workPath + u'/tmp2.geojson'):
                    os.remove(workPath + u'/tmp2.geojson')
            else:#ベクタ変換しない場合は、ラスタレイヤに追加
                # プロジェクトのCRSを使用するモード
                settings.setValue('/Projections/defaultBehavior', 'useProject')
                fileInfo = QFileInfo(fname)
                layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
                if not layer.isValid():
                    # プロジェクトのCRS設定を開始時に戻す
                    settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
                    return
                # レイヤ追加
                QgsProject.instance().addMapLayer(layer)
                # レイヤの領域にズームする
                self.zoom()
                wf_path = savename
                self.readWorldFile()
                # スタイル設定
                reg_pdf = ws.value("setting/reg_pdf", "false")
                if os.path.exists(os.path.dirname(__file__) + u'/qml/raster(WF).qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/raster(WF).qml')
                QMessageBox.information(self, 'WorldFile', u'ワールドファイル「' + savename + u'」を作成しました。')
        else:
            QMessageBox.information(self, 'WorldFile', u'ワールドファイル「' + savename + u'」を作成しました。')
        self.SetCheckBox5()
        self.SetRadioButton()
        self.zoom()
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # WorldFile⇔KMLコンバート（WorldFile）
    def pButton_32(self):
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        # プロジェクトのEPSGが「4326」以外の場合、一時的に「4326」に変更する
        if code != '4326':
            new_crs = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
            QgsProject.instance().setCrs(new_crs)
            map.refresh()
        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')

        # 画像ファイルを読み込む
        self.pButton_11()
        if self.lineEdit_path.text() == '':
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
            return
        if self.size_h.text() == '' or self.size_w.text() == '':# 画像サイズが取得できなかった場合は、先に入力を促す
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
            QMessageBox.information(self, u'エラー', u'画像サイズを入力してから、\nもう一度「変換」をクリックしてください。')
            return
        global wf_path
        filepath = self.lineEdit_path.text()
        dirpath = os.path.dirname(filepath)
        filename = os.path.basename(filepath)
        fn, ext = os.path.splitext(filename)

        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))

        if self.radioButton_wk.isChecked():#WorldFile⇒KML
            #ラスタレイヤ追加時、同一フォルダにワールドファイルがなかった場合はここで読み込む
            if self.wk1.text() == '' or self.wk2.text() == '' or self.wk3.text() == '' or self.wk4.text() == '':
                global wf_path
                wf_path = dialog.getOpenFileName(self, u'WorldFileインポート', '', '*.*')
                if not wf_path or str(wf_path) == "('', '')":
                    # プロジェクトのCRS設定を開始時に戻す
                    settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
                    return
                self.readWorldFile()
            os.chdir(dirpath)
            savename = dialog.getSaveFileName(self, u'KMLの保存先', fn + '.kml', '*.kml')
            if not savename or str(savename) == "('', '')":
                # プロジェクトのCRS設定を開始時に戻す
                settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
                return
            fp = str(savename).split("'")
            savename = fp[1]
            try:
                bb = float(self.wk4.text()) + float(self.size_h.text()) * float(self.wk2.text())
                ll = float(self.wk3.text()) + float(self.size_w.text()) * float(self.wk1.text())
                self.wk1.setText(str(ll))
                self.wk2.setText(str(bb))
                dat = '<?xml version=' + '"' + '1.0' + '"' +' encoding=' + '"' + 'UTF-8' + '"' + '?>' + '\n'
                dat = dat + '<kml xmlns=' + '"' + 'http://www.opengis.net/kml/2.2' + '"' + '>' + '\n'
                dat = dat + '    <Document>' + '\n'
                dat = dat + '        <GroundOverlay>' + '\n'
                dat = dat + '            <name></name>' + '\n'
                dat = dat + '            <description></description>' + '\n'
                dat = dat + '            <Icon><href>' + filename + '</href></Icon>' + '\n'
                dat = dat + '            <LatLonBox>' + '\n'
                dat = dat + '                <south>' + str(self.wk2.text()) + '</south>' + '\n'
                dat = dat + '                <west>' + str(float(self.wk3.text())) + '</west>' + '\n'
                dat = dat + '                <north>' + str(float(self.wk4.text())) + '</north>' + '\n'
                dat = dat + '                <east>' + str(self.wk1.text()) + '</east>' + '\n'
                dat = dat + '            </LatLonBox>' + '\n'
                dat = dat + '        </GroundOverlay>' + '\n'
                dat = dat + '    </Document>' + '\n'
                dat = dat + '</kml>' + '\n'
                fout = codecs.open(savename, 'w', 'utf-8')
                fout.write(dat)
                fout.close()
                f = codecs.open(savename, 'r', 'utf-8')
                txt = f.read()
                txt = txt.replace('\n', '\r\n')
                f = codecs.open(savename, 'w', 'utf-8')
                f.write(txt)
                f.close()
                QMessageBox.information(self, u'WorldFile⇒KML', u'「' + savename + u'」を作成しました。')
                # Google Earth を起動する
                if sys.platform == "win32":
                    os.startfile(savename)
                else:
                    opener ="open" if sys.platform == "darwin" else "xdg-open"
                    subprocess.run([opener, savename])
            except:
                QMessageBox.information(self, u'エラー', u'不正なデータです。処理を中止します。')

        else:#KML⇒WorldFile

            os.chdir(dirpath)
            fname = dialog.getOpenFileName(self, u'KMLインポート', '', '*.kml')
            if not fname or str(fname) == "('', '')":
                # プロジェクトのCRS設定を開始時に戻す
                settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
                return
            fp = str(fname).split("'")
            fname = fp[1]
            for line in codecs.open(fname, 'r', 'Shift_JISx0213'):
                if line.find('<south>') != -1:
                    dat = line.split('<south>')
                    dat2 = dat[1].split('</south>')
                    self.wk1.setText(dat2[0])
                    xb = float(dat2[0])
                if line.find('<west>') != -1:
                    dat = line.split('<west>')
                    dat2 = dat[1].split('</west>')
                    self.wk2.setText(dat2[0])
                    yb = float(dat2[0])
                if line.find('<north>') != -1:
                    dat = line.split('<north>')
                    dat2 = dat[1].split('</north>')
                    self.wk3.setText(dat2[0])
                    xt = float(dat2[0])
                if line.find('<east>') != -1:
                    dat = line.split('<east>')
                    dat2 = dat[1].split('</east>')
                    self.wk4.setText(dat2[0])
                    yt = float(dat2[0])
            try:
                db = (float(self.wk1.text()) - float(self.wk3.text())) / float(self.size_h.text())
                dl = (float(self.wk4.text()) - float(self.wk2.text())) / float(self.size_w.text())
                dat = str(dl) + '\n'
                dat = dat + '0' + '\n'
                dat = dat + '0' + '\n'
                dat = dat + str(db) + '\n'
                dat = dat + str(self.wk2.text()) + '\n'
                dat = dat + str(self.wk3.text()) + '\n'
                savename = self.lineEdit_path.text() + u'w'
                fout = codecs.open(savename, 'w', 'shift-jis')
                fout.writelines(dat)
                fout.close()
                # 元のラスタレイヤを削除
                QgsProject.instance().removeMapLayer(Layer_ID)
                # WorldFileを使ってラスタレイヤを追加する
                fileInfo = QFileInfo(self.lineEdit_path.text())
                layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
                QgsProject.instance().addMapLayer(layer)
                rect = QgsRectangle(yb,xb,yt,xt)
                map.setExtent(rect)
                map.refresh()
            except:
                wf_path = savename
                self.readWorldFile()
                QMessageBox.information(self, u'エラー', u'不正なデータです。処理を中止します。')
            QMessageBox.information(self, u'KML⇒WorldFile', u'「' + savename + u'」を作成しました。')
        # 元のCRSに戻す
        if code != '4326':
            if epsgcode != '':#元のCRSがカスタムCRSでない場合
                new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.EpsgCrsId)
            else:
                new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
        # スタイル設定
        layer = qgis.utils.iface.activeLayer()
        if self.comboBox_2.currentText() != '':
            qmlfile = str(self.comboBox_2.currentText())
            if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
        map.refresh()
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # 回転（WorldFile）
    def pButton_33(self):
        filepath = self.lineEdit_path.text()
        dirpath = os.path.dirname(filepath)
        filename = os.path.basename(filepath)
        fn, ext = os.path.splitext(filename)
        if filepath == '':
            QMessageBox.information(self, u'画像回転', u'先に「ラスタレイヤ追加」を実行してください。')
            return
        if self.lineEdit_path.text() == '':
            return
        if self.lineEdit_rotate.text() == '':
            QMessageBox.information(self, u'画像回転', u'「0°方向」または「90°方向」を選択して、\n基線となるマップキャンバス上の方向角を設定するか、\n「右回りの回転角」を選択して、\n回転角を設定してください。')
            return
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        savename = dialog.getSaveFileName(self, u'回転画像の保存先', fn + '_rotate', '*' + ext)
        if not savename or str(savename) == "('', '')":
            return
        fp = str(savename).split("'")
        savename = fp[1]
        if savename == filepath:
            QMessageBox.information(self, u'エラー', u'元ファイルは上書きできません。\n別のフォルダにするか、ファイル名を変更してください。')
            return
        # ラスタファイルを読み込む
        try:
            img1 = Image.open(filepath)
        except:
            QMessageBox.information(self, u'エラー', u'未対応のフォーマットです。\n処理を中止します。')
            return
        # 縦・横、元画像の対角線のサイズの画像を作成する
        width = img1.size[0]
        height = img1.size[1]
        wh = int(math.sqrt(int(width) **2 + int(height) **2)) + 1
        we = (wh - int(width)) / 2
        ns = (wh - int(height)) / 2
        img2 = Image.new('RGB', (wh, wh), (255, 255, 255))
        try:
            # 元画像を中央に貼り付ける
            img2.paste(img1, (int(we), int(ns)))
            # 回転
            if self.checkBox_capture.isChecked():
                if self.radioButton_rotate1.isChecked():
                    r_deg = float(self.lineEdit_rotate.text())
                else:
                    if float(self.lineEdit_rotate.text()) >= 90:
                        r_deg = float(self.lineEdit_rotate.text()) - 90
                    else:
                        r_deg = 270 + float(self.lineEdit_rotate.text())
            else:
                r_deg =  360 - float(self.lineEdit_rotate.text())
            img2 = img2.rotate(r_deg)
            # 保存する
            img2.save(savename)
            self.checkBox_capture.setChecked(False)
            self.xt2.setText('')
            self.yt2.setText('')
            self.xb2.setText('')
            self.yb2.setText('')
            # レイヤに追加する
            fileInfo = QFileInfo(savename)
            # プロジェクトのCRSを使用するモード
            settings.setValue('/Projections/defaultBehavior', 'useProject')
            layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
            if not layer.isValid():
                # プロジェクトのCRS設定を開始時に戻す
                settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
                return
            # 回転前のラスタレイヤを削除
            QgsProject.instance().removeMapLayer(Layer_ID)
            # レイヤグループ削除
            root = QgsProject.instance().layerTreeRoot()
            group = root.findGroup('WorldFile')
            if not group is None:
                for child in group.children():
                    dump = child.dump()
                    id = dump.split("=")[-1].strip()
                    QgsProject.instance().removeMapLayer(id)
                root.removeChildNode(group)
            # レイヤ追加
            QgsProject.instance().addMapLayer(layer)
            # レイヤの領域にズームする
            self.zoom()
        except:
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
            QMessageBox.information(self, u'エラー', u'未対応のフォーマットです。\n処理を中止します。')
            return
        QMessageBox.information(self, u'画像回転', u'「' + savename + u'」を作成しました。')
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # 透過 PNG／TIF 作成（WorldFile）
    def pButton_34(self):
        # 画像ファイルを読み込む
        self.pButton_11()
        if self.lineEdit_path.text() == '':
            return
        if self.size_h.text() == '' or self.size_w.text() == '':#画像サイズが取得できなかった場合は、先に入力を促す
            QMessageBox.information(self, u'エラー', u'画像サイズを入力してから、\nもう一度「作成」をクリックしてください。')
            return
        filepath = self.lineEdit_path.text()
        dirpath = os.path.dirname(filepath)
        filename = os.path.basename(filepath)
        fn, ext = os.path.splitext(filename)

        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        if self.radioButton_png.isChecked():
            savename = dialog.getSaveFileName(self, u'PNGの保存先', fn + '_trans', '*.png')
        else:
            savename = dialog.getSaveFileName(self, u'TIFの保存先', fn + '_trans', '*.tif')
        if not savename or str(savename) == "('', '')":
            return
        fp = str(savename).split("'")
        savename = fp[1]
        if savename == filepath:
            QMessageBox.information(self, u'エラー', u'元ファイルは上書きできません。\n別のフォルダにするか、ファイル名を変更してください。')
            return
        try:
            # ラスタファイルを読み込む
            img = Image.open(filepath)
            # 'RGB'モードでなければ、'RGB'モードに変換する
            if img.mode != 'RGB':
                img = img.convert('RGB')
            width = img.size[0]
            height = img.size[1]
            R1 = int(self.R1.text())
            G1 = int(self.G1.text())
            B1 = int(self.B1.text())
            R2 = int(self.R2.text())
            G2 = int(self.G2.text())
            B2 = int(self.B2.text())
            # 同じサイズの画像を作成する
            if self.checkBox_linecolor.isChecked():
                trans = Image.new('RGBA', img.size, (R1, G1, B1, 0))
            else:
                trans = Image.new('RGBA', img.size, (255, 255, 255, 0))

            # 1ピクセルずつ処理する（透過色以外を転記する）
            #for x in xrange(width):
            for x in range(width):
                for y in range(height):
                    pixel = img.getpixel((x, y))
                    if pixel[0] == R1 and pixel[1] == G1 and pixel[2] == B1:
                        continue
                    if self.checkBox_linecolor.isChecked():
                        trans.putpixel((x, y), (R2, G2, B2))
                    else:
                        trans.putpixel((x, y), pixel)
            # 保存する
            trans.save(savename)
            # 元データにワールドファイルがある場合は、パラメータを取得し、透過画像用のワールドファイルを作成する
            wf1 = dirpath + '/' + str(fn) + str(ext[0:2]) + str(ext[-1:]) + 'w'
            wf2 = dirpath + '/' + str(filename) + 'w'
            wf3 = dirpath + '/' + str(fn) + '.wld'
            n = 0
            if os.path.exists(wf1):
                n = 1
            if os.path.exists(wf2):
                n = n + 2
            if os.path.exists(wf3):
                n = n + 4
            if n != 0:
                global wf_path
                # savename を self.readWorldFile() で読み込むとエラーを起こすのでテンポラリファイルから読み込む
                if n == 1 or n == 3 or n == 5 or n == 7:
                    shutil.copy(wf1, savename + 'w')
                    wf_path = wf1
                if n == 2 or n == 6:
                    shutil.copy(wf2, savename + 'w')
                    wf_path = wf2
                if n == 4:
                    shutil.copy(wf3, savename + 'w')
                    wf_path = wf3
        except:
            QMessageBox.information(self, u'エラー', u'未対応のフォーマットです。\n処理を中止します。')
            return

        # レイヤに追加する
        fileInfo = QFileInfo(savename)
        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')
        layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
        # 透過処理前のラスタレイヤを削除
        QgsProject.instance().removeMapLayer(Layer_ID)
        # レイヤ追加
        QgsProject.instance().addMapLayer(layer)
        self.lineEdit_path.setText(savename)
        if n == 0:
            self.wk1.setText('')
            self.wk2.setText('')
            self.wk3.setText('')
            self.wk4.setText('')
        else:
            self.readWorldFile()
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
        if n != 0:
            QMessageBox.information(self, u'透過処理', u'「' + savename + u'」と、\n「' + savename + u'w」を作成しました。')
        else:
            QMessageBox.information(self, u'透過処理', u'「' + savename + u'」を作成しました。')


    # 透過色の選択（WorldFile）
    def pButton_35(self):
        color = QColorDialog.getColor(QColor(255, 255, 255), self)
        if color.isValid():
            cn = color.name()
            self.R1.setText(str(int(cn[1:3], 16)))
            self.G1.setText(str(int(cn[3:5], 16)))
            self.B1.setText(str(int(cn[-2:], 16)))


    # 線色の選択（WorldFile）
    def pButton_36(self):
        color = QColorDialog.getColor(QColor(0, 0, 0), self)
        if color.isValid():
            cn = color.name()
            self.R2.setText(str(int(cn[1:3], 16)))
            
            self.G2.setText(str(int(cn[3:5], 16)))
            self.B2.setText(str(int(cn[-2:], 16)))


   # パターン呼出（WorldFile）
    def pButton_13(self):
        pt = self.comboBox.currentText().split(',')
        self.xt.setText(pt[-4])
        self.yt.setText(pt[-3])
        self.xb.setText(pt[-2])
        self.yb.setText(pt[-1])
        self.lineEdit_pattern.setText(pt[0])
        self.radioButton5.setChecked(True)
        x1 = float(self.xt.text())
        y1 = float(self.yt.text())
        rect = QgsRectangle(float(y1),float(x1),float(y1),float(x1))
        map.setExtent(rect)
        map.refresh()
        self.xt2.setFocus()


    # チェックボックスセット（WorldFile）
    def SetCheckBox1(self):
        if self.checkBox_xt.isChecked():
            self.checkBox_yt.setChecked(False)
            self.checkBox_xb.setChecked(False)
            self.checkBox_yb.setChecked(False)
            self.SetRadioButton()
    def SetCheckBox2(self):
        if self.checkBox_yt.isChecked():
            self.checkBox_xt.setChecked(False)
            self.checkBox_xb.setChecked(False)
            self.checkBox_yb.setChecked(False)
            self.SetRadioButton()
    def SetCheckBox3(self):
        if self.checkBox_xb.isChecked():
            self.checkBox_xt.setChecked(False)
            self.checkBox_yt.setChecked(False)
            self.checkBox_yb.setChecked(False)
            self.SetRadioButton()
    def SetCheckBox4(self):
        if self.checkBox_yb.isChecked():
            self.checkBox_xt.setChecked(False)
            self.checkBox_yt.setChecked(False)
            self.checkBox_xb.setChecked(False)
            self.SetRadioButton()
    def SetCheckBox5(self):
        self.checkBox_xt.setChecked(False)
        self.checkBox_yt.setChecked(False)
        self.checkBox_xb.setChecked(False)
        self.checkBox_yb.setChecked(False)
    def SetRadioButton(self):
        self.radioButton1.setChecked(False)
        self.radioButton2.setChecked(False)
        self.radioButton3.setChecked(False)
        self.radioButton4.setChecked(False)
        self.radioButton5.setChecked(True)


    # カスタムパターン登録（WorldFile）
    def pButton_22(self):
        if self.xt.text() == '' or self.yt.text() == '' or self.xb.text() == '' or self.yb.text() == '' or self.lineEdit_pattern.text() == '':
            return
        if self.xt.text() == '-596' and self.yt.text() == '4306' and self.xb.text() == '-4563' and self.yb.text() == '371':
            QMessageBox.information(self,u'パターン登録', u'「新見出有」として登録済みのパターンです。')
            self.comboBox.setCurrentIndex(0)
            self.lineEdit_pattern.setText(u'新見出有')
            return
        if self.xt.text() == '-596' and self.yt.text() == '4312' and self.xb.text() == '-4564' and self.yb.text() == '371':
            QMessageBox.information(self,u'パターン登録', u'「旧見出有」として登録済みのパターンです。')
            self.comboBox.setCurrentIndex(1)
            self.lineEdit_pattern.setText(u'旧見出有')
            return
        if self.xt.text() == '-636' and self.yt.text() == '4312' and self.xb.text() == '-4604' and self.yb.text() == '371':
            QMessageBox.information(self,u'パターン登録', u'「旧見出無」として登録済みのパターンです。')
            self.comboBox.setCurrentIndex(2)
            self.lineEdit_pattern.setText(u'旧見出無')
            return
        if self.lineEdit_pattern.text() == u'新見出有' or self.lineEdit_pattern.text() == u'旧見出有' or self.lineEdit_pattern.text() == u'旧見出無':
            QMessageBox.information(self,u'パターン登録', u'使用できないパターン名です。')
            self.lineEdit_pattern.setFocus()
            return
        self.comboBox.addItem(self.lineEdit_pattern.text() + ',' + self.xt.text() + ',' + self.yt.text() + ',' + self.xb.text() + ',' + self.yb.text())
        self.textEdit_pattern.append(self.lineEdit_pattern.text() + ',' + self.xt.text() + ',' + self.yt.text() + ',' + self.xb.text() + ',' + self.yb.text())
        ptfname = os.path.dirname(__file__) + u'/pattern.txt'
        fname = open(ptfname,'w')
        fname.write(self.textEdit_pattern.toPlainText())
        fname.close()
        QMessageBox.information(self,'WorldFile', u'カスタムパターンファイル\n[' + ptfname + u']\nに登録しました。')


    # 地図の中心にする－右上（WorldFile）
    def pButton_26(self):
        x1 = float(self.xt.text())
        y1 = float(self.yt.text())
        rect = QgsRectangle(float(y1),float(x1),float(y1),float(x1))
        map.setExtent(rect)
        map.refresh()
        self.xt2.setFocus()


    # 地図の中心にする－左下（WorldFile）
    def pButton_27(self):
        x1 = float(self.xb.text())
        y1 = float(self.yb.text())
        rect = QgsRectangle(float(y1),float(x1),float(y1),float(x1))
        map.setExtent(rect)
        map.refresh()
        self.xb2.setFocus()


# ----------ジオリファレンス----------------------------------------------------------------------------------------------------------------
    # ワールドファイル作成(Georeference)
    def pButton_14(self):
        if self.lineEdit_path.text() == '':
            QMessageBox.information(None, 'GCP', u'先にラスタレイヤを追加してください。')
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
            return
        if self.xp1.text() == '':
            self.xp1.setText('0')
        if self.yp1.text() == '':
            self.yp1.setText('0')
        if self.xp2.text() == '':
            self.xp2.setText('0')
        if self.yp2.text() == '':
            self.yp2.setText('0')
        if self.r.text() == '0' or self.r.text() == '':
            self.r.setText('400')
        if self.s.text() == '0' or self.s.text() == '':
            self.s.setText('1000')
        t = 0.0254 / float(self.r.text()) * float(self.s.text())
        x0 = float(self.xp2.text()) - t * float(self.xp1.text())
        y0 = float(self.yp2.text()) - t * float(self.yp1.text())
        self.xp3.setText(str(x0))
        self.yp3.setText(str(y0))
        self.xp4.setText(str(t * -1))
        self.yp4.setText(str(t))
        self.textEdit_9.clear()
        self.textEdit_9.append(str(t))
        self.textEdit_9.append('0')
        self.textEdit_9.append('0')
        self.textEdit_9.append(str(t * -1))
        self.textEdit_9.append(str(y0))
        self.textEdit_9.append(str(x0))
        if self.lineEdit_path.text() == '':
            return
        else:
            savename = self.lineEdit_path.text() + 'w'
        global Layer_ID
        fname = codecs.open(savename, 'w', 'shift-jis')
        fname.write(self.textEdit_9.toPlainText() + '\n')
        fname.close()
        QMessageBox.information(self, 'Georeference', u'仮のワールドファイル「' + savename + u'」を作成しました。')
        self.radioButton8.setChecked(True)
        fname = self.lineEdit_path.text()
        if self.lineEdit_path.text() != '':
            # プロジェクトのCRSを使用するモード
            settings.setValue('/Projections/defaultBehavior', 'useProject')
            fileInfo = QFileInfo(fname)
            layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
            if not layer.isValid():
                # プロジェクトのCRS設定を開始時に戻す
                settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
                return
            # ワールドファイル作成前のラスタレイヤを削除
            QgsProject.instance().removeMapLayer(Layer_ID)
            # レイヤグループ削除
            root = QgsProject.instance().layerTreeRoot()
            group = root.findGroup('GroundControlPoint')
            if not group is None:
                for child in group.children():
                    dump = child.dump()
                    id = dump.split("=")[-1].strip()
                    QgsProject.instance().removeMapLayer(id)
                root.removeChildNode(group)
            # レイヤ追加
            QgsProject.instance().addMapLayer(layer)
            # レイヤの領域にズームする
            self.zoom()
            # レイヤのIDを取得（GCPファイル作成前のレイヤ削除のため）
            Layer_ID = layer.id()
            # スタイル設定
            if self.comboBox_2.currentText() != '':
              qmlfile = str(self.comboBox_2.currentText())
              if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
            try:
                QgsProject.instance().removeMapLayer(Layer_GCP_ID)
            except:
                pass
            self.xp1.setText('')
            self.yp1.setText('')
            self.xp2.setText('')
            self.yp2.setText('')
            self.xp1.setFocus()
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # GCP保存(Georeference)
    def pButton_15(self):
        if self.lineEdit_path.text() == '':
            return
        else:
            savename = self.lineEdit_path.text() + '.points'
            if not savename:
                return
        fname = codecs.open(savename, 'w', 'shift-jis')
        fname.write(self.textEdit_8.toPlainText() + '\r\n')
        fname.close()
        QMessageBox.information(self, 'Georeference', u'GCPファイル「' + savename + u'」を作成しました。\n\n「ラスタ」「ジオリファレンサー」を起動して、\n再度「' + self.lineEdit_path.text() + u'」を読み込み、\n変換の設定をして、ジオリファレンスを開始してください。')
        fname2 = self.lineEdit_path.text() + 'w' #WorldFile削除
        if os.path.exists(fname2):
            os.remove(fname2)
        # GCP作成前のラスタレイヤを削除
        QgsProject.instance().removeMapLayer(Layer_ID)
        # レイヤグループ削除
        root = QgsProject.instance().layerTreeRoot()
        group = root.findGroup('GroundControlPoint')
        if not group is None:
            for child in group.children():
                dump = child.dump()
                id = dump.split("=")[-1].strip()
                QgsProject.instance().removeMapLayer(id)
            root.removeChildNode(group)


    # GCP登録（Georeference）
    def pButton_53(self):
        if self.textEdit_9.toPlainText() == '':#ワールドファイル作成前の場合
            self.s.setFocus()
        else:#ワールドファイル作成済の場合
            if not self.radioButton9.isChecked():
              return
            if self.xp2.text() == '' or self.yp2.text() == '':
              return
            mPosX = float(self.mPosX.text())
            mPosY = float(self.mPosY.text())
            xx = float(self.xp2.text())
            yy = float(self.yp2.text())
            y0 = float(self.lineEdit_y.text())
            x0 = float(self.lineEdit_x.text())
            coordinate = str(xx) + ',' + str(yy)
            # プロジェクトのCRSを使用するモード
            settings.setValue('/Projections/defaultBehavior', 'useProject')
            # プロジェクトのCRSを取得する
            epsgGet()
            if epsgcode != '':
                code = epsgcode
            else:
                code = usercode
            x0 = (float(self.xp3.text()) - float(self.xp1.text())) / float(self.xp4.text())
            y0 = (float(self.yp1.text()) - float(self.yp3.text())) / float(self.yp4.text())
            self.textEdit_8.append(self.yp2.text() + ',' + self.xp2.text() + ',' + str(y0) + ',' + str(x0) + ',1')
            self.radioButton8.setChecked(True)
            name = 'Dst'
            # ポイントレイヤの追加
            layer = QgsVectorLayer('Point?crs=epsg:' + code + '&field=' + self.tr('name') + '&field=' + self.tr('x') + '&field=' + self.tr('y'), name, 'memory')
            provider = layer.dataProvider()
            feature = QgsFeature()
            geometry = QgsGeometry.fromPointXY(QgsPointXY(mPosX, mPosX))
            feature.setGeometry(geometry)
            feature.setAttributes([name,mPosY,mPosX])
            provider.addFeatures([feature])
            # グループ化
            QgsProject.instance().addMapLayer(layer, False)
            if QgsProject.instance().layerTreeRoot().findGroup(self.tr('GroundControlPoint')) == None:
                QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.tr('GroundControlPoint')))
            group = QgsProject.instance().layerTreeRoot().findGroup(self.tr('GroundControlPoint'))
            group.insertLayer(0,layer)
            # スタイル設定
            if self.radioButton9.isChecked():
                if os.path.exists(os.path.dirname(__file__) + u'/qml/DestGCP.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/DestGCP.qml')
            else:
                if os.path.exists(os.path.dirname(__file__) + u'/qml/SrcGCP.qml'):
                    layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/SrcGCP.qml')
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # ジオリファレンシング(Georeference)
    def pButton_59(self):
        if self.lineEdit_path.text() == '':
            return
        dirpath = os.path.dirname(self.lineEdit_path.text())
        filename = os.path.basename(self.lineEdit_path.text())
        fn, ext = os.path.splitext(filename)
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        savename = workPath + u'/temp.points'
        fname = codecs.open(savename, 'w', 'shift-jis')
        fname.write(self.textEdit_8.toPlainText().replace('\r', ''))
        fname.close()
        n = len(open(savename).readlines()) - 1
        if self.comboBox_4.currentIndex() == 0:#多項式１(3点)
            order = '-order 1 -co '
            if n < 3:
                QMessageBox.information(self, u'GCPを追加してください。', u'「多項式１」は、GCPが 3点 以上必要です。')
                return
        if self.comboBox_4.currentIndex() == 1:#多項式２(6点)
            order = '-order 2 -co '
            if n < 6:
                QMessageBox.information(self, u'GCPを追加してください。', u'「多項式２」は、GCPが 6点 以上必要です。')
                return
        if self.comboBox_4.currentIndex() == 2:#多項式３(10点)
            order = '-order 3 -co '
            if n < 10:
                QMessageBox.information(self, u'GCPを追加してください。', u'「多項式３」は、GCPが 10点 以上必要です。')
                return
        if self.comboBox_4.currentIndex() == 3:#シンプレートスプライン(3点)
            order = '-tps  -co '
            if n < 3:
                QMessageBox.information(self, u'GCPを追加してください。', u'「シンプレートスプライン」は、GCPが 3点 以上必要です。')
                return
        if self.comboBox_5.currentIndex() == 0:
            resample = 'near '
        if self.comboBox_5.currentIndex() == 1:
            resample = 'bilinear '
        if self.comboBox_5.currentIndex() == 2:
            resample = 'cubic '
        if self.comboBox_5.currentIndex() == 3:
            resample = 'cubicspline '
        if self.comboBox_5.currentIndex() == 4:
            resample = 'lanczos '
        if self.comboBox_6.currentIndex() == 0:
            comp = 'NONE '
        if self.comboBox_6.currentIndex() == 1:
            comp = 'LZW '
        if self.comboBox_6.currentIndex() == 2:
            comp = 'PACKBITS '
        if self.comboBox_6.currentIndex() == 3:
            comp = 'DEFLATE '
        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')
        bin_dir = self.lineEdit_bin.text()
        dat1 = '"' + bin_dir + 'gdal_translate.exe" -of GTiff -a_srs EPSG:' + self.lineEdit_EPSG3.text() + ' '
        dat2 = '"' + bin_dir + 'gdalwarp.exe" -r '
        for line in codecs.open(savename, 'r', 'shift-jis'):
            if line[:5] != 'mapX,':
                gcp = line.split(',')
                dat1 = dat1 + ' -gcp ' + gcp[2] + ' ' + gcp[3].replace('-', '') + ' ' + gcp[0] + ' ' +gcp[1]
        # ファイル名の日本語対策（一旦、作業ディレクトリに名前を変えてコピー）
        infile = workPath + u'/temp' + ext
        shutil.copy(filename, infile)
        os.chmod(infile, 0o777)
        sleep(0.5)
        dat1 = dat1 + ' "' + infile + '" "' + workPath + u'/temp2.tif"'
        dat2 = dat2 + resample + order + 'COMPRESS=' + comp + ' "' + workPath + u'/temp2.tif" "' + workPath + u'/temp3.tif"'
        result = subprocess.run(dat1, shell=True)
        if result.returncode != 0:
            QMessageBox.information(self, u'gdal_translate', u'変換に失敗しました。（gdal_translate）')
            return
        result = subprocess.run(dat2, shell=True)
        if result.returncode != 0:
            QMessageBox.information(self, u'gdal_warp', u'変換に失敗しました。（gdal_warp）')
            return
        sleep(0.5)
        shutil.copy(workPath + u'/temp3.tif', dirpath + '/' + fn + '_modified.tif')
        geotif = dirpath + '/' + fn + '_modified.tif'
        fileInfo = QFileInfo(geotif)
        layer = QgsRasterLayer(fileInfo.filePath(), fileInfo.completeBaseName())
        # WorldFile削除
        fname2 = self.lineEdit_path.text() + 'w'
        if os.path.exists(fname2):
            os.remove(fname2)
        # ワールドファイル作成前のラスタレイヤを削除
        QgsProject.instance().removeMapLayer(Layer_ID)
        # レイヤグループ削除
        root = QgsProject.instance().layerTreeRoot()
        group = root.findGroup('GroundControlPoint')
        if not group is None:
            for child in group.children():
                dump = child.dump()
                id = dump.split("=")[-1].strip()
                QgsProject.instance().removeMapLayer(id)
            root.removeChildNode(group)
        # レイヤ追加
        QgsProject.instance().addMapLayer(layer)
        self.lineEdit_path.setText(geotif)
        # スタイルの設定
        if self.comboBox_2.currentText() != '':
          qmlfile = str(self.comboBox_2.currentText())
          if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
            layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
        # レイヤの領域にズームする
        self.zoom()
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))
        if os.path.exists(workPath + u'/temp' + ext):
            os.remove(workPath + u'/temp' + ext)
        if os.path.exists(workPath + u'/temp2.tif'):
            os.remove(workPath + u'/temp2.tif')
        if os.path.exists(workPath + u'/temp3.tif'):
            os.remove(workPath + u'/temp3.tif')
        if os.path.exists(workPath + u'/temp.points'):
            os.remove(workPath + u'/temp.points')


    # 消去(Georeference)
    def pButton_17(self):
        keizoku = QMessageBox.question(self,u'消去', u'実行してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if keizoku == QMessageBox.Yes:
            self.xp1.setText('')
            self.yp1.setText('')
            self.xp2.setText('')
            self.yp2.setText('')
            self.xp3.setText('')
            self.yp3.setText('')
            self.xp4.setText('')
            self.yp4.setText('')
            self.textEdit_8.clear()
            self.textEdit_9.clear()
            self.textEdit_8.append('mapX,mapY,pixelX,pixelY,enable')
            # レイヤグループ削除
            root = QgsProject.instance().layerTreeRoot()
            group = root.findGroup('GroundControlPoint')
            if not group is None:
                for child in group.children():
                    dump = child.dump()
                    id = dump.split("=")[-1].strip()
                    QgsProject.instance().removeMapLayer(id)
                root.removeChildNode(group)
            self.radioButton10.setChecked(True)
            map.refresh()


# ----------Exif----------------------------------------------------------------------------------------------------------------
    # フォルダ選択（Exif）
    def OpenBrowse(self):
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        dialog.setOption(QFileDialog.ShowDirsOnly)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        foldername = dialog.getExistingDirectory(self, u'フォルダを選択してください。')
        if foldername == "" or foldername == None:
            return
        self.textPath.setText(foldername)
        ws.setValue("setting/reg_path", foldername)


    # Exif2CSV（Exif）
    def getExifInfo(self):
        if self.textPath.text() == '':
            QMessageBox.information(self,u'エラー', u'GPS情報付きのExifがある写真を置いたフォルダを指定してください。')
            return
        self.textExif.clear()
        if self.comboKei.currentText() == '':
            self.textExif.append('name,filepath,lat,lon')
        else:
            self.textExif.append('name,filepath,lat,lon,x,y,kei')
        path = self.textPath.text()
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        regPath = ws.value("setting/reg_path", os.path.dirname(__file__) + u'/work')
        savename = workPath + u'/photo.csv'
        os.chdir(regPath)
        csv_file = codecs.open(savename,'w', 'utf-8')
        if self.comboKei.currentText() == '':
            csv_file.write('name,filepath,lat,lon\n')
        else:
            csv_file.write('name,filepath,lat,lon,x,y,kei\n')
        extens = ['jpg','jpeg','JPG','JPEG']
        found = {x: [] for x in extens}
        for (dirpath, dirnames, filenames) in os.walk(path):
            for filename in filenames:
                ext = filename.lower().rsplit('.', 1)[-1]
                if ext in extens:
                    fullpath = os.path.join(dirpath, filename)
                    im = Image.open(filename)
                    exif = im._getexif()
                    exif = {
                        ExifTags.TAGS[MyKey]: MyValue
                        for MyKey, MyValue in exif.items()
                        if MyKey in ExifTags.TAGS
                    }
                    if 'GPSInfo' in exif:
                        gps_tags = exif['GPSInfo']
                        gps = {
                            ExifTags.GPSTAGS.get(t, t): gps_tags[t]
                            for t in gps_tags
                        }
                        is_lat = 'GPSLatitude' in gps
                        is_lat_ref = 'GPSLatitudeRef' in gps
                        is_lon = 'GPSLongitude' in gps
                        is_lon_ref = 'GPSLongitudeRef' in gps
                        if is_lat and is_lat_ref and is_lon and is_lon_ref:
                            lat = gps['GPSLatitude']
                            lat_ref = gps['GPSLatitudeRef']
                            if lat_ref == 'N':
                                lat_sign = 1.0
                            elif lat_ref == 'S':
                                lat_sign = -1.0
                            lon = gps['GPSLongitude']
                            lon_ref = gps['GPSLongitudeRef']
                            if lon_ref == 'E':
                                lon_sign = 1.0
                            elif lon_ref == 'W':
                                lon_sign = -1.0
                            lat_ang0 = lat_sign * lat[0] + lat[1] / 60 + lat[2] / 3600
                            lon_ang0 = lon_sign * lon[0] + lon[1] / 60 + lon[2] / 3600
                            x, y = lat, lon
                            data = filename + ',' + fullpath + ',' + str(lat_ang0) + ',' + str(lon_ang0)
                            if self.comboKei.currentText() != '':
                                epsg = int(self.comboKei.currentText()) + 2442
                                crsSrc = QgsCoordinateReferenceSystem(4326)
                                crsDest = QgsCoordinateReferenceSystem(epsg)
                                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                y1,x1 = trans.transform(lon_ang0,lat_ang0)
                                data = data + ',' + str(x1) + ',' + str(y1) + ',' + self.comboKei.currentText()
                            csv_file.write(data + '\n')
                            self.textExif.append(data)

        csv_file.close()
        if self.textExif.toPlainText() == 'name,filepath,lat,lon' or self.textExif.toPlainText() == 'name,filepath,lat,lon,x,y,kei':
              self.textExif.clear()
              QMessageBox.information(self, u'Exif', u'位置情報を取得できるファイルはありませんでした。')
              return
        uri = 'file:///' + workPath + u'/photo.csv?delimiter=%s&xField=%s&yField=%s' % (',', 'field_4', 'field_3') + '&crs=epsg:4326'
        layer = QgsVectorLayer(uri, 'photo', 'delimitedtext')
        # スタイルの設定
        if self.checkBox_filename.isChecked():
            if os.path.exists(os.path.dirname(__file__) + u'/qml/photo.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/photo.qml')
        else:
            if os.path.exists(os.path.dirname(__file__) + u'/qml/photo2.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/photo2.qml')

        # レイヤの追加（スタイル設定を先に実行しなければ、アクションの設定が反映されない）
        QgsProject.instance().addMapLayer(layer)
        global PhotoLayer_ID
        PhotoLayer_ID = layer.id()
        # プロジェクトのCRSを使用するモード
        settings.setValue('/Projections/defaultBehavior', 'useProject')
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        # EPSG:4326に変更する
        if code != '4326':
            new_crs = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
            QgsProject.instance().setCrs(new_crs)
        # レイヤの領域にズームする
        self.zoom()
        # Shape出力オプション
        if self.checkBox_shape.isChecked():
            dialog = QFileDialog()
            dialog.setFileMode(QFileDialog.Directory)
            try:
                dialog.setDirectory(reg_path)
            except:
                dialog.setDirectory(os.path.dirname(__file__))
            savename = dialog.getSaveFileName(self, u'Shapeファイルを保存', 'photo', '*.shp')
            if savename != '' and str(savename) != "('', '')":
                fp = str(savename).split("'")
                savename = fp[1]
                # カレントPathを記録する
                reg_path = os.path.dirname(savename)
                ws.setValue("setting/reg_path", reg_path)
                # Shapeファイル作成
                QgsVectorFileWriter.writeAsVectorFormat(layer,savename,"shift-jis",layer.crs(),"ESRI Shapefile")
                # Shapeファイル読込
                layer = QgsVectorLayer(savename, 'photo(ESRI Shapefile)', 'ogr')
                QgsProject.instance().addMapLayer(layer)
                global PhotoLayer2_ID
                PhotoLayer2_ID = layer.id()
                # スタイルの設定
                if self.checkBox_filename.isChecked():
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/photo.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/photo.qml')
                else:
                    if os.path.exists(os.path.dirname(__file__) + u'/qml/photo2.qml'):
                        layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/photo2.qml')
                # アクションの設定を有効にするため「photo」レイヤをアクティブにしてから削除する
                layer_registry = QgsProject.instance().mapLayer(PhotoLayer_ID)
                qgis.utils.iface.setActiveLayer(layer_registry)
                QgsProject.instance().removeMapLayer(PhotoLayer_ID)
        # 元のCRSに戻す（他に追加されたレイヤがない場合は、4326のまま）
        if code != '4326':
            if epsgcode != '':
                new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.EpsgCrsId)
            else:
                new_crs = QgsCoordinateReferenceSystem(int(code), QgsCoordinateReferenceSystem.InternalCrsId)
            QgsProject.instance().setCrs(new_crs)
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # CSV保存（Exif）
    def saveExif(self):
        if self.textExif.toPlainText() == '' or self.textExif.toPlainText() == 'name,filepath,lat,lon' or self.textExif.toPlainText() == 'name,filepath,lat,lon,x,y,kei':
            return
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        savename = dialog.getSaveFileName(self, u'ファイルを保存', '', '*.csv')
        if not savename or str(savename) == "('', '')":
            return
        fp = str(savename).split("'")
        savename = fp[1]
        reg_path = os.path.dirname(savename)
        ws.setValue("setting/reg_path", reg_path)
        fname = codecs.open(savename, 'w', 'shift-jis')
        fname.write(self.textExif.toPlainText() + '\n')
        fname.close()
        QMessageBox.information(self,u'CSV保存', savename + u' を作成しました。')


    # KMZ保存（Exif）
    def saveKMZ(self):
        if str(self.textPath.text().encode('shift-jis')) == '':
            QMessageBox.information(self,u'kmz保存', u'写真フォルダを選択してください。')
            return
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        infilename = workPath + u'/photo.csv' #プラグインフォルダに作成したCSVを使用
        if os.path.exists(infilename):
            reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
            dialog = QFileDialog()
            dialog.setFileMode(QFileDialog.Directory)
            try:
              dialog.setDirectory(reg_path)
            except:
              dialog.setDirectory(os.path.dirname(__file__))
            savename = dialog.getSaveFileName(self, u'ファイルを保存', '', '*.kmz')
            if not savename or str(savename) == "('', '')":
                return
            fp = str(savename).split("'")
            savename = fp[1]
            reg_path = os.path.dirname(savename)
            ws.setValue("setting/reg_path", reg_path)
            n = 0
            placemarkdata =''
            savename2 = self.textPath.text() + '/photo.kml'
            kml_file = codecs.open(savename2,'w', 'utf-8')
            kml_file.write('<?xml version="1.0" encoding="UTF-8"?><kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2"><Document id="feat_1">\n')
            for line in codecs.open(infilename, 'r', 'utf-8'):
                if n > 0:
                    dat = line.split(',')
                    filename = dat[0]
                    fn, ext = os.path.splitext(filename)
                    lat = dat[2]
                    lon = dat[3]
                    if self.comboKei.currentText() != '':
                        x1 = dat[4]
                        y1 = dat[5]
                        k = int(dat[6])
                        styledata = '<Style id="stylesel_' + str(n) + '"><BalloonStyle><text>File Name : photo' + str(n) + ext + ' (Original Name : ' + filename + ')&lt;/br&gt;X=' + str(x1) + ' Y=' + str(y1) + ' (' + str(k) + 'kei)&lt;/br&gt;&lt;/p&gt;&lt;table width=400 cellpadding=0 cellspacing=0"&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td&gt;&lt;img width=98%" src="files/photo' + str(n) + ext + '"&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table</text><displayMode>default</displayMode></BalloonStyle></Style>' + '\n'
                    else:
                        styledata = '<Style id="stylesel_' + str(n) + '"><BalloonStyle><text>File Name : photo' + str(n) + ext + ' (Original Name : ' + filename + ')&lt;/br&gt;Latitude: ' + str(lat) + ' Longitude: ' + str(lon) + ' &lt;/br&gt;&lt;/p&gt;&lt;table width=400 cellpadding=0 cellspacing=0"&gt;&lt;tbody&gt;&lt;tr&gt;&lt;td&gt;&lt;img width=98%" src="files/photo' + str(n) + ext + '"&gt;&lt;/td&gt;&lt;/tr&gt;&lt;/tbody&gt;&lt;/table</text><displayMode>default</displayMode></BalloonStyle></Style>' + '\n'
                    kml_file.write(styledata)
                    placemarkdata = placemarkdata + '<Placemark id="feat_' + str(n) + '"><name>' + fn + '</name><description>files/photo' + str(n) + ext + '</description><styleUrl>#stylesel_' + str(n) + '</styleUrl><Point id="geom_' + str(n) + '"><coordinates>' + str(lon) + ',' + str(lat) + ',0.0</coordinates></Point></Placemark>' + '\n'
                n = n + 1
            kml_file.write(placemarkdata)
            kml_file.write('</Document></kml>')
            kml_file.close()
            photodir = self.textPath.text() + '/kmz/files'
            try:
                shutil.copytree(self.textPath.text(), photodir)
            except:
                pass
            # テンポラリフォルダ・ファイルにreadonly属性がついていたら解除する
            os.chmod(photodir, 0o777)
            no = 1
            for root, dirs, files in os.walk(photodir):
                for file in files:
                    fn, ext = os.path.splitext(file)
                    try:
                        os.chmod(photodir + '/' + file, 0o777)
                    except:
                        pass
                    if ext == '.jpg' or ext == '.jpeg' or ext == '.JPG' or ext == '.JPEG':
                        try:
                            os.rename(photodir + '/' + file, photodir + '/photo' + str(no) + str(ext))
                            no = no + 1
                        except:
                           pass
                    else:
                        if file != 'photo.kml':
                            try:
                                os.remove(photodir + '/' + file)
                            except:
                                pass
            shutil.copy(savename2, self.textPath.text() + '/kmz/photo.kml')
            os.remove(photodir + '/photo.kml')
            shutil.make_archive(self.textPath.text() + '/kmz', 'zip', self.textPath.text() + '/kmz/')
            shutil.copy(self.textPath.text() + '/kmz.zip', savename)
            n = n - 1
            if n > 0:
                QMessageBox.information(self,u'kmz保存', str(n) + u' ファイル エクスポートしました。')
                # Google Earth を起動する
                if sys.platform == "win32":
                    os.startfile(savename)
                else:
                    opener ="open" if sys.platform == "darwin" else "xdg-open"
                    subprocess.run([opener, savename])
                # テンポラリファイルを削除する
                os.remove(self.textPath.text() + '/photo.kml')
                os.remove(self.textPath.text() + '/kmz.zip')
                try:
                    shutil.rmtree(self.textPath.text() + '/kmz')
                except:
                    pass
            else:
                QMessageBox.information(self,u'kmz保存', u'エクスポートできませんでした。')
        else:
            QMessageBox.information(self,u'kmz保存', u'先にレイヤに追加してください。')
            return


    # Exif情報書換(Exif)
    def editExif(self):
        if self.lineEdit_Lat.text() == '':
            return
        if self.lineEdit_Lon.text() == '':
            return
        epsgGet()
        epsg = int(epsgcode)
        if self.radioButton_Exif2.isChecked(): #緯度・経度
            if epsg != 4326:
                QMessageBox.information(self, u'エラー', u'「緯度・経度」が選択されています。\nプロジェクトのEPSGを「4326」に設定してください。')
                return
            lat = float(self.lineEdit_Lat.text())
            lon = float(self.lineEdit_Lon.text())
        else: #平面直角座標
            if (epsg > 2442 and epsg < 2462) or (epsg > 6668 and epsg < 6688):
                x = float(self.lineEdit_Lat.text())
                y = float(self.lineEdit_Lon.text())
                crsSrc = QgsCoordinateReferenceSystem(epsg)
                crsDest = QgsCoordinateReferenceSystem(4326)
                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                lon,lat = trans.transform(y,x)
            else:
                QMessageBox.information(self, u'エラー', u'「平面直角座標」が選択されています。\nプロジェクトのEPSGを変更したい世界測地系の平面直角座標系に設定してください。')
                return
        b1 = int(lat)
        b2 = int((lat - b1) * 60)
        b3 = int(((lat - b1) * 60 - b2) * 60 * 100)
        l1 = int(lon)
        l2 = int((lon - l1) * 60)
        l3 = int(((lon  - l1) * 60 - l2) * 60 * 100)
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        infile = dialog.getOpenFileName(self, u'画像選択', '', u'*.jpg(*.jpg)')
        if not infile or str(infile) == "('', '')":
            return
        fp = str(infile).split("'")
        infile = fp[1]
        dirpath = os.path.dirname(infile)
        filename = os.path.basename(infile)
        fn, ext = os.path.splitext(filename)
        ws.setValue("setting/reg_path", dirpath)
        imagefile = workPath + u'/temp' + ext
        shutil.copy(infile, imagefile)
        sleep(0.5)
        os.chmod(imagefile, 0o777)

#        img = Image.open(imagefile)
#        exif_dict = piexif.load(img.info["exif"])
#        exif_dict["GPS"][piexif.GPSIFD.GPSLatitude] = ((b1, 1), (b2 ,1), (b3, 100))  #lat
#        exif_dict["GPS"][piexif.GPSIFD.GPSLongitude] = ((l1, 1), (l2 ,1), (l3, 100)) #lon
#        exif_bytes = piexif.dump(exif_dict)
#        imagefile = dirpath + '/' + fn + u'_copy.jpg'
#        try:
#            img.save(imagefile, "jpeg", exif=exif_bytes)
#            QMessageBox.information(self, u'位置情報書換', u'書換元の画像フォルダに「' + fn + u'_copy.jpg」を作成しました。')
#        except:
#            QMessageBox.information(self, u'位置情報書換', u'位置情報書換に失敗しました。')

        img = Image.open(imagefile)
        # 既存のExif情報をロードし、存在しない場合は空の辞書を準備
        exif_dict = {}
        if "exif" in img.info:
            try:
                exif_dict = piexif.load(img.info["exif"])
            except Exception as e:
                # Exifロード中にエラーが発生した場合、空の辞書を使い、既存のExifは無視する
                QMessageBox.warning(self, u'Exif読込エラー', u'既存のExif情報読込中にエラーが発生しました。\n一部情報が失われる可能性があります。')
                exif_dict = {}
        # Exif IFD, GPS IFDが存在しない場合に初期化
        if "0th" not in exif_dict:
            exif_dict["0th"] = {}
        if "Exif" not in exif_dict:
            exif_dict["Exif"] = {}
        if "GPS" not in exif_dict:
            exif_dict["GPS"] = {}
        # --- エラーの原因となる不正なタグのチェックと修正/削除 ---
        # Exif IFD (41729: SceneType) の不正値を修正する処理
        tag_41729 = piexif.ExifIFD.SceneType
        if tag_41729 in exif_dict["Exif"]:
            current_value = exif_dict["Exif"][tag_41729]
            # 💡 修正ポイント: 値がint型であれば、piexifが期待するバイト列に変換する
            if isinstance(current_value, int):
                # SceneTypeの標準値は1（デジタル画像）であり、1バイトのバイト列として表現される
                if current_value == 1:
                    # '1'をバイト列 b'\x01'に変換し、piexifが処理できるようにする
                    exif_dict["Exif"][tag_41729] = b'\x01'
                else:
                    # その他の整数値は不正とみなし、削除
                    del exif_dict["Exif"][tag_41729]
            # 値がバイト列(bytes)またはタプル(tuple)でない場合は削除
            elif not isinstance(current_value, (bytes, tuple)):
                del exif_dict["Exif"][tag_41729]
        # その他の IFD (0th, Exif, GPS) に含まれる不正な値をチェックし削除する処理 (以前と同じ、継続して適用)
        for ifd in ["0th", "Exif", "GPS", "1st"]:
            if ifd in exif_dict:
                for tag, value in list(exif_dict[ifd].items()):
                    # piexifが期待する型（バイト列、タプル、整数など）でない値を削除
                    if not isinstance(value, (bytes, tuple, int)):
                        del exif_dict[ifd][tag]
                    # 有理数タプルが空の場合もエラーになる可能性があるためチェック
                    elif isinstance(value, tuple) and not value: 
                        del exif_dict[ifd][tag]
        # --- GPS情報の書き込み ---
        # 緯度・経度の書き込み。分母を100として精度を上げます。
        # GPSIFD.GPSLatitudeRef, GPSIFD.GPSLongitudeRef の設定も確実に行う
        exif_dict["GPS"][piexif.GPSIFD.GPSLatitudeRef] = "N" if lat >= 0 else "S"
        exif_dict["GPS"][piexif.GPSIFD.GPSLongitudeRef] = "E" if lon >= 0 else "W"
        exif_dict["GPS"][piexif.GPSIFD.GPSLatitude] = ((abs(b1), 1), (b2 ,1), (b3, 100))
        exif_dict["GPS"][piexif.GPSIFD.GPSLongitude] = ((abs(l1), 1), (l2 ,1), (l3, 100))
        # 変換成功後にdumpを実行
        try:
            exif_bytes = piexif.dump(exif_dict)
        except ValueError as e:
            QMessageBox.critical(self, u'Exif変換エラー', u'最終的なExif変換に失敗しました。\nエラー: ' + str(e))
            return
            
        imagefile = dirpath + '/' + fn + u'_copy.jpg'
        try:
            img.save(imagefile, "jpeg", exif=exif_bytes)
            QMessageBox.information(self, u'位置情報書換', u'書換元の画像フォルダに「' + fn + u'_copy.jpg」を作成しました。')
        except:
            QMessageBox.information(self, u'位置情報書換', u'位置情報書換に失敗しました。')


    # 位置情報書換で平面直角座標を選択した場合、メッセージを表示（Exif）
    def epsgMsg(self):
        QMessageBox.information(self, u'EPSG', u'プロジェクトのEPSGを変更したい世界測地系の平面直角座標系に設定してください。')


    # 位置情報書換で緯度・経度を選択した場合、EPSG4326に変更（Exif）
    def epsg4326(self):
        self.comboBox_3.setCurrentIndex(3)
        new_crs = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
        QgsProject.instance().setCrs(new_crs)
        map.refresh()
        QMessageBox.information(self, u'EPSG:4326', u'プロジェクトのEPSGを「4326(WGS84)」に変更しました。')


    # 消去（Exif）
    def pButton_60(self):
        keizoku = QMessageBox.question(self,u'消去', u'実行してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if keizoku == QMessageBox.Yes:
            self.textPath.clear()
            self.textExif.clear()
            try:
                QgsProject.instance().removeMapLayer(exif_layer)
            except:
                pass
            try:
                QgsProject.instance().removeMapLayer(PhotoLayer_ID)
            except:
                pass
            try:
                QgsProject.instance().removeMapLayer(PhotoLayer2_ID)
            except:
                pass
            try:
                os.remove(workPath + u'/photo.csv')
            except:
                pass
            map.refresh()
            workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')


# ----------座標変換----------------------------------------------------------------------------------------------------------------
    # CSV保存（座標変換）
    def pButton_8(self):
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        savename = dialog.getSaveFileName(self, u'ファイルを保存', '', '*.csv')
        if not savename or str(savename) == "('', '')":
            return
        fp = str(savename).split("'")
        savename = fp[1]
        reg_path = os.path.dirname(savename)
        ws.setValue("setting/reg_path", reg_path)
        fname = open(savename, 'w')
        fname.write('name,x(latitude),y(longitude),x(latitude),y(longitude)\n')
        fname.write(self.textEdit_5.toPlainText() + '\n')
        fname.close()


    # 座標変換実行（座標変換）
    def pButton_10(self):
        # 変換元・変換先のEPSG入力は必須
        if self.lineEdit_EPSG1.text() == '':
            QMessageBox.information(self, u'エラー', u'変換元のEPSGを設定してください。')
            self.lineEdit_EPSG1.setFocus()
            return
        else:
            code = self.lineEdit_EPSG1.text()
            custom1 = str(QgsCoordinateReferenceSystem(int(code)).authid())
        if self.lineEdit_EPSG2.text() == '':
            QMessageBox.information(self, u'エラー', u'変換先のEPSGを設定してください。')
            self.lineEdit_EPSG2.setFocus()
            return
        else:
            code = self.lineEdit_EPSG2.text()
            custom2 = str(QgsCoordinateReferenceSystem(int(code)).authid())
        if self.lineEditX1.text() == '':
            QMessageBox.information(self, u'エラー', u'変換元のX(緯度)を入力してください。')
            self.lineEditX1.setFocus()
            return
        if self.lineEditY1.text() == '':
            QMessageBox.information(self, u'エラー', u'変換元のY(経度)を入力してください。')
            self.lineEditY1.setFocus()
            return
        # 変換
        if custom1 == '':#変換元がカスタムCRSの場合
            Src_crs = QgsCoordinateReferenceSystem()
            Src_crs.createFromId(int(self.lineEdit_EPSG1.text()), QgsCoordinateReferenceSystem.InternalCrsId)
            crsSrc = QgsCoordinateReferenceSystem(Src_crs)
        else:
            crsSrc = QgsCoordinateReferenceSystem(int(self.lineEdit_EPSG1.text()))
        if custom2 == '':#変換先がカスタムCRSの場合
            Dest_crs = QgsCoordinateReferenceSystem()
            Dest_crs.createFromId(int(self.lineEdit_EPSG2.text()), QgsCoordinateReferenceSystem.InternalCrsId)
            crsDest = QgsCoordinateReferenceSystem(Dest_crs)
        else:
            crsDest = QgsCoordinateReferenceSystem(int(self.lineEdit_EPSG2.text()))

        # 2024.03.01 道庁座標⇔世界測地系の変換の場合、日本測地系の変換を噛ます
        flag = 0
        epsg1 = int(self.lineEdit_EPSG1.text())
        epsg2 = int(self.lineEdit_EPSG2.text())
        crs1_name = crsSrc.userFriendlyIdentifier()
        crs2_name = crsDest.userFriendlyIdentifier()
        if (('道庁' in crs1_name and '部原点' in crs1_name) or '地理調査所' in crs1_name):
            # 変換元EPSGが世界測地系の場合
            if (epsg2 > 2442 and epsg2 < 2462):
                flag = 1
                epsg3 = epsg2 + 27718
            elif (epsg2 > 6668 and epsg2 < 6688):
                flag = 1
                epsg3 = epsg2 + 23492
            elif (epsg2 == 4326 or epsg2 == 4612):
                flag = 1
                epsg3 = 4301
        if (('道庁' in crs2_name and '部原点' in crs2_name) or '地理調査所' in crs2_name):
            # 変換先EPSGが世界測地系の場合
            if (epsg1 > 2442 and epsg1 < 2462):
                flag = 1
                epsg3 = epsg1 + 27718
            elif (epsg1 > 6668 and epsg1 < 6688):
                flag = 1
                epsg3 = epsg1 + 23492
            elif (epsg1 == 4326 or epsg1 == 4612):
                flag = 1
                epsg3 = 4301

        if flag == 0:
            trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
            x1 = float(self.lineEditX1.text())
            y1 = float(self.lineEditY1.text())
            y2,x2 = trans.transform(y1,x1)
            self.lineEditX2.setText(str(x2))
            self.lineEditY2.setText(str(y2))
            p3 = str(self.lineEdit_3.text()) + str(int(self.lineEdit_4.text()) + 1)
            self.textEdit_5.append(self.lineEdit_3.text() + str(int(self.lineEdit_4.text()) + 1) + ',' + str(x1) + ',' + str(y1) + ',' + str(x2) + ',' + str(y2))
            no2 = int(self.lineEdit_4.text()) + 1
            self.lineEdit_4.setText(str(no2))
            self.lineEditX1.setFocus()
        else:
            crsDest2 = QgsCoordinateReferenceSystem(epsg3)
            trans = QgsCoordinateTransform(crsSrc, crsDest2, QgsProject.instance())
            x1 = float(self.lineEditX1.text())
            y1 = float(self.lineEditY1.text())
            y2,x2 = trans.transform(y1,x1)
            trans = QgsCoordinateTransform(crsDest2, crsDest, QgsProject.instance())
            y3,x3 = trans.transform(y2,x2)
            self.lineEditX2.setText(str(x3))
            self.lineEditY2.setText(str(y3))
            p3 = str(self.lineEdit_3.text()) + str(int(self.lineEdit_4.text()) + 1)
            self.textEdit_5.append(self.lineEdit_3.text() + str(int(self.lineEdit_4.text()) + 1) + ',' + str(x1) + ',' + str(y1) + ',' + str(x3) + ',' + str(y3))
            no2 = int(self.lineEdit_4.text()) + 1
            self.lineEdit_4.setText(str(no2))
            self.lineEditX1.setFocus()

        # 変換結果を地図の中心にプロットする
        if self.checkBox_4.isChecked():
            # プロジェクトのCRSを使用するモード
            settings.setValue('/Projections/defaultBehavior', 'useProject')
            # ポイントレイヤの追加
            layer = QgsVectorLayer('Point?crs=epsg:' + self.lineEdit_EPSG1.text() + '&field=' + self.tr('name') + '&field=' + self.tr('x') + '&field=' + self.tr('y'), p3, 'memory')
            provider = layer.dataProvider()
            feature = QgsFeature()
            geometry = QgsGeometry.fromPointXY(QgsPointXY(float(y1), float(x1)))
            feature.setGeometry(geometry)
            feature.setAttributes([p3,float(y1), float(x1)])
            provider.addFeatures([feature])
            # グループ化
            QgsProject.instance().addMapLayer(layer, False)
            if QgsProject.instance().layerTreeRoot().findGroup(self.tr('Projection')) == None:
                QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.tr('Projection')))
            group = QgsProject.instance().layerTreeRoot().findGroup(self.tr('Projection'))
            group.insertLayer(0,layer)
            rect = QgsRectangle(float(y1),float(x1),float(y1),float(x1))
            map.setExtent(rect)
            map.refresh()
            # レイヤID記録
            Layer_Proj_ID = layer.id()
            self.comboBox_ProjLayer.addItem(Layer_Proj_ID)
            # スタイルの設定
            if os.path.exists(os.path.dirname(__file__) + u'/qml/projection.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/projection.qml')
            # プロジェクトのCRS設定を開始時に戻す
            settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))


    # 地図の中心にする（座標変換）
    def pButton_21(self):
        if self.lineEditX1.text() == '' or self.lineEditY1.text() == '':
            self.lineEditX1.setFocus()
            return
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        x1 = float(self.lineEditX1.text())
        y1 = float(self.lineEditY1.text())
        rect = QgsRectangle(float(y1),float(x1),float(y1),float(x1))
        map.setExtent(rect)
        layer = QgsVectorLayer('Point?crs=epsg:' + code + '&field=name&field=x&field=y', 'PanToPoint', 'memory')
        provider = layer.dataProvider()
        feature = QgsFeature()
        geometry = QgsGeometry.fromPointXY(QgsPointXY(float(y1), float(x1)))
        feature.setGeometry(geometry)
        feature.setAttributes([u'Here!', float(y1), float(x1)])
        provider.addFeatures([feature])
        # グループ化
        QgsProject.instance().addMapLayer(layer, False)
        if QgsProject.instance().layerTreeRoot().findGroup(self.tr('Projection')) == None:
            QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.tr('Projection')))
        group = QgsProject.instance().layerTreeRoot().findGroup(self.tr('Projection'))
        group.insertLayer(0,layer)
        # スタイルの設定
        if os.path.exists(os.path.dirname(__file__) + u'/qml/projection.qml'):
            layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/projection.qml')
        map.refresh()


    # 一括変換（座標変換）
    def pButton_65(self):
        if self.lineEdit_EPSG1.text() == '' or self.lineEdit_EPSG2.text() == '':
            QMessageBox.information(self, u'エラー', u'変換元と変換先のEPSGを設定してください。')
            return
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        try:
            os.remove(workPath + u'/temp.txt')
        except:
            pass
        try:
            os.remove(workPath + u'/temp.obj')
        except:
            pass
        try:
            os.remove(workPath + u'/temp.obj.mtl')
        except:
            pass
        try:
            os.remove(workPath + u'/temp2.obj')
        except:
            pass
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        try:
            dialog.setDirectory(reg_path)
        except:
            dialog.setDirectory(workPath)
        # CSVファイルを読み込む
        fname = dialog.getOpenFileName(self, u'[一括変換]　変換元のファイルを選択してください。', '', '*.*')
        if not fname or str(fname) == "('', '')":
            return
        fn = str(fname).split("'")
        fname = fn[1]
        reg_path = os.path.dirname(fname)
        ws.setValue("setting/reg_path", reg_path)
        os.chdir(reg_path)
        
        fn, ext = os.path.splitext(fname)

        code1 = self.lineEdit_EPSG1.text()
        custom1 = str(QgsCoordinateReferenceSystem(int(code1)).authid())
        code2 = self.lineEdit_EPSG2.text()
        custom2 = str(QgsCoordinateReferenceSystem(int(code2)).authid())
        if custom1 == '':#変換元がカスタムCRSの場合
            Src_crs = QgsCoordinateReferenceSystem()
            Src_crs.createFromId(int(self.lineEdit_EPSG1.text()), QgsCoordinateReferenceSystem.InternalCrsId)
            crsSrc = QgsCoordinateReferenceSystem(Src_crs)
        else:
            crsSrc = QgsCoordinateReferenceSystem(int(self.lineEdit_EPSG1.text()))
        if custom2 == '':#変換先がカスタムCRSの場合
            Dest_crs = QgsCoordinateReferenceSystem()
            Dest_crs.createFromId(int(self.lineEdit_EPSG2.text()), QgsCoordinateReferenceSystem.InternalCrsId)
            crsDest = QgsCoordinateReferenceSystem(Dest_crs)
        else:
            crsDest = QgsCoordinateReferenceSystem(int(self.lineEdit_EPSG2.text()))

        flag = 0
        if ext.lower() == '.wrl':# 地理院のVRML（.wrl）用
            try:
                import pymeshlab
            except:
                pass
            qv = Qgis.QGIS_VERSION.split('.')
            pv = platform.python_version().split('.')
            if int(qv[1]) < 40:
                QMessageBox.information(self, u'エラー', u'地理院のVRML（.wrl）を変換するには、QGIS3.40以上のバージョンが必要です。')
                return
            self.lineEdit_EPSG1.setText('3857')
            crsSrc = QgsCoordinateReferenceSystem(int(self.lineEdit_EPSG1.text()))
            flag = 1
            ms = pymeshlab.MeshSet()
            savename = dialog.getSaveFileName(self, u'ファイルを保存', '', '*.obj')
            if not savename or str(savename) == "('', '')":
                return
            fn5 = str(savename).split("'")
            fname5 = fn5[1]
            fn5, ext5 = os.path.splitext(fname5)

            for line in open(fname, 'r'):
                if 'url ["' in line:
                    line = line.replace((u'\n'), '')
                    line = line.replace((u'\r'), '')
                    dat = line.split('url ')
                    gazo = dat[1].lstrip('["').rstrip('"]')

            self.label_file.setText(reg_path + '/' + gazo)
            img = Image.open(reg_path + '/' + gazo)
            size = img.size
            self.label_x_2.setText(str(size[0]))
            self.label_y_2.setText(str(size[1]))
            self.lineEdit_x_2.setText(str(size[0]))
            self.lineEdit_y_2.setText(str(size[1]))
            # ワールドファイルがある場合は、実寸と左下座標を計算する
            # 元データにワールドファイルがある場合は、縦横の実寸・左右下座標を計算する
            dirpath = os.path.dirname(reg_path + '/' + os.path.basename(gazo))
            filename = os.path.basename(reg_path + '/' + os.path.basename(gazo))
            fn, ext = os.path.splitext(reg_path + '/' + os.path.basename(gazo))
            wf1 = fn + '.wld'                    #wld
            wf2 = fn + ext + 'w'                 #pngw,tifw,jpgw...
            wf3 = fn + ext[0:2] + ext[-1:] + 'w' #pgw,tfw,jgw...
            w = 0
            if os.path.exists(wf1):
                w = 1
            if os.path.exists(wf2):
                w = 2
            if os.path.exists(wf3):
                w = 3
            # ワールドファイルが複数あった場合、QGISの優先順位に会わせる
            # wf1(pgw,tfw,jgw...)→wf2(pngw,tifw,jpgw...)→wf3(wld)
            if w != 0:
                if w == 1:
                    world_file = wf1
                if w == 2 :
                    world_file = wf2
                if w == 3:
                    world_file = wf3
                n = 1
                with open(world_file) as f:
                    for line in f:
                        if n == 1:
                            xd = float(line)
                        if n == 4:
                            yd = float(line)
                        if n == 5:
                            yt = float(line)
                        if n == 6:
                            xt = float(line)
                        n = n + 1
                xx = xd * size[0]
                yy = yd * size[1]
                xb = xt + yy
                self.lineEdit_x_2.setText(str(xx))
                self.lineEdit_y_2.setText(str(abs(yy)))
                self.lineEdit_dx.setText(str(xb))
                self.lineEdit_dy.setText(str(yt))
                dxy = ((xx / 150) + (abs(yy) / 150)) / 2

            # PyMeshLabによるwrl→obj変換
            ms.load_new_mesh(fname)
            ms.save_current_mesh(workPath + u'/temp.obj', save_textures = True, texture_quality = -1)

            # 変換元obj作成
            fname6 = workPath + u'/temp2.obj'
            fout = open(fname6, 'w')
            n = 1
            for line in open(workPath + u'/temp.obj', 'r'):
                line = line.replace((u'\n'), '')
                line = line.replace((u'\r'), '')
                if line[0:2] == 'v ':
                    dat = line.split(' ')
                    x1 = float(dat[1]) * dxy
                    z1 = float(dat[2]) * dxy
                    y1 = -1 * float(dat[3]) * dxy
                    if n == 1:
                        dx = -(x1)
                        dy = -(y1)
                    x1 = x1 + dx + yt
                    y1 = y1 + dy + xt
                    new_dat = dat[0] + ' ' + str(x1) + ' ' + str(y1) + ' ' + str(z1) + ' ' + dat[4] + ' ' + dat[5] + ' ' + dat[6]
                    fout.writelines(new_dat + '\n')
                    n = n + 1
                elif line[0:3] == 'vn ':
                    dat = line.split(' ')
                    x1 = float(dat[1])
                    z1 = float(dat[2])
                    y1 = -1 * float(dat[3])
                    new_dat = dat[0] + ' ' + str(x1) + ' ' + str(y1) + ' ' + str(z1)
                    fout.writelines(new_dat + '\n')
                else:
                    if line[0:7] == 'mtllib ':
                        fn6, ext6 = os.path.splitext(os.path.basename(fname5))
                        fout.writelines('mtllib ' + fn6 + '.mtl\n')
                    else:
                        fout.writelines(line + '\n')
            fout.close

            # mtlファイルの作成
            fout = open(reg_path + '/' + fn6 + '.mtl', 'w')
            fout.writelines('# Generated by Digitizer3\n')
            fout.writelines('# Material Count: 1\n')
            fout.writelines('newmtl material_0\n')
            fout.writelines('Ns 2.250001\n')
            fout.writelines('Ka 1.000000 1.000000 1.000000\n')
            fout.writelines('Kd 1.000000 1.000000 1.000000\n')
            fout.writelines('Ks 0.500000 0.500000 0.500000\n')
            fout.writelines('Ke 0.000000 0.000000 0.000000\n')
            fout.writelines('Ni 1.450000\n')
            fout.writelines('d 1.000000\n')
            fout.writelines('illum 2\n')
            fout.writelines('map_Kd ' + gazo + '\n')
            fout.close

            # 座標変換
            fout = open(fname5, 'w')
            infile = workPath + u'/temp.txt'
            fout2 = open(infile, 'w')
            fout2.writelines(u'name y x z\n')
            for line in open(fname6, 'r'):
                line = line.replace((u'\n'), '')
                line = line.replace((u'\r'), '')
                if line[0:2] == 'v ':
                    dat = line.split(' ')
                    y1 = float(dat[1])
                    x1 = float(dat[2])
                    trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                    x2,y2 = trans.transform(y1, x1)
                    new_dat = dat[0] + ' ' + str(x2) + ' ' + str(y2) + ' ' + dat[3] + ' ' + dat[4] + ' ' + dat[5] + ' ' + dat[6]
                    fout.writelines(new_dat + '\n')
                    fout2.writelines(new_dat + '\n')
                else:
                    fout.writelines(line + '\n')
            fout.close
            fout2.close
            self.lineEdit_9.setText('1')
            self.lineEdit_10.setText('3')
            self.lineEdit_11.setText('2')
            self.lineEdit_12.setText(' ')
            QMessageBox.information(self, u'一括変換', u'「' + os.path.basename(fname5) + u'」と「'  + fn6 + '.mtl」を作成しました。')

        elif ext.lower() == '.obj': # objの座標変換
            try:
                import pymeshlab
            except:
                pass

            flag = 1
            x = QInputDialog().getInt(None, u"obj変換", u"1 = 座標変換<br>2 = 平行移動<br>3 = サイズ変更", 1, 1, 3, 1)

            if str(x) == '(2, True)': # objの平行移動
                dx, ok = QInputDialog().getDouble(self, "横方向","補正値:", 0.00000000000, -9999999999, 9999999999, 11)
                dy, ok = QInputDialog().getDouble(self, "縦方向","補正値:", 0.00000000000, -9999999999, 9999999999, 11)
                dz, ok = QInputDialog().getDouble(self, "上下方向","補正値:", 0.00000000000, -9999999999, 9999999999, 11)
                newname = reg_path + '/(dx=' + str(dx) + ',dy=' + str(dy) + ',dz=' + str(dz) + ')' + os.path.basename(fname)
                fout = open(newname, 'w')
                infile = workPath + u'/temp.txt'
                fout2 = open(infile, 'w')
                fout2.writelines(u'name y x z\n')
                for line in open(fname, 'r'):
                    line = line.replace((u'\n'), '')
                    line = line.replace((u'\r'), '')
                    if line[0:2] == 'v ':
                        dat = line.split(' ')
                        x1 = float(dat[1]) + dx
                        y1 = float(dat[2]) + dy
                        z1 = float(dat[3]) + dz
                        new_dat = dat[0] + ' ' + str(x1) + ' ' + str(y1) + ' ' + str(z1)
                        fout.writelines(new_dat + '\n')
                        fout2.writelines(new_dat + '\n')
                    else:
                        fout.writelines(line + '\n')
                fout.close
                fout2.close
                self.lineEdit_9.setText('1')
                self.lineEdit_10.setText('3')
                self.lineEdit_11.setText('2')
                self.lineEdit_12.setText(' ')
                QMessageBox.information(self, u'Z値補正', os.path.basename(fname) + u'のZ値を補正しました。')

            elif str(x) == '(3, True)':# objのサイズ変更

                s, ok = QInputDialog().getDouble(self, "サイズ変更","スケール:", 0.0000000000, 0, 100000000, 10)
                newname = reg_path + '/(s=' + str(s) + ')' + os.path.basename(fname)
                fout = open(newname, 'w')
                infile = workPath + u'/temp.txt'
                fout2 = open(infile, 'w')
                fout2.writelines(u'name y x z\n')
                n = 1
                for line in open(fname, 'r'):
                    line = line.replace((u'\n'), '')
                    line = line.replace((u'\r'), '')
                    if line[0:2] == 'v ':
                        dat = line.split(' ')
                        x1 = float(dat[1]) * s
                        y1 = float(dat[2]) * s
                        z = float(dat[3]) * s
                        if n == 1:
                            minZ = z
                        else:
                            if z < minZ:
                                minZ = z
                        new_dat = dat[0] + ' ' + str(x1) + ' ' + str(y1) + ' ' + str(z)
                        fout.writelines(new_dat + '\n')
                        fout2.writelines(new_dat + '\n')
                        n = n + 1
                    else:
                        fout.writelines(line + '\n')
                fout.close
                fout2.close
                self.lineEdit_9.setText('1')
                self.lineEdit_10.setText('3')
                self.lineEdit_11.setText('2')
                self.lineEdit_12.setText(' ')
                QMessageBox.information(self, u'サイズ変更', os.path.basename(fname) + u'のサイズを変更しました。\nZの最小値＝' + str(minZ))

            else: # Blenderでエクスポートしたobj専用（v y x z)......EPSG:3857以外に変換
                  # 1.国土地理院のVRMLをBlenderでobj化したもの（インポート:前方がX,上がY、エクスポート：前方がX,上がZ）
                  # 2.BlenderGISで切り出したBasemap（エクスポート：前方がY,上がZ、パスモード：自動→tempフォルダに.tifと.wldが保存される。）

                self.lineEdit_EPSG1.setText('3857')
                crsSrc = QgsCoordinateReferenceSystem(int(self.lineEdit_EPSG1.text()))
                txt = ''
                mtl = fn + u'.mtl'
                xt = 0
                yt = 0
                for line in open(mtl, 'r'):
                    line = line.replace((u'\n'), '')
                    line = line.replace((u'\r'), '')
                    if line[0:7].lower() == 'map_kd ':
                        dat = line.split(' ')
                        # BlenderGISのBasemapの場合、'\\'→'\'に置換して、tempフォルダの.tif.wldを.objフォルダにコピー
                        gazo = dat[1].replace(chr(92),'[]').replace('[][]',chr(92))
                        gazo_path = os.path.dirname(gazo)
                        if gazo_path != '': # BlenderGISのBasemapの場合(.tif & .wld）
                            fn, ext = os.path.splitext(os.path.basename(gazo))
                            try:
                                shutil.copy(gazo_path + '/' + fn + '.wld', reg_path + '/' + fn + '.wld')
                                shutil.copy(gazo, reg_path + '/' + os.path.basename(gazo))
                            except:
                                pass
                        else: # 国土地理院のwrlをBlenderでobj化した場合（texture.png & texture.pwg）
                            self.label_file.setText(reg_path + '/' + os.path.basename(gazo))
                            img = Image.open(reg_path + '/' + os.path.basename(gazo))
                            size = img.size
                            self.label_x_2.setText(str(size[0]))
                            self.label_y_2.setText(str(size[1]))
                            self.lineEdit_x_2.setText(str(size[0]))
                            self.lineEdit_y_2.setText(str(size[1]))
                            # ワールドファイルがある場合は、実寸と左下座標を計算する
                            # 元データにワールドファイルがある場合は、縦横の実寸・左右下座標を計算する
                            dirpath = os.path.dirname(reg_path + '/' + os.path.basename(gazo))
                            filename = os.path.basename(reg_path + '/' + os.path.basename(gazo))
                            fn, ext = os.path.splitext(reg_path + '/' + os.path.basename(gazo))
                            wf1 = fn + '.wld'                    #wld
                            wf2 = fn + ext + 'w'                 #pngw,tifw,jpgw...
                            wf3 = fn + ext[0:2] + ext[-1:] + 'w' #pgw,tfw,jgw...
                            w = 0
                            if os.path.exists(wf1):
                                w = 1
                            if os.path.exists(wf2):
                                w = 2
                            if os.path.exists(wf3):
                                w = 3
                            # ワールドファイルが複数あった場合、QGISの優先順位に会わせる
                            # wf1(pgw,tfw,jgw...)→wf2(pngw,tifw,jpgw...)→wf3(wld)
                            if w != 0:
                                if w == 1:
                                    world_file = wf1
                                if w == 2 :
                                    world_file = wf2
                                if w == 3:
                                    world_file = wf3
                                n = 1
                                with open(world_file) as f:
                                    for line in f:
                                        if n == 1:
                                            xd = float(line)
                                        if n == 4:
                                            yd = float(line)
                                        if n == 5:
                                            yt = float(line)
                                        if n == 6:
                                            xt = float(line)
                                        n = n + 1
                                xx = xd * size[0]
                                yy = yd * size[1]
                                xb = xt + yy
                                self.lineEdit_x_2.setText(str(xx))
                                self.lineEdit_y_2.setText(str(abs(yy)))
                                self.lineEdit_dx.setText(str(xb))
                                self.lineEdit_dy.setText(str(yt))
                        txt = txt + 'map_Kd ' + os.path.basename(gazo) + '\n'
                    else:
                        txt = txt + line + '\n'
                # **.objと**.mtlから、new_**.objとnew_**.mtlを作成
                fout = open(reg_path + '/new_' + os.path.basename(mtl), 'w')
                fout.write(txt)
                fout.close()
                outfile = reg_path + '/new_' + os.path.basename(fname)
                fout = open(outfile, 'w')
                infile = workPath + u'/temp.txt'
                fout2 = open(infile, 'w')
                fout2.writelines(u'name y x z\n')
                n = 1
                for line in open(fname, 'r'):
                    line = line.replace((u'\n'), '')
                    line = line.replace((u'\r'), '')
                    if line[0:2] == 'v ':
                        dat = line.split(' ')
                        name = dat[0]
                        y1 = float(dat[1])
                        x1 = float(dat[2])
                        z = float(dat[3])
                        if gazo_path == '':
                            if n == 1:
                                dx = -(x1)
                                dy = -(y1)
                            y1 = y1 + dy + yt
                            x1 = x1 + dx + xt
                        trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                        x2,y2 = trans.transform(y1, x1)
                        new_dat = name + ' ' + str(x2) + ' ' + str(y2) + ' ' + str(z)
                        fout.writelines(new_dat + '\n')
                        fout2.writelines(new_dat + '\n')
                        n = n + 1
                    elif line[0:7] == 'mtllib ':
                        dat = line.split(' ')
                        fout.writelines(dat[0] + ' new_' + dat[1] + '\n')
                    else:
                        fout.writelines(line + '\n')
                fout.close
                fout2.close
                self.lineEdit_9.setText('1')
                self.lineEdit_10.setText('3')
                self.lineEdit_11.setText('2')
                self.lineEdit_12.setText(' ')
                QMessageBox.information(self, u'一括変換', 'new_' + os.path.basename(fname) + u' と ' + 'new_' + os.path.basename(mtl) + u'を作成しました。')
        else:
            fname2 = dialog.getSaveFileName(self, u'[CSVファイルの保存]　保存作フォルダを選択し、保存するファイル名を入力してください。', self.lineEdit_EPSG1.text() + u'-' + self.lineEdit_EPSG2.text() + u'.csv', '*.csv')
            if not fname2 or str(fname2) == "('', '')":
                return
            fn2 = str(fname2).split("'")
            fname2 = fn2[1]
            infile = workPath + u'/temp.txt'
            outfile = workPath + u'/temp.csv'
            shutil.copy(fname, infile)
            fout = open(outfile, 'w')

        n = 0
        if self.lineEdit_9.text() != '':
            nn = int(self.lineEdit_9.text()) - 1
        xn = int(self.lineEdit_10.text()) - 1
        yn = int(self.lineEdit_11.text()) - 1
        kugiri = self.lineEdit_12.text()

        # ポイントレイヤの追加
        if flag == 0:
            uri = 'file:///' + infile + '?delimiter=%s&xField=%s&yField=%s' % (kugiri, 'field_' + str(self.lineEdit_11.text()), 'field_' + str(self.lineEdit_10.text()) + '&crs=epsg:' + self.lineEdit_EPSG1.text())
        else:
            uri = 'file:///' + infile + '?delimiter=%s&xField=%s&yField=%s' % (kugiri, 'field_' + str(self.lineEdit_11.text()), 'field_' + str(self.lineEdit_10.text()) + '&crs=epsg:' + self.lineEdit_EPSG2.text())
        layer = QgsVectorLayer(uri, u'一括変換', 'delimitedtext')
        # グループ化
        QgsProject.instance().addMapLayer(layer, False)
        if QgsProject.instance().layerTreeRoot().findGroup(self.tr('Projection')) == None:
            QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.tr('Projection')))
        group = QgsProject.instance().layerTreeRoot().findGroup(self.tr('Projection'))
        group.insertLayer(0,layer)
        # スタイルの設定
        if self.comboBox_2.currentText() != '':
            qmlfile = str(self.comboBox_2.currentText())
            if os.path.exists(os.path.dirname(__file__) + u'/qml/' + qmlfile):
                layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + qmlfile)
        else:
            if os.path.exists(os.path.dirname(__file__) + u'/qml/csv.qml'):
                layer.loadNamedStyle(os.path.dirname(__file__) + u'/qml/csv.qml')
        map.refresh()

        # pymeshlab のアンロード（効果なし）
        if 'pymeshlab' in sys.modules:
            del sys.modules['pymeshlab']

        if flag == 1:
            return

        fout.writelines(u'name,EPSG:' + self.lineEdit_EPSG1.text() + u'x(lat),EPSG:' + self.lineEdit_EPSG1.text() + u'y(lon),EPSG:' + self.lineEdit_EPSG2.text()  +  u'x(lat),EPSG:' + self.lineEdit_EPSG2.text() + u'y(lon)\n')

        # 2024.03.01 道庁座標⇔世界測地系の変換の場合、日本測地系の変換を噛ます
        flag = 0
        epsg1 = int(self.lineEdit_EPSG1.text())
        epsg2 = int(self.lineEdit_EPSG2.text())
        crs1_name = crsSrc.userFriendlyIdentifier()
        crs2_name = crsDest.userFriendlyIdentifier()
        if (('道庁' in crs1_name and '部原点' in crs1_name) or '地理調査所' in crs1_name):
            # 変換元EPSGが世界測地系の場合
            if (epsg2 > 2442 and epsg2 < 2462):
                flag = 1
                epsg3 = epsg2 + 27718
            elif (epsg2 > 6668 and epsg2 < 6688):
                flag = 1
                epsg3 = epsg2 + 23492
            elif (epsg2 == 4326 or epsg2 == 4612):
                flag = 1
                epsg3 = 4301
        if (('道庁' in crs2_name and '部原点' in crs2_name) or '地理調査所' in crs2_name):
            # 変換先EPSGが世界測地系の場合
            if (epsg1 > 2442 and epsg1 < 2462):
                flag = 1
                epsg3 = epsg1 + 27718
            elif (epsg1 > 6668 and epsg1 < 6688):
                flag = 1
                epsg3 = epsg1 + 23492
            elif (epsg1 == 4326 or epsg1 == 4612):
                flag = 1
                epsg3 = 4301

        for line in open(infile, 'r'):
            line = line.replace((u'\n'), '')
            line = line.replace((u'\r'), '')
            if ext.lower() == '.sim':
                dat = line.split(',')
                if dat[0] == 'A01':
                    name = dat[2]
                    x1 = dat[3]
                    y1 = dat[4]
                    if flag == 0:
                        trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                        y2,x2 = trans.transform(float(y1), float(x1))
                        new_dat = name + ',' + x1 + ',' + y1 + ',' + str(x2) + ',' + str(y2)
                        fout.writelines(new_dat + '\n')
                    else:
                        crsDest2 = QgsCoordinateReferenceSystem(epsg3)
                        trans = QgsCoordinateTransform(crsSrc, crsDest2, QgsProject.instance())
                        y2,x2 = trans.transform(float(y1), float(x1))
                        trans = QgsCoordinateTransform(crsDest2, crsDest, QgsProject.instance())
                        y3,x3 = trans.transform(float(y2), float(x2))
                        new_dat = name + ',' + x1 + ',' + y1 + ',' + str(x3) + ',' + str(y3)
                        fout.writelines(new_dat + '\n')
            else:
                dat = line.split(kugiri)
                n = n + 1
                if n > 1:
                    if self.lineEdit_9.text() != '':
                        name = dat[nn]
                    else:
                        name = str(n)
                    x1 = dat[xn]
                    y1 = dat[yn]
                    if flag == 0:
                        trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                        y2,x2 = trans.transform(float(y1), float(x1))
                        new_dat = name + ',' + x1 + ',' + y1 + ',' + str(x2) + ',' + str(y2)
                        fout.writelines(new_dat + '\n')
                    else:
                        crsDest2 = QgsCoordinateReferenceSystem(epsg3)
                        trans = QgsCoordinateTransform(crsSrc, crsDest2, QgsProject.instance())
                        y2,x2 = trans.transform(float(y1), float(x1))
                        trans = QgsCoordinateTransform(crsDest2, crsDest, QgsProject.instance())
                        y2,x2 = trans.transform(float(y1), float(x1))
                        new_dat = name + ',' + x1 + ',' + y1 + ',' + str(x2) + ',' + str(y2)
                        fout.writelines(new_dat + '\n')
        fout.close()
        shutil.copy(outfile, fname2)
        if os.path.exists(fname2):
            QMessageBox.information(self, u'一括変換', u'「' + fname2 + u'」を作成しました。')
        else:
            QMessageBox.information(self, u'一括変換', u'「' + fname2 + u'」の作成に失敗しました。')
        try:
            os.remove(workPath + u'/temp.csv')
        except:
            pass

    # 補足（座標変換）
    def pButton_geocoder2(self):
        dat = u'◎ ジオコーダー\n'
        dat = dat + u'アクティブレイヤが、地図XML から変換した GeoJSON や FlatGeobuf の場合、\n'
        dat = dat + u'「地図XML から変換した GeoJSON や FlatGeobuf の検索」にチェックして、レイヤの\n'
        dat = dat + u'属性（市区町村名＋大字名＋丁目名＋小字名＋予備名＋地番）で部分一致\n'
        dat = dat + u'検索します。\n'
        dat = dat + u'最初の検索で、検索用のテンポラリファイルを作成します。続けて検索するときは、\n'
        dat = dat + u'既存の検索用ファイルを使用するか、新たに作成するかの確認画面が表示されます。\n'
        dat = dat + u'検索対象のレイヤを変更する場合は、新たに作成してください。\n'
        dat = dat + u'検索で一致するデータが存在する場合、テンポラリファイル（GeoJSON）を作成して\n'
        dat = dat + u'レイヤに追加します。連続して検索する場合は、前のレイヤは削除されます。\n'
        dat = dat + u'\n'
        dat = dat + u'チェックがない場合、国土地理院のAPIを利用して、住所から緯度・経度を求めます。\n'
        dat = dat + u'\n'
        dat = dat + u'検索ボックスを空欄のまま「ジオコーダー」をクリックすると、「GeoJS」のサービスを\n'
        dat = dat + u'利用して、IPアドレスから現在地を求めます。（十数キロ違うこともありますし、VPN を\n'
        dat = dat + u'使っている場合には、使えません。）大まかに現在地に移動するための機能です。\n'
        QMessageBox.information(self, u'補足', dat)

    # ジオコーダー
    def pButton_geocoder(self):
        layer = qgis.utils.iface.activeLayer()
        if layer is None:
            return
        # プロジェクトのCRS設定を取得する
        global settings
        settings = QSettings()
        oldProjValue = settings.value('/Projections/defaultBehavior')
        self.lineEdit_crsSetting.setText(str(oldProjValue))
        settings.setValue('/Projections/defaultBehavior', 'useProject') # useProject=プロジェクトのCRSを使用するモード,prompt=CRSを確認するモード,useGlobal=デフォルトのCRSを使用するモード
        # プロジェクトのCRSを取得する
        epsgGet()
        epsg = int(epsgcode)
        if self.lineEdit_geocoder.text() == '':
            self.lineEditX1.setText('')
            self.lineEditY1.setText('')
            geo_request_url = 'https://get.geojs.io/v1/ip/geo.json'
            geo_data = requests.get(geo_request_url).json()
            lat = geo_data['latitude']
            lon = geo_data['longitude']
            #self.comboBox_3.setCurrentIndex(3)
            new_crs = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
            QgsProject.instance().setCrs(new_crs)
            map.refresh()
            self.lineEdit_EPSG1.setText('4326')
            self.lineEditX1.setText(str(lat))
            self.lineEditY1.setText(str(lon))
            map.setCenter(QgsPointXY(float(lon), float(lat)))
            map.zoomScale(50000)
            map.refresh()
        else:
            if self.check_geojson.isChecked() == True:
                self.geocoder()
            else:
                self.lineEditX1.setText('')
                self.lineEditY1.setText('')
                makeUrl = "https://msearch.gsi.go.jp/address-search/AddressSearch?q=" + self.lineEdit_geocoder.text()
                response = requests.get(makeUrl)
                lat = response.json()[0]["geometry"]["coordinates"][1]
                lon = response.json()[0]["geometry"]["coordinates"][0]
                #self.comboBox_3.setCurrentIndex(3)
                new_crs = QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId)
                QgsProject.instance().setCrs(new_crs)
                map.refresh()
                self.lineEdit_EPSG1.setText('4326')
                self.lineEditX1.setText(str(lat))
                self.lineEditY1.setText(str(lon))
                self.pButton_21()
        #self.comboBox_3.setCurrentIndex(3)
        new_crs = QgsCoordinateReferenceSystem(epsg, QgsCoordinateReferenceSystem.EpsgCrsId)
        QgsProject.instance().setCrs(new_crs)
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))

    # 検索
    def geocoder(self):
        bin_dir = self.lineEdit_bin.text()
        global Vector_Layer_ID
        layer = qgis.utils.iface.activeLayer()
        src_Layer_ID = layer.id()
        original_layer = QgsProject.instance().mapLayer(src_Layer_ID)
        geojson_path = (layer.dataProvider().dataSourceUri()).split('|')[0]
        crs = layer.crs()
        epsg = str(crs.postgisSrid())

        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        tmp_path = workPath + '/search.geojson'
        geojson_path2 = workPath + '/geocoder.geojson'
        if os.path.exists(tmp_path):
            x = QInputDialog().getInt(None, u"検索用ファイルがあります。", u"1 = 既存のファイルを使用する。<br>2 = 新たに作成する。", 1, 1, 2, 1)
            if str(x) == '(1, True)':
                try:
                    QgsProject.instance().removeMapLayer(Vector_Layer_ID)
                    if os.path.exists(geojson_path2):
                        os.remove(geojson_path2)
                except:
                    pass
                geojson_path = tmp_path
            elif str(x) == '(2, True)':
                try:
                    QgsProject.instance().removeMapLayer(Vector_Layer_ID)
                    if os.path.exists(geojson_path2):
                        os.remove(geojson_path2)
                except:
                    pass
                command = '"' + 'ogr2ogr.exe" ' + tmp_path + " " + geojson_path
                os.system(command)
                geojson_path = tmp_path
            else:
                return
        else:
            command = '"' + 'ogr2ogr.exe" ' + tmp_path + " " + geojson_path
            os.system(command)
            geojson_path = tmp_path

        # 地番区域＋地番による検索
        txt = ''
        dat = self.lineEdit_geocoder.text()
        n = 0
        for line in codecs.open(geojson_path, 'r', 'utf-8'):
            if "市区町村名" in line:
                line = line.replace('地番区域', '')
                a = line.split('市区町村名')
                b = a[1].replace('"', '').replace(': ', '')
                c = b.split(',')
                shikuchouson = c[0]
                a = line.split('大字名')
                b = a[1].replace('"', '').replace(': ', '')
                c = b.split(',')
                ooaza = c[0]
                a = line.split('丁目名')
                b = a[1].replace('"', '').replace(': ', '')
                c = b.split(',')
                choume = c[0]
                a = line.split('小字名')
                b = a[1].replace('"', '').replace(': ', '')
                c = b.split(',')
                koaza = c[0]
                a = line.split('予備名')
                b = a[1].replace('"', '').replace(': ', '')
                c = b.split(',')
                yobi = c[0]
                a = line.split('地番')
                b = a[1].replace('"', '').replace(': ', '')
                c = b.split(',')
                chiban = c[0]
                tochi = shikuchouson + ooaza + choume + koaza + yobi + chiban
                #if tochi == dat:
                if dat in tochi:
                    txt = txt + line
            else:
                if line == ']\n' and txt[-2] == ',':
                    txt = txt[:-2] + '\n'
                txt = txt + line
        fname = codecs.open(geojson_path2, 'w', 'utf-8')
        fname.write(txt)
        fname.close()

        layer = QgsVectorLayer(geojson_path2, "geocoder", "ogr")
        QgsProject.instance().addMapLayer(layer)
        Vector_Layer_ID = layer.id()
        if os.path.exists(os.path.dirname(__file__) + u'/qml/mojxml_polygon2.qml'):
            layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/mojxml_polygon2.qml')
        self.zoom()
        qgis.utils.iface.setActiveLayer(original_layer)


    # EPSG1またはEPSG2に現在のEPSGをセット（座標変換）
    def epsgSet(self):
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        if self.radioButton_EPSG1.isChecked():
            self.lineEdit_EPSG1.setText(code)
            self.lineEdit_EPSG2.setText('')
            self.lineEditX1.setFocus()
        if self.radioButton_EPSG2.isChecked():
            self.lineEdit_EPSG2.setText(code)
            self.lineEdit_EPSG1.setText('')
            self.lineEdit_EPSG1.setFocus()


    # 消去（座標変換）
    def pButton_9(self):
        keizoku = QMessageBox.question(self,u'消去', u'実行してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if keizoku == QMessageBox.Yes:
            self.textEdit_5.clear()
            self.lineEdit_4.setText('0')
            self.lineEditX1.setText('')
            self.lineEditY1.setText('')
            self.lineEditX2.setText('')
            self.lineEditY2.setText('')
            for count in range(self.comboBox_ProjLayer.count()):
                Dlete_Layer_ID = self.comboBox_ProjLayer.itemText(count)
                QgsProject.instance().removeMapLayer(Dlete_Layer_ID)
            self.comboBox_ProjLayer.clear()
            # レイヤグループ削除
            root = QgsProject.instance().layerTreeRoot()
            group = root.findGroup('Projection')
            if not group is None:
                for child in group.children():
                    dump = child.dump()
                    id = dump.split("=")[-1].strip()
                    QgsProject.instance().removeMapLayer(id)
                root.removeChildNode(group)
            map.refresh()
            try:
                os.remove(workPath + u'/temp.txt')
            except:
                pass
            try:
                os.remove(workPath + u'/temp.csv')
            except:
                pass


# ----------GNSS----------------------------------------------------------------------------------------------------------------
    # check_plotクリック
    def SetEnable2(self):
        if self.check_plot.isChecked():
            self.check_centering.setEnabled(True)
        else:
            self.check_centering.setChecked(False)
            self.check_centering.setEnabled(False)

    # check_tansakuクリック
    def SetEnable3(self):
        if self.check_tansaku.isChecked():
            self.x1.setEnabled(True)
            self.y1.setEnabled(True)
            self.d.setEnabled(True)
            self.get_center()
            self.x1.setFocus()
        else:
            self.x1.clear()
            self.y1.clear()
            self.d.clear()
            self.x1.setEnabled(False)
            self.y1.setEnabled(False)
            self.d.setEnabled(False)
            clipboard = QApplication.clipboard()
            clipboard.clear()

    # ボタン名変更
    def changeText(self):
        self.label_x2.setText('')
        self.label_y2.setText('')
        self.label_h2.setText('')
        if self.epoch.isChecked():
            self.epoch.setText(u'取得中')
        else:
            self.epoch.setText(u'開始')

    # check_shousaiクリック
    def SetEnable4(self):
        self.label_x.clear()
        self.label_y.clear()
        self.label_h.clear()
        self.label_ratio.clear()

    # NMEA選択
    def SetEnable5(self):
        self.lineEdit_Ratio.setEnabled(False)
        self.epoch.setEnabled(False)
        self.lineEdit_epoch.setEnabled(False)
        if self.comboBox_sentence.currentText() == 'NMEA':
            self.check_convert2.setChecked(False)
            self.check_plot.setChecked(False)
            self.check_centering.setChecked(False)
            self.check_log.setChecked(False)
            self.check_tansaku.setChecked(False)
            self.check_shousai.setChecked(False)
            self.check_shousai.setEnabled(False)
            self.check_convert2.setEnabled(False)
            self.check_plot.setEnabled(False)
            self.check_centering.setEnabled(False)
            self.check_log.setEnabled(False)
        else:
            self.check_convert2.setEnabled(True)
            self.check_plot.setEnabled(True)
            self.check_log.setEnabled(True)
            self.check_shousai.setEnabled(True)
            if self.comboBox_sentence.currentText() == 'RTKNAVI_RATIO':
                self.lineEdit_Ratio.setEnabled(True)
                self.lineEdit_Ratio.setFocus()
            if self.comboBox_sentence.currentText() == 'RTKNAVI_FIX' or self.comboBox_sentence.currentText() == 'RTKNAVI_ALL' or self.comboBox_sentence.currentText() == 'RTKNAVI_RATIO':
                self.epoch.setEnabled(True)
                self.lineEdit_epoch.setEnabled(True)
                if self.comboBox_sentence.currentText() == 'RTKNAVI_RATIO':
                    self.lineEdit_Ratio.setEnabled(True)
            if self.comboBox_sentence.currentText() == 'TCP_FIX' or self.comboBox_sentence.currentText() == 'TCP_ALL' or self.comboBox_sentence.currentText() == 'TCP_RATIO':
                self.epoch.setEnabled(True)
                self.lineEdit_epoch.setEnabled(True)
        self.SetEnable2()
        self.SetEnable3()
        self.SetEnable4()

    # クリックした地点の平面直角座標をセット
    def get_center(self):
        try:
            clipboard = QApplication.clipboard()
            coordinate = clipboard.text()
            coordinate = coordinate.split(',')
            if coordinate[0] == 'center_coordinates':
                self.x1.setText('')
                self.y1.setText('')
                EPSG1 = int(coordinate[2])
                epsg2 = self.kei.currentText().split(':')
                EPSG2 = int(epsg2[1])
                if EPSG1 == EPSG2:
                    self.x1.setText('{:.3f}'.format(round(float(coordinate[3]), 3)))
                    self.y1.setText('{:.3f}'.format(round(float(coordinate[4]), 3)))
                else:
                    if coordinate[1] == 'usercode':#カスタムCRSの場合
                        Src_crs = QgsCoordinateReferenceSystem()
                        Src_crs.createFromId(EPSG1, QgsCoordinateReferenceSystem.InternalCrsId)
                        crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                    else:
                        Src_crs = QgsCoordinateReferenceSystem(EPSG1)
                        crsSrc = QgsCoordinateReferenceSystem(Src_crs)
                    crsDest = QgsCoordinateReferenceSystem(EPSG2)
                    trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                    y2,x2 = trans.transform(float(coordinate[4]), float(coordinate[3]))
                    self.x1.setText('{:.3f}'.format(round(x2, 3)))
                    self.y1.setText('{:.3f}'.format(round(y2, 3)))
        except:
            pass

    # GPX保存
    def gpx_save(self):
        dialog = QFileDialog()
        dialog.setDirectory(os.path.dirname(__file__) + u'/log/')
        # ログファイルを読み込む
        log_name = dialog.getOpenFileName(self, u'ログファイルを選択してください。', '', '*.log *.csv')
        if not log_name or str(log_name) == "('', '')":
            return
        fp = str(log_name).split("'")
        infile = fp[1]
        dirpath = os.path.dirname(infile)
        filename = os.path.basename(infile)
        fn, ext = os.path.splitext(filename)
        for line in open(infile, 'r'):
            if ext == 'log' and line[0:1] == '$':
                QMessageBox.information(self, u'エラー', u'「GNRMC/GPRMC」「GNGGA/GPGGA」「GNGLL/GPGLL」いずれかのログを選択してください。')
                return
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        os.chdir(reg_path.replace('/', '//'))
        gpxname = dialog.getSaveFileName(self, u'GPXで保存', fn + '.gpx', '*.gpx')
        if not gpxname or str(gpxname) == "('', '')":
            return
        fn = str(gpxname).split("'")
        reg_path = os.path.dirname(fn[1])
        ws.setValue("setting/reg_path", reg_path)
        fp = str(gpxname).split("'")
        gpxname = fp[1]
        gpx_text = '<?xml version=' + '"' + '1.0' + '"' + ' encoding=' + '"' + 'UTF-8' + '"' + '?>\n'
        gpx_text = gpx_text + '<gpx xmlns:xsi=' + '"' + 'http://www.w3.org/2001/XMLSchema-instance' + '"' + ' xmlns=' + '"' + 'http://www.topografix.com/GPX/1/0' + '"' +' xsi:schemaLocation=' + '"' + 'http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd' + '"' + '>\n'
        gpx_text = gpx_text + '    <trk>\n'
        gpx_text = gpx_text + '        <name>GNSS_Logger_Plugin</name>\n'
        gpx_text = gpx_text + '        <number>1</number>\n'
        gpx_text = gpx_text + '        <trkseg>\n'
        for line in open(infile, 'r'):
            dat = line.replace((u'\n'), '').replace((u'\r'), '').split(',')
            name = str(dat[0])
            if len(name) == 14:
                day_time = name[0:4] + '-' + name[4:6] + '-' + name[6:8] + 'T' + name[8:10] + ':' + name[10:12] + ':' + name[12:14] + 'Z'
            elif len(name) == 15:
                day_time = '20' + name[4:6] + '-' + name[2:4] + '-' + name[0:2] + 'T' + name[6:8] + ':' + name[8:10] + ':' + name[10:15] + 'Z'
            elif len(name) == 9:
                day_time = 'T' + name[0:2] + ':' + name[2:4] + ':' + name[4:9] + 'Z'
            elif len(name) == 10:
                day_time = 'T' + name[0:2] + ':' + name[2:4] + ':' + name[4:10] + 'Z'
            bb = str(dat[1])
            ll = str(dat[2])
            hh = str(dat[3])
            gpx_text = gpx_text + '            <trkpt lat=' + '"' + bb + '"' + ' lon=' + '"' + ll + '"' + '><ele>' + hh + '</ele><time>' + day_time + '</time></trkpt>\n'
        gpx_text = gpx_text + '        </trkseg>\n'
        gpx_text = gpx_text + '    </trk>\n'
        gpx_text = gpx_text + '</gpx>\n'
        fname = open(gpxname, 'w')
        fname.write(gpx_text)
        fname.close()

    # SIMA保存
    def sima_save(self):
        dialog = QFileDialog()
        dialog.setDirectory(os.path.dirname(__file__) + u'/log/')
        # ログファイルを読み込む
        log_name = dialog.getOpenFileName(self, u'ログファイルを選択してください。', '', '*.log *.csv')
        if not log_name or str(log_name) == "('', '')":
            return
        fp = str(log_name).split("'")
        infile = fp[1]
        dirpath = os.path.dirname(infile)
        filename = os.path.basename(infile)
        fn, ext = os.path.splitext(filename)
        for line in open(infile, 'r'):
            if ext == 'log' and line[0:1] == '$':
                QMessageBox.information(self, u'エラー', u'「GNRMC/GPRMC」「GNGGA/GPGGA」「GNGLL/GPGLL」いずれかのログを選択してください。')
                return
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        os.chdir(reg_path.replace('/', '//'))
        simaname = dialog.getSaveFileName(self, u'SIMAで保存', fn + '.sim', '*.sim')
        if not simaname or str(simaname) == "('', '')":
            return
        fn = str(simaname).split("'")
        reg_path = os.path.dirname(fn[1])
        ws.setValue("setting/reg_path", reg_path)
        fp = str(simaname).split("'")
        simaname = fp[1]
        sima_text = 'G00,01,GNSS_Loggerﾃﾞｰﾀ,,\n'
        sima_text = sima_text + 'Z00,座標ﾃﾞｰﾀ,\n'
        sima_text = sima_text + 'A00,\n'
        k = 1
        for line in open(infile, 'r'):
            dat = line.replace((u'\n'), '').replace((u'\r'), '').split(',')
            if dat[11] != '':
                name = str(dat[11])
            else:
                name = str(dat[0])
            hh = str(dat[3])
            xx = str(dat[6])
            yy = str(dat[7])
            sima_text = sima_text + 'A01,' + str(k) + ',' + name + ',' + xx + ',' + yy + ',' + hh + ',\n'
            k = k + 1
        sima_text = sima_text + 'A99,\n'
        fname = open(simaname, 'w')
        fname.write(sima_text)
        fname.close()

    # KML保存
    def kml_save(self):
        dialog = QFileDialog()
        dialog.setDirectory(os.path.dirname(__file__) + u'/log/')
        # ログファイルを読み込む
        log_name = dialog.getOpenFileName(self, u'ログファイルを選択してください。', '', '*.log *.csv')
        if not log_name or str(log_name) == "('', '')":
            return
        fp = str(log_name).split("'")
        infile = fp[1]
        dirpath = os.path.dirname(infile)
        filename = os.path.basename(infile)
        fn, ext = os.path.splitext(filename)
        for line in open(infile, 'r'):
            if ext == 'log' and line[0:1] == '$':
                QMessageBox.information(self, u'エラー', u'「GNRMC/GPRMC」「GNGGA/GPGGA」「GNGLL/GPGLL」いずれかのログを選択してください。')
                return
        reg_path = ws.value("setting/reg_path", os.path.dirname(__file__))
        os.chdir(reg_path.replace('/', '//'))
        kmlname = dialog.getSaveFileName(self, u'KMLで保存', fn + '.kml', '*.kml')
        if not kmlname or str(kmlname) == "('', '')":
            return
        fn = str(kmlname).split("'")
        reg_path = os.path.dirname(fn[1])
        ws.setValue("setting/reg_path", reg_path)
        fp = str(kmlname).split("'")
        kmlname = fp[1]
        point_text = ''
        rosen_text = ''
        kml_text = '<?xml version=' + '"' + '1.0' + '"' + ' encoding=' + '"' + 'UTF-8' + '"' + '?>\n'
        kml_text = kml_text + '<kml xmlns=' + '"' + 'http://www.opengis.net/kml/2.2' + '"' + ' xmlns:gx=' + '"' + 'http://www.google.com/kml/ext/2.2' + '"' +' xmlns:kml=' + '"' + 'http://www.opengis.net/kml/2.2' + '"' + ' xmlns:atom=' + '"' + 'http://www.w3.org/2005/Atom' + '"' + '>\n'
        kml_text = kml_text + '    <Document>\n'
        kml_text = kml_text + '        <name></name>\n'
        kml_text = kml_text + '        <StyleMap id=' + '"' + 'my_line' + '"' + '>\n'
        kml_text = kml_text + '            <Pair>\n'
        kml_text = kml_text + '                <key>normal</key>\n'
        kml_text = kml_text + '                <styleUrl>#s_my_line</styleUrl>\n'
        kml_text = kml_text + '            </Pair>\n'
        kml_text = kml_text + '        </StyleMap>\n'
        kml_text = kml_text + '        <Style id=' + '"' + 's_my_line' + '"' + '>\n'
        kml_text = kml_text + '            <LineStyle>\n'
        kml_text = kml_text + '                <color>880000ff</color>\n'
        kml_text = kml_text + '                <width>2</width>\n'
        kml_text = kml_text + '            </LineStyle>\n'
        kml_text = kml_text + '            <PolyStyle>\n'
        kml_text = kml_text + '                <fill>0</fill>\n'
        kml_text = kml_text + '            </PolyStyle>\n'
        kml_text = kml_text + '        </Style>\n'
        k = 0
        for line in open(infile, 'r'):
            dat = line.replace((u'\n'), '').replace((u'\r'), '').split(',')
            if dat[11] != '':
                name = str(dat[11])
            else:
                name = str(dat[0])
            bb = str(dat[1])
            ll = str(dat[2])
            hh = str(dat[3])
            epsg = str(dat[5])
            xx = str(dat[6])
            yy = str(dat[7])
            point_text = point_text + '        <Placemark>\n'
            point_text = point_text + '          <name>' + name + '</name>\n'
            point_text = point_text + '          <description><![CDATA[<div>EPSG:' + epsg + '</div><div>X= ' + xx + '</div><div>Y= ' + yy + '</div><div>H= ' + hh + '</div>]]></description>\n'
            point_text = point_text + '          <Point>\n'
            point_text = point_text + '              <coordinates>' + ll + ',' + bb + ',' + hh + '</coordinates>\n'
            point_text = point_text + '          </Point>\n'
            point_text = point_text + '        </Placemark>\n'
            point = ll + ',' + bb + ',' + hh + ' '
            if k == 0:
                rosen_text = rosen_text + '        <Placemark>\n'
                rosen_text = rosen_text + '            <name>track</name>\n'
                rosen_text = rosen_text + '            <description>track</description>\n'
                rosen_text = rosen_text + '            <styleUrl>#my_line</styleUrl>\n'
                rosen_text = rosen_text + '            <LineString>\n'
                rosen_text = rosen_text + '                <tessellate>1</tessellate>\n'
                rosen_text = rosen_text + '                <altitudeMode>relativeToGround</altitudeMode>\n'
                rosen_text = rosen_text + '                    <coordinates>\n'
                coordinates = '                            ' + point
                k = 1
            else:
                coordinates = coordinates + point
        rosen_text = rosen_text + coordinates +'\n'
        rosen_text = rosen_text + '                    </coordinates>\n'
        rosen_text = rosen_text + '            </LineString>\n'
        rosen_text = rosen_text + '        </Placemark>\n'
        kml_text = kml_text + rosen_text + point_text
        kml_text = kml_text + '    </Document>\n'
        kml_text = kml_text + '</kml>\n'
        fname2 = open(kmlname, 'w')
        fname2.write(kml_text)
        fname2.close()


    # 消去
    def clearlog(self):
        kakunin = QMessageBox.question(self,u'消去', u'表示中のログを消去します。\n実行してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if kakunin == QMessageBox.Yes:
            self.textLog.clear()
            self.x1.clear()
            self.y1.clear()
            self.d.clear()
            self.label_x.clear()
            self.label_y.clear()
            self.label_h.clear()
            self.label_ratio.clear()
            self.label_x2.setText('')
            self.label_y2.setText('')
            self.label_h2.setText('')
            self.check_tansaku.setChecked(False)


    # 接続・切断
    def on_off(self, checked):
        self.stop_event = threading.Event()
        self.inc_event = threading.Event()
        if self.comboBox_sentence.currentText() != 'TCP_FIX' and self.comboBox_sentence.currentText() != 'TCP_ALL' and self.comboBox_sentence.currentText() != 'TCP_RATIO':
            self.thread = threading.Thread(target = self.get_log)
        else:
            self.thread = threading.Thread(target = self.get_log2)
        global oldProjValue
        if checked:
            if self.check_tansaku.isChecked():
                if self.x1.text() == '':
                    QMessageBox.information(self, u'エラー', u'探索する測点のX座標を設定してください。')
                    self.switch_on.setChecked(False)
                    return
                if self.y1.text() == '':
                    QMessageBox.information(self, u'エラー', u'探索する測点のY座標を設定してください。')
                    self.switch_on.setChecked(False)
                    return
            if self.textLog.toPlainText() != '':
                kakunin = QMessageBox.question(self,u'受信', u'表示中のログは消去されます。\n実行してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
                if kakunin == QMessageBox.No:
                    self.switch_on.setChecked(False)
                    return
            # 開始時のCRS設定を記憶する
            oldProjValue = QSettings().value('/Projections/defaultBehavior', 'prompt', type = str)
            self.switch_on.setText(u'切断')
            self.GPX.setEnabled(False)
            self.SIMA.setEnabled(False)
            self.KML.setEnabled(False)
            self.clear_log.setEnabled(False)
            self.kei.setEnabled(False)
            self.check_convert2.setEnabled(False)
            self.check_tansaku.setEnabled(False)
            self.radioButton_time1.setEnabled(False)
            self.radioButton_time2.setEnabled(False)
            self.comboBox_port.setEnabled(False)
            self.comboBox_baudrate.setEnabled(False)
            self.comboBox_sentence.setEnabled(False)
            self.textLog.clear()
            self.label_x.clear()
            self.label_y.clear()
            self.label_h.clear()
            self.label_ratio.clear()
            if not self.check_log.isChecked():
                self.textLog.append(u'ログ記録中')
            self.thread.start()
            return
        else:
            self.switch_on.setText(u'受信開始')
            self.GPX.setEnabled(True)
            self.SIMA.setEnabled(True)
            self.KML.setEnabled(True)
            self.clear_log.setEnabled(True)
            self.kei.setEnabled(True)
            self.check_convert2.setEnabled(True)
            self.check_tansaku.setEnabled(True)
            self.check_plot.setEnabled(True)
            self.comboBox_port.setEnabled(True)
            self.comboBox_baudrate.setEnabled(True)
            self.comboBox_sentence.setEnabled(True)
            self.radioButton_time1.setEnabled(True)
            self.radioButton_time2.setEnabled(True)
            if self.check_plot.isChecked():
                self.check_centering.setEnabled(True)
            else:
                self.check_centering.setChecked(False)
                self.check_centering.setEnabled(False)
            if not self.check_log.isChecked():
                self.textLog.clear()
            self.stop_event.set()
            self.epoch.setChecked(False)
            self.epoch.setText(u'開始')

            # プロジェクトのCRS設定を開始時に戻す
            QSettings().setValue('/Projections/defaultBehavior', str(oldProjValue))

    def stop(self):
        self.stop_event.set()
        self.thread.join()

    # 受信
    def get_log(self):
        global daytime
        global b
        global l
        global h
        global g
        global x1
        global y1
        global x2
        global y2
        global x01
        global y01
        global x02
        global y02
        global EPSG2
        global EPSG3
        global x0
        global y0
        global t0
        x0 = 999999
        y0 = 999999
        epsg2 = self.kei.currentText().split(':')
        EPSG2 = int(epsg2[1])
        epsgGet()
        if epsgcode != '':
            EPSG3 = int(epsgcode)
        else:
            EPSG3 = int(usercode)

        if os.name == 'nt':
            ser = serial.Serial(
                port=self.comboBox_port.currentText(),
                baudrate=int(self.comboBox_baudrate.currentText()),
                bytesize=8,
                parity='N',
                stopbits=1,
                timeout=1)#,
                #xonxoff=False,
                #rtscts=False,
                #writeTimeout=None,
                #dsrdtr=False)
        else:
            ser = serial.Serial(
                port='/dev/' + self.comboBox_port.currentText(),\
                baudrate=int(self.comboBox_baudrate.currentText()),\
                parity=serial.PARITY_NONE,\
                stopbits=serial.STOPBITS_ONE,\
                bytesize=serial.EIGHTBITS,\
                    timeout=1)

        def degrees_to_decimal(data, hemisphere):
            try:
                decimalPointPosition = data.index('.')
                degrees = float(data[:decimalPointPosition-2])
                minutes = float(data[decimalPointPosition-2:])/60
                output = degrees + minutes
                if hemisphere is 'N' or hemisphere is 'E':
                    return output
                if hemisphere is 'S' or hemisphere is 'W':
                    return -output
            except:
                return ""

        def parse_GNRMC(data):
            data = data.split(',')
            dict = {
                    'fix_time': data[1],
                    'Status': data[2],
                    'latitude': data[3],
                    'NothingIndicator': data[4],
                    'longitude': data[5],
                    'EastingIndicator': data[6],
                    'speed': data[7],
                    'true_course': data[8],
                    'fix_date': data[9],
                    'variation': data[10],
                    'variation_e_w': data[11],
                    'checksum': data[12]
            }
            dict['decimal_latitude'] = degrees_to_decimal(dict['latitude'], dict['NothingIndicator'])
            dict['decimal_longitude'] = degrees_to_decimal(dict['longitude'], dict['EastingIndicator'])
            return dict

        def parse_GNGGA(data):
            data = data.split(',')
            dict = {
                    'fix_time': data[1],
                    'latitude': data[2],
                    'NothingIndicator': data[3],
                    'longitude': data[4],
                    'EastingIndicator': data[5],
                    'Status': data[6],
                    'SVsUsed': data[7],
                    'HDOP': data[8],
                    'altitude': data[9],
                    'unit1': data[10],
                    'geoid': data[11],
                    'unit2': data[12],
                    'dgps': data[13],
                    'checksum': data[14]
            }
            dict['decimal_latitude'] = degrees_to_decimal(dict['latitude'], dict['NothingIndicator'])
            dict['decimal_longitude'] = degrees_to_decimal(dict['longitude'], dict['EastingIndicator'])
            return dict

        def parse_GNGLL(data):
            data = data.split(',')
            dict = {
                    'latitude': data[1],
                    'NothingIndicator': data[2],
                    'longitude': data[3],
                    'EastingIndicator': data[4],
                    'fix_time': data[5],
                    'Status': data[6],
                    'ModeIndicator': data[7]
            }
            dict['decimal_latitude'] = degrees_to_decimal(dict['latitude'], dict['NothingIndicator'])
            dict['decimal_longitude'] = degrees_to_decimal(dict['longitude'], dict['EastingIndicator'])
            return dict


        startTime = str(datetime.datetime.now())[0:19].replace('-', '').replace(':', '').replace(' ', '')

        if self.comboBox_sentence.currentText() == 'GNRMC/GPRMC':

            while not self.stop_event.is_set():
                try:
                    line = ser.readline()
                    line = line.strip().decode('Shift_JISx0213')
                    if '$GNRMC' in line or '$GPRMC' in line:
                        if '$GNRMC' in line:
                            gn = line.split('$GNRMC')
                            line = '$GNRMC' + gn[1]
                            log_name = 'GNRMC'
                        else:
                            gn = line.split('$GPRMC')
                            line = '$GPRMC' + gn[1]
                            log_name = 'GPRMC'

                        gpsData = parse_GNRMC(line)
                        if gpsData['Status'] == 'A':
                            day_time = datetime.datetime.now()
                            if self.radioButton_time1.isChecked():
                                daytime = str(day_time)[0:19].replace('-', '').replace(':', '').replace(' ', '')
                            else:
                                daytime = str(gpsData['fix_date']) + str(gpsData['fix_time'])
                            b = '{:.9f}'.format(round(float(gpsData['decimal_latitude']), 9))
                            l = '{:.9f}'.format(round(float(gpsData['decimal_longitude']), 9))
                            h = ''
                            g = ''
                            crsSrc = QgsCoordinateReferenceSystem(4326)
                            # 世界測地系(JGD2011）に変換
                            crsDest = QgsCoordinateReferenceSystem(EPSG2)
                            trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                            y1,x1 = trans.transform(float(l), float(b))
                            x01 = '{:.7f}'.format(round(x1, 7))
                            y01 = '{:.7f}'.format(round(y1, 7))
                            # プロジェクトのCRSに変換
                            if self.check_convert2.isChecked():
                                if epsgcode == '':#カスタムCRSの場合
                                    Dest_crs = QgsCoordinateReferenceSystem()
                                    Dest_crs.createFromId(EPSG3, QgsCoordinateReferenceSystem.InternalCrsId)
                                    crsDest = QgsCoordinateReferenceSystem(Dest_crs)
                                else:
                                    crsDest = QgsCoordinateReferenceSystem(EPSG3)
                                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                y2,x2 = trans.transform(float(l), float(b))
                                x02 = '{:.7f}'.format(round(x2, 7))
                                y02 = '{:.7f}'.format(round(y2, 7))
                            else:
                                x2 = ''
                                y2 = ''
                                x02 = ''
                                y02 = ''
                                EPSG3 = ''
                            log_line = daytime + ',' + b + ',' + l + ',' + h + ',' + g + ',' + str(EPSG2) + ',' + x01 + ',' + y01 + ',' + str(EPSG3) + ',' + x02 + ',' + y02 + ',,'
                            if self.check_tansaku.isChecked():
                                self.tansaku()
                            if self.check_plot.isChecked():
                                self.plot()
                            if self.check_shousai.isChecked():
                                try:
                                    self.label_x.setText(str('{:.3f}'.format(round(x1, 3))))
                                    self.label_y.setText(str('{:.3f}'.format(round(y1, 3))))
                                except:
                                    pass
                            if self.check_log.isChecked():
                                self.textLog.append(log_line)
                            with open(os.path.dirname(__file__) + '/log/' + startTime + u'_' + log_name + u".log", "a") as myfile:
                                myfile.write(log_line + '\n')
                except:
                    pass
            ser.close()

        elif self.comboBox_sentence.currentText() == 'GNGGA/GPGGA':
            while not self.stop_event.is_set():
                try:
                    line = ser.readline()
                    line = line.strip().decode('Shift_JISx0213')
                    if '$GNGGA' in line or '$GPGGA' in line:
                        if '$GNGGA' in line:
                            gn = line.split('$GNGGA')
                            line = '$GNGGA' + gn[1]
                            log_name = 'GNGGA'
                        else:
                            gn = line.split('$GPGGA')
                            line = '$GPGGA' + gn[1]
                            log_name = 'GPGGA'
                        gpsData = parse_GNGGA(line)
                        if gpsData['Status'] == '1' or gpsData['Status'] == '2' or gpsData['Status'] == '4' or gpsData['Status'] == '5':
                            day_time = datetime.datetime.now()
                            if self.radioButton_time1.isChecked():
                                daytime = str(day_time)[0:19].replace('-', '').replace(':', '').replace(' ', '')
                            else:
                                daytime = str(gpsData['fix_time'])
                            b = '{:.9f}'.format(round(float(gpsData['decimal_latitude']), 9))
                            l = '{:.9f}'.format(round(float(gpsData['decimal_longitude']), 9))
                            h = str(gpsData['altitude'])
                            g = str(gpsData['geoid'])
                            crsSrc = QgsCoordinateReferenceSystem(4326)
                            # 世界測地系(JGD2011）に変換
                            crsDest = QgsCoordinateReferenceSystem(EPSG2)
                            trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                            y1,x1 = trans.transform(float(l), float(b))
                            x01 = '{:.7f}'.format(round(x1, 7))
                            y01 = '{:.7f}'.format(round(y1, 7))
                            # プロジェクトのCRSに変換
                            if self.check_convert2.isChecked():
                                if epsgcode == '':#カスタムCRSの場合
                                    Dest_crs = QgsCoordinateReferenceSystem()
                                    Dest_crs.createFromId(EPSG3, QgsCoordinateReferenceSystem.InternalCrsId)
                                    crsDest = QgsCoordinateReferenceSystem(Dest_crs)
                                else:
                                    crsDest = QgsCoordinateReferenceSystem(EPSG3)
                                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                y2,x2 = trans.transform(float(l), float(b))
                                x02 = '{:.7f}'.format(round(x2, 7))
                                y02 = '{:.7f}'.format(round(y2, 7))
                            else:
                                x2 = ''
                                y2 = ''
                                x02 = ''
                                y02 = ''
                                EPSG3 = ''
                            log_line = daytime + ',' + b + ',' + l + ',' + h + ',' + g + ',' + str(EPSG2) + ',' + x01 + ',' + y01 + ',' + str(EPSG3) + ',' + x02 + ',' + y02 + ',,'
                            if self.check_tansaku.isChecked():
                                self.tansaku()
                            if self.check_plot.isChecked():
                                self.plot()
                            if self.check_shousai.isChecked():
                                try:
                                    self.label_x.setText(str('{:.3f}'.format(round(x1, 3))))
                                    self.label_y.setText(str('{:.3f}'.format(round(y1, 3))))
                                    self.label_h.setText(h)
                                except:
                                    pass
                            if self.check_log.isChecked():
                                self.textLog.append(log_line)
                            with open(os.path.dirname(__file__) + '/log/' + startTime + u'_' + log_name + u".log", "a") as myfile:
                                myfile.write(log_line + '\n')
                except:
                    pass
            ser.close()

        elif self.comboBox_sentence.currentText() == 'GNGLL/GPGLL':

            while not self.stop_event.is_set():
                try:
                    line = ser.readline()
                    line = line.strip().decode('Shift_JISx0213')
                    if '$GNGLL' in line or '$GPGLL' in line:
                        if '$GNGLL' in line:
                            gn = line.split('$GNGLL')
                            line = '$GNGLL' + gn[1]
                            log_name = 'GNGLL'
                        else:
                            gn = line.split('$GPGLL')
                            line = '$GPGLL' + gn[1]
                            log_name = 'GPGLL'
                        gpsData = parse_GNGLL(line)
                        if gpsData['Status'] == 'A':
                            day_time = datetime.datetime.now()
                            if self.radioButton_time1.isChecked():
                                daytime = str(day_time)[0:19].replace('-', '').replace(':', '').replace(' ', '')
                            else:
                                daytime = str(gpsData['fix_time'])
                            b = '{:.9f}'.format(round(float(gpsData['decimal_latitude']), 9))
                            l = '{:.9f}'.format(round(float(gpsData['decimal_longitude']), 9))
                            h = ''
                            g = ''
                            crsSrc = QgsCoordinateReferenceSystem(4326)
                            # 世界測地系(JGD2011）に変換
                            crsDest = QgsCoordinateReferenceSystem(EPSG2)
                            trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                            y1,x1 = trans.transform(float(l), float(b))
                            x01 = '{:.7f}'.format(round(x1, 7))
                            y01 = '{:.7f}'.format(round(y1, 7))
                            # プロジェクトのCRSに変換
                            if self.check_convert2.isChecked():
                                if epsgcode == '':#カスタムCRSの場合
                                    Dest_crs = QgsCoordinateReferenceSystem()
                                    Dest_crs.createFromId(EPSG3, QgsCoordinateReferenceSystem.InternalCrsId)
                                    crsDest = QgsCoordinateReferenceSystem(Dest_crs)
                                else:
                                    crsDest = QgsCoordinateReferenceSystem(EPSG3)
                                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                y2,x2 = trans.transform(float(l), float(b))
                                x02 = '{:.7f}'.format(round(x2, 7))
                                y02 = '{:.7f}'.format(round(y2, 7))
                            else:
                                x2 = ''
                                y2 = ''
                                x02 = ''
                                y02 = ''
                                EPSG3 = ''
                            log_line = daytime + ',' + b + ',' + l + ',' + h + ',' + g + ',' + str(EPSG2) + ',' + x01 + ',' + y01 + ',' + str(EPSG3) + ',' + x02 + ',' + y02 + ',,'
                            if self.check_tansaku.isChecked():
                                self.tansaku()
                            if self.check_plot.isChecked():
                                self.plot()
                            if self.check_shousai.isChecked():
                                try:
                                    self.label_x.setText(str('{:.3f}'.format(round(x1, 3))))
                                    self.label_y.setText(str('{:.3f}'.format(round(y1, 3))))
                                except:
                                    pass
                            if self.check_log.isChecked():
                                self.textLog.append(log_line)
                            with open(os.path.dirname(__file__) + '/log/' + startTime + u'_' + log_name + u".log", "a") as myfile:
                                myfile.write(log_line + '\n')
                except:
                    pass
            ser.close()

        elif self.comboBox_sentence.currentText() == 'NMEA':

            while not self.stop_event.is_set():
                try:
                    line = ser.readline()
                    line = line.strip().decode('Shift_JISx0213')
                    if line[0:1] == '$' or line[0:1] == 'µ':
                        with open(os.path.dirname(__file__) + '/' + startTime + u"_NMEA.log", "a") as myfile:
                            myfile.write(line + '\n')
                except:
                    pass
            ser.close()

        else:

            log_name = self.comboBox_sentence.currentText()
            n = 0
            x001 = 0
            y001 = 0
            h001 = 0

            while not self.stop_event.is_set():
                try:
                    line = ser.readline()
                    line = line.strip().decode('Shift_JISx0213')
                    line = re.sub(r"\s+", ",", line).replace('\r\n', '')
                    if line != '':
                        dat = line.split(',')
                        if (self.comboBox_sentence.currentText() == 'RTKNAVI_FIX' and dat[5] == '1') or (self.comboBox_sentence.currentText() == 'RTKNAVI_ALL' and (dat[5] == '1' or dat[5] == '2')) or (self.comboBox_sentence.currentText() == 'RTKNAVI_RATIO' and float(dat[14]) >= float(self.lineEdit_Ratio.text())):
                            day_time = datetime.datetime.now()
                            if self.radioButton_time1.isChecked():
                                daytime = str(day_time)[0:19].replace('-', '').replace(':', '').replace(' ', '')
                            else:
                                daytime = dat[1].replace(':', '')
                            b = '{:.9f}'.format(round(float(dat[2]), 9))
                            l = '{:.9f}'.format(round(float(dat[3]), 9))
                            h = '{:.3f}'.format(round(float(dat[4]), 3))
                            g = ''
                            if float(b) != 0 and float(l) != 0:
                                crsSrc = QgsCoordinateReferenceSystem(4326)
                                # 世界測地系(JGD2011）に変換
                                crsDest = QgsCoordinateReferenceSystem(EPSG2)
                                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                y1,x1 = trans.transform(float(l), float(b))
                                x01 = '{:.7f}'.format(round(x1, 7))
                                y01 = '{:.7f}'.format(round(y1, 7))
                                # プロジェクトのCRSに変換
                                if self.check_convert2.isChecked():
                                    if epsgcode == '':#カスタムCRSの場合
                                        Dest_crs = QgsCoordinateReferenceSystem()
                                        Dest_crs.createFromId(EPSG3, QgsCoordinateReferenceSystem.InternalCrsId)
                                        crsDest = QgsCoordinateReferenceSystem(Dest_crs)
                                    else:
                                        crsDest = QgsCoordinateReferenceSystem(EPSG3)
                                    trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                    y2,x2 = trans.transform(float(l), float(b))
                                    x02 = '{:.7f}'.format(round(x2, 7))
                                    y02 = '{:.7f}'.format(round(y2, 7))
                                else:
                                    x2 = ''
                                    y2 = ''
                                    x02 = ''
                                    y02 = ''
                                    EPSG3 = ''
                                log_line = daytime + ',' + b + ',' + l + ',' + h + ',' + g + ',' + str(EPSG2) + ',' + x01 + ',' + y01 + ',' + str(EPSG3) + ',' + x02 + ',' + y02 + ',,'
                                if not self.epoch.isChecked():
                                    n = 0
                                    x001 = 0
                                    y001 = 0
                                    h001 = 0
                                ep = int(self.lineEdit_epoch.text())
                                if self.epoch.isChecked() and n != ep:
                                    x001 = x001 + x1
                                    y001 = y001 + y1
                                    h001 = h001 + float(h)
                                    n = n + 1
                                    self.epoch.setText(str(n))
                                elif n == ep:
                                    x001 = x001 / ep
                                    y001 = y001 / ep
                                    h001 = h001 / ep
                                    self.epoch.setChecked(False)
                                    self.label_x2.setText(str('{:.3f}'.format(round(x001, 3))))
                                    self.label_y2.setText(str('{:.3f}'.format(round(y001, 3))))
                                    self.label_h2.setText(str('{:.3f}'.format(round(h001, 3))))
                                    self.epoch.setText(u'開始')
                                    crsSrc = QgsCoordinateReferenceSystem(EPSG2)
                                    crsDest = QgsCoordinateReferenceSystem(4326)
                                    trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                    y3,x3 = trans.transform(y001, x001)
                                    n = 0
                                    x001 = 0
                                    y001 = 0
                                    h001 = 0
                                    d = datetime.datetime.today()
                                    daystr = d.strftime("%Y%m%d")
                                    csvname = os.path.dirname(__file__) + '/log/' + daystr + '.csv'
                                    pn = self.lineEdit_pn.text()
                                    csvtext = daytime + ',' + str(x3) + ',' + str(y3) + ',' + self.label_h2.text() + ',,' + str(EPSG2) + ',' + self.label_x2.text() + ',' + self.label_y2.text() + ',,,,' + pn + ',\n'
                                    fname = codecs.open(csvname, 'a', 'shift-jis')
                                    fname.write(csvtext)
                                    fname.close()
                                    #self.lineEdit_pn.setFocus() #QGIS3ではクラッシュする
                                if self.check_tansaku.isChecked():
                                    self.tansaku()
                                if self.check_plot.isChecked():
                                    self.plot()
                                if self.check_shousai.isChecked():
                                    try:
                                        self.label_x.setText(str('{:.3f}'.format(round(x1, 3))))
                                        self.label_y.setText(str('{:.3f}'.format(round(y1, 3))))
                                        self.label_h.setText(h)
                                        self.label_ratio.setText(dat[14])
                                    except:
                                        pass
                                if self.check_log.isChecked():
                                    self.textLog.append(log_line)
                                with open(os.path.dirname(__file__) + "/log/" + startTime + u"_" + log_name + u".log", "a") as myfile:
                                    myfile.write(log_line + '\n')
                                with open(os.path.dirname(__file__) + "/log/" + startTime + u"_" + log_name + u".pos", "a") as myfile:
                                    myfile.write(line + '\n')
                except:
                    pass
            ser.close()


    def get_log2(self):

        global daytime
        global b
        global l
        global h
        global g
        global x1
        global y1
        global x2
        global y2
        global x01
        global y01
        global x02
        global y02
        global EPSG2
        global EPSG3
        global x0
        global y0
        global t0
        x0 = 999999
        y0 = 999999
        epsg2 = self.kei.currentText().split(':')
        EPSG2 = int(epsg2[1])
        epsgGet()
        if epsgcode != '':
            EPSG3 = int(epsgcode)
        else:
            EPSG3 = int(usercode)

        log_name = self.comboBox_sentence.currentText()
        n = 0
        x001 = 0
        y001 = 0
        h001 = 0

        startTime = str(datetime.datetime.today())[0:10].replace('-', '') + str(datetime.datetime.today())[11:19].replace(':' or '-', '')

        host = 'localhost'
        port = 52001
        bufsize = 4096
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        with closing(sock):
            sock.connect((host, port))
            while not self.stop_event.is_set():
                #try:
                    line = sock.recv(bufsize).decode('utf-8', 'ignore')
                    line = re.sub(r"\s+", ",", line).replace('\r\n', '')
                    if line != ',':
                        dat = line.split(',')
                        if (self.comboBox_sentence.currentText() == 'TCP_FIX' and dat[5] == '1') or (self.comboBox_sentence.currentText() == 'TCP_ALL' and (dat[5] == '1' or dat[5] == '2')) or (self.comboBox_sentence.currentText() == 'TCP_RATIO' and float(dat[14]) >= float(self.lineEdit_Ratio.text())):
                            day_time = datetime.datetime.today()
                            if self.radioButton_time1.isChecked():
                                daytime = str(datetime.datetime.today())[0:19].replace('-', '').replace(':', '').replace(' ', '')
                            else:
                                daytime = dat[1].replace(':', '')
                            b = '{:.9f}'.format(round(float(dat[2]), 9))
                            l = '{:.9f}'.format(round(float(dat[3]), 9))
                            h = '{:.3f}'.format(round(float(dat[4]), 3))
                            g = ''
                            if float(b) != 0 and float(l) != 0:
                                crsSrc = QgsCoordinateReferenceSystem(4326)
                                # 世界測地系(JGD2011）に変換
                                crsDest = QgsCoordinateReferenceSystem(EPSG2)
                                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                y1,x1 = trans.transform(float(l), float(b))
                                x01 = '{:.7f}'.format(round(x1, 7))
                                y01 = '{:.7f}'.format(round(y1, 7))
                                # プロジェクトのCRSに変換
                                if self.check_convert2.isChecked():
                                    if epsgcode == '':#カスタムCRSの場合
                                        Dest_crs = QgsCoordinateReferenceSystem()
                                        Dest_crs.createFromId(EPSG3, QgsCoordinateReferenceSystem.InternalCrsId)
                                        crsDest = QgsCoordinateReferenceSystem(Dest_crs)
                                    else:
                                        crsDest = QgsCoordinateReferenceSystem(EPSG3)
                                    trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                    y2,x2 = trans.transform(float(l), float(b))
                                    x02 = '{:.7f}'.format(round(x2, 7))
                                    y02 = '{:.7f}'.format(round(y2, 7))
                                else:
                                    x2 = ''
                                    y2 = ''
                                    x02 = ''
                                    y02 = ''
                                    EPSG3 = ''
                                log_line = daytime + ',' + b + ',' + l + ',' + h + ',' + g + u",EPSG:" + str(EPSG2) + ',' + x01 + ',' + y01 + u',,,,,'
                                if not self.epoch.isChecked():
                                    n = 0
                                    x001 = 0
                                    y001 = 0
                                    h001 = 0
                                ep = int(self.lineEdit_epoch.text())
                                if self.epoch.isChecked() and n != ep:
                                    x001 = x001 + x1
                                    y001 = y001 + y1
                                    h001 = h001 + float(h)
                                    n = n + 1
                                    self.epoch.setText(str(n))
                                elif n == ep:
                                    x001 = x001 / ep
                                    y001 = y001 / ep
                                    h001 = h001 / ep
                                    self.epoch.setChecked(False)
                                    self.label_x2.setText(str('{:.3f}'.format(round(x001, 3))))
                                    self.label_y2.setText(str('{:.3f}'.format(round(y001, 3))))
                                    self.label_h2.setText(str('{:.3f}'.format(round(h001, 3))))
                                    self.epoch.setText(u'開始')
                                    crsSrc = QgsCoordinateReferenceSystem(EPSG2)
                                    crsDest = QgsCoordinateReferenceSystem(4326)
                                    trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                                    y3,x3 = trans.transform(float(l), float(b))
                                    n = 0
                                    x001 = 0
                                    y001 = 0
                                    h001 = 0
                                    d = datetime.datetime.today()
                                    daystr = d.strftime("%Y%m%d")
                                    csvname = os.path.dirname(__file__) + '/log/' + daystr + '.csv'
                                    pn = self.lineEdit_pn.text()
                                    csvtext = daytime + ',' + str(x3) + ',' + str(y3) + ',' + self.label_h2.text() + ',,' + str(epsg2[1]) + ',' + self.label_x2.text() + ',' + self.label_y2.text() + ',,,,' + pn + ',\n'
                                    fname = codecs.open(csvname, 'a', 'shift-jis')
                                    fname.write(csvtext)
                                    fname.close()
                                if self.check_tansaku.isChecked():
                                    self.tansaku()
                                if self.check_plot.isChecked():
                                    self.plot()
                                if self.check_shousai.isChecked():
                                    try:
                                        self.label_x.setText(str('{:.3f}'.format(round(x1, 3))))
                                        self.label_y.setText(str('{:.3f}'.format(round(y1, 3))))
                                        self.label_h.setText(h)
                                        self.label_ratio.setText(dat[14])
                                    except:
                                        pass
                                if self.check_log.isChecked():
                                    self.textLog.append(log_line)
                                with open(os.path.dirname(__file__) + "/log/" + startTime + u"_" + log_name + u".log", "a") as myfile:
                                    myfile.write(log_line + '\n')
                                with open(os.path.dirname(__file__) + "/log/" + startTime + u"_" + log_name + u".pos", "a") as myfile:
                                    myfile.write(line + '\n')
                #except:
                #    pass
        sock.close()


    # 探索
    def tansaku(self):
        x2 = round(float(self.x1.text()), 3)
        y2 = round(float(self.y1.text()), 3)
        dx = x2 - x1
        dy = y2 - y1
        #点間距離
        s = math.sqrt(dx ** 2 + dy ** 2)
        #方向角
        RAD = 3.14159265358979 / 180
        pi = math.atan2(1, 1) * 4
        if dx == 0:
            if dy == 0:
                a = 0
            elif dy > 0:
                a = pi / 2
            elif dy < 0:
                a = pi * 3 / 2
        elif dx != 0:
            ha = math.atan2(math.fabs(dy), math.fabs(dx))
            if dx > 0:
                if dy >= 0:
                    a = ha
                if dy <  0:
                    a = 2 * pi - ha
            if dx < 0:
                if dy >= 0:
                    a = pi - ha
                if dy <  0:
                    a = pi + ha
        if a >= 2 * pi:
            a = a - 2 * pi
        dd = a / RAD
        self.d.setText('{:.8f}'.format(round(dd, 8)) + u'／' + '{:.3f}'.format(round(s, 3)))


    # プロット
    def plot(self):
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        layer = QgsVectorLayer('Point?crs=epsg:' + code + '&field=name&field=Latitude&field=Longitude&field=Altitude&field=Geoid&field=EPSG1&field=X1&field=Y1&field=EPSG2&field=X2&field=Y2', daytime, 'memory')
        if epsgcode != '':#プロジェクトのCRSがカスタムCRS以外の場合
            layer.setCrs(QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.EpsgCrsId))
        else:#プロジェクトのCRSがカスタムCRSの場合
            layer.setCrs(QgsCoordinateReferenceSystem(4326, QgsCoordinateReferenceSystem.InternalCrsId))
        provider = layer.dataProvider()
        feature = QgsFeature()
        geometry = QgsGeometry.fromPointXY(QgsPointXY(float(l), float(b)))
        feature.setGeometry(geometry)
        feature.setAttributes([daytime, l, b, h, g, EPSG2, x01, y01, EPSG3, x02, y02])
        provider.addFeatures([feature])
        QgsProject.instance().addMapLayer(layer, False)
        if QgsProject.instance().layerTreeRoot().findGroup(self.tr('Log')) == None:
            QgsProject.instance().layerTreeRoot().insertChildNode(0,QgsLayerTreeGroup(self.tr('Log')))
        group = QgsProject.instance().layerTreeRoot().findGroup(self.tr('Log'))
        group.insertLayer(0,layer)

        if self.check_centering.isChecked():
            crsSrc = QgsCoordinateReferenceSystem(4326)
            if code != '4326' and code != '4612':
                if epsgcode != '':
                    crsDest = QgsCoordinateReferenceSystem(int(code))
                else:
                    Dest_crs = QgsCoordinateReferenceSystem()
                    Dest_crs.createFromId(int(code), QgsCoordinateReferenceSystem.InternalCrsId)
                    crsDest = QgsCoordinateReferenceSystem(Dest_crs)
                trans = QgsCoordinateTransform(crsSrc, crsDest, QgsProject.instance())
                y3,x3 = trans.transform(float(l), float(b))
                rect = QgsRectangle(float(y3),float(x3),float(y3),float(x3))
            else:
                rect = QgsRectangle(float(l),float(b),float(l),float(b))
            map.setExtent(rect)
        return


# ----------設定----------------------------------------------------------------------------------------------------------------
    # 新しいレイヤの投影座標系（設定）
    def crsSetting(self):
        # ここで設定を変更すると、以後、これが「開始時のCRS設定」となる
        # CRSを確認するモード
        if self.radioButton_crsSetting1.isChecked():
            settings.setValue('/Projections/defaultBehavior', 'prompt')
            self.lineEdit_crsSetting.setText('prompt')
        # プロジェクトのCRSを使用するモード
        elif self.radioButton_crsSetting2.isChecked():
            settings.setValue('/Projections/defaultBehavior', 'useProject')
            self.lineEdit_crsSetting.setText('useProject')
        # デフォルトのCRSを使用するモードモード
        elif self.radioButton_crsSetting3.isChecked():
            settings.setValue('/Projections/defaultBehavior', 'useGlobal')
            self.lineEdit_crsSetting.setText('useGlobal')


    # 作業フォルダ選択（設定）pButton_folder
    def pButton_61(self):
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        dialog = QFileDialog()
        dialog.setFileMode(QFileDialog.Directory)
        dialog.setOption(QFileDialog.ShowDirsOnly)
        try:
            dialog.setDirectory(workPath)
        except:
            dialog.setDirectory(os.path.dirname(__file__))
        foldername = dialog.getExistingDirectory(self, u'フォルダを選択してください。')
        if foldername == '' or foldername == None:
            foldername = workPath
        self.lineEdit_workPath.setText(foldername)
        ws.setValue("setting/workPath", foldername)


    # 作業フォルダをデフォルトに設定（設定）
    def pButton_62(self):
        keizoku = QMessageBox.question(self,u'デフォルトに設定', u'作業フォルダを「' + os.path.dirname(__file__) + u'/work」に設定してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if keizoku == QMessageBox.Yes:
            self.lineEdit_workPath.setText(os.path.dirname(__file__) + u'/work')
            ws.setValue("setting/workPath", os.path.dirname(__file__) + u'/work')


    # フォントサイズの設定（設定）
    def pButton_66(self):
        fs = int(self.font_size.text())
        if fs == "":
            return
        if sys.platform == "win32":
            fname = os.path.dirname(__file__) + u'/ui_dialog.ui'
        else:
            fname = os.path.dirname(__file__) + u'/ui_dialog_Mac.ui'
        txt = ""
        flag = 0
        for line in codecs.open(fname, 'r', 'utf-8'):
            if '<widget class="QLabel" name="label_14">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_15">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_18">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_19">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_21">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_version">' in line:
                flag = 1
            if (flag == 1) and ('</widget>' in line):
                flag = 0
            if (flag == 0) and ('<pointsize>' in line):
                dat = line.split(u'>')
                txt = txt + dat[0] + '>' + str(fs) + '</pointsize>\n'
            else:
                txt = txt + line
        uifile = codecs.open(fname,'w', 'utf-8')
        uifile.write(txt)
        uifile.close()
        QMessageBox.information(self, u'フォントサイズ変更', u'フォントサイズを' + str(fs) + u'ポイントに変更しました。\nQGISを再起動するかDigitier3をリロードすると\n設定が反映されます。')


    # フォントサイズをデフォルトに戻す（設定）
    def pButton_67(self):
        if sys.platform == "win32":
            fname = os.path.dirname(__file__) + u'/ui_dialog.ui'
        else:
            fname = os.path.dirname(__file__) + u'/ui_dialog_Mac.ui'
        txt = ""
        flag = 0
        for line in codecs.open(fname, 'r', 'utf-8'):
            if '<widget class="QLabel" name="label_14">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_15">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_18">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_19">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_21">' in line:
                flag = 1
            if '<widget class="QLabel" name="label_version">' in line:
                flag = 1
            if (flag == 1) and ('</widget>' in line):
                flag = 0
            if (flag == 0) and ('<pointsize>' in line):
                dat = line.split(u'>')
                if sys.platform == "win32":
                    txt = txt + dat[0] + '>9</pointsize>\n'
                else:
                    txt = txt + dat[0] + '>12</pointsize>\n'
            else:
                txt = txt + line
        uifile = codecs.open(fname,'w', 'utf-8')
        uifile.write(txt)
        uifile.close()
        if sys.platform == "win32":
            QMessageBox.information(self, u'フォントサイズ変更', u'フォントサイズを9ポイントに変更しました。\nQGISを再起動するかDigitier3をリロードすると\n設定が反映されます。')
        else:
            QMessageBox.information(self, u'フォントサイズ変更', u'フォントサイズを12ポイントに変更しました。\nQGISを再起動するかDigitier3をリロードすると\n設定が反映されます。')


    # Window最大幅の設定（設定）
    def pButton_68(self):
        ww = int(self.window_width.text())
        if ww == "":
            return
        if ww < 570:
            ww = 570
        if sys.platform == "win32":
            fname = os.path.dirname(__file__) + u'/ui_dialog.ui'
        else:
            fname = os.path.dirname(__file__) + u'/ui_dialog_Mac.ui'
        txt = ""
        flag = 0
        for line in codecs.open(fname, 'r', 'utf-8'):
            if ('<widget class="QDialog" name="display">' in line) or ('<widget class="QTabWidget" name="tabWidget">' in line):
                flag = 1
            if (flag == 1) and ('<property name="geometry">' in line):
                flag = 2
            if (flag == 2) and ('<property name="minimumSize">' in line):
                flag = 3
            if (flag == 3) and ('<property name="maximumSize">' in line):
                flag = 4
            if (flag == 4) and ('</property>' in line):
                flag = 0
            if (flag == 2 or flag == 4) and ('<width>' in line):
                dat = line.split(u'>')
                txt = txt + dat[0] + '>' + str(ww) + '</width>\n'
            else:
                txt = txt + line
        uifile = codecs.open(fname,'w', 'utf-8')
        uifile.write(txt)
        uifile.close()
        fname = os.path.dirname(__file__) + u'/digitizer3.py'
        txt = ""
        flag = 0
        for line in codecs.open(fname, 'r', 'utf-8'):
            if ('def pButton_18(self)' in line):
                flag = 1
            if flag == 1 and 'self.lineEdit_path.resize(501, 21)' in line:
                flag = 0
            if flag == 1 and 'self.resize(' in line:
                dat = line.split(u'(')
                txt = txt + dat[0] + '(' + str(ww) + ', 368)\n'
            else:
                txt = txt + line
        uifile = codecs.open(fname,'w', 'utf-8')
        uifile.write(txt)
        uifile.close()
        QMessageBox.information(self, u'Window最大幅変更', u'Window最大幅を' + str(ww) + u'に変更しました。\nQGISを再起動するかDigitier3をリロードすると\n設定が反映されます。')


    # Window最大幅をデフォルトに戻す（設定）
    def pButton_69(self):
        if sys.platform == "win32":
            fname = os.path.dirname(__file__) + u'/ui_dialog.ui'
        else:
            fname = os.path.dirname(__file__) + u'/ui_dialog_Mac.ui'
        txt = ""
        flag = 0
        for line in codecs.open(fname, 'r', 'utf-8'):
            if ('<widget class="QDialog" name="display">' in line) or ('<widget class="QTabWidget" name="tabWidget">' in line):
                flag = 1
            if (flag == 1) and ('<property name="geometry">' in line):
                flag = 2
            if (flag == 2) and ('<property name="minimumSize">' in line):
                flag = 3
            if (flag == 3) and ('<property name="maximumSize">' in line):
                flag = 4
            if (flag == 4) and ('</property>' in line):
                flag = 0
            if (flag == 2 or flag == 4) and ('<width>' in line):
                dat = line.split(u'>')
                txt = txt + dat[0] + '>570</width>\n'
            else:
                txt = txt + line
        uifile = codecs.open(fname,'w', 'utf-8')
        uifile.write(txt)
        uifile.close()
        fname = os.path.dirname(__file__) + u'/digitizer3.py'
        txt = ""
        flag = 0
        for line in codecs.open(fname, 'r', 'utf-8'):
            if ('def pButton_18(self)' in line):
                flag = 1
            if flag == 1 and 'self.lineEdit_path.resize(501, 21)' in line:
                flag = 0
            if flag == 1 and 'self.resize(' in line:
                dat = line.split(u'(')
                txt = txt + dat[0] + '(570, 368)\n'
            else:
                txt = txt + line
        uifile = codecs.open(fname,'w', 'utf-8')
        uifile.write(txt)
        uifile.close()
        QMessageBox.information(self, u'Window最大幅変更', u'Window最大幅を570に変更しました。\nQGISを再起動するかDigitier3をリロードすると\n設定が反映されます。')


    # 現在のプロジェクトのCRSを「デフォルトのCRS」に設定する（設定）
    def defaultCRS2(self):
        epsgGet()
        if epsgcode != '':
            crs = 'EPSG:' + epsgcode
        else:
            crs = 'USER:' + usercode
        settings.setValue('/Projections/layerDefaultCrs', crs)


    # プロジェクトファイルを開く（設定）
    def openProject(self):
        if self.combo_project.currentText() =='':
            return
        pn = self.combo_project.currentText()
        result = QMessageBox.question(self,u'読込確認', u'表示中のレイヤは全て削除されます。\n' + pn + u' を読み込んでもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if result == QMessageBox.Yes:
            QgsProject.instance().removeAllMapLayers()
            projfile = os.path.dirname(__file__) + u'/project/' + self.combo_project.currentText()
            QgsProject.instance().read(projfile)
            self.set_Combo()


    # プロジェクトファイルを保存する（設定）
    def saveProject(self):
        if self.combo_project.currentText() =='':
            return
        pn = self.combo_project.currentText()
        if pn.lower()[-4:] != '.qgs':
            pn = pn + '.qgs'
        projfile = os.path.dirname(__file__) + u'/project/' + pn
        if os.path.exists(projfile):
            result = QMessageBox.question(self,u'上書き確認', pn + u' は、既に存在します。\n上書きしてもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
            if result == QMessageBox.Yes:
                QgsProject.instance().write(projfile)
            else:
                return
        else:
            QgsProject.instance().write(projfile)
        # プロジェクトファイルリストの取得
        projdir = os.path.dirname(__file__) + u'/project'
        self.combo_project.clear()
        self.combo_project.addItem('')
        for root, dirs, files in os.walk(projdir):
            for file in files:
                if file.lower()[-4:] == '.qgs':
                    self.combo_project.addItem(str(file))
        i = 0
        for count in range(self.combo_project.count()):
            if count > 0:
              dat = self.combo_project.itemText(count)
              if dat == pn:
                  i = count
        self.combo_project.setCurrentIndex(i)


    # プロジェクトファイルを削除する（設定）
    def deleteProject(self):
        if self.combo_project.currentText() =='':
            return
        projfile = os.path.dirname(__file__) + u'/project/' + self.combo_project.currentText()
        result = QMessageBox.question(self,u'削除確認', self.combo_project.currentText() + u' を削除してもよろしいですか？',QMessageBox.Yes | QMessageBox.No,QMessageBox.No)
        if result == QMessageBox.Yes:
            try:
                os.remove(projfile)
                projdir = os.path.dirname(__file__) + u'/project'
                self.combo_project.clear()
                self.combo_project.addItem('')
                for root, dirs, files in os.walk(projdir):
                    for file in files:
                        if file.lower()[-4:] == '.qgs':
                            self.combo_project.addItem(str(file))
            except:
                pass
            try:
                os.remove(projfile + u'~')
            except:
                pass


# ----------共通----------------------------------------------------------------------------------------------------------------
    # ×ボタンがクリックされた時（共通）＊
    def closeEvent(self,event):
        #qgis.utils.iface.messageBar().pushMessage(u'Digitizer', u'マップキャンバスをクリックすると再開します。', duration = 5)
        self.radioButton5.setChecked(True)
        self.radioButton10.setChecked(True)
        self.checkBox.setChecked(False)
        # プロジェクトのCRS設定を開始時に戻す
        settings.setValue('/Projections/defaultBehavior', str(self.lineEdit_crsSetting.text()))

        # [全般]
        ws.setValue("setting/window_w", self.width())              # ウィンドウの幅
        ws.setValue("setting/window_x", self.x() + 8)              # ウィンドウの横位置（+ 8は、環境により調整が必要かも）
        ws.setValue("setting/window_y", self.y() + 31)             # ウィンドウの縦位置（+31は、環境により調整が必要かも）

        # [Digitizer]
        ws.setValue("setting/pn_header1", self.lineEdit_1.text())  # 点名の頭文字

        # [I/O]
        ws.setValue("setting/op_x", self.lineEdit_5.text())       # 読込オプション Xの列
        ws.setValue("setting/op_y", self.lineEdit_6.text())       # 読込オプション Yの列
        ws.setValue("setting/op_sep", self.lineEdit_7.text())     # 読込オプション 区切文字
        ws.setValue("setting/pref", self.pref.currentIndex())     # 都道府県

        # [GDAL/OGR]
        ws.setValue("setting/python_path", self.python_path.text())                     # python.exeのPath
        ws.setValue("setting/mojxml2geojson_Path", self.mojxml2geojson_folder.text())   # mojxml2geojsonのPath
        if self.check_xml_1.isChecked():
            ws.setValue("setting/check_xml_1","1")
        else:
            ws.setValue("setting/check_xml_1","0")
        if self.check_xml_2.isChecked():
            ws.setValue("setting/check_xml_2","1")
        else:
            ws.setValue("setting/check_xml_2","0")
        if self.check_xml_3.isChecked():
            ws.setValue("setting/check_xml_3","1")
        else:
            ws.setValue("setting/check_xml_3","0")
        if self.check_xml_4.isChecked():
            ws.setValue("setting/check_xml_4","1")
        else:
            ws.setValue("setting/check_xml_4","0")
        if self.check_xml_5.isChecked():
            ws.setValue("setting/check_xml_5","1")
        else:
            ws.setValue("setting/check_xml_5","0")
        if self.check_xml_6.isChecked():
            ws.setValue("setting/check_xml_6","1")
        else:
            ws.setValue("setting/check_xml_6","0")
        if self.check_xml_7.isChecked():
            ws.setValue("setting/check_xml_7","1")
        else:
            ws.setValue("setting/check_xml_7","0")
        if self.check_xml_8.isChecked():
            ws.setValue("setting/check_xml_8","1")
        else:
            ws.setValue("setting/check_xml_8","0")
        if self.check_xml_9.isChecked():
            ws.setValue("setting/check_xml_9","1")
        else:
            ws.setValue("setting/check_xml_9","0")
        ws.setValue("setting/pm_ubuntu", self.pm_ubuntu.text())
        ws.setValue("setting/pm_op_1", self.pm_op_1.text())
        ws.setValue("setting/pm_op_2", self.pm_op_2.text())
        ws.setValue("setting/pm_op_3", self.pm_op_3.text())
        ws.setValue("setting/pm_op_4", self.pm_op_4.text())
        ws.setValue("setting/pm_op_5", self.pm_op_5.text())
        ws.setValue("setting/pm_op_6", self.pm_op_6.text())
        ws.setValue("setting/pm_op_7", self.pm_op_7.text())
        ws.setValue("setting/pm_op_8", self.pm_op_8.text())
        ws.setValue("setting/pm_op_9", self.lineEdit_tippecanoe.text())
        if self.radioButton_pm_1.isChecked():
            ws.setValue("setting/pm_src","1")
        elif self.radioButton_pm_2.isChecked():
            ws.setValue("setting/pm_src","2")
        elif self.radioButton_pm_3.isChecked():
            ws.setValue("setting/pm_src","3")
        elif self.radioButton_pm_4.isChecked():
            ws.setValue("setting/pm_src","4")
        elif self.radioButton_pm_5.isChecked():
            ws.setValue("setting/pm_src","5")
        if self.radioButton_layer_1.isChecked():
            ws.setValue("setting/pm_layer","1")
        else:
            ws.setValue("setting/pm_layer","0")
        workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
        csv_path = workPath + '/temp1.csv'
        if not os.path.exists(csv_path):
            self.listWidget_address.clear()
            self.listWidget_zokusei.clear()
            self.lineEdit_src.setText('')
        ws.setValue("setting/savefolder", self.lineEdit_savefolder.text())
        ws.setValue("setting/apikey", self.lineEdit_apikey.text())
        ws.setValue("setting/year", self.lineEdit_year.text())

        # [WorldFile]
        if self.checkBox_3.isChecked():                           # ベクタ変換する
            ws.setValue("setting/addLayer1", 1)
        else:
            ws.setValue("setting/addLayer1", 0)
        if self.checkBox_crop.isChecked():                        # 図郭で切り取る
            ws.setValue("setting/crop", 1)
        else:
            ws.setValue("setting/crop", 0)
        ws.setValue("setting/line_R", self.R2.text())             # 線色 R
        ws.setValue("setting/line_G", self.G2.text())             # 線色 G
        ws.setValue("setting/line_B", self.B2.text())             # 線色 B

        # [Georeference]
        ws.setValue("setting/scale", self.s.text())               # 縮尺（分母）
        ws.setValue("setting/dpi", self.r.text())                 # 解像度

        # [Exif]
        ws.setValue("setting/kei", self.comboKei.currentIndex())  # 平面直角座標系
        if self.checkBox_filename.isChecked():                    # ファイル名を表示する
            ws.setValue("setting/show_fname", 1)
        else:
            ws.setValue("setting/show_fname", 0)
        if self.checkBox_shape.isChecked():                       # Shape保存
            ws.setValue("setting/save_shape", 1)
        else:
            ws.setValue("setting/save_shape", 0)

        # [座標変換]
        if self.checkBox_2.isChecked():                           # マップキャンバスから座標を取得する
            ws.setValue("setting/capture", 1)
        else:
            ws.setValue("setting/capture", 0)
        if self.checkBox_4.isChecked():                           # 変換後、ポイントレイヤに追加する
            ws.setValue("setting/addLayer2", 1)
        else:
            ws.setValue("setting/addLayer2", 0)
        ws.setValue("setting/pn_header2", self.lineEdit_3.text()) # 点名の頭文字
        ws.setValue("setting/op_p2", self.lineEdit_9.text())      # 読込オプション 点名の列
        ws.setValue("setting/op_x2", self.lineEdit_10.text())     # 読込オプション Xの列
        ws.setValue("setting/op_y2", self.lineEdit_11.text())     # 読込オプション Yの列
        ws.setValue("setting/op_sep2", self.lineEdit_12.text())   # 読込オプション 区切文字

        # [GNSS]
        ws.setValue("setting/GNSS_kei", self.kei.currentIndex())                     # 平面直角座標系
        ws.setValue("setting/GNSS_Port", self.comboBox_port.currentIndex())          # Port
        ws.setValue("setting/GNSS_Baudrate", self.comboBox_baudrate.currentIndex())  # Baudrate
        ws.setValue("setting/GNSS_Sentence", self.comboBox_sentence.currentIndex())  # Sentence
        if self.radioButton_time1.isChecked():                                       # Time
            gnss_time = '1'
        else:
            gnss_time = '0'
        ws.setValue("setting/GNSS_Time", gnss_time)
        if self.check_plot.isChecked():                                              # プロット
            gnss_plot = '1'
        else:
            gnss_plot = '0'
        ws.setValue("setting/GNSS_Plot", gnss_plot)
        if self.check_centering.isChecked():                                         # センタリング
            gnss_centering = '1'
        else:
            gnss_centering = '0'
        ws.setValue("setting/GNSS_Centering", gnss_centering)
        if self.check_log.isChecked():                                               # ログ表示
            gnss_log = '1'
        else:
            gnss_log = '0'
        ws.setValue("setting/GNSS_Log", gnss_log)
        if self.check_shousai.isChecked():                                           # 詳細表示
            gnss_view = '1'
        else:
            gnss_view = '0'
        ws.setValue("setting/GNSS_View", gnss_view)

        # [設定]
        if self.check_start.isChecked():
            ws.setValue("setting/start", 1)
            ws.setValue("setting/startProj", self.combo_project.currentIndex())
        else:
            ws.setValue("setting/start", 0)
            ws.setValue("setting/startProj", 0)
        if self.check_kakunin.isChecked():
            ws.setValue("setting/kakunin", 1)
        else:
            ws.setValue("setting/kakunin", 0)

        # [設定]
        if self.check_start.isChecked():
            ws.setValue("setting/start", 1)
            ws.setValue("setting/startProj", self.combo_project.currentIndex())
        else:
            ws.setValue("setting/start", 0)
            ws.setValue("setting/startProj", 0)
        if self.check_kakunin.isChecked():
            ws.setValue("setting/kakunin", 1)
        else:
            ws.setValue("setting/kakunin", 0)


    # 選択したレイヤの領域にズーム（共通）
    def zoom(self):
        layer = qgis.utils.iface.activeLayer()
        extent = layer.extent()
        map.setExtent(extent)
        map.zoomScale(map.scale() * 1.1)
        map.refresh()
        scale = round(map.scale(), 0)
        self.lineEdit_scale.setText(str(int(scale)))


    # プロジェクトのCRSコンボボックスをセットする（共通）
    def set_Combo(self):
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        i = 0
        for count in range(self.comboBox_3.count()):
            if count > 0:
              dat = self.comboBox_3.itemText(count).split(',')
              if dat[1] == code:
                  i = count
        self.comboBox_3.setCurrentIndex(i)
        if i == 0:
            self.comboBox_3.setCurrentText(code)
            #self.comboBox_3.setItemText(0, code)
        self.lineEdit_8.setText(code)

    # タブが変更された時（共通）
    def setTab(self):
        self.lineEdit_path.setText('')
        self.scrollArea.move(250, 25)
        self.scrollArea.hide()
        self.pButton_pmtiles2()
        self.pButton_sima4()
        self.pButton_close()
        self.pButton_Helmert3()
        # プロジェクトのCRSを取得
        epsgGet()
        if epsgcode != '':
            code = epsgcode
        else:
            code = usercode
        # プロジェクトのCRSコンボボックスをセットする
        self.set_Combo()
        #self.radioButton_Layer_8.setChecked(True)
        self.comboBox_2.setCurrentIndex(0)
        # 新しいレイヤの投影座標系の設定の取得
        oldProjValue = QSettings().value('/Projections/defaultBehavior', 'prompt', type = str)
        self.lineEdit_crsSetting.setText(str(oldProjValue))

        if self.tabWidget.currentIndex() == 0:#[Digitizer]
            self.pushButton_1.setFocus()

        if self.tabWidget.currentIndex() == 1:#[I/O]
            # スケールを取得
            scale = round(map.scale(), 0)
            self.lineEdit_scale.setText(str(int(scale)))
            self.lineEdit_8.setText(code)
            # 新しいレイヤの投影座標系の設定
            if str(oldProjValue) == 'prompt':
                self.radioButton_crsSetting1.setChecked(True)
            if str(oldProjValue) == 'useProject':
                self.radioButton_crsSetting2.setChecked(True)
            if str(oldProjValue) == 'useGlobal':
                self.radioButton_crsSetting3.setChecked(True)

        if self.tabWidget.currentIndex() == 2:#[GDAL/OGR]
            # プロジェクトのCRSを取得
            epsgGet()
            if epsgcode != '':
                code = epsgcode
            else:
                code = usercode
            self.lineEdit_srsEPSG.setText(code)
            self.lineEdit_dstEPSG.setText(code)
            self.pushButton_23.setFocus()
            self.radioButton_raster.setChecked(True)
            self.setFormat()
            if self.python_path.text() == "":
                pv = str(sys.version).split('.')
                python_ver = pv[0] + pv[1]
                QGISpath = (str(QgsApplication.prefixPath()).replace('apps/qgis','apps/Python') + python_ver + '/python3.exe')
                self.python_path.setText(QGISpath)
            workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
            csv_path = workPath + '/temp1.csv'
            if not os.path.exists(csv_path):
                self.listWidget_address.clear()
                self.listWidget_zokusei.clear()
                self.lineEdit_src.setText('')

        if self.tabWidget.currentIndex() == 3:#[WorldFile]
          # パターンファイルリストを更新
          fpath = self.lineEdit_path_wf.text()
          self.lineEdit_path.setText(fpath)
          self.comboBox.clear()
          self.textEdit_pattern.clear()
          self.comboBox.addItem(u'新見出有,-596,4306,-4563,371')
          self.comboBox.addItem(u'旧見出有,-596,4312,-4564,371')
          self.comboBox.addItem(u'旧見出無,-636,4312,-4604,371')
          ptfname = os.path.dirname(__file__) + u'/pattern.txt'
          if os.path.exists(ptfname):
              for line in codecs.open(ptfname,'r', 'shift-jis'):
                  self.comboBox.addItem(line.replace((u'\n' or u'\r\n'),''))
                  self.textEdit_pattern.append(line.replace((u'\n' or u'\r\n'),''))
          self.pushButton_11.setFocus()
          prgPath = ''
          if sys.platform == "win32": # Windows
              # Tesseract-OCR を prgPath1・prgPath2 以外にインストールした場合は、OSの種類に拘わらず prgPath2 を書き換えると良い。
              prgPath1 = 'C:/PROGRA~1/Tesseract-OCR/tesseract.exe' # 32bit OS
              prgPath2 = 'C:/PROGRA~2/Tesseract-OCR/tesseract.exe' # 64bit OS
              if os.path.exists(prgPath1):
                  prgPath = prgPath1 + ' '
              else:
                  if os.path.exists(prgPath2):
                      prgPath = prgPath2 + ' '
          else: # Mac
              if os.path.isdir('/usr/local/Cellar/tesseract/'):
                  for root, dirs, files in os.walk('/usr/local/Cellar/tesseract/'):
                      for fname in files:
                          if os.path.join(root, fname)[-9:] == 'tesseract':
                            prgPath = os.path.join(root, fname)
          self.checkBox_xt.setChecked(False)
          self.checkBox_yt.setChecked(False)
          self.checkBox_xb.setChecked(False)
          self.checkBox_yb.setChecked(False)
          if prgPath == '':
              self.checkBox_xt.setEnabled(False)
              self.checkBox_yt.setEnabled(False)
              self.checkBox_xb.setEnabled(False)
              self.checkBox_yb.setEnabled(False)
          else:
              self.checkBox_xt.setEnabled(True)
              self.checkBox_yt.setEnabled(True)
              self.checkBox_xb.setEnabled(True)
              self.checkBox_yb.setEnabled(True)
          self.lineEditXY.setText('')

        if self.tabWidget.currentIndex() == 4:#[Georeference]
          epsgGet()
          if epsgcode != '':
              code = epsgcode
          else:
              code = usercode
          self.lineEdit_EPSG3.setText(code)
          fpath = self.lineEdit_path_gcp.text()
          self.lineEdit_path.setText(fpath)
          self.comboBox_6.setCurrentIndex(1)
          self.pushButton_16.setFocus()

        if self.tabWidget.currentIndex() == 5:#[Exif]
            self.pushButton_23.setFocus()

        if self.tabWidget.currentIndex() == 6:#[座標変換]
            epsgGet()
            self.radioButton_EPSG2.setChecked(True)
            self.lineEdit_EPSG2.setText(epsgcode)
            if self.lineEdit_EPSG1.text() == '':
                self.lineEdit_EPSG1.setText(epsgcode)
            self.lineEdit_EPSG1.setFocus()

        if self.tabWidget.currentIndex() == 8:#[設定]
            # 作業フォルダ
            workPath = ws.value("setting/workPath", os.path.dirname(__file__) + u'/work')
            if os.path.exists(workPath):
                self.lineEdit_workPath.setText(workPath)
            else:
                workPath = os.path.dirname(__file__) + u'/work'
                ws.setValue("setting/workPath", workPath)
                self.lineEdit_workPath.setText(workPath)


    # プロジェクトのEPSG変更（共通）
    def pButton_47(self):
        if self.comboBox_3.currentText() == '':
            return
        n = self.comboBox_3.currentText().count(',')
        if n == 0:
            epsg = int(self.comboBox_3.currentText())
        else:
            dat = self.comboBox_3.currentText().split(',')
            epsg = int(dat[1])
        custom = str(QgsCoordinateReferenceSystem(epsg).authid())
        if custom != '':#指定のCRSがカスタムCRSでない場合
            new_crs = QgsCoordinateReferenceSystem(epsg, QgsCoordinateReferenceSystem.EpsgCrsId)
        else:
            new_crs = QgsCoordinateReferenceSystem(epsg, QgsCoordinateReferenceSystem.InternalCrsId)
        QgsProject.instance().setCrs(new_crs)
        map.refresh()
        self.lineEdit_8.setText(str(epsg))


    # スタイル変更（共通）
    def pButton_31(self):
        if self.comboBox_2.currentText() == '':
            return
        layer = qgis.utils.iface.activeLayer()
        if str(layer) != 'None':
            layer.loadNamedStyle(os.path.dirname(__file__) + '/qml/' + str(self.comboBox_2.currentText()))
            map.zoomScale(map.scale() * 1.0001)
            map.refresh()
            scale = round(map.scale(), 0)
            self.lineEdit_scale.setText(str(int(scale)))
        else:
            QMessageBox.information(self, u'エラー', u'レイヤが選択されていません。')


    # ウィンドウリサイズ（共通）
    def pButton_18(self):
        if self.pushButton_18.text() == u'最大化':
          self.resize(570, 368)
          self.lineEdit_path.resize(501, 21)
          self.pushButton_18.setText(u'最小化')
        else:
          self.resize(250, 368)
          self.lineEdit_path.resize(184, 21)
          self.pushButton_18.setText(u'最大化')



# Exif情報取得
def get_exif(fn):
    ret = {}
    try:
        i = Image.open(fn)
        info = i._getexif()
        if info is not None:
            for tag, value in info.items():
                decoded = TAGS.get(tag, tag)
                ret[decoded] = value
            return ret
    except IOError:
        return None


# プロジェクトのEPSG取得
def epsgGet():
    global epsgcode
    global usercode
    crs = qgis.utils.iface.mapCanvas().mapSettings().destinationCrs()
    epsgcode = str(crs.authid())
    if epsgcode[0:5] == 'EPSG:':
        epsgcode = epsgcode.replace('EPSG:', '')
        usercode = ''
    else:
        usercode = epsgcode.replace('USER:', '')
        epsgcode = ""
