import adjust_lon from './adjust_lon';
import nad_intr from './nad_intr';
import inverseNadCvt from './inverseNadCvt';

export default function(pin, inverse, ct) {
  var val = {
    "x": Number.NaN,
    "y": Number.NaN
  };
  if (isNaN(pin.x)) {
    return val;
  }
  var tb = {
    "x": pin.x,
    "y": pin.y
  };
  tb.x -= ct.ll[0];
  tb.y -= ct.ll[1];
  tb.x = adjust_lon(tb.x - Math.PI) + Math.PI;
  var t = nad_intr(tb, ct);
  if (inverse) {
    return inverseNadCvt(t, val, tb, ct);
  }
  else {
    if (!isNaN(t.x)) {
      val.x = pin.x - t.x;
      val.y = pin.y + t.y;
    }
  }
  return val;
}