using UnityEngine;
using UnityEngine.UI;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
/// <summary>UI更新クラス</summary>
public class LonLatToUI : MonoBehaviour
{
    /// <summary>テキストテンプレート</summary>
    private const string LonLatInfoTemplate = "緯度:   {0}\n経度: {1}\n住所: {2}\n平面直角座標系: {3}\nＸ座標：{4}\nＹ座標：{5}";

    /// <summary>表示用テキストUIオブジェクト</summary>
    private Text lonLatInfo;

    /// <summary>経緯度取得オブジェクト</summary>
    private LonLatGetter lonLatGetter;

    /// <summary>逆ジオコーディングオブジェクト</summary>
    private LonLatToAddr lonLatToAddr;

    public string kei = "";
    public double B0;
    public double L0;
    public double x;
    public double y;

    /// <summary>初期化</summary>
    private void Start()
    {
        // テキストラベルオブジェクトを保持
        lonLatInfo = GameObject.Find("LonLatInfo").GetComponent<Text>();

        // 経緯度取得オブジェクトオブジェクトを保持
        lonLatGetter = GetComponent<LonLatGetter>();

        // 逆ジオコーディングオブジェクトを取得
        lonLatToAddr = GetComponent<LonLatToAddr>();
    }

    /// <summary>経緯度の値をテキストUIに反映</summary>
    private void Update()
    {
        // 経緯度の値を取得できるか判定
        if (lonLatGetter.CanGetLonLat())
        {
            if (kei == "")
            {
                StartCoroutine(lonLatToAddr.GetAddrFromLonLat(lonLatGetter.Longitude, lonLatGetter.Latitude));
                //初回のみ座標系原点を設定
                string str = lonLatToAddr.Address;
                string[] pref = str.Split(' ');
                if (pref[0] == "北海道")
                {
                    if (str.IndexOf("函館市") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("伊達市") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("北斗市") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("豊浦町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("壮瞥町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("洞爺湖町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("余市町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("仁木町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("古平町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("積丹町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("赤井川村") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("神恵内村") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("泊村") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("岩内町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("共和町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("蘭越町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("黒松内町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("寿都町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("島牧村") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("倶知安町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("ニセコ町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("京極町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("喜茂別町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("留寿都村") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("真狩村") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("松前町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("福島町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("知内町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("木古内町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("七飯町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("鹿部町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("森町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("八雲町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("長万部町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("江差町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("上ノ国町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("厚沢部町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("乙部町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("奥尻町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("今金町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("せたな町") >= 0)
                    {
                        kei = "11";
                    }
                    else if (str.IndexOf("北見市") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("帯広市") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("釧路市") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("網走市") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("根室市") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("美幌町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("津別町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("斜里町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("清里町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("小清水町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("訓子府町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("置戸町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("佐呂間町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("大空町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("新得町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("鹿追町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("上士幌町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("士幌町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("音更町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("陸別町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("足寄町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("本別町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("池田町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("浦幌町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("豊頃町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("幕別町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("芽室町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("清水町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("中札内村") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("更別村") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("大樹町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("広尾町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("釧路町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("厚岸町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("浜中町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("標茶町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("弟子屈町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("鶴居村") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("白糠町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("別海町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("中標津町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("標津町") >= 0)
                    {
                        kei = "13";
                    }
                    else if (str.IndexOf("羅臼町") >= 0)
                    {
                        kei = "13";
                    }
                    else
                    {
                        kei = "12";
                    }
                }
                else if (str.IndexOf("青森県") >= 0)
                {
                    kei = "10";
                }
                else if (str.IndexOf("岩手県") >= 0)
                {
                    kei = "10";
                }
                else if (str.IndexOf("宮城県") >= 0)
                {
                    kei = "10";
                }
                else if (str.IndexOf("秋田県") >= 0)
                {
                    kei = "10";
                }
                else if (str.IndexOf("山形県") >= 0)
                {
                    kei = "10";
                }
                else if (str.IndexOf("福島県") >= 0)
                {
                    kei = "9";
                }
                else if (str.IndexOf("茨城県") >= 0)
                {
                    kei = "9";
                }
                else if (str.IndexOf("栃木県") >= 0)
                {
                    kei = "9";
                }
                else if (str.IndexOf("群馬県") >= 0)
                {
                    kei = "9";
                }
                else if (str.IndexOf("埼玉県") >= 0)
                {
                    kei = "9";
                }
                else if (str.IndexOf("千葉県") >= 0)
                {
                    kei = "9";
                }
                else if (str.IndexOf("東京都") >= 0)
                {
                    if (str.IndexOf("小笠原村") >= 0)
                    {
                        if ((lonLatGetter.Latitude <= 28) && ((lonLatGetter.Longitude >= 140.5) && (lonLatGetter.Longitude <= 143)))
                        {
                            kei = "14";
                        }
                        else if ((lonLatGetter.Latitude <= 28) && (lonLatGetter.Longitude < 140.5))
                        {
                            kei = "18";
                        }
                        else if ((lonLatGetter.Latitude <= 28) && (lonLatGetter.Longitude > 143))
                        {
                            kei = "19";
                        }
                        else
                        {
                            kei = "9";
                        }
                    }
                }
                else if (str.IndexOf("神奈川県") >= 0)
                {
                    kei = "9";
                }
                else if (str.IndexOf("新潟県") >= 0)
                {
                    kei = "8";
                }
                else if (str.IndexOf("山梨県") >= 0)
                {
                    kei = "8";
                }
                else if (str.IndexOf("長野県") >= 0)
                {
                    kei = "8";
                }
                else if (str.IndexOf("静岡県") >= 0)
                {
                    kei = "8";
                }
                else if (str.IndexOf("富山県") >= 0)
                {
                    kei = "7";
                }
                else if (str.IndexOf("石川県") >= 0)
                {
                    kei = "7";
                }
                else if (str.IndexOf("岐阜県") >= 0)
                {
                    kei = "7";
                }
                else if (str.IndexOf("愛知県") >= 0)
                {
                    kei = "7";
                }
                else if (str.IndexOf("福井県") >= 0)
                {
                    kei = "6";
                }
                else if (str.IndexOf("三重県") >= 0)
                {
                    kei = "6";
                }
                else if (str.IndexOf("滋賀県") >= 0)
                {
                    kei = "6";
                }
                else if (str.IndexOf("京都府") >= 0)
                {
                    kei = "6";
                }
                else if (str.IndexOf("大阪府") >= 0)
                {
                    kei = "6";
                }
                else if (str.IndexOf("奈良県") >= 0)
                {
                    kei = "6";
                }
                else if (str.IndexOf("和歌山県") >= 0)
                {
                    kei = "6";
                }
                else if (str.IndexOf("兵庫県") >= 0)
                {
                    kei = "5";
                }
                else if (str.IndexOf("鳥取県") >= 0)
                {
                    kei = "5";
                }
                else if (str.IndexOf("岡山県") >= 0)
                {
                    kei = "5";
                }
                else if (str.IndexOf("徳島県") >= 0)
                {
                    kei = "4";
                }
                else if (str.IndexOf("香川県") >= 0)
                {
                    kei = "4";
                }
                else if (str.IndexOf("愛媛県") >= 0)
                {
                    kei = "4";
                }
                else if (str.IndexOf("高知県") >= 0)
                {
                    kei = "4";
                }
                else if (str.IndexOf("島根県") >= 0)
                {
                    kei = "3";
                }
                else if (str.IndexOf("広島県") >= 0)
                {
                    kei = "3";
                }
                else if (str.IndexOf("山口県") >= 0)
                {
                    kei = "3";
                }
                else if (str.IndexOf("福岡県") >= 0)
                {
                    kei = "2";
                }
                else if (str.IndexOf("佐賀県") >= 0)
                {
                    kei = "2";
                }
                else if (str.IndexOf("熊本県") >= 0)
                {
                    kei = "2";
                }
                else if (str.IndexOf("大分県") >= 0)
                {
                    kei = "2";
                }
                else if (str.IndexOf("宮崎県") >= 0)
                {
                    kei = "2";
                }
                else if (str.IndexOf("鹿児島県") >= 0)
                {
                    if (str.IndexOf("名瀬市") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("十島村") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("笠沙町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("薩摩郡里村") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("上甑村") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("下甑村") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("鹿島村") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("大和村") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("宇検村") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("瀬戸内町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("住用村") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("龍郷町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("笠利町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("喜界町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("徳之島町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("天城町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("伊仙町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("和泊町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("知名町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("与論町") >= 0)
                    {
                        kei = "1";
                    }
                    else if (str.IndexOf("三島村") >= 0)
                    {
                        kei = "1";
                    }
                    else
                    {
                        kei = "2";
                    }
                }
                else if (str.IndexOf("長崎県") >= 0)
                {
                    kei = "1";
                }
                else if (str.IndexOf("沖縄県") >= 0)
                {
                    if (str.IndexOf("平良市") >= 0)
                    {
                        kei = "16";
                    }
                    else if (str.IndexOf("石垣市") >= 0)
                    {
                        kei = "16";
                    }
                    else if (str.IndexOf("城辺町") >= 0)
                    {
                        kei = "16";
                    }
                    else if (str.IndexOf("下地町") >= 0)
                    {
                        kei = "16";
                    }
                    else if (str.IndexOf("上野村") >= 0)
                    {
                        kei = "16";
                    }
                    else if (str.IndexOf("伊良部町") >= 0)
                    {
                        kei = "16";
                    }
                    else if (str.IndexOf("多良間村") >= 0)
                    {
                        kei = "16";
                    }
                    else if (str.IndexOf("竹富町") >= 0)
                    {
                        kei = "16";
                    }
                    else if (str.IndexOf("与那国町") >= 0)
                    {
                        kei = "16";
                    }
                    else if (str.IndexOf("南大東村") >= 0)
                    {
                        kei = "17";
                    }
                    else if (str.IndexOf("北大東村") >= 0)
                    {
                        kei = "17";
                    }
                    else
                    {
                        kei = "15";
                    }
                }
                if (kei == "1")
                {
                    L0 = 129.50d;
                    B0 = 33d;
                }
                else if (kei == "2")
                {
                    L0 = 131.00d;
                    B0 = 33d;
                }
                else if (kei == "3")
                {
                    L0 = 132.1666666666666d;
                    B0 = 36d;
                }
                else if (kei == "4")
                {
                    L0 = 133.50d;
                    B0 = 33d;
                }
                else if (kei == "5")
                {
                    L0 = 134.3333333333333d;
                    B0 = 33d;
                }
                else if (kei == "6")
                {
                    L0 = 136.00d;
                    B0 = 36d;
                }
                else if (kei == "7")
                {
                    L0 = 137.1666666666666d;
                    B0 = 36d;
                }
                else if (kei == "8")
                {
                    L0 = 138.50d;
                    B0 = 36;
                }
                else if (kei == "9")
                {
                    L0 = 139.8333333333333d;
                    B0 = 36d;
                }
                else if (kei == "10")
                {
                    L0 = 140.8333333333333d;
                    B0 = 40d;
                }
                else if (kei == "11")
                {
                    L0 = 140.15d;
                    B0 = 44d;
                }
                else if (kei == "12")
                {
                    L0 = 142.15d;
                    B0 = 44d;
                }
                else if (kei == "13")
                {
                    L0 = 144.25d;
                    B0 = 44d;
                }
                else if (kei == "14")
                {
                    L0 = 142.00d;
                    B0 = 26d;
                }
                else if (kei == "15")
                {
                    L0 = 127.50d;
                    B0 = 26d;
                }
                else if (kei == "16")
                {
                    L0 = 124.00d;
                    B0 = 26d;
                }
                else if (kei == "17")
                {
                    L0 = 131.00d;
                    B0 = 26d;
                }
                else if (kei == "18")
                {
                    L0 = 136.00d;
                    B0 = 20d;
                }
                else if (kei == "19")
                {
                    L0 = 154.00d;
                    B0 = 26d;
                }
            }
            double m0 = 0.9999;
            double RAD = 3.14159265358979d / 180d;
            double b0 = B0 * RAD;
            double l0 = L0 * RAD;
            double b = lonLatGetter.Latitude * RAD;
            double l = lonLatGetter.Longitude * RAD;
            double la = 1.005052501813087d;
            double lb = 0.005063108622224d;
            double lc = 0.000010627590263d;
            double ld = 0.000000020820379d;
            double le = 0.000000000039324d;
            double lf = 0.000000000000071d;
            double a = 6378137;
            double f = 1 / 298.257222101d;
            double e = Math.Sqrt(2 * f - Math.Pow(f, 2));
            double S0 = a * (1 - Math.Pow(e, 2)) * (la * b0 - lb / 2 * Math.Sin(2 * b0) + lc / 4 * Math.Sin(4 * b0) - ld / 6 * Math.Sin(6 * b0) + le / 8 * Math.Sin(8 * b0) - lf / 10 * Math.Sin(10 * b0));
            double ee = Math.Sqrt(2 / f - 1) / (1 / f - 1);
            double su = Math.Pow(ee, 2) * Math.Pow(Math.Cos(b), 2);
            double c = a * Math.Sqrt(1 + Math.Pow(ee, 2));
            double N = c / Math.Sqrt(1 + su);
            double th = Math.Tan(b);
            double dl = l - l0;
            double S = a * (1 - Math.Pow(e, 2)) * (la * b - lb / 2 * Math.Sin(2 * b) + lc / 4 * Math.Sin(4 * b) - ld / 6 * Math.Sin(6 * b) + le / 8 * Math.Sin(8 * b) - lf / 10 * Math.Sin(b));
            double x = ((S - S0) + N / 2 * Math.Sin(b) * Math.Cos(b) * Math.Pow(dl, 2) + N / 24 * Math.Sin(b) * Math.Pow(Math.Cos(b), 3) * (5 - Math.Pow(th, 2) + 9 * su + 4 * Math.Pow(su, 2)) * Math.Pow(dl, 4) + N / 720 * Math.Sin(b) * Math.Pow(Math.Cos(b), 5) * (61 - 58 * Math.Pow(th, 2) + Math.Pow(th, 4)) * Math.Pow(dl, 6)) * m0;
            double y = (N * Math.Cos(b) * dl + N / 6 * Math.Pow(Math.Cos(b), 3) * (1 - Math.Pow(th, 2) + su) * Math.Pow(dl, 3) + N / 120 * Math.Pow(Math.Cos(b), 5) * (5 - 18 * Math.Pow(th, 2) + Math.Pow(th, 4)) * Math.Pow(dl, 5)) * m0;
            lonLatInfo.text = string.Format(LonLatInfoTemplate, lonLatGetter.Latitude.ToString("F10"), lonLatGetter.Longitude.ToString("F10"), lonLatToAddr.Address, kei, x.ToString("F3"), y.ToString("F3"));
        }
        else
        {
            lonLatInfo.text = string.Format(LonLatInfoTemplate, "測定不能", "測定不能", "測定不能", "測定不能", "測定不能", "測定不能");
            kei = "";
        }
    }
}